/*	ES6 Promises polyfill via: https://github.com/jakearchibald/es6-promise */
!function(){var a,b,c,d;!function(){var e={},f={};a=function(a,b,c){e[a]={deps:b,callback:c}},d=c=b=function(a){function c(b){if("."!==b.charAt(0))return b;for(var c=b.split("/"),d=a.split("/").slice(0,-1),e=0,f=c.length;f>e;e++){var g=c[e];if(".."===g)d.pop();else{if("."===g)continue;d.push(g)}}return d.join("/")}if(d._eak_seen=e,f[a])return f[a];if(f[a]={},!e[a])throw new Error("Could not find module "+a);for(var g,h=e[a],i=h.deps,j=h.callback,k=[],l=0,m=i.length;m>l;l++)"exports"===i[l]?k.push(g={}):k.push(b(c(i[l])));var n=j.apply(this,k);return f[a]=g||n}}(),a("promise/all",["./utils","exports"],function(a,b){"use strict";function c(a){var b=this;if(!d(a))throw new TypeError("You must pass an array to all.");return new b(function(b,c){function d(a){return function(b){f(a,b)}}function f(a,c){h[a]=c,0===--i&&b(h)}var g,h=[],i=a.length;0===i&&b([]);for(var j=0;j<a.length;j++)g=a[j],g&&e(g.then)?g.then(d(j),c):f(j,g)})}var d=a.isArray,e=a.isFunction;b.all=c}),a("promise/asap",["exports"],function(a){"use strict";function b(){return function(){process.nextTick(e)}}function c(){var a=0,b=new i(e),c=document.createTextNode("");return b.observe(c,{characterData:!0}),function(){c.data=a=++a%2}}function d(){return function(){j.setTimeout(e,1)}}function e(){for(var a=0;a<k.length;a++){var b=k[a],c=b[0],d=b[1];c(d)}k=[]}function f(a,b){var c=k.push([a,b]);1===c&&g()}var g,h="undefined"!=typeof window?window:{},i=h.MutationObserver||h.WebKitMutationObserver,j="undefined"!=typeof global?global:void 0===this?window:this,k=[];g="undefined"!=typeof process&&"[object process]"==={}.toString.call(process)?b():i?c():d(),a.asap=f}),a("promise/config",["exports"],function(a){"use strict";function b(a,b){return 2!==arguments.length?c[a]:(c[a]=b,void 0)}var c={instrument:!1};a.config=c,a.configure=b}),a("promise/polyfill",["./promise","./utils","exports"],function(a,b,c){"use strict";function d(){var a;a="undefined"!=typeof global?global:"undefined"!=typeof window&&window.document?window:self;var b="Promise"in a&&"resolve"in a.Promise&&"reject"in a.Promise&&"all"in a.Promise&&"race"in a.Promise&&function(){var b;return new a.Promise(function(a){b=a}),f(b)}();b||(a.Promise=e)}var e=a.Promise,f=b.isFunction;c.polyfill=d}),a("promise/promise",["./config","./utils","./all","./race","./resolve","./reject","./asap","exports"],function(a,b,c,d,e,f,g,h){"use strict";function i(a){if(!v(a))throw new TypeError("You must pass a resolver function as the first argument to the promise constructor");if(!(this instanceof i))throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");this._subscribers=[],j(a,this)}function j(a,b){function c(a){o(b,a)}function d(a){q(b,a)}try{a(c,d)}catch(e){d(e)}}function k(a,b,c,d){var e,f,g,h,i=v(c);if(i)try{e=c(d),g=!0}catch(j){h=!0,f=j}else e=d,g=!0;n(b,e)||(i&&g?o(b,e):h?q(b,f):a===D?o(b,e):a===E&&q(b,e))}function l(a,b,c,d){var e=a._subscribers,f=e.length;e[f]=b,e[f+D]=c,e[f+E]=d}function m(a,b){for(var c,d,e=a._subscribers,f=a._detail,g=0;g<e.length;g+=3)c=e[g],d=e[g+b],k(b,c,d,f);a._subscribers=null}function n(a,b){var c,d=null;try{if(a===b)throw new TypeError("A promises callback cannot return that same promise.");if(u(b)&&(d=b.then,v(d)))return d.call(b,function(d){return c?!0:(c=!0,b!==d?o(a,d):p(a,d),void 0)},function(b){return c?!0:(c=!0,q(a,b),void 0)}),!0}catch(e){return c?!0:(q(a,e),!0)}return!1}function o(a,b){a===b?p(a,b):n(a,b)||p(a,b)}function p(a,b){a._state===B&&(a._state=C,a._detail=b,t.async(r,a))}function q(a,b){a._state===B&&(a._state=C,a._detail=b,t.async(s,a))}function r(a){m(a,a._state=D)}function s(a){m(a,a._state=E)}var t=a.config,u=(a.configure,b.objectOrFunction),v=b.isFunction,w=(b.now,c.all),x=d.race,y=e.resolve,z=f.reject,A=g.asap;t.async=A;var B=void 0,C=0,D=1,E=2;i.prototype={constructor:i,_state:void 0,_detail:void 0,_subscribers:void 0,then:function(a,b){var c=this,d=new this.constructor(function(){});if(this._state){var e=arguments;t.async(function(){k(c._state,d,e[c._state-1],c._detail)})}else l(this,d,a,b);return d},"catch":function(a){return this.then(null,a)}},i.all=w,i.race=x,i.resolve=y,i.reject=z,h.Promise=i}),a("promise/race",["./utils","exports"],function(a,b){"use strict";function c(a){var b=this;if(!d(a))throw new TypeError("You must pass an array to race.");return new b(function(b,c){for(var d,e=0;e<a.length;e++)d=a[e],d&&"function"==typeof d.then?d.then(b,c):b(d)})}var d=a.isArray;b.race=c}),a("promise/reject",["exports"],function(a){"use strict";function b(a){var b=this;return new b(function(b,c){c(a)})}a.reject=b}),a("promise/resolve",["exports"],function(a){"use strict";function b(a){if(a&&"object"==typeof a&&a.constructor===this)return a;var b=this;return new b(function(b){b(a)})}a.resolve=b}),a("promise/utils",["exports"],function(a){"use strict";function b(a){return c(a)||"object"==typeof a&&null!==a}function c(a){return"function"==typeof a}function d(a){return"[object Array]"===Object.prototype.toString.call(a)}var e=Date.now||function(){return(new Date).getTime()};a.objectOrFunction=b,a.isFunction=c,a.isArray=d,a.now=e}),b("promise/polyfill").polyfill()}();

/* Deferred promise polyfill/helper (for delegating the resolving of the promise) */
(function(P){if(P){P.defer=function(){p=new Promise(function(rs,rj){return {promise:p,resolve:rs,reject:rj}})}}})(this.Promise);


window.APP = (function() {


/************** / APP CONFIG /*/

// Loaded configuration (for sync access)
var CFG = null;

// Configuration status
var hasAppConfig;

// Load and init config
function initAppConfig() {
	hasAppConfig = AppConfig();
	return hasAppConfig;
}

// Manipulate config
function AppConfig(key, set_value) {
	// No configuration loaded, or forced init (no key specified)
	if (typeof key === 'undefined' || CFG === null) {
		return localforage.getItem('AppConfig').then(function (AppConfig) {
			// No storage yet, store the default storage config
			if (AppConfig === null) {
				AppConfig = {
					gps: 0 // GPS disabled by default
				}
				localforage.setItem('AppConfig',AppConfig);
			}

			// Store for local/async access
			CFG = AppConfig;
		});
	}

	// Remove 'key'
	if (set_value === null) {
		delete CFG[key];
		localforage.setItem('AppConfig',CFG);
	
	// Query 'key'
	} else if (typeof set_value === 'undefined') {
		return CFG[key];

	// Set 'key' to 'set_value'
	} else {
		CFG[key] = set_value;
		localforage.setItem('AppConfig',CFG);
	}
}


/************** / APP DATA /*/

// Application data
var RES = {};

// Application data ready state
var hasAppData;

// Init & load app data
function initAppData() {
	// Load core app data
	var appdata = new Promise(function (resolve, reject) {
		var xhr = new XMLHttpRequest();
		xhr.open('GET','content/appdata.json',true);
		xhr.onreadystatechange = function () {
			if (xhr.readyState != 4 || xhr.status != 200) return;
			try {
				RES.appdata = xhr.responseJSON || JSON.parse(xhr.responseText);
				resolve(RES.appdata);
				//console.log('hasAppData',RES);
			} catch (e) {
				alert("Data error: "+e.toString());
				reject(e);
			}
		};
		xhr.send();
	});

	// Load data for what-to-do in solutions
	var solutionsdata = new Promise(function (resolve, reject) {
		var xhr = new XMLHttpRequest();
		xhr.open('GET','content/solutions.csv',true);
		xhr.onreadystatechange = function () {
			if (xhr.readyState != 4 || xhr.status != 200) return;

			resolve(xhr.responseText);
		};
		xhr.send();

	// Parse csv
	}).then(function(csv) {
		var R = {}, headers;

		csv.split(/\r?\n/).reduce(function (dataset, row, i) {
			if (i === 0) {
				headers = row.split(/;/);
				headers.shift(); // remove first element
				headers = headers.map(function(e){ return e.toLowerCase(); }); // elements to lowercase
				//console.log(headers);
				return dataset;
			}

			if (!row) return dataset;

			var rowdata = row.split(/;/),
				label = rowdata.shift().toLowerCase();

			dataset[label] = rowdata.reduce(function(r, row, i) {
				if (!row) return r;

				if (!(headers[i] in r)) r[headers[i]] = [];
				r[headers[i]].push(row.replace(/^\"|\"$/g,'')); // trim enclosing quots

				return r;
			}, dataset[label]||{});
			return dataset;
		}, R);

		//console.log(R);
		return RES.solutionsdata = R;

	}).catch(function(e) {
		console.error(e.toString(), e.fileName.match(/[^\/]+$/)[0] + '::' + e.lineNumber);
		alert(e);
	});

	// Load data for "explain" part of solutions
	var explaindata = appdata.then(function (appdata) {
		var explaindata = new Promise(function (resolve, reject) {
			var xhr = new XMLHttpRequest();
			xhr.open('GET','content/explain.json',true);
			xhr.onreadystatechange = function () {
				if (xhr.readyState != 4 || xhr.status != 200) return;
				try {
					RES.explaindata = xhr.responseJSON || JSON.parse(xhr.responseText);
					resolve(RES.explaindata);
				} catch (e) {
					alert("Data error: "+e.toString());
					reject(e);
				}
			};
			xhr.send();
		});

	}).catch(function(e) {
		console.error(e.toString(), e.fileName.match(/[^\/]+$/)[0] + '::' + e.lineNumber);
		alert(e);
	});

	// Load data for "learn more" part of solutions
	var learnmoredata = new Promise(function (resolve, reject) {
		var xhr = new XMLHttpRequest();
		xhr.open('GET','content/info.json',true);
		xhr.onreadystatechange = function () {
			if (xhr.readyState != 4 || xhr.status != 200) return;
			try {
				RES.learnmoredata = xhr.responseJSON || JSON.parse(xhr.responseText);
				resolve(RES.learnmoredata);
			} catch (e) {
				alert("Data error: "+e.toString());
				reject(e);
			}
		};
		xhr.send();

	}).catch(function(e) {
		console.error(e.toString(), e.fileName.match(/[^\/]+$/)[0] + '::' + e.lineNumber);
		alert(e);
	});

	return (hasAppData = Promise.all([ appdata, solutionsdata, explaindata, learnmoredata ]));
}


/************** / GEOLOCATION /*/

// Last geolocation
var lastLocation = null;

// Application has access to geolocation coords
var hasLocation;

// Init & load app data
function initGeolocation() {
	hasLocation = new Promise(function (resolve, reject) {
		if (!AppConfig('gps')) return;

		navigator.geolocation.getCurrentPosition(
			function (position) {
				resolve(position);

				lastLocation =  position.coords.latitude + ',' + position.coords.longitude;
				//console.log('Last location: '+lastLocation);
			},
			function (e) {
				//console.log('Failed to get geolocation.');
				reject(e);

				setTimeout(initGeolocation,10000);
			}
		);
	});
}


/************** / SCREENS FRAMEWORK /*/

var lastScreen;
function switchScreen(to) {
	lastScreen = activeScreen();
	//console.log('Switch: ',lastScreen,' -> ',to);

	document.querySelector('main>section.active').classList.remove('active');
	document.querySelector('main>section[data-screen="' + to + '"]').classList.add('active');

	document.body.dataset.screen = to;
}
function switchBack() {
	setHeader(['submenu'],document.querySelector('[data-screen="'+lastScreen+'"]').dataset.title);
	return switchScreen(lastScreen);
}
function switchHome() {
	setHeader([]);
	return switchScreen('home');
}

function activeScreen() {
	return document.querySelector('main>section.active').dataset.screen;
}

function setHeader(flags, title, subtitle) {
	if (flags) document.body.dataset.path = flags.join(' ');

	console.debug('Title',title,subtitle);
	document.querySelector('body>header>.title>h1').textContent = (title||'');
	document.querySelector('body>header>.title>h2').textContent = (subtitle||'');
}

function callActivityFallback(number) {
	//console.log('Call activity failed for number '+number);
	window.location.href="tel:"+number;
}
function callActivityHandler(e) {
	var number = (e && e.target && e.target.dataset.number) || e || '';

 	try {
		var activity = new MozActivity({
			name: "webtelephony/number",
			number: number
		});
	}

	catch (e) {
		callActivityFallback(number);
	}

	activity.onsuccess = function() {
		//console.log("Called", this.result);
	};
	activity.onerror = function() {
		callActivityFallback(number);
	};
}

function smsActivityHandler(number, body) {
	var activity;

	try {
		activity = new MozActivity({
			name: 'new',
			data: {
				type: 'websms/sms',
				number: number,
				body: body
			}
		});

		activity.onsuccess = function() {
			//console.log("Sent SMS", this.result);
		};
		activity.onerror = function(e) {
			Console.error("SMS sending error: ", e);
		};
	}

	catch (e) {
		alert('Az SMS-küldés nem használható ezen az eszközön.');
	}
}

function emailActivityHandler(address, body) {
	var activity;
	var url = 'mailto:'+address+'?subject=Segítség! Unicef HelpAPP segélykérés'+(body ? '&body='+encodeURIComponent(body) : '');

	try {
		activity = new MozActivity({
			name: 'new',
			data: {
				type : "mail",
				url: url
			}
		});

		activity.onsuccess = function() {
			//console.log("Sent e-mail", this.result);
		};
		activity.onerror = function(e) {
			Console.error("E-mail sending error: ", e);
		};
	}

	catch (e) {
		window.location.href=url;
	}
}


/************** / BOOTSTRAP APP & UI /*/

function init() {
	// Initialize application config
	initAppConfig();

	// Load app data
	initAppData();

	// Initialize settings
	initSettings();

	// Header dim button
	document.querySelector('body>header>button.lowcontrast').addEventListener('click',function() {
		document.body.dataset.dim = (document.body.dataset.dim === "yes") ? "no" : "yes";
	});

	// Header: about button
	document.querySelector('body>header>button.about').addEventListener('click',function(e) {
		setHeader(['submenu'],document.querySelector('[data-screen="about"]').dataset.title);
		switchScreen('about');
	});

	// Header: settings button
	document.querySelector('body>header>button.settings').addEventListener('click',function(e) {
		setHeader(['submenu'],document.querySelector('[data-screen="settings"]').dataset.title);
		switchScreen('settings');
	});

	// Header: home button
	document.querySelector('body>header>button.home').addEventListener('click',function(e) {
		switchHome();
	});

	// Header: back button
	document.querySelector('body>header>button.back').addEventListener('click',function(e) {
		switchBack();
	});

	// Main page call buttons
	[].forEach.call(document.querySelectorAll('[data-action="call"]'), function(o) {
		o.addEventListener("click", callActivityHandler);
	});

	// Main page SOS call buttons
	document.querySelector('[data-action="call-sos-number-1"]').addEventListener('click', function(e) {
		var number = AppConfig('sos-number-1');
		if (!number) alert('Nem állítottál még be SOS-hívószámot!');
		callActivityHandler(number);
	});
	document.querySelector('[data-action="call-sos-number-2"]').addEventListener('click', function(e) {
		var number = AppConfig('sos-number-2');
		if (!number) alert('Nem állítottál még be SOS-hívószámot!');
		callActivityHandler(number);
	});
	
	// Main page SMS button
	document.querySelector('[data-action="send-sos-sms"]').addEventListener('click', function(e) {
		var number = AppConfig('sos-sms');
		var body = 'Segítségre van szükségem.'+( lastLocation ? ' Itt vagyok: '+lastLocation : '' );

		if (!number) alert('Nem állítottál még be SOS SMS-számot!');
		smsActivityHandler(number, body);
	});

	// Main page e-mail button
	document.querySelector('[data-action="send-sos-email"]').addEventListener('click', function(e) {
		var address = AppConfig('sos-email');
		var body = 'Segítségre van szükségem.'+( lastLocation ? ' Itt vagyok: '+lastLocation : '' );

		if (!address) alert('Nem állítottál még be SOS e-mail címet!');
		emailActivityHandler(address, body);
	});


	// Main page footer: find solutions & learn more page
	hasAppData.then(function(appdata) {
		// Find solution
		initFindSolutionPage();

		document.querySelector('[data-action="find-solution"]').addEventListener('click',function(e) {
			setHeader(['submenu'],document.querySelector('[data-screen="find-solution"]').dataset.title);
			switchScreen('find-solution');
		});
		//console.log('Inited: find-solution');


		// Learn more
		initLearnMorePage();

		document.querySelector('[data-action="learn-more"]').addEventListener('click',function(e) {
			setHeader(['submenu'],document.querySelector('[data-screen="learn-more"]').dataset.title);
			switchScreen('learn-more');
		});
		//console.log('Inited: learn-more');
	}).catch(function(e){
		console.error(e.toString(), e.fileName.match(/[^\/]+$/)[0] + '::' + e.lineNumber);
		alert(e);
	});


	// Main page: geolocation and sos numbers bootstrapping
	// GPS options handlers
	document.querySelector('[data-action="config-gps=1"]').addEventListener('click',function (e) {
		//console.log('Geolocation enabled.');

		AppConfig('gps',1);
		document.querySelector('.toggle[data-config="config-gps"]').dataset.value = 1;
		initGeolocation();
	});
	document.querySelector('[data-action="config-gps=0"]').addEventListener('click',function (e) {
		//console.log('Geolocation disabled!');

		AppConfig('gps',0);
		document.querySelector('.toggle[data-config="config-gps"]').dataset.value = 0;
	});

	// SOS Number initializers
	document.querySelector('[data-action="config-sos-number-1"]').addEventListener('click',function(e) {
		getSOSContact('sos-number').then(function(contact) {
			//console.log(contact);
			AppConfig('sos-number-1', contact.phone);
			AppConfig('sos-number-1-name', contact.name);
			initSettings();
		});
	});
	document.querySelector('[data-action="config-sos-number-2"]').addEventListener('click',function(e) {
		getSOSContact('sos-number').then(function(contact) {
			AppConfig('sos-number-2', contact.phone);
			AppConfig('sos-number-2-name', contact.name);
			initSettings();
		});
	});
	document.querySelector('[data-action="config-sos-sms"]').addEventListener('click',function(e) {
		getSOSContact('sms').then(function(contact) {
			AppConfig('sos-sms', contact.phone);
			initSettings();
		});
	});
	document.querySelector('[data-action="config-sos-email"]').addEventListener('click',function(e) {
		getSOSContact('email').then(function(contact) {
			AppConfig('sos-email', contact.email);
			initSettings();
		});
	});
}

function getSOSContact(contact_type) {
	return new Promise(function (resolve, reject) {
		var pickactivity;

		try {
			throw(new Error('WebActivities polyfill')); // WebActivities not working properly on device, use polyfill

			pickactivity = new MozActivity({
				name: "pick",
				data: {
					type : [ "webcontacts/contact" ]
				}
			});
		}
		catch (e) {
			//console.log('Activity exception: '+e);
			success.call( { result: pickContactPolyfill(contact_type) } );
		}

		//console.log(pickactivity);
		pickactivity.onsuccess = success;
		pickactivity.onerror = function(err) {
			alert(err);
			reject();
		}

		function success() {
			//console.log(this.result);

			var l;
			for (l in this.result) //console.log(l,this.result[l]);
			resolve(this.result);
		};
	});
}
function pickContactPolyfill(contact_type) {
	if (contact_type === 'sms') {
		return {
			phone: prompt("Telefonszám?")
		}
	} else if (contact_type === 'email') {
		return {
			email: prompt("E-mail cím?")
		};
	} else {
		return {
			phone: prompt("Telefonszám?"),
			name: prompt("Név?")
		};
	} 
}



function initSettings() {
	hasAppConfig.then(function() {
		// Current gps setting
		var gps = AppConfig('gps');

		// Update config toggles
		document.querySelector('.toggle[data-config="config-gps"]').dataset.value=gps ? 1 : 0;
		//console.log('Geolocation is '+(gps?'enabled':'disabled')+'.');

		// Bootstrap GEO
		if (gps) initGeolocation();

		// Update SOS contacts
		var sos1 = AppConfig('sos-number-1'),
			sos2 = AppConfig('sos-number-2'),
			sossms = AppConfig('sos-sms'),
			sosemail = AppConfig('sos-email');

		// Show in settings and main page
		if (sos1) {
			document.querySelector('[data-action="config-sos-number-1"]>span>small').innerHTML=AppConfig('sos-number-1-name')+'<br>'+sos1;
			document.querySelector('[data-action="call-sos-number-1"]>span').innerHTML=AppConfig('sos-number-1-name');
		}
		if (sos2) {
			document.querySelector('[data-action="config-sos-number-2"]>span>small').innerHTML=AppConfig('sos-number-2-name')+'<br>'+sos2;
			document.querySelector('[data-action="call-sos-number-2"]>span').innerHTML=AppConfig('sos-number-2-name');
		}

		// Show in settings
		if (sossms) {
			document.querySelector('[data-action="config-sos-sms"]>span>small').innerHTML=sossms;
		}
		if (sosemail) {
			document.querySelector('[data-action="config-sos-email"]>span>small').innerHTML=sosemail;
		}

	}).catch(function(e){
		console.error(e.toString(), e.fileName.match(/[^\/]+$/)[0] + '::' + e.lineNumber);
		alert(e);
	});
}

// Learn more
function initLearnMorePage() {
	var info = RES.appdata.info;

	document.querySelector('[data-screen="learn-more"] > ul').appendChild(
		info.order.reduce(function(frag, label) {
			var li = document.createElement('li');
				li.dataset.about = label;
				li.innerHTML = '<i class="'+label+'"></i><span>'+info.texts[label]+'</span>';

				frag.appendChild(li);

			return frag;
		}, document.createDocumentFragment())
	);

	// Selection handler
	document.querySelector('main>section[data-screen="learn-more"] > ul').addEventListener('click',function(e) {
		var target = e.target;
		if (!target) return;
		while (target && target.tagName !== 'LI') {
			target = target.parentNode;
		}
		var targetlabel = target.dataset.about;
		//console.log(e.target, targetlabel, RES);

		// Set up screen data
		var content = document.querySelector('main>section[data-screen="more-info"] .content');
			content.innerHTML = RES.learnmoredata[targetlabel];
			content.parentNode.scrollTop = 0;

		// Switch screens
		setHeader(['submenu subtitle back'],document.querySelector('[data-screen="more-info"]').dataset.title, RES.appdata.info.texts[targetlabel]);
		switchScreen('more-info');
	});

}


// Find solution
function initFindSolutionPage() {
	var frag;
	var who = RES.appdata.who,
		how = RES.appdata.how;

	// Generate scroll areas with button items
	var lScroll = document.querySelector('.scroller > .left > ul'),
		rScroll = document.querySelector('.scroller > .right > ul');

	lScroll.appendChild(
		who.order.reduce(function (frag, o, n) {
			var e = document.createElement('li');
				e.innerHTML = '<i class="'+o+'"></i><span>'+who.texts[o]+'</span>';
				if (n===0) e.className='selected';
				e.dataset.label=who.texts[o].toLowerCase();

				frag.appendChild(e);

			return frag;

		},document.createDocumentFragment())
	);

	rScroll.appendChild(
		how.order.reduce(function (frag, o, n) {
			var e = document.createElement('li');
				e.innerHTML = '<span>'+how.texts[o]+'</span><i class="'+o+'"></i>';
				if (n===0) e.className='selected';
				e.dataset.label=how.texts[o].toLowerCase();

				frag.appendChild(e);

			return frag;

		},document.createDocumentFragment())
	);

	// Heights of the scrollable viewports
	var lView = lScroll.parentNode, rView = rScroll.parentNode;
	var lH = lView.clientHeight,
		rH = rView.clientHeight;

	lScroll.style.paddingTop = lScroll.style.paddingBottom = lH/2 + 'px';
	lView.scrollTop = lH/2;

	rScroll.style.paddingTop = rScroll.style.paddingBottom = rH/2 + 'px';
	rView.scrollTop = rH/2;

	// Total heights of scrollable contents
	var lSize = lView.scrollHeight,
		rSize = rView.scrollHeight;

	// Scrollables autocentering/option selection
	lScroll.addEventListener('click',function lsc(e,target) {
		target = target || e.target;
		if (!target) return;
		if (!target.tagName || target.tagName!=='LI') {
			return target.parentNode? lsc(e,target.parentNode) : void 0;
		}

		lScroll.querySelector('li.selected').classList.remove('selected');
		target.className='selected';

		// Animated centering
		centerOption(rScroll.querySelector('li.selected'));
		centerOption(target);
	});

	rScroll.addEventListener('click',function rsc(e,target) {
		target = target || e.target;
		if (!target) return;
		if (!target.tagName || target.tagName!=='LI') {
			return target.parentNode? rsc(e,target.parentNode) : void 0;
		}

		rScroll.querySelector('li.selected').classList.remove('selected');
		target.className='selected';

		// Animated centering
		centerOption(lScroll.querySelector('li.selected'));
		centerOption(target);
	});


	// Initial centering of options
	centerOption(lScroll.querySelector('li.selected'));
	centerOption(rScroll.querySelector('li.selected'));

	// What to do-action
	document.querySelector('footer.toolbar > [data-action="what-to-do"]').addEventListener('click',function(e) {
		var who = lScroll.querySelector('li.selected').dataset.label,
			how = rScroll.querySelector('li.selected').dataset.label,
			lkey = lScroll.querySelector('li>i').className,
			rkey = rScroll.querySelector('li>i').className;
		//console.log(who, how, RES.solutionsdata[who][how]);

		// Set up header
		document.querySelector('[data-screen="what-to-do"] .header .left').innerHTML = 
			e.innerHTML = '<i class="'+lkey+'"></i><span>'+RES.appdata.who.texts[lkey]+'</span>';
		document.querySelector('[data-screen="what-to-do"] .header .right').innerHTML = 
			e.innerHTML = '<span>'+RES.appdata.how.texts[rkey]+'</span><i class="'+rkey+'"></i>';

		// Create cards
		document.querySelector('[data-screen="what-to-do"] ul.content').innerHTML=
			RES.solutionsdata[who][how].reduce(function(frag, o, n) {
				return frag+"<li"+(n===0?' class="active"':'')+">"+o+"</li>";
			}, '');

		setHeader(['submenu back'],document.querySelector('[data-screen="what-to-do"]').dataset.title);
		switchScreen('what-to-do');
	});

	// More info/explain action
	document.querySelector('footer.toolbar > [data-action="explain"]').addEventListener('click',function(e) {
		var how = rScroll.querySelector('li.selected').dataset.label;
		//console.log(how);

		// Set up screen data
		document.querySelector('[data-screen="explain"] .content div.what').innerHTML = RES.explaindata[how].what;
		document.querySelector('[data-screen="explain"] .content div.who' ).innerHTML = RES.explaindata[how].who;
		document.querySelector('[data-screen="explain"] .content div.how' ).innerHTML = RES.explaindata[how].how;

		// Switch screens
		setHeader(['submenu subtitle back'],document.querySelector('[data-screen="explain"]').dataset.title, how);
		switchScreen('explain');
	});

	[].forEach.call(document.querySelectorAll('footer.toolbar [data-action="share-idea"]'),function(btn) {
		btn.addEventListener('click',function(e) {
			var url = 'mailto:otlet@unicef.hu?subject='+encodeURIComponent('Ötletem van');
			try {
				new MozActivity({
					name: 'new',
					data: {
						type : 'mail',
						url: url
					}
				});

			} catch (e) {
				window.location.href = url;
			}
		});
	});

	// What-to-do action pagers
	document.querySelector('footer.toolbar [data-action="prev-solution"]').addEventListener('click',function(e) {
		var active = document.querySelector('[data-screen="what-to-do"] > .content > .active');

		active.classList.remove('active');
		(active.previousElementSibling||active.parentNode.lastChild).classList.add('active');
	});

	document.querySelector('footer.toolbar [data-action="next-solution"]').addEventListener('click',function(e) {
		var active = document.querySelector('[data-screen="what-to-do"] > .content > .active');

		active.classList.remove('active');
		(active.nextElementSibling||active.parentNode.firstChild).classList.add('active');
	});

}

function centerOption(target) {
	var raf, start = null, anim;
	var view = target.parentNode.parentNode;
	var sct = target.offsetTop - view.clientHeight/2 - target.clientHeight/2;
	var sts = view.scrollTop;

	// Clamping
	if (sct <0) sct = 0;
	if (sct > view.scrollTopMax) sct = view.scrollTopMax;

	if (sct === sts) return;

	// Animate scroll
	anim = (raf = window.requestAnimationFrame||window.mozRequestAnimationFrame)(function animate(timestamp) {
		var progress;
		// Start
		if (start === null) start = timestamp;
		// Finished scrolling
		if ((progress = timestamp - start) > 1000) {
			return (window.cancelAnimationFrame||window.mozCancelAnimationFrame)(anim);
		} else {
			raf(animate);
		}

		// Animate scroll
		//view.scrollTop = sts + ((sct - sts) * progress/1000);
		view.scrollTop = Math.floor( expo_out( progress/1000, sts, (sct - sts), 1 ) );
	});

	// Easings - based on gizma.com/easing/

	// Easing - linear
	function linear(t, start, change, duration) {
		return change * t / duration + start;
	}
	// Easing - exponential-out
	function expo_out(t, start, change, duration) {
		return change * ( -Math.pow( 2, -10 * t/duration ) + 1 ) + start;
	}
}

return { init: init };

})();

window.APP.init();
