Ext.define('HeroBuilder.view.Main', {
    extend: 'Ext.tab.Panel',
    xtype: 'main',

    requires: [
        'Ext.TitleBar'
    ],

    config: {
        tabBarPosition: 'bottom',

        items: [
            {
                title: 'Home',
                iconCls: 'home',

                styleHtmlContent: true,
                scrollable: true,

                items: {
                    docked: 'top',
                    xtype: 'titlebar',
                    title: 'Hero&apos;s Handbook'
                },

                html: [
                    "Welcome to the Hero's Handbook app for the <em>DungeonBook</em> virtual tabletop application. This app is designed ",
                    "both to introduce you to the basic rules, and to help you to create a Hero character for your first <em>DungeonBook</em> game.<br />", 
                    "<br />If you'd like to learn more about <em>DungeonBook</em>, the <strong>Introduction</strong> section is a good place to start. ",
                    "Alternatively, the <strong>How To Play</strong> section offers a quick guide to <em>DungeonBook</em>'s rules,",
                     " and the <strong>About Heroes</strong> section will give you more information about the main characters in the DungeonBook game."
                ].join("")
            },

            {
                title: 'Introduction',
                iconCls: 'favorites',

                styleHtmlContent: true,
                scrollable: true,

                items: {
                    docked: 'top',
                    xtype: 'titlebar',
                    title: 'Introduction'
                },

                html: [
                    "<h3>What is a Roleplaying Game?</strong></h3>",
                    "A roleplaying game (or RPG) is a game in which you play a fictional character (known in <em>DungeonBook</em> as a <strong>Hero</strong>) in a fantasy setting. A referee (or <strong>StoryMaster</strong>) describes the world and its inhabitants. <br />",
                    "You decide what actions your Hero takes, depending on the situation he (or she) is faced with, and the StoryMaster informs you of the outcome. Dice are often used to represent fate, or to determine the outcome of an action if success is uncertain.<br />", 
                    "Traditionally, RPG's are played on a table, with the players reading their character's information from a sheet of paper, telling the StoryMaster what their character is doing and rolling dice or following the RPG system's rules to determine outcomes.",
                    "<br / ><br /><br /><h3>What type of character will I play?</h3>",
                    "You will play the role of a Hero. Heroes are professional adventurers, people whose job it is to rescue villages from marauding goblins, or recover lost items, or fight Dragons, or perhaps reclaim kingdoms from the wilderness.<br />", 
                    "Not everyone can be a Hero. It takes courage to face the kind of adversity on which Heroes thrive, it takes training to handle a weapon properly, and it takes brains to know when to fight, and when to run!<br />", 
                    "<br /><br /><h3>What makes DungeonBook different?</h3>", 
                    "<em>DungeonBook</em> is a virtual tabletop application, designed specifically for both BlackBerry 10 & BlackBerry PlayBook. It takes the place of the table on which traditional RPG's are usually played. ",
                    "The full <em>DungeonBook</em> app contains everything you need to play: a full set of dice, complete rules, somewhere to store your Hero's information - even a place to keep notes while you play!"
                ].join("")
            },

            {
                title: 'How to Play',
                iconCls: 'info',

                styleHtmlContent: true,
                scrollable: true,

                items: {
                    docked: 'top',
                    xtype: 'titlebar',
                    title: 'How to Play '
                },

                html: [
                    "<h3>About the DungeonBook RPG system</h3>",
                    "The <em>DungeonBook</em> RPG system is designed to be as simple as possible. Most tasks (casting a spell, using an item or attacking an enemy, for example) can be accomplished with just a few taps.<br />", 
                    "<br /><br /><h3>Preparing to Play</h3>",
                    "<em>DungeonBook</em> games are best played with 2 or more players, as well as a StoryMaster. Every player should have a Hero to play, and the StoryMaster should have a Quest prepared (either the Quest included in the DungeonBook app, one of his or her own making, or a downloaded pre-made Quest).<br />",
                    "The StoryMaster should also be familiar with the additional rules contained in the StoryMaster's Guide section of the full DungeonBook app.<br />",
                    "<br /><br /><h3>Start/Join a Game</h3>",
                    "The StoryMaster should login to DungeonBook, and for a new Quest, should choose the <em>'Start New Quest'</em> option (For an existing Quest, choose <em>'Continue Saved Quest'</em> instead).<br />",
                    "Each of the players should then login and select the <em>'Join Game'</em> option. The next screen contains details of available Quests; simply click on the one you wish to join.<br />",
                    "<br /><br /><h3>Import a Hero</h3>",
                    "After you have Joined a game, you will need to import a Hero to play in the DungeonBook game. Click on the \"Import\" button, then select a Hero you've created. If you haven't yet built a Hero, you will be given the option to create one.</strong><br />",
                    "<hr />",
                    "<br /><h3>Game Phases</h3>", 
                    "There are two main phases in <em>DungeonBook</em>: <strong>Exploration</strong> and <strong>Combat</strong>. Everything takes place in one or other of these two phases.<br />",
                    "<br /><br /><h4>Exploration</h4>",
                    "The <strong>Exploration</strong> phase is the most common in DungeonBook, and covers talking to other characters or Heroes, searching an area, using an item - in fact, anything else that doesn't involve combat.<br />", 
                    "The order of events in the Exploration phase is as follows:<br />",
                    "<blockquote><hr /></blockquote>",
                    "<ol><li><em>Random Encounters</em> - StoryMaster checks every two rounds</li>",
                    "<li><em>Actions</em>- Each player describes his (or her) Hero's actions.</li>",
                    "<li><em>Results</em>: If -</li>",
                    "<ol><li>the Heroes enter a new area, it is revealed on the map.</li>",
                    "<li>an encounter occurs, skip to the <strong>Combat</strong> phase.</li>",
                    "<li>a discovery is made (for example, a secret door or hidden item), it is revealed to the discovering player.</li></ol>",
                    "</ol><blockquote><hr /></blockquote>",
                    "<h4>Combat</h4>",
                    "The <strong>Combat</strong> phase, as the name suggests, encompasses combat in all its forms: hand-to-hand (or <em>mélee</em>), magical (offensive and defensive spells), or ranged (using thrown or projectile weapons). ",
                    "The order of events in the Combat phase is as follows:<br />",
                    "<blockquote><hr /></blockquote>",
                    "<ol><li>Determine Initiative by rolling 1d8.</li>",
                    "<li>The side with the higher score acts first:</li>",
                    "<ol><li>Movement</li>",
                    "<li>Ranged combat</li>",
                    "<ol><li>Select target</li>",
                    "<li>Roll to Hit</li>",
                    "<li>Roll for damage</li></ol>",
                    "<li>Magic</li>",
                    "<ol><li>Select target</li>",
                    "<li>Make Resistance rolls</li>",
                    "<li>Apply result immediately</li></ol>",
                    "<li>Mélee combat</li>",
                    "<ol><li>Select target</li>",
                    "<li>Make Hit Rolls</li>",
                    "<li>Roll for damage</li></ol></ol>",
                    "<li>The side with the lower score follows the above steps.</li>",
                    "<li>Results: If -</li>",
                    "<ol><li>all monsters have been defeated, combat ends; return to the <strong>Exploration</strong> phase.</li>",
                    "<li>one side runs away, the other may wish to pursue, and the fleeing side may attempt escape.</li>",
                    "<li>the combat continues; return to Step 1 of the Combat phase</li></ol>",
                    "</ol><br />",
                    "The sequence continues until one side is defeated, surrenders, or manages a successful retreat.",
                    "<blockquote><hr /></blockquote>",
                    "Once the <strong>Combat</strong> phase has ended, play reverts to the <strong>Exploration</strong> phase."
                ].join("")
            },

            {
                title: 'About Heroes',
                iconCls: 'user',

                styleHtmlContent: true,
                scrollable: true,

                items: {
                    docked: 'top',
                    xtype: 'titlebar',
                    title: 'About Heroes'
                },

                html: [
                     "<em>DungeonBook</em>'s Hero-building process is really simple, but there are a few choices which will affect your game. This page describes the main options and the differences between them.<br />",
                     "<br /><br /><h3>General Information</h3>", 
                     "<h4>Race</strong></h4>",
                     "There are three Hero races to choose from:<br />",
                     "The sturdy <strong>Dwarf</strong>, the mystical <strong>Elf</strong> or the adaptable <strong>Human</strong>.<br />",
                      "<br /><h5>The Dwarf</h5>",
                      "Dwarves are well-renowned across Druithar for their prowess in battle. Whether assailed by physical or magical force, Dwarves stand strong.<br />",
                      "<em>As a result of their superior fighting ability, Dwarves gain a BONUS to their Attack statistic. However, Dwarves show very little aptitude for Magic, so they incur a PENALTY to their Magic stat.</em><br />",
                      "<br /><h5>The Elf</h5>",
                      "Elves are the longest lived of Druithar's principal races. This longevity means that Elves are ideally suited to the study of Magic. However, the Elvish race has paid a price for their studies: they are generally physically weaker, compared to the other races.<br />",
                      "<em>Elves' natural magical ability earns them a BONUS to their Magic statistic. Due to their weakened constitutions, however, they incur a PENALTY to their Attack stat.</em><br />",
                      "<br /><h5>The Human</h5>",
                      "Humans are the most numerous of Druithar's races. The secret to their proliferation is their natural adaptability - Humans are well-known for being able to turn their hands to almost any task.<br />",
                      "<em>Humans are the most adaptable of Druithar's races, but do not specialise in the way that the other races do. They incur no PENALTIES to any stats, but they gain no BONUSES either.</em><br />",
                      "<br /><br /><h4>Gender</h4>",
                      "Your DungeonBook Hero may be either Male or Female. Neither gender gains any advantage over the other. DungeonBook generally uses your Hero's gender in order to personalise your playing experience (generally for in-game text, or when referring to your Hero as \"him\" or \"her\".<br />",
                      "<br /><br /><h4>Name</h4>",
                      "You will need to give your Hero a name, whether it's a real-world name, such as \"Stephen\" or \"Jessica\", or a fantasy name like \"SwiftFoot\", or \"Darksword\".<br />",
                      "If you are having trouble thinking of a name for your Hero, DungeonBook can generate one for you.<br /> ",
                      "<br /><br /><h3>Statistics</h3>",
                      "<h5>Health</h5>",
                      "Your Hero's <strong>Health</strong> stat represents how much physical punishment he (or she) can withstand. A Hero with a higher Health stat is able to work harder, for longer, than a Hero with a lower Health stat.<br />",
                      "<br /><h5>Attack</h5>",
                      "The <strong>Attack</strong> stat shows how effective your Hero is at physical attacks, either with a weapon or bare-handed. A Hero with a higher Attack stat tends to attack with greater force than a Hero with a lower Attack stat.<br />",
                      "<br /><h5>Defend</h5>",
                      "Your Hero's <strong>Defend</strong> stat illustrates how well he (or she) is able to defend himself (or herself) when physically attacked. Heroes with a higher Defend stat generally take less damage than Heroes with lower ones.<br />",
                      "<br /><h5>Magic</h5>",
                      "The <strong>Magic</strong> statistic is a measure of your Hero's prowess with Magic. Real control of Magic takes years of practice, however almost all Heroes have <em>some</em> innate ability. Heroes with a higher Magic stat can cast more powerful magic than Heroes with lower Magic stats.<br />",
                      "<br /><br /><h3>Inventory</h3>",
                      "Your newly-created Hero has no weapons, no armour and no adventuring supplies - yet! You will have the opportunity to purchase all the equipment and supplies your Hero will need before you embark on your first Quest."
                ].join("")
            },

           {
                title: 'Credits',
                iconCls: 'compose',

                styleHtmlContent: true,
                scrollable: true,


                items: {
                    docked: 'top',
                    xtype: 'titlebar',
                    title: 'Credits'
                },

                html: [
                    "<em>DungeonBook Hero's Handbook</em> was built using the Sencha Touch application framework.<br />",
                    "<br /><strong>This application, its contents and the DungeonBook RPG system featured within are &copy;Jon&nbsp;Hunnings,&nbsp;MMIII. All rights reserved.</strong><br />",
                    "<br /><h4>Dedication:</h4>",
                    "This app is dedicated to Sam, for saying nothing when I spent days glued to my BlackBerry, and to Elliot and Briony, who were the inspiration behind DungeonBook in the first place.<br />",
                    "<br /><h5>Special Mention:</h5>",
                    " Special thanks to the Developer team at BlackBerry, especially Tom Anderson, William Vablais and Asha Sodha. Thanks also to Alejandro Diaz, Alex Bass, Justin Tokarchuk, Shane Cridlebaugh, John Reid, Lloyd Summers, Jeremy Duke and Thomas (@ph03n1x)."
                ].join(" ")
            },
        ]
    }
});