/*global angular */

define(['angular'], function() {
  // this is where our app definition is
  var app = angular
    .module('app', ['mobile-navigate', 'ngCookies', 'angularMoment'])
    .value('$anchorScroll', angular.noop)
    .config(['$routeProvider', '$provide', function($routeProvider, $provide) {
      
      // $provide.factory('xmlHttpInterceptor', ['xmlFilter', function (xmlFilter) {
      //   return function (promise) {
      //     return promise.then(function (response) {
      //       response.xml = xmlFilter(response.data);
      //       return response;
      //     });
      //   };
      // }]);

      // here we specify routes
      // which HTML and JS to execute when a certain route is requested
      $routeProvider
        .when('/', {
          //templateUrl: 'views/list.html',
          templateUrl: 'views/main.html',
          controller: 'MainCtrl'
        })
        .when('/login', {
          templateUrl: 'views/login.html',
          controller: 'LoginCtrl'
        })
        .when('/forgotpassword', {
          templateUrl: 'views/forgotpassword.html',
          controller: 'LoginCtrl'
        })
        .when('/register', {
          templateUrl: 'views/register.html',
          controller: 'RegisterCtrl'
        })
        .when('/issues', {
          templateUrl: 'views/issues.html',
          controller: 'IssuesCtrl'
        })
        .when('/issue/:id', {
          templateUrl: 'views/issue.html',
          controller: 'IssueCtrl'
        })
        .when('/map/:lat/:lng', {
          templateUrl: 'views/map.html',
          controller: 'MapCtrl'
        })
        .when('/hero/:id', {
          templateUrl: 'views/hero.html',
          controller: 'HeroCtrl'
        })
        /*.when('/detail/:id', {
          templateUrl: 'views/detail.html',
          controller: 'DetailCtrl'
        })*/
        .when('/add', {
          templateUrl: 'views/newIssue.html',
          controller: 'NewIssueCtrl'
        })
        .when('/edit/:id', {
          templateUrl: 'views/edit.html',
          controller: 'EditCtrl'
        })
        .when('/comments/:object_id', {
          templateUrl: 'views/comments.html',
          controller: 'CommentsCtrl'
        })
        .when('/menu', {
          templateUrl: 'views/menu.html',
          controller: 'MenuCtrl'
        })
        .when('/search', {
          templateUrl: 'views/search.html',
          controller: 'SearchCtrl'
        })
        .when('/myIssues', {
          templateUrl: 'views/myIssues.html',
          controller: 'IssuesCtrl'
        })
        .when('/settings', {
          templateUrl: 'views/settings.html',
          controller: 'SettingsCtrl'
        })
        .when('/chAvatar', {
          templateUrl: 'views/chAvatar.html'
        })
        .when('/chName', {
          templateUrl: 'views/chName.html',
          controller: 'SettingsCtrl'
        })
        .when('/chLanguage', {
          templateUrl: 'views/chLanguage.html'
        })
        .when('/delete', {
          templateUrl: 'views/deleteAccount.html',
          controller: 'SettingsCtrl'
        })
        .when('/about', {
          templateUrl: 'views/about.html',
          controller: ''
        })
        .otherwise({
          redirectTo: '/'
        });
    }]);
  
  app.controller('MainCtrl', ['$scope', '$navigate', '$location', '$cookieStore', 'localize', function($scope, $navigate, $location, $cookieStore, localize) {
    $scope.$navigate = $navigate;
    var search = $location.search();

    // IF THE USER IS ALREADY LOGGED IN, SEND HIM TO THE ISSUES PAGE
    if (!$cookieStore.get('user')) {
      $navigate.go($location.path(), 'none').search(search);
    } else {
      $navigate.go('/issues', 'slide').search(search);
    }

    if ($cookieStore.get('user_app_language')) {
      localize.language = $cookieStore.get('user_app_language').language;
    }
  }]);

  app.config(['$httpProvider', function($httpProvider) {
    delete $httpProvider.defaults.headers.common['X-Requested-With'];
  }]);

  // TouchStart is faster than click, that's why we add this here as a
  // directive. Use `ng-tap` in code rather than `ng-click`.
  app.directive('ngTap', function() {
    var isTouch = !!('ontouchstart' in window);
    return function(scope, elm, attrs) {
      // if there is no touch available, we'll fall back to click
      if (isTouch) {
        var tapping = false;
        elm.bind('touchstart', function() {
          tapping = true;
        });
        // prevent firing when someone is f.e. dragging
        elm.bind('touchmove', function() {
          tapping = false;
        });
        elm.bind('touchend', function() {
          tapping && scope.$apply(attrs.ngTap);
        });
      }
      else {
        elm.bind('click', function() {
          scope.$apply(attrs.ngTap);
        });
      }
    };
  });

  app.directive('onKeyup', function() {
    return function(scope, elm, attrs) {
      elm.bind("keyup", function() {
        scope.$apply(attrs.onKeyup);
      });
    };
  });

  return app;
});
