'use strict';

define(['app'], function(app) {
	app.controller('CommentsCtrl', ['$rootScope', '$scope', '$routeParams', '$cookieStore', '$location', '$http', 
		function($rootScope, $scope, $routeParams, $cookieStore, $location, $http) {
		$rootScope.user = $cookieStore.get('user') || $location.path('/login');
		$scope.comments = [];

		var formData = new FormData();
            formData.append('object_id', $routeParams.object_id);

		$http({
            method: 'GET', 
            url: globals.RootPath + '/comments?object_id=' + $routeParams.object_id,
            headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId}
        })
        .success(function(res, status){
        	if (status !== 200) return false;
        	
        	var comments = res.data;
            for (var c=0; c < comments.length; c++) {
                var comment = comments[c];

                // if (issue.microtime && issue.microtime != 'null' && issue.microtime != null) {
                //     var momentDate = moment.unix(issue.microtime);
                //     var issueDate = new Date(momentDate);
                //     issue.modification_date = new Date(moment(issueDate).format('MMMM D, YYYY hh:mm:ss'));
                // } else {
                //     issue.modification_date = 0;
                // }

                comment.userImage = '';
                if (comment.user.selected_image) {
                    switch (comment.user.selected_image) {
                        case 'avatar':
                            issue.userImage = globals.S3PathAvatars + issue.user.avatar + '_c_ldpi.png';
                        break;

                        case 'fb':
                            //comment.userImage = comment.user.fb_image;
                            comment.userImage = 'http://graph.facebook.com/' + comment.user.fb_id + '/picture?width=70&height=70';
                        break;

                        case 'uploaded':
                            comment.userImage = globals.S3Path + comment.user.media[0].filename;
                        break;
                    }
                }

                if (comment.microtime && comment.microtime != 'null' && comment.microtime != null) {
                    var momentDate = moment.unix(comment.microtime);
                    var commentDate = new Date(momentDate);
                    comment.modification_date = new Date(moment(commentDate).format('MMMM D, YYYY HH:mm:ss'));
                } else {
                    comment.modification_date = 0;
                }
            }

            $scope.comments = comments;
            
        })
        .error(function(data, status){
        });
        

        $scope.send = function(){
        	var formData = new FormData();
            formData.append('object_id', $routeParams.object_id);
            formData.append('content', $scope.content);
            
            $http.post(globals.RootPath + '/comments', formData, {
				//url: globals.RootPath + '/proxy.php',
				headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                transformRequest: angular.identity
			})
			.success(function(res, status){
				if (status !== 200) return false;
                var newComment = res.data;
                
                if (newComment.microtime && newComment.microtime != 'null' && newComment.microtime != null) {
                    var momentDate = moment.unix(newComment.microtime);
                    var commentDate = new Date(momentDate);
                    newComment.modification_date = new Date(moment(commentDate).format('MMMM D, YYYY HH:mm:ss'));
                } else {
                    newComment.modification_date = 0;
                }
				$scope.comments.unshift(newComment);
                // CLEAR THE COMMENT TEXT AREA IF THE COMMENT IS SENT SUCCESSFULLY
                $scope.content = '';
			})
			.error(function(data, status){
			});
		};
	}]);
});