'use strict';

define(['app'], function(app) {
    app.controller('IssueCtrl', ['$rootScope', '$scope', '$routeParams', '$cookieStore', '$location', '$http', '$q', 'checkRetina', '$window',
        function($rootScope, $scope, $routeParams, $cookieStore, $location, $http, $q, checkRetina, $window) {
        $rootScope.user = $cookieStore.get('user') || $location.path('/login');

        $scope.photos = [];
        
        //console.log(globals.RootPath + '/proxy.php?url=issues/' + $routeParams.id);
        //$http({method: 'GET', url: globals.RootPath + '/proxy.php?ConsumerKey=' + globals.ConsumerKey + '&url=issue&AuthorizationId=' + $rootScope.user.authorizationId})
        $http({
            method: 'GET', 
            //url: globals.RootPath + '/proxy.php?url=issues/' + $routeParams.id + '?counter=1',
            url: globals.RootPath + '/issues/' + $routeParams.id + '?counter=1',
            // data: 'counter=1',
            headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId}
        })
        .success(function(res, status){
            if (status !== 200) return false;
            
            var needLocation = false;
            var address = '';
            var issue = res.data[0];

            if (issue.fsq) {
                if (issue.fsq.fsq_address && issue.fsq.fsq_address.length > 0) {
                    address = issue.fsq.fsq_address;
                } else {
                    needLocation = true;
                }
            } else {
                needLocation = true;
            }

            if (needLocation) {
                var neighbourhood = issue.location.neighbourhood;
                var suburb = issue.location.suburb;
                var city = issue.location.city;
                var county = issue.location.county;
                var country = issue.location.country;
                var state = issue.location.state;
                
                if (neighbourhood.length > 0) address += neighbourhood + ', ';
                if (suburb.length > 0) address += suburb + ', ';
                if (city.length > 0) address += city + ', ';
                if (county.length > 0) address += county + ', ';
                if (country.length > 0) address += country + ', ';
                if (state.length > 0) address += state;
            }

            if (issue.fsq.fsq_name) {
                issue.address = issue.fsq.fsq_name + ', ' + address;
            } else {
                issue.address = address;
            }
            
            issue.userImage = '';
            if (issue.user.selected_image) {
                switch (issue.user.selected_image) {
                    case 'avatar':
                        issue.userImage = globals.S3PathAvatars + issue.user.avatar + '_c_ldpi.png';
                    break;

                    case 'fb':
                        //issue.userImage = issue.user.fb_image;
                        issue.userImage = 'http://graph.facebook.com/' + issue.user.fb_id + '/picture?width=70&height=70';
                    break;

                    case 'uploaded':
                        issue.userImage = globals.S3Path + issue.user.media[0].filename;
                    break;
                }
            }
            // console.log(issue.userImage);
                
            var counter = res.counter;
            if (issue.media && issue.media[0] && issue.media[0].filename)
                issue.mainImg = globals.S3Path + issue.media[0].filename;
            else
                issue.mainImg = '';

            if (issue.microtime && issue.microtime != 'null' && issue.microtime != null) {
                var momentDate = moment.unix(issue.microtime);
                var issueDate = new Date(momentDate);
                issue.modification_date = new Date(moment(issueDate).format('MMMM D, YYYY hh:mm:ss'));
            } else {
                issue.modification_date = '';
            }
                
            $scope.issue = issue;
            $scope.counter = counter;
            $scope.issue.user.creation_date = new Date();

            if (issue.voted == 1)
                    issue.class = 'ftrBtn voteFtr voteFtrOK';
                else
                    issue.class = 'ftrBtn voteFtr';

                var catColor = issue.category.color;
                var catIcon = globals.S3PathIcons + issue.category.id + '_c_hdpi.png';
                
                // IF CATEGORY IS NOT SET, SHOW THE DEFAULT ICON
                if (!issue.category.id) {
                    catIcon = globals.S3PathIcons + issue.category.id + '_c_hdpi_default.png';
                }

                if (checkRetina.isRetina($window)) {
                    catIcon = globals.S3PathIcons + issue.category.id + '_c_hdpi.png';

                    // IF CATEGORY IS NOT SET, SHOW THE DEFAULT ICON (RETINA THIS TIME)
                    if (!issue.category.id) {
                        catIcon = globals.S3PathIcons + issue.category.id + '_c_xhdpi_default.png';
                    }
                }
                issue.catStyle = {background:'url(' + catIcon + ') no-repeat'};
        })
        .error(function(data, status){
        });

        //Vote for this issue from single issue view

        $scope.vote = function(issue){
            
            // var VOTE_SUCCESS = function(res) {
            //     if(voted == 1) alert("You already voted for thiss issue. You can't vote again.");

            //     console.log("Vote OK");
            // }

            var voted = issue.voted;
            var object_id = issue.object_id;
            var formData = new FormData();
            formData.append('object_id', object_id);
            formData.append('callback', 'VOTE_SUCCESS');

            if(voted == 0) {
                $http.post(globals.RootPath + '/votes', formData, {
                    //url: globals.RootPath + '/proxy.php?url=votes?object_id=' + object_id,
                    headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                    transformRequest: angular.identity
                })
                .success(function(res, status){
                    if (status !== 200) return false;
                    $('#ftrBtn' + issue.id).addClass('voteFtrOK');

                    // FORCE THE ISSUES REQUEST TO RELOAD ALL THE ISSUES
                    $rootScope.issues_delete_cache = true;
                    //eval(res);
                })
                .error(function(data, status){
                    
                });
            }else{
                $('#ftrBtn' + issue.id).addClass('voteFtrOK');
                alert("You already voted for this issue. You can't vote again.");
            }
        };

//Flag issue as inappropriate

        $scope.flag = function(object_id){
            var REPORT_SUCCESSFULL = function(res) {
                // console.log("Flag OK");
            }

            var formData = new FormData();
            formData.append('object_id', object_id);
            formData.append('callback', 'REPORT_SUCCESSFULL');

            $http.post(globals.RootPath + '/reports', formData, {
                headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                transformRequest: angular.identity
            }).success(function(res, statys) {
                if (status !== 200) return false;
                

                eval(res);
            }).error(function(res, status) {
                
            });
        };

        //Add image to an already published issue

        $scope.takePicture = function() {
            var pickImg = new MozActivity({
                name: "pick",
                data: {
                    type: ["image/jpg", "image/jpeg", "img/png"]
                }
            });

            pickImg.onsuccess = function () { 
                // we got an image! (returned as a blob)
                // now let's send it to the API
                var blob = this.result.blob;
                var img = document.createElement("img");
                img.src = window.URL.createObjectURL(blob);
                
                // now display the image in your app
                // $("#issueImg").append(img);
                if ($scope.photos.length == 0) 
                    $("#issueImg1").append(img);
                else if ($scope.photos.length == 1) 
                    $("#issueImg2").append(img);
                else if ($scope.photos.length == 2) 
                    $("#issueImg3").append(img);

                var fileToDataURL = function (file) {
                    var deferred = $q.defer();
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        deferred.resolve(e.target.result);
                    };
                    reader.readAsDataURL(file);
                    return deferred.promise;
                };
                // console.log('object_id:' + $scope.issue.object_id);

                var url = window.URL.createObjectURL(blob);
                fileToDataURL(blob).then(function (dataURL) {
                    var formData = new FormData();
                    formData.append('object_id', $scope.issue.object_id);
                    formData.append('url', 'media');
                    formData.append('photo', blob, 'photo');
                    
                    $http.post(globals.RootPath + '/media', formData, {
                        headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                        transformRequest: angular.identity
                    }).success(function(res) {
                        $scope.result = res;
                        $scope.photos.push(res.file);

                        
                    }).error(function(result) {
                    });
                });
                alert("Thanks! You successfully uploaded the image for this issue");

            };
            pickImg.onerror = function () { 
                // didn’t work...
                //alert("Something went wrong trying to get the image from your camera!")
            };
        }
    }]);
});