'use strict';

define(['app'], function(app) {
	app.controller('IssuesCtrl', ['$rootScope', '$scope', '$http', '$location', '$window', '$cookieStore', 'checkRetina', 'http', '$navigate',
        function ($rootScope, $scope, $http, $location, $window, $cookieStore, checkRetina, http, $navigate) {

        if (!$cookieStore.get('user')) {
            $location.path('/login');
            //$navigate.eraseHistory();

            return false;
        }
        $rootScope.user = $cookieStore.get('user') || $location.path('/login');


        var _cache = false;
        if ($rootScope.issues_delete_cache) _cache = true;

        var _url = globals.RootPath + '/issues';

        if ($location.path() == '/myIssues') {
            // FORCE THE ISSUES REQUEST TO RELOAD ALL THE ISSUES
            _url = globals.RootPath + '/issues?id_user=' + $rootScope.user.user_id;
        }

        http({
            idbCache: {cacheKey: 'issues', expiresInMs: 60000, forceSkipCache: _cache},
            method: 'GET',
            url: _url,
            headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId}
        })
        .success(function(res, status){
        	//console.log('status: ' + status);
            //console.debug(res);
        	//eval(res);

            // RESTORE THE CACHE TO TRUE IN CASE IT WAS FALSE
            $rootScope.issues_delete_cache = false;

            $scope.issues = [];

            for (var i=0; i<res.data.length; i++) {
                var needLocation = false;
                var address = '';


                if (res.data[i].fsq) {
                    if (res.data[i].fsq.fsq_address && res.data[i].fsq.fsq_address.length > 0) {
                        address = res.data[i].fsq.fsq_address;
                    } else {
                        needLocation = true;
                    }
                } else {
                    needLocation = true;
                }

                if (needLocation) {
                    var neighbourhood = res.data[i].location.neighbourhood;
                    var suburb = res.data[i].location.suburb;
                    var city = res.data[i].location.city;
                    var county = res.data[i].location.county;
                    var country = res.data[i].location.country;
                    var state = res.data[i].location.state;

                    if (neighbourhood.length > 0) address += neighbourhood + ', ';
                    if (suburb.length > 0) address += suburb + ', ';
                    if (city.length > 0) address += city + ', ';
                    if (county.length > 0) address += county + ', ';
                    if (country.length > 0) address += country + ', ';
                    if (state.length > 0) address += state;
                }

                var issue = res.data[i];

                issue.address = address;

                if (issue.image.length > 0) {
                    issue.image = globals.S3Path + res.data[i].image;
                } else {
                    issue.image = '';
                }

                issue.userImage = '';
                if (issue.user.selected_image) {
                    switch (issue.user.selected_image) {
                        case 'avatar':
                            issue.userImage = globals.S3PathAvatars + issue.user.avatar + '_c_hdpi.png';
                        break;

                        case 'fb':
                            //issue.userImage = issue.user.fb_image;
                            issue.userImage = 'http://graph.facebook.com/' + issue.user.fb_id + '/picture?width=70&height=70';
                        break;

                        case 'uploaded':
                            issue.userImage = globals.S3Path + issue.user.media[0].filename;
                        break;
                    }
                }
                var catColor = issue.category.color;
                var catIcon = globals.S3PathIcons + issue.category.id + '_s_ldpi.png';

                // IF CATEGORY IS NOT SET, SHOW THE DEFAULT ICON
                if (!issue.category.id) {
                    catIcon = globals.S3PathIcons + issue.category.id + '_s_ldpi_default.png';
                }

                if (checkRetina.isRetina($window)) {
                    catIcon = globals.S3PathIcons + issue.category.id + '_s_hdpi.png';

                    // IF CATEGORY IS NOT SET, SHOW THE DEFAULT ICON (RETINA THIS TIME)
                    if (!issue.category.id) {
                        catIcon = globals.S3PathIcons + issue.category.id + '_s_xhdpi_default.png';
                    }
                }


                issue.catStyle={background:'url(' + catIcon + ')'};

                if (issue.voted == 1)
                    issue.class = 'voteBtn voteBtnON';
                else
                    issue.class = 'voteBtn';

                if (issue.microtime && issue.microtime != 'null' && issue.microtime != null) {
                    var momentDate = moment.unix(issue.microtime);
                    var issueDate = new Date(momentDate);
                    issue.modification_date = new Date(moment(issueDate).format('MMMM D, YYYY HH:mm:ss'));
                } else {
                    issue.modification_date = 0;
                }

                $scope.issues.push(issue);
            }
        })
        .error(function(data, status){
        });

        //Vote for this issue from all issues view

	  	$scope.vote = function(issue){
            var voted = issue.voted;
            var object_id = issue.object_id;
            var formData = new FormData();
            formData.append('object_id', object_id);

            if(voted == 0) {
                $http.post(globals.RootPath + '/votes', formData, {
                    headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                    transformRequest: angular.identity
                })
                .success(function(res, status){
                    if (status !== 200) return false;
                    $('#voteBtn' + issue.id).addClass('voteBtnON');

                    issue.voted = 1;
                })
                .error(function(data, status){
                });
            }
            else{
                $('#voteBtn' + issue.id).addClass('voteBtnON');
                alert("You already voted for this issue. You can\'t vote again.");
            }
        };

        $scope.goBack = function(){
            $rootScope.issues_delete_cache = true;
            $navigate.back();
        }

	}]);
});
