'use strict';

define(['app'], function(app) {
    app.controller('LoginCtrl', ['$rootScope', '$scope', '$location', '$cookieStore', 'Auth', 'md5', '$navigate', '$http', 'i18n',
        function($rootScope, $scope, $location, $cookieStore, Auth, md5, $navigate, $http, i18n) {
        //var xml = xmlFilter('<blogs><blog name="my first blog" id="1"/></blogs>');
        //console.log(xml.find('blog'));

        $scope.rememberme = true;

        $scope.login = function() {
            $scope.msg = false;
            // var hash_pass = md5.createHash($scope.password);

            Auth.login({
                    username: $scope.username,
                    password: $scope.password
                },
                function(res, status) {
                    if (res.login == 'fail') {
                        $scope.msg = res.msg;
                    } else {
                        //TODO: add role to the received object
                        //$rootScope.user should be set using the username and the role both sent by the server
                        var user_image = '';

                        switch (res.data.selected_image) {
                            case 'fb':
                                if (res.data.fb_image.length > 0) {
                                    user_image = res.data.fb_image;
                                }
                            break;

                            case 'avatar':
                                // TODO
                                // AVATAR IMAGES ARE STILL NOT UPLOADED ON S3...
                                if (res.data.avatar.length > 0) {
                                    user_image = globals.S3PathAvatars + res.data.avatar + '_c_mdpi.png';
                                }
                            break;

                            case 'uploaded':
                                if (res.data.media && res.data.media[0] && res.data.media[0].filename)
                                    user_image = globals.S3Path + res.data.media[0].filename;
                            break;
                        }


                        $cookieStore.put('user', {
                            role: 2,
                            user_id: res.data.id,
                            username: res.data.username,
                            first_name: res.data.first_name,
                            last_name: res.data.last_name,
                            user_image: user_image,
                            authorizationId: res.authorization_id
                        });

                        $rootScope.user = $cookieStore.get('user') || { username: '', role: userRoles.public };

                        // console.log('LOGGED IN: ' + $rootScope.user.role);
                        if ($rootScope.user.role > 1)
                            //$location.path('/issues');
                            $navigate.go('/issues', 'slide');
                    }
                },
                function(err, status) {
                    // console.log('ERROR LOGIN: ' + status);
                    // console.debug(err);
                    $rootScope.error = "Failed to login";
                });
        };

        $scope.successLogoutCb = function() {
            $location.path('/');
        }
        $scope.errorLogoutCb = function(){
            // console.log('Error trying to logging out');
        }

        $scope.logout = function() {
            Auth.logout($scope.successLogoutCb, $scope.errorLogoutCb);
        };


        $scope.forgotPassword = function(){
            var user_email = $scope.user_email;
            // console.log('user email: ' + user_email);
            $http({
                method: 'POST',
                url: globals.RootPath + '/heroj/forgot-password?email=' + user_email,
                headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .success(function(res, status) {
                if (status !== 200) return false;

                $cookieStore.remove('user');
                $rootScope.user = '';

                alert('You will receive an email with instructions about how to reset your password. Now you\'re gonna be redirected to the login screen.');
                $navigate.go('/login', 'none');

            })
            .error(function(res, status) {
                alert('Something went wrong. Please try again.');
            });
        };




    }]);
});