'use strict';

define(['app'], function(app) {
	app.controller('MenuCtrl', ['$rootScope', '$scope', '$http', '$navigate','$cookieStore', function ($rootScope, $scope, $http, $navigate, $cookieStore){
		
        $scope.user = $rootScope.user;
        
        $http({
			method: 'GET', 
            url: globals.RootPath + '/users/' + $rootScope.user.user_id + '?counter=1',
			headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId}
		})
        .success(function(res, status){
            if (status !== 200) return false;
        	// console.log('success status: ' + status);
			// console.debug(res);
            var hero = res.data[0];
            hero.userImage = '';
                if (hero.selected_image) {
                    switch (hero.selected_image) {
                        case 'avatar':
                            hero.userImage = globals.S3PathAvatars + hero.avatar + '_c_ldpi.png';
                        break;

                        case 'fb':
                            // hero.userImage = hero.fb_image;
                            hero.userImage = 'http://graph.facebook.com/' + hero.fb_id + '/picture?width=70&height=70';
                        break;

                        case 'uploaded':
                            hero.userImage = globals.S3Path + hero.media[0].filename;
                        break;
                    }
                }
                
            // $rootScope.user.user_image = hero.userImage;
            $scope.hero = hero;
            $scope.counter = res.counter;
        })
        .error(function(data, status){
        });

        $scope.myIssues = function () {
            $rootScope.issues_delete_cache = true; 
            $navigate.go('/myIssues', 'slide');
        };

        $scope.logOut = function(){
                $cookieStore.remove('user');
                $rootScope.user = '';
                alert('You are now signed out. Come back soon!');
                $navigate.go('/login', 'none');
        };

	}]);
});