'use strict';

define(['app'], function(app) {
	app.controller('NewIssueCtrl', ['$rootScope', '$scope', '$routeParams', '$cookieStore', '$location', '$http', '$q', '$navigate', '$window',
		function($rootScope, $scope, $routeParams, $cookieStore, $location, $http, $q, $navigate, $window) {
		$rootScope.user = $cookieStore.get('user') || $location.path('/login');
   
		$scope.photos = [];
		// FETCH THE COUNTRY NAME SO THAT IT WILL BE AVAILABLE WHEN SEARCHING PLACES IN FOURSQUARE
		$scope.country = 'all';
		if (!$rootScope.user.lat || !$rootScope.user.lng) {
			if ("geolocation" in $window.navigator) {
                var options = {
                  timeout: 20000,
                  maximumAge: 0
                };

                function success(pos) {
                	var crd = pos.coords;
                	$rootScope.user.lat = crd.latitude;
                	$rootScope.user.lng = crd.longitude;

                  	$http.get('http://api.geonames.org/countrySubdivisionJSON?lat=' + $rootScope.user.lat + '&lng=' + $rootScope.user.lng + '&username=fleka')
					.success(function(res, status){
						if (res.message || status != 200) {
							// REACHED MAXIMUM LIMIT OF 3000 REQUESTS PER DAY
							$scope.country = 'all';
							return;	
						}
						$scope.country = res.countryName;
					})
					.error(function(res, status){
						$scope.country = 'all';
					})
                };

                function error(err) {
                  // alert('ERROR(' + err.code + '): ' + err.message);
                };

                $window.navigator.geolocation.getCurrentPosition(success, error, options);
            } else {
              /* geolocation IS NOT available */
              alert('no geolocation');
            }
		}

		$scope.newIssue = function(){
        	// BUILD A STRING OF PHOTOS LIKE IF IT WOULD BE A JSON ARRAY
			var photos_str = '[';
			for (var p=0; p<$scope.photos.length;p++) {
				if (p>0) photos_str += ',';
				
				photos_str += '"' + $scope.photos[p] + '"';
			}
			photos_str += ']';

			var formData = new FormData();
            formData.append('title', $scope.title);
            formData.append('description', $scope.desc);
            formData.append('id_category', $scope.categoryID);
            formData.append('lat', $scope.lat);
            formData.append('lng', $scope.lng);
            formData.append('photos', photos_str);

            $http.post(globals.RootPath + '/issues', formData, {
                headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                transformRequest: angular.identity
            }).success(function(res) {
				//reset the variables, so a new issue can be posted
				$scope.photos = [];

				// FORCE THE ISSUES REQUEST TO RELOAD ALL THE ISSUES
				$rootScope.issues_delete_cache = true;

				alert('Issue added successfully ;)');
				$navigate.go('/issues', 'slide');
            }).error(function(result) {
            });
		};

		$scope.selected = undefined;
		$scope.fsqPlaces = [];

		$scope.getSelectedLatLng = function(_index) {
			$('.fsqPlaces').hide();
			$scope.lat = $scope.fsqPlaces[_index].location.lat;
			$scope.lng = $scope.fsqPlaces[_index].location.lng;
			$scope.selected = $scope.fsqPlaces[_index].name;

		}

		$scope.suggestFsqVenues = function() {
			var query = $scope.selected;
			if (query.length < 3) {
				$scope.fsqPlaces = [];
				return false;
			}
			$('.fsqPlaces').show();
			
			// console.log('country: ' + $scope.country);
			
			$http.get('https://api.foursquare.com/v2/venues/suggestcompletion?client_id=VB4TYLQZLAQCJTQFKDOREKCNV1A4XJB2MRAUT202LVUEQQIT&client_secret=ZV3SF2DTC0ZJ5N4M5X2MEFKWJPZWWKLIDMCDL2DVSGGRMFYB' +
				'&v=20130709' +
				'&intent=global' + 
				'&query=' + query + 
				'&near=' + $scope.country
			)
			.success(function(res, status) {

				var minivenues = res.response.minivenues;
				$scope.fsqPlaces = minivenues;

				if (minivenues.length <= 0) $('.fsqPlaces').hide();
				// $scope.fsqPlaces = [];
				// for (var mv=0; mv<minivenues.length; mv++) {
				// 	$scope.fsqPlaces.push(minivenues[mv].name);
				// }
			})
			.error(function(res, status) {
				$('.fsqPlaces').hide();
			});
		}
				
		$scope.takePicture = function() {
			var pickImg = new MozActivity({
			    name: "pick",
			    data: {
			        type: ["image/jpg", "image/jpeg", "img/png"]
			    }
			});

			pickImg.onsuccess = function () { 
			    // we got an image! (returned as a blob)
			    // now let's send it to the API
			    var blob = this.result.blob;
			    var img = document.createElement("img");
			    img.src = window.URL.createObjectURL(blob);
			    
			    // now display the image in your app
			    // $("#issueImg").append(img);
			    if ($scope.photos.length == 0) 
			    	$("#issueImg1").append(img);
			   	else if ($scope.photos.length == 1) 
			    	$("#issueImg2").append(img);
			    else if ($scope.photos.length == 2) 
			    	$("#issueImg3").append(img);

				var fileToDataURL = function (file) {
		            var deferred = $q.defer();
		            var reader = new FileReader();
		            reader.onload = function (e) {
		            	deferred.resolve(e.target.result);
		            };
		            reader.readAsDataURL(file);
		            return deferred.promise;
		        };

				var url = window.URL.createObjectURL(blob);
	        	fileToDataURL(blob).then(function (dataURL) {
	        		var formData = new FormData();
                    formData.append('url', 'media');
                    formData.append('photo', blob, 'photo');
                    
                    $http.post(globals.RootPath + '/media', formData, {
                        headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                        transformRequest: angular.identity
                    }).success(function(res) {
                    	$scope.result = res;
						$scope.photos.push(res.file);
                    }).error(function(result) {
                    });
                });
			};
			pickImg.onerror = function () { 
			    // didn’t work...
			    //alert("Something went wrong trying to get the image from your camera!")
			};
		}
		$scope.getCategories = function(){
			//showing div as categories modal
			$scope.showModal ='showModal';
			$http({
				method: 'GET', 
	            url: globals.RootPath + '/categories',
				headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId}
			})
	        .success(function(res, status){
	            if (status !== 200) return false;
	            $scope.categories = res.data;
	        })
	        .error(function(data, status){
	        });

		}

		$scope.categories = [];
		$scope.getCategoryName = function(subcat) {
			$scope.showModal='hideModal';
			$scope.categoryID = subcat.id;
			$scope.categoryName = subcat.name;
		}

	}]);
});