'use strict';

define(['app'], function(app) {
    app.controller('RegisterCtrl', ['$rootScope', '$scope', '$location', '$cookieStore', 'Auth', 'md5', '$navigate', '$http', 'i18n', 'checkRetina', '$window', 
        function($rootScope, $scope, $location, $cookieStore, Auth, md5, $navigate, $http, i18n, checkRetina, $window) {
        
        $scope.avatar_images = [];
        $scope.selected_avatar = globals.S3PathAvatars + 'img1_c_ldpi.png';

        $scope.registerHero = function(){
            //var user_email = $scope.user_email;
            // console.log('register ctrl');

            var firstName   = $scope.firstName;
            var lastName    = $scope.lastName;
            var email       = $scope.email;
            var username    = $scope.username;
            var password    = md5.createHash($scope.password);
            var avatar      = $scope.avatar;
            var lang        = 'en';
            var formData    = new FormData();
            formData.append('first_name', firstName);
            formData.append('last_name', lastName);
            formData.append('user_email', email);
            formData.append('username', username);
            formData.append('password', password);
            formData.append('avatar', avatar);
            formData.append('lang', lang);
            formData.append('selected_image', 'avatar');

            $http.post(globals.RootPath + '/users/', formData, {
                headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                transformRequest: angular.identity
            })
            .success(function(res, status) {
                if (status !== 200) return false;
                // console.log('$http success');
                // console.debug(res);
                var user_image = '';

                switch (res.data.selected_image) {
                    case 'fb':
                        if (res.data.fb_image.length > 0) {
                            user_image = res.data.fb_image;
                        }
                    break;

                    case 'avatar':
                        // TODO
                        // AVATAR IMAGES ARE STILL NOT UPLOADED ON S3...
                        if (res.data.avatar.length > 0) {
                            user_image = globals.S3Path + 'avatar/' + res.data.avatar;
                        }
                    break;

                    case 'uploaded':
                        if (res.data.media && res.data.media[0] && res.data.media[0].filename)
                            user_image = globals.S3Path + res.data.media[0].filename;
                    break;
                }


                $cookieStore.put('user', {
                    role: 2, 
                    user_id: res.data.id,
                    username: res.data.username, 
                    first_name: res.data.first_name,
                    last_name: res.data.last_name,
                    user_image: user_image,
                    authorizationId: res.authorization_id
                });

                $rootScope.user = $cookieStore.get('user') || { username: '', role: userRoles.public };
                // $scope.user = $rootScope.user;

                if ($rootScope.user.role > 1)
                    //$location.path('/issues');
                    $scope.showModal ='showModal';

            }).error(function(res, status) {
                console.debug(res);
                console.log('error');
            });
        };

        $scope.showAvatars = function() {
            $scope.avatar_images = [];
            $scope.showing_avatars = true;

            var resolution = 'mdpi';
            if (checkRetina.isRetina($window)) {
                resolution = 'hdpi';
            }

            for (var a=1; a <= 10; a++) {
                $scope.avatar_images.push(globals.S3PathAvatars + 'img' + a + '_c_' + resolution + '.png');
            }
        }

        $scope.selectAvatar = function(_index) {
            $scope.avatar = 'img' + _index;
            $scope.selected_avatar = globals.S3PathAvatars + 'img' + (_index+1) + '_c_ldpi.png';
            $scope.showing_avatars = false;
        }

        $scope.continue = function(){
            $scope.showModal='hideModal';
            $navigate.go('/issues', 'slide');
        };




    }]);
});