'use strict';

define(['app'], function(app) {
	app.controller('SearchCtrl', ['$rootScope', '$scope', '$http', 
		function ($rootScope, $scope, $http){
		$scope.searchIssues = function() {
			var query = $scope.search;
			
			$http({
	            method: 'GET', 
	            url: globals.RootPath + '/issues' + '?title=' + query,
	            headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId}
        	})
			.success(function(res, status) {

				$('.beforeSearch').hide();
				
				// console.log('i am in success');
				var searchResult = res.data;
				var results = [];
				
				for (var r=0; r<searchResult.length;r++) {
					var result = searchResult[r];
						result.image = globals.S3Path + result.image;

					result.userImage = '';
	                if (result.user.selected_image) {
	                    switch (result.user.selected_image) {
	                        case 'avatar':
	                            result.userImage = globals.S3PathAvatars + result.user.avatar + '_c_ldpi.png';
	                        break;

	                        case 'fb':
	                            //result.userImage = result.user.fb_image;
	                            result.userImage = 'http://graph.facebook.com/' + result.user.fb_id + '/picture?width=70&height=70';
	                        break;

	                        case 'uploaded':
	                            result.userImage = globals.S3Path + result.user.media[0].filename;
	                        break;
	                    }
	                }
                	
					if (result.voted == 1)
	                    result.class = 'voteBtn voteBtnON';
	                else
	                    result.class = 'voteBtn';

					results.push(result);
				}
				if (searchResult.length == 0){
					$('.noSearch').show();
					$('.srchRes').hide();
				}else{
					$('.srchRes').show();
				}
				$scope.searchResult = results;
				var searchNo = res.data.length;
				$scope.resultsNumber = searchNo;
			})
			.error(function(res, status) {
			});
		}

		$scope.vote = function(term){
            var voted = term.voted;
            var object_id = term.object_id;
            var formData = new FormData();
            formData.append('object_id', object_id);

            if(voted == 0) {
                $http.post(globals.RootPath + '/votes', formData, {
                    headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': false },
                    transformRequest: angular.identity
                })
                .success(function(res, status){
                    if (status !== 200) return false;
                    $('#voteBtn' + term.id).addClass('voteBtnON');

                    term.voted = 1;
                })
                .error(function(data, status){
                });
            }
            else{
                $('#voteBtn' + term.id).addClass('voteBtnON');
                alert("You already voted for this issue. You can't vote again.");
            }
        };

	}]);
});


