'use strict';

define(['app'], function(app) {
	app.controller('SettingsCtrl', ['$rootScope', '$cookieStore', '$navigate', '$scope', '$http', 'checkRetina', '$window', 'localize', 
        function ($rootScope, $cookieStore, $navigate, $scope, $http, checkRetina, $window, localize){
        $scope.username = $rootScope.user.username;
        $rootScope.avatar_images = [];
        
        $scope.changeName = function(){
            var id = $scope.user.user_id;
            var username = $scope.username;
            
            var xsrf = $.param({username: username});
            $http({
                method: 'POST',
                url: globals.RootPath + '/users/' + id,
                data: xsrf,
                headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .success(function(res, status) {
                if (status !== 200) return false;
                $scope.showModal='showModal';
                
                $rootScope.user.username = username;

                $cookieStore.put('user', $rootScope.user);

            })
            .error(function(res, status) {
                alert('error');
            });
        };

        $scope.changeAvatar = function(){
            var id = $scope.user.user_id;
            var avatar = $scope.avatar;
            
            var xsrf = $.param({avatar: avatar, selected_avatar: 'avatar'});
            $http({
                method: 'POST',
                url: globals.RootPath + '/users/' + id,
                data: xsrf,
                headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .success(function(res, status) {
                if (status !== 200) return false;
                $scope.showModal='showModal';
                
                $rootScope.user.avatar = $scope.avatar;
                $rootScope.user.selected_image = 'avatar';
                $rootScope.user.user_image = globals.S3PathAvatars + $scope.avatar + '_c_ldpi.png';

                $cookieStore.put('user', $rootScope.user);

                $navigate.back();

            })
            .error(function(res, status) {
                alert('error');
            });
        };

        $scope.showAvatars = function() {
            $rootScope.avatar_images = [];

            var resolution = 'mdpi';
            if (checkRetina.isRetina($window)) {
                resolution = 'hdpi';
            }

            for (var a=1; a <= 10; a++) {
                $rootScope.avatar_images.push(globals.S3PathAvatars + 'img' + a + '_c_' + resolution + '.png');
            }

            $navigate.go('/chAvatar', 'modal');
        }

        $rootScope.selectAvatar = function(_index) {
            $scope.avatar = 'img' + ((_index*1)+1);
            $scope.selected_avatar = globals.S3PathAvatars + 'img' + (_index+1) + '_c_ldpi.png';
            
            $scope.changeAvatar();
        }

        $scope.showLanguages = function() {
            $rootScope.languages = [
                {
                    label: 'English',
                    code: 'en-US'
                }, 
                {
                    label: 'Italiano',
                    code: 'it-IT'
                }
            ];

            $navigate.go('/chLanguage', 'modal');
        }

        $rootScope.selectLanguage = function(_index) {
            var languageCode = $rootScope.languages[_index].code;
            localize.skipCache = true;
            localize.resourceFileLoaded = false;
            localize.language = languageCode;

            $navigate.back();
        }

        $scope.deleteUser = function(){
            var id = $scope.user.user_id;
            $http({
                method: 'DELETE',
                url: globals.RootPath + '/users/' + id,
                headers: { 'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId, 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .success(function(res, status) {
                if (status !== 200) return false;
                
                $cookieStore.remove('user');
                $rootScope.user = '';
                
                alert('You successfully deleted your account. See you some other time. Have a  nice day :)');
                $navigate.go('/login', 'none');

            })
            .error(function(res, status) {
                alert('Something went wrong. Please try again.');
            });
        };

        $scope.continue = function(){
            $scope.showModal='hideModal';
            // $navigate.go('/menu', 'none');
            $navigate.back();
        };

        
	}]);
});