'use strict';

define(['app'], function(app) {
	app.controller('HeroCtrl', ['$rootScope', '$scope', '$routeParams', '$cookieStore', '$location', '$http', 
        function($rootScope, $scope, $routeParams, $cookieStore, $location, $http) {
		$rootScope.user = $cookieStore.get('user') || $location.path('/login');

        
		$http({
            method: 'GET', 
            url: globals.RootPath + '/users/' + $routeParams.id + '?counter=1',
            headers: {'ConsumerKey': globals.ConsumerKey, 'AuthorizationId': $rootScope.user.authorizationId}
        })
        .success(function(res, status){
            if (status !== 200) return false;

            $scope.hero = res.data[0];
            var hero = $scope.hero;
            $scope.counter = res.counter;
            hero.userImage = '';
                if (hero.selected_image) {
                    switch (hero.selected_image) {
                        case 'avatar':
                            hero.userImage = globals.S3PathAvatars + hero.avatar + '_c_ldpi.png';
                        break;

                        case 'fb':
                            // hero.userImage = hero.fb_image;
                            hero.userImage = 'http://graph.facebook.com/' + hero.fb_id + '/picture?width=70&height=70';
                        break;

                        case 'uploaded':
                            hero.userImage = globals.S3Path + hero.media[0].filename;
                        break;
                    }
                }
        })
        .error(function(data, status){
        });
	}]);
});