/*global angular */
require.config({
  shim: {
    'angular': {
      exports: 'angular'
    }
  },
  paths: {
    app: 'js/app',
    angular: './components/angular/angular'
  },
  baseUrl: '/'
});

(function() {
  console.time('requirejs');
  require([
    // application
    'app',
    'js/jquery-2.0.2.min.js',
    'js/mobile-nav.js',
    'js/sprintf.min.js',
    'js/globals.js',

    // dependencies
    'angular',
    'components/angular-cookies/angular-cookies',
    'components/moment/min/moment.min',
    'components/angular-moment/angular-moment',


    // services
    'js/services/database.js',
    'js/services/dates.js',
    'js/services/http-cache.js',
    'js/services/localization.js',
    'js/services/md5.js',
    'js/services/Auth.js',
    'js/services/CheckRetina.js',
    'js/services/angular-xml.js',


    // controllers
    'js/controllers/list.js',
    'js/controllers/add.js',
    'js/controllers/detail.js',
    'js/controllers/edit.js',
    'js/controllers/NewIssue.js',
    'js/controllers/Menu.js',
    'js/controllers/Login.js',
    'js/controllers/Issues.js',
    'js/controllers/Issue.js',
    'js/controllers/hero.js',
    'js/controllers/Comments.js',
    'js/controllers/Map.js',
    'js/controllers/Votes.js',
    'js/controllers/SettingsCtrl.js',
    'js/controllers/SearchCtrl.js',
    'js/controllers/RegisterCtrl.js'
  ], function() {
    console.timeEnd('requirejs');

    angular.bootstrap(document, ['app']);
  });

})();
