var shirt = new Image(64, 87);
shirt.src = "cards/0.png";
var cardpack = new Array("a", "aa", "aaa", "aaaa", "b", "bb", "bbb", "bbbb", "c", "cc", "ccc", "cccc", "d", "dd", "ddd", "dddd", "e", "ee", "eee", "eeee", "f", "ff", "fff", "ffff", "g", "gg", "ggg", "gggg", "h", "hh", "hhh", "hhhh", "i", "ii", "iii", "iiii", "j", "jj", "jjj", "jjjj", "k", "kk", "kkk", "kkkk", "l", "ll", "lll", "llll", "m", "mm", "mmm", "mmmm");
var pictures = new Array(cardpack.length - 1);
localStorage.setItem('cardpack', JSON.stringify(new Array()));
localStorage.setItem('cash', 0);
localStorage.setItem('bonuscash', 0);

function showResult(result, thiscash) {
	var printresult = '';
	var printblock = '';
	if (result == 0) {
		printblock = 'looseblock';
		printresult = '<h3><center>YOU LOOSE! -'+thiscash+' $</center></h3>';
	} else {
		printblock = 'winblock';
		printresult = '<h3><center>YOU WIN! +'+thiscash+' $</center></h3>';
	}

	var div = document.createElement('div');
	div.id = 'resultDiv';
	div.className = printblock;
	div.innerHTML = printresult;
	div.onclick = closeResult;
	
	var superdiv = document.getElementById('gameDiv');
	superdiv.appendChild(div);
}

function showDuel(thiscash) {
	var div = document.createElement('div');
	div.id = 'resultDiv';
	div.className = 'duelblock';
	div.innerHTML = '<h3><center>Duel! '+thiscash+' $</center></h3>';
	div.onclick = closeResult;
	
	var superdiv = document.getElementById('gameDiv');
	superdiv.appendChild(div);
}

function closeResult() {
	var element = document.getElementById('resultDiv');
	element.parentNode.removeChild(element);
	upDate();
}

function changeId(id, value) {
	document.getElementById(id).innerHTML = value;
}

function disableId(id, value) {
	document.getElementById(id).disabled = value;
}

function getStorageVar(storageItem) {
	var toreturn = localStorage.getItem(storageItem);
	return parseInt(toreturn);
}

function outFromPack(thiscard) {
	var now_cardpack = JSON.parse(localStorage["cardpack"]);
	cleft = now_cardpack;
	cleft.push(thiscard);
	localStorage.setItem('cardpack', JSON.stringify(cleft));
}

function gameIsgame() {
	var now_cardpack = JSON.parse(localStorage["cardpack"]);
	var varcardsleft = cardsleft();
	if (varcardsleft < 0) {
		var bonuscash = getStorageVar('bonuscash');
		if (bonuscash > 0) {
			var half_bonuscash = bonuscash / 2;
			var cash = getStorageVar('cash');
			var new_cash = cash + half_bonuscash;
			
			localStorage.setItem('cash', new_cash);
			changeId('cashdiv',new_cash+' $');
			changeId('dueldiv','');
		}
		var new_cash = getStorageVar('cash');
		if (new_cash > 0) changeId('resultdiv','<h3>YOU WIN!</h3>');
		else changeId('resultdiv','<h3>YOU LOOSE!</h3>');
		
		changeId('againdiv','<a href="#" onClick="start()">Again!</a>');
		return false;
	}
	else return true;
}

function getRandomCard() {
	do {
		thiscounter = Math.floor((Math.random() * cardpack.length - 1) + 1);
		var now_cardpack = JSON.parse(localStorage["cardpack"]);
		var a = now_cardpack.indexOf(cardpack[thiscounter]);
	} while (a >= 0);
	return thiscounter;
}

function showRandomCard(id) {
	document.imgDisplayFirst.src = pictures[id].src;
	outFromPack(cardpack[id]);
	document.imgDisplaySecond.src = shirt.src;
}

function allcontrolsoff() {
	disableId('low', true);
	disableId('high', true);
}

function controls(enabled) {
	if (enabled) {
		disableId('low', false);
		disableId('high', false);
	}
	else {
		disableId('low', true);
		disableId('high', true);
	}
}

function cardsleft() {
	var now_cardpack = JSON.parse(localStorage["cardpack"]);
	var divizion = cardpack.length - now_cardpack.length;
	var toreturn = divizion - 1;
	return parseInt(toreturn);
}

function start() {
	localStorage.setItem('cardpack', JSON.stringify(new Array()));
	localStorage.setItem('cash', 0);
	localStorage.setItem('bonuscash', 0);
	
	changeId('againdiv','');
	changeId('resultdiv','');
	changeId('cardsleft','Cards left '+cardsleft());
	
	var k = getRandomCard();
	
	document.imgDisplayFirst.src = pictures[k].src;
	outFromPack(cardpack[k]);
	document.imgDisplaySecond.src = shirt.src;
	
	controls(true);
	var cash = getStorageVar('cash');
	changeId('cashdiv',cash+' $');
}

function initialize() {
	for (var i=0;i<cardpack.length;i++) {
		pictures[i] = new Image(64, 87);
		pictures[i].src = "cards/"+cardpack[i]+".png";
	}
	start();
}

function upDate() {
	var cleft = cardsleft();
	if (cleft <= 0) cleft = 0;
	changeId('cardsleft','Cards left '+cleft);
	var goOn = gameIsgame();
	if (goOn) {
		var k = getRandomCard();
		showRandomCard(k);
		controls(true);
	} else allcontrolsoff();
}

function play(pos) {
	changeId('cardsleft','Cards left '+cardsleft());

	var now_cardpack = JSON.parse(localStorage["cardpack"]);
	var comp_turn = now_cardpack[now_cardpack.length - 1];

	var k = getRandomCard();
	document.imgDisplaySecond.src = pictures[k].src;
	controls(false);
	outFromPack(cardpack[k]);
	
	var my_turn = cardpack[k];
	var cash = getStorageVar('cash');
	var my_letter = my_turn[0];
	var comp_letter = comp_turn[0];
	
	var thiscash = 0;
	var bonuscash = getStorageVar('bonuscash');
	
	if (my_letter == comp_letter) {
		if (bonuscash > 0) localStorage.setItem('bonuscash', bonuscash + 200);
		else localStorage.setItem('bonuscash', 200);
		bonuscash = getStorageVar('bonuscash');
		thiscash = bonuscash;
		changeId('dueldiv','Duel! Stake '+thiscash+'$');
	} else {
		if (bonuscash) thiscash += bonuscash;	
		else thiscash += 100;
		changeId('dueldiv','');
		bonuscash = 0;
		localStorage.setItem('bonuscash', bonuscash);
	}
	
	if (pos == 0) {
		if (my_turn > comp_turn) {
			cash += thiscash;
			turn = 1;
		}
		else {
			cash -= thiscash;
			turn = 0;
		}
	} else {
		if (my_turn < comp_turn) {
			cash += thiscash;
			turn = 1;
		}
		else {
			cash -= thiscash;
			turn = 0;
		}
	}
	
	if (!bonuscash) showResult(turn,thiscash);
	else showDuel(bonuscash);
	
	changeId('cashdiv',cash+' $');
	localStorage.setItem('cash', cash);
	
	var goOn = gameIsgame();
	if (!goOn) allcontrolsoff();
}