/*! intel-appframework - v2.1.0 - 2014-07-28 */

/*
 Intel 2013
 @author Ian Maffett
 @description A plugin to allow jQuery developers to use App Framework UI
 MIT - https://github.com/darius/requestAnimationFrame/commit/4f27a5a21902a883330da4663bea953b2f96cb15#diff-9879d6db96fd29134fc802214163b95a

    http://paulirish.com/2011/requestanimationframe-for-smart-animating/
    http://my.opera.com/emoller/blog/2011/12/20/requestanimationframe-for-smart-er-animating
    requestAnimationFrame polyfill by Erik M?ller. fixes from Paul Irish and Tino Zijdel
    MIT license

    Adapted from https://gist.github.com/paulirish/1579671 which derived from 
    http://paulirish.com/2011/requestanimationframe-for-smart-animating/
    http://my.opera.com/emoller/blog/2011/12/20/requestanimationframe-for-smart-er-animating

    requestAnimationFrame polyfill by Erik M?ller.
    Fixes from Paul Irish, Tino Zijdel, Andrew Mao, Klemen Slavi?, Darius Bacon
 2011 - Intel
 Intel
 2011 Intel
 @author Intel
 @version 2.0
*/
(function(a,n){function m(c,a){if(c)if(c.nodeType)a[a.length++]=c;else for(var b=0,f=c.length;b<f;b++)a[a.length++]=c[b]}function l(c,a){c.os={};c.os.webkit=a.match(/WebKit\/([\d.]+)/)?!0:!1;c.os.android=a.match(/(Android)\s+([\d.]+)/)||a.match(/Silk-Accelerated/)?!0:!1;c.os.androidICS=c.os.android&&a.match(/(Android)\s4/)?!0:!1;c.os.ipad=a.match(/(iPad).*OS\s([\d_]+)/)?!0:!1;c.os.iphone=!c.os.ipad&&a.match(/(iPhone\sOS)\s([\d_]+)/)?!0:!1;c.os.ios7=(c.os.ipad||c.os.iphone)&&a.match(/7_/)?!0:!1;c.os.webos=
a.match(/(webOS|hpwOS)[\s\/]([\d.]+)/)?!0:!1;c.os.touchpad=c.os.webos&&a.match(/TouchPad/)?!0:!1;c.os.ios=c.os.ipad||c.os.iphone;c.os.playbook=a.match(/PlayBook/)?!0:!1;c.os.blackberry10=a.match(/BB10/)?!0:!1;c.os.blackberry=c.os.playbook||c.os.blackberry10||a.match(/BlackBerry/)?!0:!1;c.os.chrome=a.match(/Chrome/)?!0:!1;c.os.opera=a.match(/Opera/)?!0:!1;c.os.fennec=a.match(/fennec/i)?!0:a.match(/Firefox/)?!0:!1;c.os.ie=a.match(/MSIE 10.0/i)||a.match(/Trident\/7/i)?!0:!1;c.os.ieTouch=c.os.ie&&a.toLowerCase().match(/touch/i)?
!0:!1;c.os.tizen=a.match(/Tizen/i)?!0:!1;c.os.supportsTouch=n.DocumentTouch&&d instanceof n.DocumentTouch||"ontouchstart"in n;c.os.kindle=a.match(/Silk-Accelerated/)?!0:!1;c.feat={};var b=d.documentElement.getElementsByTagName("head")[0];c.feat.nativeTouchScroll="undefined"!==typeof b.style["-webkit-overflow-scrolling"]&&(c.os.ios||c.os.blackberry10);c.feat.cssPrefix=c.os.webkit?"Webkit":c.os.fennec?"Moz":c.os.ie?"ms":c.os.opera?"O":"";c.feat.cssTransformStart=!c.os.opera?"3d(":"(";c.feat.cssTransformEnd=
!c.os.opera?",0)":")";c.os.android&&!c.os.webkit&&(c.os.android=!1)}jQuery.event.props.push("touches");jQuery.event.props.push("originalTouches");jQuery.event.props.push("changedTouches");var d=n.document,k={},h="object"===typeof MSApp,b=1;a.extend(a.fn,{vendorCss:function(c,e,b){return this.css(a.feat.cssPrefix+c,e,b)},cssTranslate:function(c){return this.vendorCss("Transform","translate"+a.feat.cssTransformStart+c+a.feat.cssTransformEnd)},computedStyle:function(a){if(!(0===this.length||void 0==
a))return n.getComputedStyle(this[0],"")[a]},replaceClass:function(a,e){if(void 0==a||void 0==e)return this;var b=function(a){d=d.replace(a in k?k[a]:k[a]=RegExp("(^|\\s)"+a+"(\\s|$)")," ")},f=0;for(;f<this.length;f++)if(void 0==a)this[f].className=e;else{var d=this[f].className;a.split(/\s+/g).concat(e.split(/\s+/g)).forEach(b);d=d.trim();this[f].className=0<d.length?(d+" "+e).trim():e}return this}});l(a,navigator.userAgent);a.__detectUA=l;a.uuid=function(){var a=function(){return(65536*(1+Math.random())|
0).toString(16).substring(1)};return a()+a()+"-"+a()+"-"+a()+"-"+a()+"-"+a()+a()+a()};a.getCssMatrix=function(c){a.is$(c)&&(c=c.get(0));var e=n.WebKitCSSMatrix||n.MSCSSMatrix;if(void 0===c)return e?new e:{a:0,b:0,c:0,d:0,e:0,f:0};c=n.getComputedStyle(c);c=c.webkitTransform||c.transform||c[a.feat.cssPrefix+"Transform"];return e?new e(c):c?(e=c.replace(/[^0-9\-.,]/g,"").split(","),{a:+e[0],b:+e[1],c:+e[2],d:+e[3],e:+e[4],f:+e[5]}):{a:0,b:0,c:0,d:0,e:0,f:0}};a.create=function(c,e){var b,f=new a;if(e||
"<"!==c[0]){e.html&&(e.innerHTML=e.html,delete e.html);b=d.createElement(c);for(var k in e)b[k]=e[k];f[f.length++]=b}else b=d.createElement("div"),h?MSApp.execUnsafeLocalFunction(function(){b.innerHTML=c.trim()}):b.innerHTML=c,m(b.childNodes,f);return f};a.query=function(c,e){try{return a(c,e)}catch(b){return a()}};a.bind=function(c,e,b){c.__events||(c.__events={});a.isArray(e)||(e=[e]);for(var f=0;f<e.length;f++)c.__events[e[f]]||(c.__events[e[f]]=[]),c.__events[e[f]].push(b)};a.trigger=function(c,
e,b){var f=!0;if(!c.__events)return f;a.isArray(e)||(e=[e]);a.isArray(b)||(b=[]);for(var d=0;d<e.length;d++)if(c.__events[e[d]])for(var k=c.__events[e[d]],h=0;h<k.length;h++)a.isFunction(k[h])&&!1===k[h].apply(c,b)&&(f=!1);return f};a.unbind=function(c,e,b){if(c.__events)if(void 0==e)delete c.__events;else{a.isArray(e)||(e=[e]);for(var f=0;f<e.length;f++)if(c.__events[e[f]])for(var d=c.__events[e[f]],k=0;k<d.length;k++)if(void 0==b&&delete d[k],d[k]===b){d.splice(k,1);break}}};a.cleanUpContent=function(){};
a.isObject=function(a){return"object"===typeof a};a.asap=function(c,e,b){if(!a.isFunction(c))throw"$.asap - argument is not a valid function";setTimeout(function(){c.apply(e,b)})};var f={};a.parseJS=function(a){if(a){if("string"===typeof a){var e=d.createElement("div");h?MSApp.execUnsafeLocalFunction(function(){e.innerHTML=a}):e.innerHTML=a;a=e}var b=a.getElementsByTagName("script");a=null;for(var p=0;p<b.length;p++)if(0<b[p].src.length&&!f[b[p].src]&&!h){var k=d.createElement("script");k.type=b[p].type;
k.src=b[p].src;d.getElementsByTagName("head")[0].appendChild(k);f[b[p].src]=1;k=null}else n.eval(b[p].innerHTML)}};a.is$=function(c){return c instanceof a};a.jsonP=function(c){if(h)return c.type="get",c.dataType=null,a.get(c);var e="jsonp_callback"+ ++b,f="",p,k=d.createElement("script");n[e]=function(b){clearTimeout(f);a(k).remove();delete n[e];c.success.call(void 0,b)};-1!==c.url.indexOf("callback=?")?k.src=c.url.replace(/=\?/,"="+e):(p=c.jsonp?c.jsonp:"callback",-1===c.url.indexOf("?")?c.url+=
"?"+p+"="+e:c.url+="&"+p+"="+e,k.src=c.url);c.error&&(k.onerror=function(){clearTimeout(f);c.error.call(void 0,"","error")});a("head").append(k);0<c.timeout&&(f=setTimeout(function(){c.error.call(void 0,"","timeout")},c.timeout));return{}};n.$afm=a;n.numOnly||(n.numOnly=function(a){if(void 0===a||""===a)return 0;if(isNaN(parseFloat(a)))if(a.replace)a=a.replace(/[^0-9.-]/g,"");else return 0;return parseFloat(a)})})(jQuery,window);window.af=window.jq=jQuery;
(function(a){a.fn.actionsheet=function(a){for(var l,d=0;d<this.length;d++)l=new n(this[d],a);return 1===this.length?l:this};var n=function(){var m=function(l,d){if(this.el="string"===typeof l||l instanceof String?document.getElementById(l):l){if(this instanceof m){if("object"===typeof d)for(var k in d)this[k]=d[k]}else return new m(l,d);var h=this,b;k=function(){};if("string"===typeof d)b=a("<div id='af_actionsheet'><div style='width:100%'>"+d+"<a href='javascript:;' class='cancel'>Cancel</a></div></div>");
else if("object"===typeof d){b=a("<div id='af_actionsheet'><div style='width:100%'></div></div>");var f=a(b.children().get(0));d.push({text:"Cancel",cssClasses:"cancel"});for(var c=0;c<d.length;c++){var e=a("<a href='javascript:;'>"+(d[c].text||"TEXT NOT ENTERED")+"</a>");e[0].onclick=d[c].handler||k;d[c].cssClasses&&0<d[c].cssClasses.length&&e.addClass(d[c].cssClasses);f.append(e)}}a(l).find("#af_actionsheet").remove();a(l).find("#af_action_mask").remove();a(l).append(b);b.vendorCss("Transition",
"all 0ms");b.cssTranslate("0,0");b.css("top",window.innerHeight+"px");this.el.style.overflow="hidden";b.on("click","a",function(){h.hideSheet();return!1});this.activeSheet=b;a(l).append("<div id='af_action_mask' style='position:absolute;top:0px;left:0px;right:0px;bottom:0px;z-index:9998;background:rgba(0,0,0,.4)'/>");setTimeout(function(){b.vendorCss("Transition","all 300ms");b.cssTranslate("0,"+-b.height()+"px")},10);a("#af_action_mask").bind("touchstart touchmove touchend click",function(a){a.preventDefault();
a.stopPropagation()})}else window.alert("Could not find element for actionsheet "+l)};m.prototype={activeSheet:null,hideSheet:function(){var l=this;this.activeSheet.off("click","a",function(){l.hideSheet()});a(this.el).find("#af_action_mask").unbind("click").remove();this.activeSheet.vendorCss("Transition","all 0ms");var d=this.activeSheet,k=this.el;setTimeout(function(){d.vendorCss("Transition","all 300ms");d.cssTranslate("0,0px");setTimeout(function(){d.remove();d=null;k.style.overflow="none"},
500)},10)}};return m}()})(af);
(function(a){var n=[],m=function(b,f){var c,e;c="string"===typeof b||b instanceof String?document.getElementById(b):a.is$(b)?b[0]:b;c.afCSS3AnimateId||(c.afCSS3AnimateId=a.uuid());e=c.afCSS3AnimateId;n[e]?(n[e].animate(f),c=n[e]):(c=h(c,f),n[e]=c);return c};a.fn.css3Animate=function(a){!a.complete&&a.callback&&(a.complete=a.callback);var f=m(this[0],a);a.complete=null;a.sucess=null;a.failure=null;for(var c=1;c<this.length;c++)f.link(this[c],a);return f};a.css3AnimateQueue=function(){return new h.queue};
var l=a.feat.cssTransformStart,d=a.feat.cssTransformEnd,k=a.feat.cssPrefix.replace(/-/g,"")+"TransitionEnd",k=a.os.fennec||""===a.feat.cssPrefix||a.os.ie?"transitionend":k,k=k.replace(k.charAt(0),k.charAt(0).toLowerCase()),h=function(){var b=function(f,c){if(!(this instanceof b))return new b(f,c);this.callbacksStack=[];this.activeEvent=null;this.countStack=0;this.isActive=!1;this.el=f;this.linkFinishedProxy=a.proxy(this.linkFinished,this);if(this.el){this.animate(c);var e=this;af(this.el).bind("destroy",
function(){var a=e.el.afCSS3AnimateId;e.callbacksStack=[];n[a]&&delete n[a]})}};b.prototype={animate:function(b){this.isActive&&this.cancel();this.isActive=!0;if(b){var c=!!b.addClass,e,g,p=numOnly(b.time);if(c)b.removeClass?af(this.el).replaceClass(b.removeClass,b.addClass):af(this.el).addClass(b.addClass);else{0===p&&(b.time=0);b.y||(b.y=0);b.x||(b.x=0);b.previous&&(e=new a.getCssMatrix(this.el),b.y+=numOnly(e.f),b.x+=numOnly(e.e));b.origin||(b.origin="0% 0%");b.scale||(b.scale="1");b.rotateY||
(b.rotateY="0");b.rotateX||(b.rotateX="0");b.skewY||(b.skewY="0");b.skewX||(b.skewX="0");b.timingFunction||(b.timingFunction="linear");if("number"===typeof b.x||-1===b.x.indexOf("%")&&-1===b.x.toLowerCase().indexOf("px")&&-1===b.x.toLowerCase().indexOf("deg"))b.x=parseInt(b.x,10)+"px";if("number"===typeof b.y||-1===b.y.indexOf("%")&&-1===b.y.toLowerCase().indexOf("px")&&-1===b.y.toLowerCase().indexOf("deg"))b.y=parseInt(b.y,10)+"px";e="translate"+l+b.x+","+b.y+d+" scale("+parseFloat(b.scale)+") rotate("+
b.rotateX+")";a.os.opera||(e+=" rotateY("+b.rotateY+")");e+=" skew("+b.skewX+","+b.skewY+")";this.el.style[a.feat.cssPrefix+"Transform"]=e;this.el.style[a.feat.cssPrefix+"BackfaceVisibility"]="hidden";void 0!==b.opacity&&(this.el.style.opacity=b.opacity);b.width&&(this.el.style.width=b.width);b.height&&(this.el.style.height=b.height);this.el.style[a.feat.cssPrefix+"TransitionProperty"]="all";-1===(""+b.time).indexOf("s")?(e="ms",g=b.time+e):-1!==b.time.indexOf("ms")?(e="ms",g=b.time):(e="s",g=b.time+
e);b.delay&&(this.el.style[a.feat.cssPrefix+"TransitionDelay"]=b.delay);this.el.style[a.feat.cssPrefix+"TransitionDuration"]=g;this.el.style[a.feat.cssPrefix+"TransitionTimingFunction"]=b.timingFunction;this.el.style[a.feat.cssPrefix+"TransformOrigin"]=b.origin}this.callbacksStack.push({complete:b.complete,success:b.success,failure:b.failure});this.countStack++;var h=this;g=window.getComputedStyle(this.el);c&&(c=g[a.feat.cssPrefix+"TransitionDuration"],p=numOnly(c),b.time=p,-1!==c.indexOf("ms")?e=
"ms":(e="s",b.time*=1E3));0===p||"ms"===e&&5>p||"none"===g.display?a.asap(a.proxy(this.finishAnimation,this,[!1])):(this.activeEvent=function(a){clearTimeout(h.timeout);h.finishAnimation(a);h.el.removeEventListener(k,h.activeEvent,!1)},h.timeout=setTimeout(this.activeEvent,numOnly(b.time)+50),this.el.addEventListener(k,this.activeEvent,!1))}else window.alert("Please provide configuration options for animation of "+this.el.id)},addCallbackHook:function(a){a&&this.callbacksStack.push(a);this.countStack++;
return this.linkFinishedProxy},linkFinished:function(a){a?this.cancel():this.finishAnimation()},finishAnimation:function(a){a&&a.preventDefault&&a.preventDefault();this.isActive&&(this.countStack--,0===this.countStack&&this.fireCallbacks(!1))},fireCallbacks:function(a){this.clearEvents();var c=this.callbacksStack;this.cleanup();for(var b=0;b<c.length;b++){var g=c[b].complete,d=c[b].success,k=c[b].failure;"function"===typeof g&&g(a);a&&"function"===typeof k?k():"function"===typeof d&&d()}},cancel:function(){this.isActive&&
this.fireCallbacks(!0)},cleanup:function(){this.callbacksStack=[];this.isActive=!1;this.countStack=0},clearEvents:function(){this.activeEvent&&this.el.removeEventListener(k,this.activeEvent,!1);this.activeEvent=null},link:function(a,c){var b={complete:c.complete,success:c.success,failure:c.failure};c.complete=this.addCallbackHook(b);c.success=null;c.failure=null;m(a,c);c.complete=b.complete;c.success=b.success;c.failure=b.failure;return this}};return b}();h.queue=function(){return{elements:[],push:function(a){this.elements.push(a)},
pop:function(){return this.elements.pop()},run:function(){var a=this;if(0!==this.elements.length&&("function"===typeof this.elements[0]&&this.shift()(),0!==this.elements.length)){var f=this.shift();0<this.elements.length&&(f.complete=function(c){c||a.run()});h(document.getElementById(f.id),f)}},shift:function(){return this.elements.shift()}}}})(af);Date.now||(Date.now=function(){return(new Date).getTime()});
(function(){for(var a=["webkit","moz","ms"],n=0;n<a.length&&!window.requestAnimationFrame;++n){var m=a[n];window.requestAnimationFrame=window[m+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m+"CancelAnimationFrame"]||window[m+"CancelRequestAnimationFrame"]}if(/iP(ad|hone|od).*OS 6/.test(window.navigator.userAgent)||!window.requestAnimationFrame||!window.cancelAnimationFrame){var l=0;window.requestAnimationFrame=function(a){var k=Date.now(),h=Math.max(l+16,k);return setTimeout(function(){a(l=
h)},h-k)};window.cancelAnimationFrame=clearTimeout}})();
(function(a){var n=[];a.fn.animateCss=function(d){var k,h="string"===typeof this[0]||this[0]instanceof String?document.getElementById(this[0]):a.is$(this[0])?this[0][0]:this[0];h.afAnimateId||(h.afAnimateId=a.uuid());k=h.afAnimateId;n[k]?(d&&n[k].animate(d),d=n[k]):(d=m(h,d),n[k]=d);return d};var m=function(a,k){if(!(this instanceof m))return new m(a,k);if(this.el=a){k&&this.animate(k);var h=this;af(this.el).bind("destroy",function(){var a=h.el.afAnimateId;n[a]&&delete n[a]})}};m.prototype={animationTimer:null,
isAnimating:!1,startX:0,startY:0,runTime:0,endX:0,endY:0,currX:0,currY:0,animationStartTime:0,pauseTime:0,completeCB:null,easingFn:"linear",animateOpts:{},updateCb:null,animate:function(d){this.isAnimating||(this.isAnimating=!0,window.cancelAnimationFrame(this.animationTimer),d||(d={x:0,y:0,duration:0}),this.easingFn=d.easing||"linear",this.completeCB=d.complete||null,this.updateCB=d.update||null,this.runTime=numOnly(d.duration),d.complete&&delete d.complete,this.animateOpts=d,this.startTime=Date.now(),
this.startMatrix=a.getCssMatrix(this.el),0===this.runTime&&this.doAnimate())},start:function(){this.doAnimate()},doAnimate:function(){var a=Date.now(),k,h=this;0===this.runTime||a>=this.startTime+this.runTime?(h.setPosition(this.animateOpts.x,this.animateOpts.y),h.isAnimating=!1,this.updateCB&&this.updateCB({x:this.animateOpts.x,y:this.animateOpts.y}),this.completeCB&&this.completeCB()):(a=(a-this.startTime)/this.runTime,k=l[this.easingFn](1<a?1:a),a=(this.animateOpts.x-this.startMatrix.e)*k+this.startMatrix.e,
k=(this.animateOpts.y-this.startMatrix.f)*k+this.startMatrix.f,this.setPosition(a,k),this.updateCB&&this.updateCB({x:a,y:k}),this.isAnimating&&(this.animationTimer=window.requestAnimationFrame(function(){h.doAnimate()})))},setPosition:function(d,k){this.el.style[a.feat.cssPrefix+"Transform"]="matrix3d( 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, "+d+", "+k+", 0, 1 )";this.currX=d;this.currY=k},stop:function(){this.isAnimating=!1;window.cancelAnimationFrame(this.animationTimer);this.pauseTime=Date.now()-this.startTime},
resume:function(){this.isAnimating=!0;this.startTime=Date.now()-this.pauseTime;this.doAnimate()}};var l={linear:function(a){return a},easeOutSine:function(a){return Math.sin(a*Math.PI/2)}}})(af);
(function(a){a.passwordBox=function(){return new n};var n=function(){this.oldPasswords={}};n.prototype={showPasswordPlainText:!1,getOldPasswords:function(m){var l=m&&document.getElementById(m)?document.getElementById(m):document;if(l){m=l.getElementsByTagName("input");for(l=0;l<m.length;l++)"password"===m[l].type&&a.os.webkit&&(m[l].type="text",a(m[l]).vendorCss("TextSecurity","disc"))}else window.alert("Could not find container element for passwordBox "+m)},changePasswordVisiblity:function(m,l){m=
parseInt(m,10);var d=document.getElementById(l);1===m?a(d).vendorCss("TextSecurity","none"):a(d).vendorCss("TextSecurity","disc");a.os.webkit||(d.type=1===m?"text":"password")}}})(af);
(function(a){function n(){if(a.os.android&&!a.os.chrome&&a.os.webkit){var d=!1;a.bind(a.touchLayer,["cancel-enter-edit","exit-edit"],function(){if(d){d=!1;for(var a in m){var b;m[a].el?b=!0:(delete m[a],b=!1);b&&m[a].androidFormsMode&&m[a].stopFormsMode()}}})}l=!0}var m=[];a.fn.scroller=function(k){for(var h,b,f=0;f<this.length;f++)h=this[f],h.afScrollerId||(h.afScrollerId=a.uuid()),b=h.afScrollerId,m[b]?h=m[b]:(k||(k={}),a.feat.nativeTouchScroll||(k.useJsScroll=!0),h=d(this[f],k),m[b]=h);return 1===
this.length?h:this};var l=!1,d=function(){function d(c,b){var g=document.createElement("div");g.style.position="absolute";g.style.width=c+"px";g.style.height=b+"px";g.style[a.feat.cssPrefix+"BorderRadius"]="2px";g.style.borderRadius="2px";g.style.display="none";g.className="scrollBar";g.style.background="black";return g}var h,b,f=function(c,b){this.el=c;this.afEl=a(this.el);for(var g in b)this[g]=b[g]};f.prototype={refresh:!1,refreshContent:"Pull to Refresh",refreshHangTimeout:2E3,refreshHeight:60,
refreshElement:null,refreshCancelCB:null,refreshRunning:!1,scrollTop:0,scrollLeft:0,preventHideRefresh:!0,verticalScroll:!0,horizontalScroll:!1,refreshTriggered:!1,moved:!1,eventsActive:!1,rememberEventsActive:!1,scrollingLocked:!1,autoEnable:!0,blockFormsFix:!1,loggedPcentY:0,loggedPcentX:0,infinite:!1,infiniteEndCheck:!1,infiniteTriggered:!1,scrollSkip:!1,scrollTopInterval:null,scrollLeftInterval:null,bubbles:!0,lockBounce:!1,initScrollProgress:!1,_scrollTo:function(a,b){b=parseInt(b,10);if(0===
b||isNaN(b))this.el.scrollTop=Math.abs(a.y),this.el.scrollLeft=Math.abs(a.x);else{var g=(this.el.scrollTop-a.y)/Math.ceil(b/10),f=(this.el.scrollLeft-a.x)/Math.ceil(b/10),d=this,k=Math.ceil(this.el.scrollTop-a.y)/g,h=Math.ceil(this.el.scrollLeft-a.x)/g,l=0,m=0;d.scrollTopInterval=window.setInterval(function(){d.el.scrollTop-=g;m++;m>=k&&(d.el.scrollTop=a.y,clearInterval(d.scrollTopInterval))},10);d.scrollLeftInterval=window.setInterval(function(){d.el.scrollLeft-=f;l++;l>=h&&(d.el.scrollLeft=a.x,
clearInterval(d.scrollLeftInterval))},10)}},enable:function(){},disable:function(){},hideScrollbars:function(){},addPullToRefresh:function(){},_scrollToTop:function(a){this._scrollTo({x:0,y:0},a)},_scrollToBottom:function(a){this._scrollTo({x:0,y:this.el.scrollHeight-this.el.offsetHeight},a)},scrollToBottom:function(a){return this._scrollToBottom(a)},scrollToTop:function(a){return this._scrollToTop(a)},init:function(c,b){this.el=c;this.afEl=a(this.el);this.defaultProperties();for(var g in b)this[g]=
b[g];var f=this,d=function(){f.eventsActive&&(!a.feat.nativeTouchScroll&&(!a.ui||a.ui.activeDiv===f.container))&&f.adjustScroll()};this.afEl.bind("destroy",function(){f.disable(!0);var c=f.el.afScrollerId;m[c]&&delete m[c];a.unbind(a.touchLayer,"orientationchange-reshape",d)});a.bind(a.touchLayer,"orientationchange-reshape",d);a(window).bind("resize",d)},needsFormsFix:function(c){return this.useJsScroll&&this.isEnabled()&&"none"!==this.el.style.display&&0<a(c).closest(this.afEl).size()},handleEvent:function(a){if(!this.scrollingLocked)switch(a.type){case "touchstart":clearInterval(this.scrollTopInterval);
this.preventHideRefresh=!this.refreshRunning;this.moved=!1;if(a.target.getAttribute("no-scroll"))return a.preventDefault();this.onTouchStart(a);this.bubbles||a.stopPropagation();break;case "touchmove":this.onTouchMove(a);this.bubbles||a.stopPropagation();break;case "touchend":this.onTouchEnd(a);this.bubbles||a.stopPropagation();break;case "scroll":this.onScroll(a)}},coreAddPullToRefresh:function(c){c&&(this.refreshElement=c);null===this.refreshElement?(c=document.getElementById(this.container.id+
"_pulldown"),c=null!==c?a(c):a("<div id='"+this.container.id+"_pulldown' class='afscroll_refresh' style='position:relative;height:60px;text-align:center;line-height:60px;font-weight:bold;'>"+this.refreshContent+"</div>")):c=a(this.refreshElement);c=c.get(0);this.refreshContainer=a("<div style='overflow:hidden;height:0;width:100%;display:none;background:inherit;-webkit-backface-visibility: hidden !important;'></div>");a(this.el).prepend(this.refreshContainer.prepend(c));this.refreshContainer=this.refreshContainer[0]},
fireRefreshRelease:function(c){if(this.refresh&&c&&(this.setRefreshContent("Refreshing..."),c=!1!==a.trigger(this,"refresh-release",[c]),this.preventHideRefresh=!1,this.refreshRunning=!0,c)){var b=this;0<this.refreshHangTimeout&&(this.refreshCancelCB=setTimeout(function(){b.hideRefresh()},this.refreshHangTimeout))}},setRefreshContent:function(c){a(this.container).find(".afscroll_refresh").html(c)},lock:function(){this.scrollingLocked||(this.scrollingLocked=!0,(this.rememberEventsActive=this.eventsActive)&&
this.disable())},unlock:function(){this.scrollingLocked&&(this.scrollingLocked=!1,this.rememberEventsActive&&this.enable())},scrollToItem:function(c,b){a.is$(c)||(c=a(c));var g,f;"bottom"===b?(g=c.offset(),g=g.top-this.afEl.offset().bottom+g.height,g+=4):(g=c.offset().top,g-=document.body.scrollTop,f=this.afEl.offset().top,document.body.scrollTop<f&&(g-=f),g-=4);this.scrollBy({y:g,x:0},0)},setPaddings:function(c,b){var g=a(this.el),f=numOnly(g.css("paddingTop"));g.css("paddingTop",c+"px").css("paddingBottom",
b+"px");this.scrollBy({y:c-f,x:0})},divide:function(a,b){return 0!==b?a/b:0},isEnabled:function(){return this.eventsActive},addInfinite:function(){this.infinite=!0},clearInfinite:function(){this.infiniteTriggered=!1;this.scrollSkip=!0},scrollTo:function(a,b){return this._scrollTo(a,b)},updateP2rHackPosition:function(){}};h=function(c,b){this.init(c,b);if(b.hasParent)this.container=this.el.parentNode;else{var g=a.create("div",{});g.append(a(this.el).contents());a(this.el).append(g);this.container=
this.el;this.el=g.get(0)}this.container.afScrollerId=c.afScrollerId;this.afEl=a(this.container);"hidden"!==this.container.style.overflow&&(this.container.style.overflow="hidden");this.addPullToRefresh(null,!0);b.autoEnable&&(this.autoEnable=b.autoEnable);this.autoEnable&&this.enable(!0);this.verticalScroll&&(!0===this.verticalScroll&&!0===this.scrollBars)&&(g=d(5,20),g.style.top="0px",this.vScrollCSS&&(g.className=this.vScrollCSS),g.style.display="none",this.container.appendChild(g),this.vscrollBar=
g);this.horizontalScroll&&(!0===this.horizontalScroll&&!0===this.scrollBars)&&(g=d(20,5),g.style.bottom="0px",this.hScrollCSS&&(g.className=this.hScrollCSS),g.style.display="none",this.container.appendChild(g),this.hscrollBar=g);this.horizontalScroll&&(this.el.style.cssFloat="left");this.el.hasScroller=!0};b=function(c,b){b.nativeParent&&(c=c.parentNode);this.init(c,b);var g=a(c);if(!0===b.replaceParent){var f=g.parent();g.css("height",f.height()).css("width",f.width());g.insertBefore(g.parent());
f.remove()}this.container=this.el;g.css("-webkit-overflow-scrolling","touch");b.autoEnable&&(this.autoEnable=b.autoEnable);this.autoEnable&&this.enable()};b.prototype=new f;h.prototype=new f;b.prototype.defaultProperties=function(){this.refreshContainer=null;this.dX=this.cX=this.dY=this.cY=0;this.cancelPropagation=!1;this.yReset=this.xReset=this.loggedPcentX=this.loggedPcentY=0;var a=this;this.adjustScrollOverflowProxy=function(){a.afEl.css("overflow","auto");a.afEl.parent().css("overflow","hidden")}};
b.prototype.enable=function(a){this.eventsActive||(this.eventsActive=!0,this.el.style.overflow="auto",a?this.scrollToTop(0):this.adjustScroll(),this.el.addEventListener("touchstart",this,!1),this.el.addEventListener("scroll",this,!1),this.updateP2rHackPosition())};b.prototype.disable=function(c){this.eventsActive&&(this.logPos(this.el.scrollLeft,this.el.scrollTop),!c&&!a.ui&&(this.el.style.overflow="hidden"),this.el.removeEventListener("touchstart",this,!1),this.el.removeEventListener("touchmove",
this,!1),this.el.removeEventListener("touchend",this,!1),this.el.removeEventListener("scroll",this,!1),this.eventsActive=!1)};b.prototype.addPullToRefresh=function(a,b){b||(this.refresh=!0);this.refresh&&!0===this.refresh&&(this.coreAddPullToRefresh(a),this.refreshContainer.style.position="absolute",this.refreshContainer.style.top="-60px",this.refreshContainer.style.height="60px",this.refreshContainer.style.display="block",this.updateP2rHackPosition())};b.prototype.updateP2rHackPosition=function(){if(!this.refresh)return a(this.el).find(".p2rhack").remove();
var c=a(this.el).find(".p2rhack");0===c.length&&(a(this.el).append("<div class='p2rhack' style='position:absolute;width:1px;height:1px;opacity:0;background:transparent;z-index:-1;-webkit-transform:translate3d(-1px,0,0);'></div>"),c=a(this.el).find(".p2rhack"));c.css("top",this.el.scrollHeight+this.refreshHeight+1+"px")};b.prototype.onTouchStart=function(a){this.lastScrollInfo={top:0};this.xReset=this.yReset=0;this.verticalScroll&&(0===this.el.scrollTop&&this.refresh&&(this.el.scrollTop=1,this.yReset=
-1),this.el.scrollTop===this.el.scrollHeight-this.el.clientHeight&&this.infinite&&(this.el.scrollTop-=1,this.yReset=1));this.horizontalScroll&&(0===this.el.scrollLeft&&(this.el.scrollLeft=1,this.xReset=-1),this.el.scrollLeft===this.el.scrollWidth-this.el.clientWidth&&(this.el.scrollLeft-=1,this.xReset=1));this.refreshCancelCB&&clearTimeout(this.refreshCancelCB);this.refresh&&this.el.addEventListener("touchend",this,!1);this.el.addEventListener("touchmove",this,!1);this.dY=a.touches[0].pageY;this.dX=
a.touches[0].pageX;this.startTop=this.el.scrollTop;this.startLeft=this.el.scrollLeft;(this.refresh||this.infinite)&&this.refresh&&0>this.dY&&this.showRefresh()};b.prototype.onTouchMove=function(c){var b=c.touches[0].pageY-this.dY,g=c.touches[0].pageX-this.dX,f=this.el.scrollHeight-this.el.scrollTop===this.el.clientHeight&&0>b,d=this.el.scrollWidth-this.el.scrollLeft===this.el.clientWidth&&0>g,k="input"!==c.target.tagName.toLowerCase();this.verticalScroll&&0===this.startTop&&0===this.el.scrollTop&&
0<b&&k&&c.preventDefault();this.horizontalScroll&&0===this.startTop&&0===this.el.scrollLeft&&0<g&&k&&c.preventDefault();this.verticalScroll&&f&&k&&c.preventDefault();this.horizontalScroll&&d&&k&&c.preventDefault();this.moved||(a.trigger(this,"scrollstart",[this.el,{x:g,y:b}]),a.trigger(a.touchLayer,"scrollstart",[this.el,{x:g,y:b}]),this.refresh||this.el.addEventListener("touchend",this,!1),this.moved=!0);this.horizontalScroll&&Math.abs(b)>Math.abs(g)&&c.preventDefault();this.refresh&&this.el.scrollTop<
-this.refreshHeight?this.showRefresh():this.refresh&&this.refreshTriggered&&this.refreshRunning&&this.el.scrollTop>this.refreshHeight?(this.refreshRunning=this.refreshTriggered=!1,this.refreshCancelCB&&clearTimeout(this.refreshCancelCB),this.hideRefresh(!1),this.setRefreshContent("Pull to Refresh"),a.trigger(this,"refresh-cancel")):this.refresh&&(this.refreshTriggered&&!this.refreshRunning&&this.el.scrollTop>-this.refreshHeight)&&(this.refreshRunning=this.refreshTriggered=!1,this.refreshCancelCB&&
clearTimeout(this.refreshCancelCB),this.hideRefresh(!1),this.setRefreshContent("Pull to Refresh"),a.trigger(this,"refresh-cancel"));this.cY=b;this.cX=g;this.lastScrollInfo.top=this.cY;this.initScrollProgress&&(a.trigger(this,"scroll",[{x:-this.el.scrollLeft,y:-this.el.scrollTop}]),a.trigger(a.touchLayer,"scroll",[{x:-this.el.scrollLeft,y:-this.el.scrollTop}]))};b.prototype.showRefresh=function(){this.refreshTriggered||(this.refreshTriggered=!0,this.setRefreshContent("Release to Refresh"),a.trigger(this,
"refresh-trigger"))};b.prototype.onTouchEnd=function(){var b=this.el.scrollTop<=-this.refreshHeight;this.fireRefreshRelease(b,!0);this.moved||(this.el.scrollTop+=this.yReset,this.el.scrollLeft+=this.xReset);if(b&&this.refresh){var e=a.create("<div style='height:"+this.el.clientHeight+this.refreshHeight+"px;width:1px;-webkit-transform:translated3d(-1px,0,0)'></div>");a(this.el).append(e);this.refreshContainer.style.top="0px";this.refreshContainer.style.position="";setTimeout(function(){e.remove()})}this.el.removeEventListener("touchmove",
this,!1);this.el.removeEventListener("touchend",this,!1);this.infiniteEndCheck=!0;this.infinite&&(!this.infiniteTriggered&&this.el.scrollTop>=this.el.scrollHeight-this.el.clientHeight)&&(this.infiniteTriggered=!0,a.trigger(this,"infinite-scroll"),this.infiniteEndCheck=!0);this.touchEndFired=!0;var g=this,f=this.el.scrollTop,d=this.el.scrollLeft,k=0;clearInterval(g.nativePolling);g.nativePolling=setInterval(function(){k++;25===k&&g.initScrollProgress&&(a.trigger(g,"scroll",[{x:-g.el.scrollLeft+g.cX,
y:-g.el.scrollTop+g.cY}]),a.trigger(a.touchLayer,"scroll",[{x:-g.el.scrollLeft+g.cX,y:-g.el.scrollTop+g.cY}]));if(200<=k)clearInterval(g.nativePolling),g.initScrollProgress&&(a.trigger(g,"scroll",[{x:-g.el.scrollLeft,y:-g.el.scrollTop}]),a.trigger(a.touchLayer,"scroll",[{x:-g.el.scrollLeft,y:-g.el.scrollTop}]));else if(g.el.scrollTop!==f||g.el.scrollLeft!==d)clearInterval(g.nativePolling),a.trigger(a.touchLayer,"scrollend",[g.el]),a.trigger(g,"scrollend",[g.el]),g.initScrollProgress&&(a.trigger(g,
"scroll",[{x:-g.el.scrollLeft,y:-g.el.scrollTop}]),a.trigger(a.touchLayer,"scroll",[{x:-g.el.scrollLeft,y:-g.el.scrollTop}]))},20)};b.prototype.hideRefresh=function(b){if(!this.preventHideRefresh){var e=this,g=function(b){e.refreshContainer.style.top="-60px";e.refreshContainer.style.position="absolute";e.dY=e.cY=0;b||(e.el.style[a.feat.cssPrefix+"Transform"]="none",e.el.style[a.feat.cssPrefix+"TransitionProperty"]="none",e.el.scrollTop=0,e.logPos(e.el.scrollLeft,0),e.refreshRunning=!1,e.setRefreshContent("Pull to Refresh"),
a.trigger(e,"refresh-finish"))};!1===b||!e.afEl.css3Animate?g():e.afEl.css3Animate({y:e.el.scrollTop-e.refreshHeight+"px",x:"0%",time:"325ms",complete:g});this.refreshTriggered=!1}};b.prototype.hideScrollbars=function(){};b.prototype.scrollTo=function(a,b){this.logPos(a.x,a.y);a.x*=-1;a.y*=-1;return this._scrollTo(a,b)};b.prototype.scrollBy=function(a,b){a.x+=this.el.scrollLeft;a.y+=this.el.scrollTop;this.logPos(this.el.scrollLeft,this.el.scrollTop);return this._scrollTo(a,b)};b.prototype.scrollToBottom=
function(a){this._scrollToBottom(a);this.logPos(this.el.scrollLeft,this.el.scrollTop)};b.prototype.onScroll=function(){this.infinite&&this.touchEndFired?this.touchEndFired=!1:this.scrollSkip?this.scrollSkip=!1:(this.infinite&&(!this.infiniteTriggered&&this.el.scrollTop>=this.el.scrollHeight-this.el.clientHeight)&&(this.infiniteTriggered=!0,a.trigger(this,"infinite-scroll"),this.infiniteEndCheck=!0),this.infinite&&(this.infiniteEndCheck&&this.infiniteTriggered)&&(this.infiniteEndCheck=!1,a.trigger(this,
"infinite-scroll-end")))};b.prototype.logPos=function(a,b){this.loggedPcentX=this.divide(a,this.el.scrollWidth);this.loggedPcentY=this.divide(b,this.el.scrollHeight);this.scrollLeft=a;this.scrollTop=b;isNaN(this.loggedPcentX)&&(this.loggedPcentX=0);isNaN(this.loggedPcentY)&&(this.loggedPcentY=0)};b.prototype.adjustScroll=function(){this.adjustScrollOverflowProxy();this.el.scrollLeft=this.loggedPcentX*this.el.scrollWidth;this.el.scrollTop=this.loggedPcentY*this.el.scrollHeight;this.logPos(this.el.scrollLeft,
this.el.scrollTop)};h.prototype.defaultProperties=function(){this.boolScrollLock=!1;this.elementInfo=this.currentScrollingObject=null;this.verticalScroll=!0;this.horizontalScroll=!1;this.scrollBars=!0;this.hscrollBar=this.vscrollBar=null;this.vScrollCSS=this.hScrollCSS="scrollBar";this.firstEventInfo=null;this.moved=!1;this.preventPullToRefresh=!0;this.refreshSafeKeep=this.androidFormsMode=this.isScrolling=!1;this.lastScrollbar="";this.scrollingFinishCB=this.container=this.finishScrollingObject=null;
this.androidPerfHack=this.loggedPcentX=this.loggedPcentY=0};h.prototype.enable=function(a){this.eventsActive||(this.eventsActive=!0,a?this.scrollerMoveCSS({x:0,y:0},0):this.adjustScroll(),this.container.addEventListener("touchstart",this,!1),this.container.addEventListener("touchmove",this,!1),this.container.addEventListener("touchend",this,!1))};h.prototype.adjustScroll=function(){var a=this.getViewportSize();this.scrollerMoveCSS({x:Math.round(this.loggedPcentX*(this.el.clientWidth-a.w)),y:Math.round(this.loggedPcentY*
(this.el.clientHeight-a.h))},0)};h.prototype.disable=function(){if(this.eventsActive){var a=this.getCSSMatrix(this.el);this.logPos(numOnly(a.e)-numOnly(this.container.scrollLeft),numOnly(a.f)-numOnly(this.container.scrollTop));this.container.removeEventListener("touchstart",this,!1);this.container.removeEventListener("touchmove",this,!1);this.container.removeEventListener("touchend",this,!1);this.eventsActive=!1}};h.prototype.addPullToRefresh=function(a,b){b||(this.refresh=!0);this.refresh&&!0===
this.refresh&&(this.coreAddPullToRefresh(a),this.el.style.overflow="visible")};h.prototype.hideScrollbars=function(){this.hscrollBar&&(this.hscrollBar.style.display="none",this.hscrollBar.style[a.feat.cssPrefix+"TransitionDuration"]="0ms");this.vscrollBar&&(this.vscrollBar.style.display="none",this.vscrollBar.style[a.feat.cssPrefix+"TransitionDuration"]="0ms")};h.prototype.getViewportSize=function(){var a=window.getComputedStyle(this.container);isNaN(numOnly(a.paddingTop))&&window.alert(typeof a.paddingTop+
"::"+a.paddingTop+":");return{h:this.container.clientHeight>window.innerHeight?window.innerHeight:this.container.clientHeight-numOnly(a.paddingTop)-numOnly(a.paddingBottom),w:this.container.clientWidth>window.innerWidth?window.innerWidth:this.container.clientWidth-numOnly(a.paddingLeft)-numOnly(a.paddingRight)}};h.prototype.onTouchStart=function(b){this.moved=!1;this.currentScrollingObject=null;a(this.el).animateCss().stop();if(this.container&&(this.refreshCancelCB&&(clearTimeout(this.refreshCancelCB),
this.refreshCancelCB=null),this.scrollingFinishCB&&(clearTimeout(this.scrollingFinishCB),this.scrollingFinishCB=null),!(1!==b.touches.length||this.boolScrollLock)&&!(b.touches[0].target&&void 0!==b.touches[0].target.type&&"select"===b.touches[0].target.tagName.toLowerCase()))){var e={top:0,left:0,speedY:0,speedX:0,absSpeedY:0,absSpeedX:0,deltaY:0,deltaX:0,absDeltaY:0,absDeltaX:0,y:0,x:0,duration:0};this.elementInfo={};var g=this.getViewportSize();this.elementInfo.bottomMargin=g.h;this.elementInfo.maxTop=
this.el.clientHeight-this.elementInfo.bottomMargin;0>this.elementInfo.maxTop&&(this.elementInfo.maxTop=0);this.elementInfo.divHeight=this.el.clientHeight;this.elementInfo.rightMargin=g.w;this.elementInfo.maxLeft=this.el.clientWidth-this.elementInfo.rightMargin;0>this.elementInfo.maxLeft&&(this.elementInfo.maxLeft=0);this.elementInfo.divWidth=this.el.clientWidth;this.elementInfo.hasVertScroll=this.verticalScroll||0<this.elementInfo.maxTop;this.elementInfo.hasHorScroll=0<this.elementInfo.maxLeft;this.elementInfo.requiresVScrollBar=
this.vscrollBar&&this.elementInfo.hasVertScroll;this.elementInfo.requiresHScrollBar=this.hscrollBar&&this.elementInfo.hasHorScroll;this.saveEventInfo(b);this.saveFirstEventInfo(b);b=this.getCSSMatrix(this.el);e.top=numOnly(b.f)-numOnly(this.container.scrollTop);e.left=numOnly(b.e)-numOnly(this.container.scrollLeft);this.container.scrollTop=this.container.scrollLeft=0;this.currentScrollingObject=this.el;this.refresh&&0===e.top?(this.refreshContainer.style.display="block",this.refreshHeight=this.refreshContainer.firstChild.clientHeight,
this.refreshContainer.firstChild.style.top=-this.refreshHeight+"px",this.refreshContainer.style.overflow="visible",this.preventPullToRefresh=!1):0>e.top&&(this.preventPullToRefresh=!0,this.refresh&&(this.refreshContainer.style.overflow="hidden"));e.x=e.left;e.y=e.top;this.setVScrollBar(e,0,0)&&(this.vscrollBar.style.right="0px",this.vscrollBar.style[a.feat.cssPrefix+"Transition"]="",a(this.vscrollBar).animateCss().stop());this.setHScrollBar(e,0,0)&&(this.container.clientHeight>window.innerHeight?
this.hscrollBar.style.top=window.innerHeight-numOnly(this.hscrollBar.style.height)+"px":this.hscrollBar.style.bottom=numOnly(this.hscrollBar.style.height),this.hscrollBar.style[a.feat.cssPrefix+"Transition"]="",a(this.hscrollBar).animateCss().stop());this.lastScrollInfo=e;this.hasMoved=!1;0===this.elementInfo.maxTop&&0===this.elementInfo.maxLeft&&this.lockBounce?this.scrollToTop(0):this.scrollerMoveCSS(this.lastScrollInfo,0);this.scrollerMoveCSS(this.lastScrollInfo,0)}};h.prototype.getCSSMatrix=function(b){if(this.androidFormsMode){var e=
parseInt(b.style.marginTop,10);b=parseInt(b.style.marginLeft,10);isNaN(e)&&(e=0);isNaN(b)&&(b=0);return{f:e,e:b}}return a.getCssMatrix(b)};h.prototype.saveEventInfo=function(a){this.lastEventInfo={pageX:a.touches[0].pageX,pageY:a.touches[0].pageY,time:a.timeStamp}};h.prototype.saveFirstEventInfo=function(a){this.firstEventInfo={pageX:a.touches[0].pageX,pageY:a.touches[0].pageY,time:a.timeStamp}};h.prototype.setVScrollBar=function(a,b,g){if(!this.elementInfo.requiresVScrollBar)return!1;var f=parseFloat(this.elementInfo.bottomMargin/
this.elementInfo.divHeight)*this.elementInfo.bottomMargin+"px";numOnly(f)>this.elementInfo.bottomMargin&&(f=this.elementInfo.bottomMargin+"px");f!==this.vscrollBar.style.height&&(this.vscrollBar.style.height=f);a=this.elementInfo.bottomMargin-numOnly(this.vscrollBar.style.height)-(this.elementInfo.maxTop+a.y)/this.elementInfo.maxTop*(this.elementInfo.bottomMargin-numOnly(this.vscrollBar.style.height));a>this.elementInfo.bottomMargin&&(a=this.elementInfo.bottomMargin);0>a&&(a=0);this.scrollbarMoveCSS(this.vscrollBar,
{x:0,y:a},b,g);return!0};h.prototype.setHScrollBar=function(a,b,g){if(!this.elementInfo.requiresHScrollBar)return!1;var f=parseFloat(this.elementInfo.rightMargin/this.elementInfo.divWidth)*this.elementInfo.rightMargin+"px";f!==this.hscrollBar.style.width&&(this.hscrollBar.style.width=f);a=this.elementInfo.rightMargin-numOnly(this.hscrollBar.style.width)-(this.elementInfo.maxLeft+a.x)/this.elementInfo.maxLeft*(this.elementInfo.rightMargin-numOnly(this.hscrollBar.style.width));a>this.elementInfo.rightMargin&&
(a=this.elementInfo.rightMargin);0>a&&(a=0);this.scrollbarMoveCSS(this.hscrollBar,{x:a,y:0},b,g);return!0};h.prototype.onTouchMove=function(b){if(null!==this.currentScrollingObject&&(!b.target||!(b.target.getAttribute("type")&&-1!==b.target.getAttribute("type").toLowerCase().indexOf("range")))){var e=this.calculateMovement(b);this.calculateTarget(e);this.lastScrollInfo=e;this.moved||(a.trigger(this,"scrollstart",[this.el,{x:this.lastScrollInfo.top,y:this.lastScrollInfo.left}]),a.trigger(a.touchLayer,
"scrollstart",[this.el,{x:this.lastScrollInfo.top,y:this.lastScrollInfo.left}]),this.elementInfo.requiresVScrollBar&&(this.vscrollBar.style.display="block"),this.elementInfo.requiresHScrollBar&&(this.hscrollBar.style.display="block"));this.moved=!0;this.refresh&&0===e.top?(this.refreshContainer.style.display="block",this.refreshHeight=this.refreshContainer.firstChild.clientHeight,this.refreshContainer.firstChild.style.top=-this.refreshHeight+"px",this.refreshContainer.style.overflow="visible",this.preventPullToRefresh=
!1):0>e.top&&(this.preventPullToRefresh=!0,this.refresh&&(this.refreshContainer.style.overflow="hidden"));this.saveEventInfo(b);if(!1===this.isScrolling&&(this.isScrolling=!0,this.onScrollStart))this.onScrollStart();b=this.getCSSMatrix(this.el);this.lastScrollInfo.top=numOnly(b.f);this.lastScrollInfo.left=numOnly(b.e);this.recalculateDeltaY(this.lastScrollInfo);this.recalculateDeltaX(this.lastScrollInfo);this.checkYboundary(this.lastScrollInfo);this.elementInfo.hasHorScroll&&this.checkXboundary(this.lastScrollInfo);
b=0<this.lastScrollInfo.y&&0<this.lastScrollInfo.deltaY;var g=this.lastScrollInfo.y<-this.elementInfo.maxTop&&0>this.lastScrollInfo.deltaY,f;if(b||g)e=b?this.lastScrollInfo.y:-this.lastScrollInfo.y-this.elementInfo.maxTop,e=(this.container.clientHeight-e)/this.container.clientHeight,0.5>e&&(e=0.5),f=0,b&&0<this.lastScrollInfo.top||g&&this.lastScrollInfo.top<-this.elementInfo.maxTop?f=this.lastScrollInfo.top:g&&(f=-this.elementInfo.maxTop),g=this.lastScrollInfo.deltaY*e,1>Math.abs(this.lastScrollInfo.deltaY*
e)&&(g=b?1:-1),this.lastScrollInfo.y=f+g;if(this.elementInfo.hasHorScroll&&(b=0<this.lastScrollInfo.x&&0<this.lastScrollInfo.deltaX,g=this.lastScrollInfo.x<-this.elementInfo.maxLeft&&0>this.lastScrollInfo.deltaX,b||g))e=b?this.lastScrollInfo.x:-this.lastScrollInfo.x-this.elementInfo.maxLeft,e=(this.container.clientWidth-e)/this.container.clientWidth,0.5>e&&(e=0.5),f=0,b&&0<this.lastScrollInfo.left||g&&this.lastScrollInfo.left<-this.elementInfo.maxLeft?f=this.lastScrollInfo.left:g&&(f=-this.elementInfo.maxLeft),
g=this.lastScrollInfo.deltaX*e,1>Math.abs(this.lastScrollInfo.deltaX*e)&&(g=b?1:-1),this.lastScrollInfo.x=f+g;this.lockBounce&&!this.refresh&&(0<this.lastScrollInfo.x?this.lastScrollInfo.x=0:-1*this.lastScrollInfo.x>this.elementInfo.maxLeft&&(this.lastScrollInfo.x=-1*this.elementInfo.maxLeft),0<this.lastScrollInfo.y?this.lastScrollInfo.y=0:-1*this.lastScrollInfo.y>this.elementInfo.maxTop&&(this.lastScrollInfo.y=-1*this.elementInfo.maxTop));this.scrollerMoveCSS(this.lastScrollInfo,0);this.setVScrollBar(this.lastScrollInfo,
0,0);this.setHScrollBar(this.lastScrollInfo,0,0);this.refresh&&!this.preventPullToRefresh&&(!this.refreshTriggered&&this.lastScrollInfo.top>this.refreshHeight?(this.refreshTriggered=!0,this.setRefreshContent("Release to Refresh"),a.trigger(this,"refresh-trigger")):this.refreshTriggered&&this.lastScrollInfo.top<this.refreshHeight&&(this.refreshTriggered=!1,this.setRefreshContent("Pull to Refresh"),a.trigger(this,"refresh-cancel")));this.infinite&&!this.infiniteTriggered&&Math.abs(this.lastScrollInfo.top)>
this.el.clientHeight-this.container.clientHeight&&(this.infiniteTriggered=!0,a.trigger(this,"infinite-scroll"))}};h.prototype.calculateMovement=function(a,b){var g={top:0,left:0,speedY:0,speedX:0,absSpeedY:0,absSpeedX:0,deltaY:0,deltaX:0,absDeltaY:0,absDeltaX:0,y:0,x:0,duration:0},f=b?this.firstEventInfo:this.lastEventInfo,d=b?a.pageX:a.touches[0].pageX,k=b?a.pageY:a.touches[0].pageY,h=b?a.time:a.timeStamp;g.deltaY=this.elementInfo.hasVertScroll?k-f.pageY:0;g.deltaX=this.elementInfo.hasHorScroll?
d-f.pageX:0;g.time=h;g.duration=h-f.time;return g};h.prototype.calculateTarget=function(a){a.y=this.lastScrollInfo.y+a.deltaY;a.x=this.lastScrollInfo.x+a.deltaX;0<Math.abs(a.deltaY)&&(a.y+=(0<a.deltaY?1:-1)*this.elementInfo.divHeight*this.androidPerfHack);0<Math.abs(a.deltaX)&&(a.x+=(0<a.deltaX?1:-1)*this.elementInfo.divWidth*this.androidPerfHack)};h.prototype.checkYboundary=function(a){var b=this.container.clientHeight/2,g=this.elementInfo.maxTop+b;if(a.y>b)a.y=b;else if(-a.y>g)a.y=-g;else return;
this.recalculateDeltaY(a)};h.prototype.checkXboundary=function(a){var b=this.container.clientWidth/2,g=this.elementInfo.maxLeft+b;if(a.x>b)a.x=b;else if(-a.x>g)a.x=-g;else return;this.recalculateDeltaX(a)};h.prototype.recalculateDeltaY=function(a){var b=Math.abs(a.deltaY);a.deltaY=a.y-a.top;var g=Math.abs(a.deltaY);a.duration=a.duration*g/b};h.prototype.recalculateDeltaX=function(a){var b=Math.abs(a.deltaX);a.deltaX=a.x-a.left;var g=Math.abs(a.deltaX);a.duration=a.duration*g/b};h.prototype.hideRefresh=
function(b){var e=this;if(!this.preventHideRefresh){var g=function(){e.setRefreshContent("Pull to Refresh");a.trigger(e,"refresh-finish")};this.scrollerMoveCSS({x:0,y:0},325);!1===b||!e.afEl.css3Animate?g():e.afEl.css3Animate({time:"325ms",complete:g});this.refreshTriggered=!1}};h.prototype.setMomentum=function(a){a.speedY=this.divide(a.deltaY,a.duration);a.speedX=this.divide(a.deltaX,a.duration);a.absSpeedY=Math.abs(a.speedY);a.absSpeedX=Math.abs(a.speedX);a.absDeltaY=Math.abs(a.deltaY);a.absDeltaX=
Math.abs(a.deltaX);if(0<a.absDeltaY){if(a.deltaY=(0>a.deltaY?-1:1)*a.absSpeedY*a.absSpeedY/0.0024,a.absDeltaY=Math.abs(a.deltaY),a.duration=a.absSpeedY/0.0012,a.speedY=a.deltaY/a.duration,a.absSpeedY=Math.abs(a.speedY),0.12>a.absSpeedY||5>a.absDeltaY)a.deltaY=a.absDeltaY=a.duration=a.speedY=a.absSpeedY=0}else if(a.absDeltaX){if(a.deltaX=(0>a.deltaX?-1:1)*a.absSpeedX*a.absSpeedX/0.0024,a.absDeltaX=Math.abs(a.deltaX),a.duration=a.absSpeedX/0.0012,a.speedX=a.deltaX/a.duration,a.absSpeedX=Math.abs(a.speedX),
0.12>a.absSpeedX||5>a.absDeltaX)a.deltaX=a.absDeltaX=a.duration=a.speedX=a.absSpeedX=0}else a.duration=0};h.prototype.onTouchEnd=function(){var b=this;if(null!==this.currentScrollingObject&&this.moved){this.finishScrollingObject=this.currentScrollingObject;this.currentScrollingObject=null;var e=this.calculateMovement(this.lastEventInfo,!0);this.androidFormsMode||this.setMomentum(e);this.calculateTarget(e);var g=this.getCSSMatrix(this.el);e.top=numOnly(g.f);e.left=numOnly(g.e);this.checkYboundary(e);
this.elementInfo.hasHorScroll&&this.checkXboundary(e);g=!this.preventPullToRefresh&&(e.top>this.refreshHeight||e.y>this.refreshHeight);this.fireRefreshRelease(g,0<e.top);if(this.refresh&&g)e.y=this.refreshHeight,e.duration=325;else if(0<=e.y)e.y=0,0<=e.top&&(e.duration=325);else if(-e.y>this.elementInfo.maxTop||0===this.elementInfo.maxTop)e.y=-this.elementInfo.maxTop,-e.top>this.elementInfo.maxTop&&(e.duration=325);if(this.elementInfo.hasHorScroll)if(0<=e.x)e.x=0,0<=e.left&&this.refresh&&(e.duration=
325);else if(-e.x>this.elementInfo.maxLeft||0===this.elementInfo.maxLeft)e.x=-this.elementInfo.maxLeft,-e.left>this.elementInfo.maxLeft&&this.refresh&&(e.duration=325);if(e.x===e.left&&e.y===e.top||this.androidFormsMode)e.duration=0;setTimeout(function(){b.scrollerMoveCSS(e,e.duration,"cubic-bezier(0.33,0.66,0.66,1)")});this.setVScrollBar(e,e.duration,"cubic-bezier(0.33,0.66,0.66,1)");this.setHScrollBar(e,e.duration,"cubic-bezier(0.33,0.66,0.66,1)");this.setFinishCalback(e.duration);this.infinite&&
!this.infiniteTriggered&&Math.abs(e.y)>=this.el.clientHeight-this.container.clientHeight&&(b=this,setTimeout(function(){b.infiniteTriggered=!0;a.trigger(b,"infinite-scroll")},e.duration-50))}};h.prototype.setFinishCalback=function(b){var e=this;this.scrollingFinishCB=setTimeout(function(){e.hideScrollbars();a.trigger(a.touchLayer,"scrollend",[e.el]);a.trigger(e,"scrollend",[e.el]);e.isScrolling=!1;e.elementInfo=null;e.infinite&&e.infiniteTriggered&&a.trigger(e,"infinite-scroll-end")},b)};h.prototype.startFormsMode=
function(){if(!this.blockFormsFix){var b=this.getCSSMatrix(this.el);this.refreshSafeKeep=this.refresh;this.refresh=!1;this.androidFormsMode=!0;this.el.style[a.feat.cssPrefix+"Transform"]="none";this.el.style[a.feat.cssPrefix+"Transition"]="none";this.el.style[a.feat.cssPrefix+"Perspective"]="none";this.scrollerMoveCSS({x:numOnly(b.e),y:numOnly(b.f)},0);this.container.style[a.feat.cssPrefix+"Perspective"]="none";this.container.style[a.feat.cssPrefix+"BackfaceVisibility"]="visible";this.vscrollBar&&
(this.vscrollBar.style[a.feat.cssPrefix+"Transform"]="none",this.vscrollBar.style[a.feat.cssPrefix+"Transition"]="none",this.vscrollBar.style[a.feat.cssPrefix+"Perspective"]="none",this.vscrollBar.style[a.feat.cssPrefix+"BackfaceVisibility"]="visible");this.hscrollBar&&(this.hscrollBar.style[a.feat.cssPrefix+"Transform"]="none",this.hscrollBar.style[a.feat.cssPrefix+"Transition"]="none",this.hscrollBar.style[a.feat.cssPrefix+"Perspective"]="none",this.hscrollBar.style[a.feat.cssPrefix+"BackfaceVisibility"]=
"visible")}};h.prototype.stopFormsMode=function(){if(!this.blockFormsFix){var b=this.getCSSMatrix(this.el);this.refresh=this.refreshSafeKeep;this.androidFormsMode=!1;this.el.style[a.feat.cssPrefix+"Perspective"]=1E3;this.el.style.marginTop=0;this.el.style.marginLeft=0;this.el.style[a.feat.cssPrefix+"Transition"]="0ms linear";this.scrollerMoveCSS({x:numOnly(b.e),y:numOnly(b.f)},0);this.container.style[a.feat.cssPrefix+"Perspective"]=1E3;this.container.style[a.feat.cssPrefix+"BackfaceVisibility"]="hidden";
this.vscrollBar&&(this.vscrollBar.style[a.feat.cssPrefix+"Perspective"]=1E3,this.vscrollBar.style[a.feat.cssPrefix+"BackfaceVisibility"]="hidden");this.hscrollBar&&(this.hscrollBar.style[a.feat.cssPrefix+"Perspective"]=1E3,this.hscrollBar.style[a.feat.cssPrefix+"BackfaceVisibility"]="hidden")}};h.prototype.scrollerMoveCSS=function(b,e,g){e||(e=0);g||(g="linear");e=numOnly(e);var f=this;this.el&&this.el.style&&(this.eventsActive&&(this.androidFormsMode?(this.el.style.marginTop=Math.round(b.y)+"px",
this.el.style.marginLeft=Math.round(b.x)+"px"):(e={x:b.x,y:b.y,duration:e,easing:"easeOutSine"},f.initScrollProgress&&(e.update=function(b){a.trigger(f,"scroll",[b]);a.trigger(a.touchLayer,"scroll",[b])}),a(this.el).animateCss(e).start())),this.logPos(b.x,b.y))};h.prototype.logPos=function(a,b){var g;g=this.elementInfo?{h:this.elementInfo.bottomMargin,w:this.elementInfo.rightMargin}:this.getViewportSize();this.loggedPcentX=this.divide(a,this.el.clientWidth-g.w);this.loggedPcentY=this.divide(b,this.el.clientHeight-
g.h);this.scrollTop=b;this.scrollLeft=a};h.prototype.scrollbarMoveCSS=function(b,e,g,f){g||(g=0);b&&b.style&&(this.androidFormsMode?(b.style.marginTop=Math.round(e.y)+"px",b.style.marginLeft=Math.round(e.x)+"px"):a(b).animateCss({x:e.x,y:e.y,duration:g,easing:"easeOutSine"}).start())};h.prototype.scrollTo=function(a,b){b||(b=0);this.scrollerMoveCSS(a,b)};h.prototype.scrollBy=function(a,b){var g=this.getCSSMatrix(this.el),f=numOnly(g.f),g=numOnly(g.e);this.scrollTo({y:f-a.y,x:g-a.x},b)};h.prototype.scrollToBottom=
function(a){this.scrollTo({y:-1*(this.el.clientHeight-this.container.clientHeight),x:0},a)};h.prototype.scrollToTop=function(a){this.scrollTo({x:0,y:0},a)};return function(c,e){var g;if(!l&&a.touchLayer&&a.isObject(a.touchLayer))n();else if(!a.touchLayer||!a.isObject(a.touchLayer))a.touchLayer={};if(g="string"===typeof c||c instanceof String?document.getElementById(c):c){var d=a(g);e.hasParent&&(d=d.parent());d.hasClass("x-scroll")&&(e.horizontalScroll=!0);d.hasClass("y-scroll")&&(e.verticalScroll=
!0);return a.os.desktop?new f(g,e):e.useJsScroll?new h(g,e):new b(g,e)}window.alert("Could not find element for scroller "+c)}}()})(af);
(function(a){function n(d,k,h){!0===h&&(this.getAttribute("multiple")||a.selectBox.updateMaskValue(this.parentNode.id,this.text,this.value),this.parentNode.value=this.value);return h}function m(d,k,h){this.options[h]&&(this.getAttribute("multiple")||a.selectBox.updateMaskValue(this.linker,this.options[h].value,this.options[h].text),this.value=this.options[h].value);return h}function l(d){var k=d.target;a(k.linker).remove();delete k.linker;d.stopPropagation()}a.selectBox={scroller:null,currLinker:null,
getOldSelects:function(d){if(a.os.android&&!a.os.androidICS)if(a.fn.scroller){var k=d&&document.getElementById(d)?document.getElementById(d):document;if(k){d=k.getElementsByTagName("select");for(k=0;k<d.length;k++){var h=d[k];h.style.display="none";var b=a.create("div",{className:"afFakeSelect"});b.get(0).linker=d[k];h.linker=b.get(0);b.insertAfter(d[k]);h.watch("selectedIndex",m);for(var f=0;f<h.options.length;f++)h.options[f].watch("selected",n),h.options[f].selected&&b.html(h.options[f].text);
a(h).one("destroy",l)}this.createHtml()}else window.alert("Could not find container element for af.selectBox "+d)}else window.alert("This library requires af.scroller")},updateDropdown:function(a){if(a)for(var k=0;k<a.options.length;k++)a.options[k].selected&&(a.linker.innerHTML=a.options[k].text)},initDropDown:function(d){if(!d.disabled&&d&&d.options&&0!==d.options.length){var k=0,h=a("#afSelectBoxfix");h.html("<ul></ul>");for(var h=h.find("ul"),b=0;b<d.options.length;b++){d.options[b].watch("selected",
n);var f=d.options[b].selected?"selected":"";f&&(k=b+1);f=a.create("li",{html:d.options[b].text,className:f});f.data("ind",b);h.append(f)}a("#afModalMask").show();try{if(0<k&&"multiple"!==d.getAttribute("multiple")){d=0;var c=numOnly(h.find("li").computedStyle("height")),e=numOnly(a("#afSelectBoxContainer").computedStyle("height"));k*c>=e&&(d=(k-1)*-c);this.scroller.scrollTo({x:0,y:d})}}catch(g){console.log("error init dropdown"+g)}k="block"===a("#afSelectClose").css("display")?numOnly(a("#afSelectClose").height()):
0;a("#afSelectWrapper").height(numOnly(a("#afSelectBoxContainer").height())-k+"px")}},updateMaskValue:function(d,k,h){a(d).html(h)},setDropDownValue:function(d,k){if(d){var h=a(d);k=parseInt(k,10);d.getAttribute("multiple")?(h=a("#afSelectBoxfix li:nth-child("+(k+1)+")"),h.hasClass("selected")?h.removeClass("selected"):h.addClass("selected")):(d.selectedIndex=k,h.find("option").prop("selected",!1),h.find("option:nth-child("+(k+1)+")").prop("selected",!0),this.scroller.scrollTo({x:0,y:0}),this.hideDropDown());
a(d).trigger("change")}},hideDropDown:function(){a("#afModalMask").hide();a("#afSelectBoxfix").html("")},createHtml:function(){var d=this;document.getElementById("afSelectBoxfix")||a(document).ready(function(){a(document).on("click",".afFakeSelect",function(){this.linker.disabled||(d.currLinker=this,"multiple"===this.linker.getAttribute("multiple")?a("#afSelectClose").show():a("#afSelectClose").hide(),d.initDropDown(this.linker))});var k=a.create("div",{id:"afSelectBoxContainer"}),h=a.create("div",
{id:"afSelectBoxfix"}),b=a.create("div",{id:"afSelectWrapper"});b.css("position","relative");b.append(h);var h=a.create("div",{id:"afSelectClose",html:"<a id='afSelectDone'>Done</a> <a id='afSelectCancel'>Cancel</a>"}),f=a.create("div",{id:"afModalMask"}),c=a("#afui");k.prepend(h).append(b);f.append(k);0<c.length?c.append(f):document.body.appendChild(f.get(0));d.scroller=a.query("#afSelectBoxfix").scroller({scroller:!1,verticalScroll:!0,vScrollCSS:"afselectscrollBarV",hasParent:!0});a("#afModalMask").on("click",
function(b){0===a(b.target).closest("#afSelectBoxContainer").length&&d.hideDropDown()});a("#afSelectBoxfix").on("click","li",function(b){b=a(b.target);d.setDropDownValue(d.currLinker.linker,b.data("ind"))});a("#afSelectBoxContainer").on("click","a",function(b){if("afSelectCancel"===b.target.id)return d.hideDropDown();var c=a(d.currLinker.linker);c.find("option").prop("selected",!1);a("#afSelectBoxfix li").each(function(){var b=a(this);if(b.hasClass("selected")){var e=parseInt(b.data("ind"),10);c.find("option:nth-child("+
(e+1)+")").prop("selected",!0);d.currLinker.innerHTML=b.html()}});d.hideDropDown();b.stopPropagation();b.preventDefault();return!1})})}};HTMLElement.prototype.watch||(HTMLElement.prototype.watch=function(a,k){var h=this[a],b=h,f=function(){return b},c=function(e){h=b;return b=k.call(this,a,h,e)};delete this[a]&&(HTMLElement.defineProperty?HTMLElement.defineProperty(this,a,{get:f,set:c,enumerable:!1,configurable:!0}):HTMLElement.prototype.__defineGetter__&&HTMLElement.prototype.__defineSetter__&&(HTMLElement.prototype.__defineGetter__.call(this,
a,f),HTMLElement.prototype.__defineSetter__.call(this,a,c)))});HTMLElement.prototype.unwatch||(HTMLElement.prototype.unwatch=function(a){var k=this[a];delete this[a];this[a]=k})})(af);
(function(a){function n(a,f,c,e){var g=Math.abs(a-f),d=Math.abs(c-e);return g>=d?0<a-f?"Left":"Right":0<c-e?"Up":"Down"}function m(){l.last&&Date.now()-l.last>=k&&(l.el.trigger("longTap"),l={})}var l={},d,k=750,h;a(document).ready(function(){var b;a(document.body).bind("touchstart",function(f){f.originalEvent&&(f=f.originalEvent);if(f.touches&&0!==f.touches.length){var c=Date.now(),e=c-(l.last||c);f.touches&&0!==f.touches.length&&(l.el=a("tagName"in f.touches[0].target?f.touches[0].target:f.touches[0].target.parentNode),
d&&clearTimeout(d),l.x1=f.touches[0].pageX,l.y1=f.touches[0].pageY,l.x2=l.y2=0,0<e&&250>=e&&(l.isDoubleTap=!0),l.last=c,h=setTimeout(m,k),a.ui.useAutoPressed&&!l.el.data("ignore-pressed")&&l.el.addClass("pressed"),b&&(a.ui.useAutoPressed&&!b.data("ignore-pressed")&&b[0]!==l.el[0])&&b.removeClass("pressed"),b=l.el)}}).bind("touchmove",function(a){a.originalEvent&&(a=a.originalEvent);l.x2=a.touches[0].pageX;l.y2=a.touches[0].pageY;clearTimeout(h)}).bind("touchend",function(b){b.originalEvent&&(b=b.originalEvent);
l.el&&(a.ui.useAutoPressed&&!l.el.data("ignore-pressed")&&l.el.removeClass("pressed"),l.isDoubleTap?(l.el.trigger("doubleTap"),l={}):0<l.x2||0<l.y2?((30<Math.abs(l.x1-l.x2)||30<Math.abs(l.y1-l.y2))&&l.el.trigger("swipe")&&l.el.trigger("swipe"+n(l.x1,l.x2,l.y1,l.y2),l),l.x1=l.x2=l.y1=l.y2=l.last=0):"last"in l&&(l.el.trigger("tap"),d=setTimeout(function(){d=null;l.el&&l.el.trigger("singleTap");l={}},250)))}).bind("touchcancel",function(){l.el&&(a.ui.useAutoPressed&&!l.el.data("ignore-pressed"))&&l.el.removeClass("pressed");
l={};clearTimeout(h)})});"swipe swipeLeft swipeRight swipeUp swipeDown doubleTap tap singleTap longTap".split(" ").forEach(function(b){a.fn[b]=function(a){return this.bind(b,a)}})})(af);
(function(a){a.touchLayer=function(b){a.touchLayer=new c(b);return a.touchLayer};var n=["input","select","textarea","range"],m=["button","radio","checkbox","range","date"],l=a.os.ios,d=a.os.blackberry,k=a.os.blackberry||a.os.fennec||a.os.android&&!a.os.androidICS,h=a.os.ios&&!a.os.ios7,b=!1,f=!1,c=function(b){this.clearTouchVars();b.addEventListener("touchstart",this,!1);b.addEventListener("touchmove",this,!1);b.addEventListener("touchend",this,!1);b.addEventListener("click",this,!1);b.addEventListener("focusin",
this,!1);document.addEventListener("scroll",this,!1);window.addEventListener("resize",this,!1);window.addEventListener("orientationchange",this,!1);this.layer=b;this.scrollEndedProxy_=a.proxy(this.scrollEnded,this);this.exitEditProxy_=a.proxy(this.exitExit,this,[]);this.launchFixUIProxy_=a.proxy(this.launchFixUI,this);var c=this;this.scrollTimeoutExpireProxy_=function(){c.scrollTimeout_=null;c.scrollTimeoutEl_.addEventListener("scroll",c.scrollEndedProxy_,!1)};this.retestAndFixUIProxy_=function(){a.os.android&&
!a.os.chrome&&(c.layer.style.height="100%");a.asap(c.testAndFixUI,c,arguments)};document.addEventListener("click",function(a){if(f)return a.preventDefault(),a.stopPropagation(),!1;void 0!==a.clientX&&null!==c.lastTouchStartX&&(2>Math.abs(c.lastTouchStartX-a.clientX)&&2>Math.abs(c.lastTouchStartY-a.clientY))&&(a.preventDefault(),a.stopPropagation())},!0);a.bind(this,"scrollstart",function(b){c.isScrolling=!0;c.scrollingEl_=b;a.feat.nativeTouchScroll||(c.scrollerIsScrolling=!0);c.fireEvent("UIEvents",
"scrollstart",b,!1,!1)});a.bind(this,"scrollend",function(b){c.isScrolling=!1;a.feat.nativeTouchScroll||(c.scrollerIsScrolling=!1);c.fireEvent("UIEvents","scrollend",b,!1,!1)});this.hideAddressBar(0,1);this.launchFixUI(5)};c.prototype={dX:0,dY:0,cX:0,cY:0,touchStartX:null,touchStartY:null,layer:null,scrollingEl_:null,scrollTimeoutEl_:null,scrollTimeout_:null,reshapeTimeout_:null,scrollEndedProxy_:null,exitEditProxy_:null,launchFixUIProxy_:null,reHideAddressBarTimeout_:null,retestAndFixUIProxy_:null,
panElementId:"header",blockClicks:!1,allowDocumentScroll_:!1,ignoreNextResize_:!1,blockPossibleClick_:!1,isScrolling:!1,isScrollingVertical_:!1,wasPanning_:!1,isPanning_:!1,isFocused_:!1,justBlurred_:!1,requiresNativeTap:!1,holdingReshapeType_:null,trackingClick:!1,scrollerIsScrolling:!1,handleEvent:function(a){switch(a.type){case "touchstart":this.onTouchStart(a);break;case "touchmove":this.onTouchMove(a);break;case "touchend":this.onTouchEnd(a);break;case "click":this.onClick(a);break;case "blur":this.onBlur(a);
break;case "scroll":this.onScroll(a);break;case "orientationchange":this.onOrientationChange(a);break;case "resize":this.onResize(a);break;case "focusin":this.onFocusIn(a)}},launchFixUI:function(a){a||(a=2);if(null===this.reHideAddressBarTimeout_)return this.testAndFixUI(0,a)},resetFixUI:function(){this.reHideAddressBarTimeout_&&clearTimeout(this.reHideAddressBarTimeout_);this.reHideAddressBarTimeout_=null},testAndFixUI:function(b,c){var f=this.getReferenceHeight(),d=this.getCurrentHeight();if(f!==
d&&!(0.97*d<f&&0.97*f<d))return this.hideAddressBar(b,c),!0;a.os.android&&this.resetFixUI();return!1},hideAddressBar:function(b,c){if(!a.ui||!a.ui.isIntel)if(b>=c)this.resetFixUI();else if(a.os.desktop||a.os.kindle)this.layer.style.height="100%";else if(a.os.android){window.scrollTo(1,1);this.layer.style.height=this.isFocused_||window.innerHeight>=window.outerHeight?window.innerHeight+"px":window.outerHeight+"px";var f=b+1;this.reHideAddressBarTimeout_=setTimeout(this.retestAndFixUIProxy_,250*f,f,
c)}else this.isFocused_||(document.documentElement.style.height="5000px",window.scrollTo(0,0),document.documentElement.style.height=window.innerHeight+"px",this.layer.style.height=window.innerHeight+"px")},getReferenceHeight:function(){return window.innerHeight},getCurrentHeight:function(){return a.os.android?window.innerHeight:numOnly(document.documentElement.style.height)},onOrientationChange:function(){this.focusedElement&&this.focusedElement.blur();!this.holdingReshapeType_&&this.reshapeTimeout_?
this.fireReshapeEvent("orientationchange"):this.previewReshapeEvent("orientationchange");a.os.android&&a.os.chrome&&(this.layer.style.height="100%")},onResize:function(){this.ignoreNextResize_?this.ignoreNextResize_=!1:this.launchFixUI()&&this.reshapeAction()},onClick:function(b){var c=b.target&&void 0!==b.target.tagName?b.target.tagName.toLowerCase():"";if(-1!==n.indexOf(c)&&(!this.isFocused_||b.target!==this.focusedElement)){c=b.target&&void 0!==b.target.type?b.target.type.toLowerCase():"";if(-1===
m.indexOf(c)){this.isFocused_&&this.focusedElement.removeEventListener("blur",this,!1);this.focusedElement=b.target;this.focusedElement.addEventListener("blur",this,!1);if(!this.isFocused_&&!this.justBlurred_)if(a.trigger(this,"enter-edit",[b.target]),a.os.ios){var f=this;setTimeout(function(){f.fireReshapeEvent("enter-edit")},300)}else this.previewReshapeEvent("enter-edit");this.isFocused_=!0}else this.isFocused_=!1;this.justBlurred_=!1;this.allowDocumentScroll_=!0;l&&b.target.focus()}else a.os.blackberry10&&
this.isFocused_&&this.focusedElement.blur()},previewReshapeEvent:function(a){var b=this;this.reshapeTimeout_=setTimeout(function(){b.fireReshapeEvent(a);b.reshapeTimeout_=null;b.holdingReshapeType_=null},750);this.holdingReshapeType_=a},fireReshapeEvent:function(b){a.trigger(this,"reshape");a.trigger(this,b?b+"-reshape":"unknown-reshape")},reshapeAction:function(){this.reshapeTimeout_?(clearTimeout(this.reshapeTimeout_),this.fireReshapeEvent(this.holdingReshapeType_),this.reshapeTimeout_=this.holdingReshapeType_=
null):this.previewReshapeEvent()},onFocusIn:function(a){if(!this.isFocused_)this.onClick(a)},onBlur:function(b){a.os.android&&b.target===window||(this.isFocused_=!1,this.focusedElement&&this.focusedElement.removeEventListener("blur",this,!1),this.focusedElement=null,this.justBlurred_=!0,a.asap(this.exitEditProxy_,this,[b.target]))},exitExit:function(b){this.justBlurred_=!1;if(!this.isFocused_)if(a.trigger(this,"exit-edit",[b]),this.allowDocumentScroll_=!1,a.os.ios){var c=this;setTimeout(function(){c.fireReshapeEvent("exit-edit")},
300)}else this.previewReshapeEvent("exit-edit")},onScroll:function(a){!this.allowDocumentScroll_&&(!this.isPanning_&&a.target===document)&&(this.allowDocumentScroll_=!0,this.wasPanning_?(this.wasPanning_=!1,setTimeout(this.launchFixUIProxy_,2E3,[2])):this.launchFixUI())},onTouchStart:function(c){this.dX=c.touches[0].pageX;this.dY=c.touches[0].pageY;this.lastTimestamp=c.timeStamp;this.lastTouchStartX=this.lastTouchStartY=null;if(a.os.ios){if(b===c.touches[0].identifier)return f=!0,c.preventDefault(),
b=!1;b=c.touches[0].identifier;f=!1}if(this.scrollerIsScrolling)return this.moved=!0,this.scrollerIsScrolling=!1,c.preventDefault(),!1;this.trackingClick=!0;(h||a.feat.nativeTouchScroll)&&this.checkDOMTree(c.target,this.layer);this.isScrolling&&(null!==this.scrollTimeout_?(clearTimeout(this.scrollTimeout_),this.scrollTimeout_=null,this.scrollTimeoutEl_!==this.scrollingEl_?this.scrollEnded(!1):this.blockPossibleClick_=!0):this.scrollTimeoutEl_&&(this.scrollEnded(!0),this.blockPossibleClick_=!0));if(a.os.android&&
c&&c.target&&c.target.getAttribute&&"ignore"===c.target.getAttribute("data-touchlayer")||this.isFocused_&&!a.os.blackberry10)this.allowDocumentScroll_=this.requiresNativeTap=!0;else if(k&&c.target&&void 0!==c.target.tagName){var g=c.target.tagName.toLowerCase();-1!==n.indexOf(g)&&(this.requiresNativeTap=!0)}else c.target&&(void 0!==c.target.tagName&&"input"===c.target.tagName.toLowerCase()&&"range"===c.target.type)&&(this.requiresNativeTap=!0);!a.os.chrome&&(!a.os.fennec&&!a.os.androidICS)&&(!this.isPanning_&&
!this.requiresNativeTap?(this.isScrolling&&!a.feat.nativeTouchScroll||!this.isScrolling)&&c.preventDefault():this.isScrollingVertical_&&this.demandVerticalScroll())},demandVerticalScroll:function(){0>=this.scrollingEl_.scrollTop?this.scrollingEl_.scrollTop=1:this.scrollingEl_.scrollTop+this.scrollingEl_.clientHeight>=this.scrollingEl_.scrollHeight&&(this.scrollingEl_.scrollTop=this.scrollingEl_.scrollHeight-this.scrollingEl_.clientHeight-1)},ignoreScrolling:function(a){return void 0===a.scrollWidth||
void 0===a.clientWidth||void 0===a.scrollHeight||void 0===a.clientHeight?!0:!1},allowsVerticalScroll:function(a,b){var c=b.overflowY;return"scroll"===c||"auto"===c&&a.scrollHeight>a.clientHeight?!0:!1},allowsHorizontalScroll:function(a,b){var c=b.overflowX;return"scroll"===c||"auto"===c&&a.scrollWidth>a.clientWidth?!0:!1},checkDOMTree:function(b,c){if(h&&this.panElementId===b.id)this.isPanning_=!0;else{if(a.feat.nativeTouchScroll){if(this.ignoreScrolling(b))return;var f=window.getComputedStyle(b);
if(this.allowsVerticalScroll(b,f)){this.isScrollingVertical_=!0;this.scrollingEl_=b;this.isScrolling=!0;return}this.allowsHorizontalScroll(b,f)&&(this.isScrollingVertical_=!1,this.scrollingEl_=null,this.isScrolling=!0)}b!==c&&b.parentNode&&this.checkDOMTree(b.parentNode,c)}},scrollEnded:function(a){null!==this.scrollTimeoutEl_&&(a&&this.scrollTimeoutEl_.removeEventListener("scroll",this.scrollEndedProxy_,!1),this.fireEvent("UIEvents","scrollend",this.scrollTimeoutEl_,!1,!1),this.scrollTimeoutEl_=
null)},onTouchMove:function(b){var c=this.moved;this.moved=!0;d&&(this.cY=b.touches[0].pageY-this.dY,this.cX=b.touches[0].pageX-this.dX);this.isPanning_||(this.isScrolling&&(c||this.fireEvent("UIEvents","scrollstart",this.scrollingEl_,!1,!1),this.speedY=(this.lastY-b.touches[0].pageY)/(b.timeStamp-this.lastTimestamp),this.lastY=b.touches[0].pageY,this.lastX=b.touches[0].pageX,this.lastTimestamp=b.timeStamp),!a.os.blackberry10&&!this.requiresNativeTap&&(!this.isScrolling||!a.feat.nativeTouchScroll&&
!this.requiresNativeTap)&&b.preventDefault())},onTouchEnd:function(b){var c=this.moved;d&&(c=c&&!(10>Math.abs(this.cX)&&10>Math.abs(this.cY)));if(!a.os.ios||!this.requiresNativeTap)this.allowDocumentScroll_=!1;if(this.isPanning_&&c)this.wasPanning_=!0;else if(!c&&!this.requiresNativeTap){this.scrollerIsScrolling=!1;if(!this.trackingClick)return;b.preventDefault();if(!this.blockClicks&&!this.blockPossibleClick_){var c=b.target,f=b.changedTouches?b.changedTouches[0]:b.touches[0];3===c.nodeType&&(c=
c.parentNode);this.fireEvent("Event","click",c,!0,b.mouseToTouch,f[0]);this.lastTouchStartX=this.dX;this.lastTouchStartY=this.dY}}else c&&(this.isScrolling&&(this.scrollTimeoutEl_=this.scrollingEl_,0.01>Math.abs(this.speedY)?this.scrollEnded(!1):this.scrollTimeout_=setTimeout(this.scrollTimeoutExpireProxy_,30)),this.requiresNativeTap&&(this.isFocused_||a.trigger(this,"cancel-enter-edit",[b.target])));a.os.blackberry10&&(this.lastTouchStartX=this.dX,this.lastTouchStartY=this.dY);this.clearTouchVars()},
clearTouchVars:function(){this.speedY=this.lastY=this.cY=this.cX=this.dX=this.dY=0;this.trackingClick=this.blockPossibleClick_=this.requiresNativeTap=this.isScrollingVertical_=this.isScrolling=this.isPanning_=this.moved=!1},fireEvent:function(b,c,f,d,k,h){var l=document.createEvent(b);l.initEvent(c,d,!0);h&&a.each(h,function(a,b){l.key=b});k&&(l.mouseToTouch=!0);f.dispatchEvent(l)}}})(af);
(function(a){a.fn.popup=function(a){return new m(this[0],a)};var n=[],m=function(){var d=function(d,h){if(this.container="string"===typeof d||d instanceof String?document.getElementById(d):d)try{if("string"===typeof h||"number"===typeof h)h={message:h,cancelOnly:"true",cancelText:"OK"};this.id=h.id=h.id||a.uuid();this.addCssClass=h.addCssClass?h.addCssClass:"";this.suppressTitle=h.suppressTitle||this.suppressTitle;this.title=h.suppressTitle?"":h.title||"Alert";this.message=h.message||"";this.cancelText=
h.cancelText||"Cancel";this.cancelCallback=h.cancelCallback||function(){};this.cancelClass=h.cancelClass||"button";this.doneText=h.doneText||"Done";this.doneCallback=h.doneCallback||function(){};this.doneClass=h.doneClass||"button";this.cancelOnly=h.cancelOnly||!1;this.onShow=h.onShow||function(){};this.autoCloseDone=void 0!==h.autoCloseDone?h.autoCloseDone:!0;n.push(this);1===n.length&&this.show()}catch(b){console.log("error adding popup "+b)}else window.alert("Error finding container for popup "+
d)};d.prototype={id:null,addCssClass:null,title:null,message:null,cancelText:null,cancelCallback:null,cancelClass:null,doneText:null,doneCallback:null,doneClass:null,cancelOnly:!1,onShow:null,autoCloseDone:!0,suppressTitle:!1,show:function(){var d=this,h="<div id='"+this.id+"' class='afPopup hidden "+this.addCssClass+"'><header>"+this.title+"</header><div>"+this.message+"</div><footer><a href='javascript:;' class='"+this.cancelClass+"' id='cancel'>"+this.cancelText+"</a><a href='javascript:;' class='"+
this.doneClass+"' id='action'>"+this.doneText+"</a><div style='clear:both'></div></footer></div>";a(this.container).append(a(h));var b=a.query("#"+this.id);b.bind("close",function(){d.hide()});this.cancelOnly&&(b.find("A#action").hide(),b.find("A#cancel").addClass("center"));b.find("A").each(function(){var b=a(this);b.bind("click",function(a){"cancel"===b.attr("id")?(d.cancelCallback.call(d.cancelCallback,d),d.hide()):(d.doneCallback.call(d.doneCallback,d),d.autoCloseDone&&d.hide());a.preventDefault()})});
d.positionPopup();a.blockUI(0.5);b.bind("orientationchange",function(){d.positionPopup()});b.find("header").show();b.find("footer").show();setTimeout(function(){b.removeClass("hidden");d.onShow(d)},50)},hide:function(){var d=this;a.query("#"+d.id).addClass("hidden");a.unblockUI();!a.os.ie&&!a.os.android?setTimeout(function(){d.remove()},250):d.remove()},remove:function(){var d=a.query("#"+this.id);d.unbind("close");d.find("BUTTON#action").unbind("click");d.find("BUTTON#cancel").unbind("click");d.unbind("orientationchange").remove();
n.splice(0,1);0<n.length&&n[0].show()},positionPopup:function(){var d=a.query("#"+this.id);d.css("top",window.innerHeight/2.5+window.pageYOffset-d[0].clientHeight/2+"px");d.css("left",window.innerWidth/2-d[0].clientWidth/2+"px")}};return d}(),l=!1;a.blockUI=function(d){l||(d=d?" style='opacity:"+d+";'":"",a.query("BODY").prepend(a("<div id='mask'"+d+"></div>")),a.query("BODY DIV#mask").bind("touchstart",function(a){a.preventDefault()}),a.query("BODY DIV#mask").bind("touchmove",function(a){a.preventDefault()}),
l=!0)};a.unblockUI=function(){l=!1;a.query("BODY DIV#mask").unbind("touchstart");a.query("BODY DIV#mask").unbind("touchmove");a("BODY DIV#mask").remove()}})(af);
(function(a){var n=window.location.pathname+window.location.search,m=window.location.hash,l=m,d=function(){function b(){f.useOSThemes&&(a("#afui").removeClass("ios ios7 win8 tizen bb android light dark firefox"),a.os.android?a("#afui").addClass("android"):a.os.ie?a("#afui").addClass("win8"):a.os.blackberry||a.os.blackberry10||a.os.playbook?(a("#afui").addClass("bb"),f.backButtonText="Back"):a.os.ios7?a("#afui").addClass("ios7"):a.os.ios?a("#afui").addClass("ios"):a.os.tizen?a("#afui").addClass("tizen"):
a.os.fennec&&(a("#afui").addClass("firefox"),f.animateHeaders=!1));if(a.os.ios){a("head").find("#iosBlurrHack").remove();var b;b="-webkit-backface-visibility: hidden;-webkit-perspective:1000;";a("head").append("<style id='iosBlurrHack'>#afui .y-scroll > *, #afui .x-scroll > * {"+b+"}</style>")}else a.os.android&&!a.os.androidICS?f.transitionTime="150ms":a.os.fennec&&f.ready(function(){window.addEventListener("deviceorientation",function(){var b=numOnly(a("#header").css("height"))+numOnly(a("#navbar").css("height"));
a("#content").css("height",window.innerHeight-b)})});a.os.ios7&&a("#afui").hasClass("ios7")&&f.overlayStatusbar&&(f.ready(function(){a("#afui").addClass("overlayStatusbar")}),a(document.body).css("background","rgb(249,249,249)"))}var f=this;this.availableTransitions={};this.availableTransitions["default"]=this.availableTransitions.none=this.noTransition;if("function"===typeof define&&define.amd||"undefined"!==typeof module&&module.exports)f.autoLaunch=!1;var c=function(){var c=document.getElementById("afui");
if(null===c){c=document.createElement("div");c.id="afui";for(var g=document.body;g&&g.firstChild;)c.appendChild(g.firstChild);a(document.body).prepend(c)}f.isIntel="intel"in window&&window.intel&&window.intel.xdk&&"app"in window.intel.xdk;a.os.supportsTouch&&a.touchLayer(c);b()};if("complete"===document.readyState||"loaded"===document.readyState)if(c(),f.init)f.autoBoot();else a(window).one("afui:init",function(){f.autoBoot()});else a(document).ready(function(){c();if(f.init)f.autoBoot();else a(window).one("afui:init",
function(){f.autoBoot()})},!1);"intel"in window||(window.intel={xdk:{}},window.intel.xdk.webRoot="");window.addEventListener("popstate",function(){if(f.useInternalRouting){var a=f.getPanelId(document.location.hash);"#"!==document.location.href.replace(document.location.origin+"/","")&&(""===a&&1===f.history.length&&(a="#"+f.firstDiv.id),""!==a&&0!==af(a).filter(".panel").length&&a!=="#"+f.activeDiv.id&&f.goBack())}},!1)};d.prototype={init:!1,transitionTime:"230ms",showLoading:!0,loadingText:"Loading Content",
loadContentQueue:[],isIntel:!1,titlebar:"",navbar:"",header:"",viewportContainer:"",remotePages:{},history:[],homeDiv:"",screenWidth:"",content:"",modalWindow:"",customFooter:!1,defaultFooter:"",defaultHeader:null,customMenu:!1,customAside:!1,defaultAside:"",defaultMenu:"",_readyFunc:null,doingTransition:!1,passwordBox:a.passwordBox?new a.passwordBox:!1,selectBox:a.selectBox?a.selectBox:!1,ajaxUrl:"",transitionType:"slide",scrollingDivs:{},firstDiv:"",hasLaunched:!1,isLaunching:!1,launchCompleted:!1,
activeDiv:"",customClickHandler:"",menuAnimation:null,togglingSideMenu:!1,sideMenuWidth:"200px",handheldMinWidth:"768",trimBackButtonText:!0,useOSThemes:!0,overlayStatusbar:!1,lockPageBounce:!0,animateHeaders:!0,useAutoPressed:!0,horizontalScroll:!1,_currentHeaderID:"defaultHeader",useInternalRouting:!0,autoBoot:function(){this.hasLaunched=!0;var a=this;if(this.autoLaunch)if(this.isIntel){var f=function(){a.launch();document.removeEventListener("intel.xdk.device.ready",f)};document.addEventListener("intel.xdk.device.ready",
f)}else this.launch()},css3animate:function(b,f){b=a(b);return b.css3Animate(f)},dispatchPanelEvent:function(a,f){if("string"===typeof a&&window[a])return window[a](f);if(-1!==a.indexOf(".")){var c=window,e=a.split("."),g=e.length,d=0;for(d;d<g-1;d++)if(c=c[e[d]],void 0===c)return;return c[e[d]](f)}},enableTabBar:function(){a(document).on("click",".button-grouped.tabbed",function(b){var f=a(b.target);f.closest(".tabbed").find(".button").data("ignore-pressed","true").removeClass("pressed");f.closest(".button").addClass("pressed");
setTimeout(function(){f.closest(".button").addClass("pressed")})})},disableTabBar:function(){a(document).off("click",".button-grouped.tabbed");a(".button-grouped.tabbed .button").removeAttr("data-ignore-pressed")},setLeftSideMenuWidth:function(b){this.sideMenuWidth=b;b=(b+"").replace("px","")+"px";var f=numOnly(window.innerWidth)-numOnly(b);a("head").find("style#afui_sideMenuWidth").remove();b="@media handheld, only screen and (min-width: 768px) {#afui > #navbar.hasMenu.splitview, #afui > #header.hasMenu.splitview, #afui > #content.hasMenu.splitview  {    margin-left:"+
b+" !important;    width: "+f+"px !important;}}#afui #menu {width:"+b+"  !important}";a("head").append("<style id='afui_sideMenuWidth'>"+b+"</style>")},setSideMenuWidth:function(){this.setLeftSideMenuWidth.apply(this,arguments)},setRightSideMenuWidth:function(b){this.sideMenuWidth=b;b=(b+"").replace("px","")+"px";a("head").find("style#afui_asideMenuWidth").remove();a("head").append("<style id='afui_asideMenuWidth'>#afui #aside_menu {width:"+b+"  !important}</style>")},disableNativeScrolling:function(){a.feat.nativeTouchScroll=
!1},manageHistory:!0,loadDefaultHash:!0,useAjaxCacheBuster:!1,actionsheet:function(b){return a.query("#afui").actionsheet(b)},popup:function(b){return a.query("#afui").popup(b)},blockUI:function(b){a.blockUI(b)},unblockUI:function(){a.unblockUI()},removeFooterMenu:function(){a.query("#navbar").hide();this.showNavMenu=!1},showNavMenu:!0,autoLaunch:!0,showBackbutton:!0,showBackButton:!0,backButtonText:"",resetScrollers:!1,ready:function(b){if(this.launchCompleted)b();else a(document).one("afui:ready",
function(){b()})},setBackButtonStyle:function(b){a.query("#header .backButton").get(0).className=b},goBack:function(a){if(a=Math.min(Math.abs(~~a||1),this.history.length))a=this.history.splice(-a).shift(),this.loadContent(a.target+"",0,1,a.transition),this.transitionType=a.transition,this.updateHash(a.target)},clearHistory:function(){this.history=[];this.setBackButtonVisibility(!1)},pushHistory:function(b,f,c,e){this.history.push({target:b,transition:c});try{this.manageHistory&&(window.history.pushState(f,
f,n+"#"+f+e),a(window).trigger("hashchange",null,{newUrl:n+"#"+f+e,oldUrl:n+b}))}catch(g){}},updateHash:function(b){if(this.manageHistory){l=b=-1===b.indexOf("#")?"#"+b:b;var f=window.location.hash,c=this.getPanelId(b).substring(1);try{window.history.replaceState(c,c,n+b),a(window).trigger("hashchange",null,{newUrl:n+b,oldUrl:n+f})}catch(e){}}},getPanelId:function(a){var f=a.indexOf("/");return-1===f?a:a.substring(0,f)},updateBadge:function(b,f,c,e){void 0===c&&(c="");b=a(b);var g=b.find("span.af-badge");
0===g.length?("absolute"!==b.css("position")&&b.css("position","relative"),g=a.create("span",{className:"af-badge "+c,html:f}),b.append(g)):g.html(f);g.removeClass("tl bl br tr");g.addClass(c);void 0===e&&(e="red");a.isObject(e)?g.css(e):e&&g.css("background",e);g.data("ignore-pressed","true")},removeBadge:function(b){a(b).find("span.af-badge").remove()},toggleNavMenu:function(b){this.showNavMenu&&("none"!==a.query("#navbar").css("display")&&(void 0!==b&&!0!==b||void 0===b)?a.query("#navbar").hide():
(void 0===b||void 0!==b&&!0===b)&&a.query("#navbar").show())},toggleHeaderMenu:function(b){"none"!==a.query("#header").css("display")&&(void 0!==b&&!0!==b||void 0===b)?a.query("#header").hide():(void 0===b||void 0!==b&&!0===b)&&a.query("#header").show()},toggleAsideMenu:function(){this.toggleRightSideMenu.apply(this,arguments)},toggleRightSideMenu:function(a,f,c){if(this.isAsideMenuEnabled())return this.toggleLeftSideMenu(a,f,c,!0)},toggleLeftSideMenu:function(b,f,c,e){if(!(!this.isSideMenuEnabled()&&
!this.isAsideMenuEnabled()||this.togglingSideMenu))if(e||this.isSideMenuEnabled())if(e||!(a.ui.splitview&&window.innerWidth>=a.ui.handheldMinWidth)){var g=this,d=a.query("#menu"),h=a.query("#aside_menu"),k=a.query("#content,  #header, #navbar"),l=a.query(".afui_panel_mask");c=c||this.transitionTime;var m=this.isSideMenuOn(),n=e?"-"+numOnly(h.css("width")):numOnly(d.css("width"));0===l.length&&window.innerWidth<a.ui.handheldMinWidth&&(k.append("<div class='afui_panel_mask'></div>"),l=a.query(".afui_panel_mask"),
a(".afui_panel_mask").bind("click",function(){a.ui.toggleSideMenu(!1,null,null,e)}));var q=this.getSideMenuPosition();m&&!e&&0>q?m=!1:m&&(e&&0<q)&&(m=!1);if(2===b||!m&&(void 0!==b&&!1!==b||void 0===b))this.togglingSideMenu=!0,e?h.show():d.show(),g.css3animate(k,{x:n,time:c,complete:function(b){g.togglingSideMenu=!1;k.vendorCss("Transition","");f&&f(b);0!==l.length&&window.innerWidth<a.ui.handheldMinWidth&&l.show()}});else if(void 0===b||void 0!==b&&!1===b)this.togglingSideMenu=!0,g.css3animate(k,
{x:"0px",time:c,complete:function(b){k.vendorCss("Transition","");k.vendorCss("Transform","");g.togglingSideMenu=!1;f&&f(b);a.ui.splitview||d.hide();h.hide();0!==l.length&&window.innerWidth<a.ui.handheldMinWidth&&l.hide()}})}},toggleSideMenu:function(){this.toggleLeftSideMenu.apply(this,arguments)},disableSideMenu:function(){this.disableLeftSideMenu()},disableLeftSideMenu:function(){var b=a.query("#content, #header, #navbar");this.isSideMenuOn()?this.toggleSideMenu(!1,function(a){a||b.removeClass("hasMenu")}):
b.removeClass("hasMenu")},enableLeftSideMenu:function(){a.query("#content, #header, #navbar").addClass("hasMenu")},enableSideMenu:function(){return this.enableLeftSideMenu()},disableRightSideMenu:function(){var b=a.query("#content, #header, #navbar");this.isSideMenuOn()?this.toggleSideMenu(!1,function(a){a||b.removeClass("hasAside")}):b.removeClass("hasAside")},enableRightSideMenu:function(){a.query("#content, #header, #navbar").addClass("hasAside")},isSideMenuEnabled:function(){return a.query("#content").hasClass("hasMenu")},
isAsideMenuEnabled:function(){return a.query("#content").hasClass("hasAside")},isSideMenuOn:function(){var a=0!==this.getSideMenuPosition()?!0:!1;return(this.isSideMenuEnabled()||this.isAsideMenuEnabled)&&a},getSideMenuPosition:function(){return numOnly(parseFloat(a.getCssMatrix(a("#content")).e))},splitview:!0,disableSplitView:function(){a.query("#content, #header, #navbar, #menu").removeClass("splitview");this.splitview=!1},prevFooter:null,updateNavbarElements:function(b){if(this.prevFooter)if(this.prevFooter.data("parent")){var f=
this.scrollingDivs.hasOwnProperty(this.prevFooter.data("parent"));a.feat.nativeTouchScroll||a.os.desktop||!f?this.prevFooter.appendTo("#"+this.prevFooter.data("parent")):this.prevFooter.appendTo(a("#"+this.prevFooter.data("parent")).find(".afScrollPanel"))}else this.prevFooter.appendTo("#afui");a.is$(b)||(b=a.query("#"+b));a.query("#navbar").append(b);this.prevFooter=b;b=a.query("#navbar > footer > a:not(.button)");0<b.length&&(b.data("ignore-pressed","true").data("resetHistory","true"),f=parseFloat(100/
b.length),b.css("width",f+"%"));b=a.query("#navbar footer");if(0!==b.length){b=b.get(0).childNodes;for(f=0;f<b.length;f++)3===b[f].nodeType&&b[f].parentNode.removeChild(b[f])}},prevHeader:null,updateHeaderElements:function(b,f){var c=this;a.is$(b)||(b=a.query("#"+b));if(b!==this.prevHeader)if(this._currentHeaderID=b.prop("id"),this.prevHeader){var e=this.scrollingDivs.hasOwnProperty(this.prevHeader.data("parent"));a.query("#header").append(b);if(a.ui.animateHeaders){var g=f?"100px":"-100px",d=f?"-100px":
"100px";c.prevHeader.addClass("ignore");c.css3animate(b,{x:d,opacity:0.3,time:"1ms"});c.css3animate(c.prevHeader,{x:g,y:0,opacity:0.3,time:c.transitionTime,delay:numOnly(c.transitionTime)/5+"ms",complete:function(){c.prevHeader.data("parent")?a.feat.nativeTouchScroll||a.os.desktop||!e?c.prevHeader.appendTo("#"+c.prevHeader.data("parent")):c.prevHeader.appendTo(a("#"+c.prevHeader.data("parent")).find(".afScrollPanel")):c.prevHeader.appendTo("#afui");c.prevHeader.removeClass("ignore");c.css3animate(c.prevHeader,
{x:d,opacity:1,time:"1ms"});c.prevHeader=b}});c.css3animate(b,{x:"0px",opacity:1,time:c.transitionTime})}else c.prevHeader.data("parent")?a.feat.nativeTouchScroll||a.os.desktop||!e?this.prevHeader.appendTo("#"+this.prevHeader.data("parent")):this.prevHeader.appendTo(a("#"+this.prevHeader.data("parent")).find(".afScrollPanel")):c.prevHeader.appendTo("#afui"),c.prevHeader=b}else a.query("#header").append(b),this.prevHeader=b},previAsideMenu:null,updateAsideElements:function(){return this.updateRightSideMenuElements.apply(this,
arguments)},updateRightSideMenuElements:function(b){if(!(void 0===b||null===b)){var f=a.query("#aside_menu_scroller");this.prevAsideMenu&&(this.prevAsideMenu.insertBefore("#afui #aside_menu"),this.prevAsideMenu=null);a.is$(b)||(b=a.query("#"+b));a(b).attr("title")&&(a(b).prepend(a.create("header",{className:"header"}).append(a.create("h1",{html:a(b).attr("title")}).get(0))),a(b).removeAttr("title"));f.html("");f.append(b);this.prevAsideMenu=b;this.scrollingDivs.aside_menu_scroller.hideScrollbars();
this.scrollingDivs.aside_menu_scroller.scrollToTop()}},updateSideMenu:function(a){return this.updateSideMenuElements(a)},updateSideMenuElements:function(){return this.updateLeftSideMenuElements.apply(this,arguments)},updateLeftSideMenuElements:function(b){if(!(void 0===b||null===b)){var f=a.query("#menu_scroller");this.prevMenu&&(this.prevMenu.insertBefore("#afui #menu"),this.prevMenu=null);a.is$(b)||(b=a.query("#"+b));a(b).attr("title")&&(a(b).prepend(a.create("header",{className:"header"}).append(a.create("h1",
{html:a(b).attr("title")}).get(0))),a(b).removeAttr("title"));f.html("");f.append(b);this.prevMenu=b;this.scrollingDivs.menu_scroller.hideScrollbars();this.scrollingDivs.menu_scroller.scrollToTop()}},setTitle:function(b){"defaultHeader"===this._currentHeaderID&&a.query("#header header:not(.ignore)  #pageTitle").html(b)},setBackButtonText:function(b){"defaultHeader"===this._currentHeaderID&&(this.trimBackButtonText&&7<=b.length&&(b=b.substring(0,5)+"..."),0<this.backButtonText.length?a.query("#header header:not(.ignore) .backButton").html(this.backButtonText):
a.query("#header header:not(.ignore)  .backButton").html(b))},setBackButtonVisibility:function(b){b?a.query("#header .backButton").css("visibility","visible"):a.query("#header .backButton").css("visibility","hidden")},showMask:function(b){b||(b=this.loadingText||"");a.query("#afui_mask>h1").html(b);a.query("#afui_mask").show()},hideMask:function(){a.query("#afui_mask").hide()},modalReference_:null,showModal:function(b,f){this.modalTransition=f||"up";var c=a.query("#modalContainer");"string"===typeof b&&
(b="#"+b.replace("#",""));var e=a.query(b);this.modalReference_=e;var g=a.query("#afui_modal");if(e.length){var d=this.scrollingDivs.hasOwnProperty(e.attr("id")),h;a.feat.nativeTouchScroll||a.os.desktop||!d?(h=e.contents(),c.append(h)):(h=a(e.get(0).childNodes[0]).contents(),c.children().eq(0).append(h));this.runTransition(this.modalTransition,this.modalTransContainer,this.modalWindow,!1);a(this.modalWindow).css("display","");a(this.modalWindow).addClass("display","flexContainer");d?this.scrollingDivs.modal_container.enable(this.resetScrollers):
this.scrollingDivs.modal_container.disable();c.addClass("panel").show();"none"===e.data("header")?g.find("#modalHeader").hide():0<h.filter("header").length?g.find("#modalHeader").append(h.filter("header")).show():g.find("#modalHeader").append(a.create("header",{}).append(a.create("h1",{html:e.data("title")}).get(0)).append(a.create("a",{className:"button icon close"}).attr("onclick","$.ui.hideModal()").get(0))).show();if("none"===e.data("footer"))g.find("#modalFooter").hide();else if(0<h.filter("footer").length){g.find("#modalFooter").append(h.filter("footer")).show();
g=a.query("#modalFooter > footer > a:not(.button)");0<g.length&&(d=parseFloat(100/g.length),g.css("width",d+"%"));g=a.query("#modalFooter footer");if(0===g.length)return;g=g.get(0).childNodes;for(d=0;d<g.length;d++)3===g[d].nodeType&&g[d].parentNode.removeChild(g[d])}else g.find("#modalFooter").hide();this.scrollToTop("modal");c.data("panel",b);c=e.get(0);(g=c.getAttribute("data-load"))&&this.dispatchPanelEvent(g,c);e.trigger("loadpanel")}},hideModal:function(){var b=this,f=a.query("#modalContainer"),
c=this.scrollingDivs.hasOwnProperty(this.modalReference_.attr("id"));this.runTransition(b.modalTransition,b.modalWindow,b.modalTransContainer,!0);this.scrollingDivs.modal_container.disable();var e=a.query(f.data("panel")),g=e.data("unload");g&&this.dispatchPanelEvent(g,e.get(0));e.trigger("unloadpanel");setTimeout(function(){a.feat.nativeTouchScroll||a.os.desktop||!c?(b.modalReference_.append(a("#modalHeader header")),b.modalReference_.append(f.contents()),b.modalReference_.append(a("#modalFooter footer"))):
(b.modalReference_.children().eq(0).append(a("#modalHeader header")),a(b.modalReference_.get(0).childNodes[0]).append(f.children().eq(0).contents()),b.modalReference_.children().eq(0).append(a("#modalFooter footer")))},this.transitionTime)},updatePanel:function(b,f){b="#"+b.replace("#","");var c=a.query(b).get(0);if(c){var e=a.create("div",{html:f}),e=e.children(".panel")&&0<e.children(".panel").length?e.children(".panel").get(0):e.get(0);if(c.getAttribute("js-scrolling")&&("yes"===c.getAttribute("js-scrolling").toLowerCase()||
"true"===c.getAttribute("js-scrolling").toLowerCase()))a.cleanUpContent(c.childNodes[0],!1,!0),a(c.childNodes[0]).html(f);else{a.cleanUpContent(c,!1,!0);a(c).html(f);var g=this.scrollingDivs[c.id];g&&g.refresh&&g.addPullToRefresh()}e.getAttribute("data-title")&&c.setAttribute("data-title",e.getAttribute("data-title"))}},updateContentDiv:function(a,f){return this.updatePanel(a,f)},addContentDiv:function(b,f,c,e,g){var d;"string"===typeof b?(-1===b.lastIndexOf("#",1)&&(b="#"+b),d=a.query(b).get(0)):
(d=a.is$(b)?b.get(0):b,b=d.id);d?f=d:(f=a.create("div",{html:f}),f=f.children(".panel")&&0<f.children(".panel").length?f.children(".panel").get(0):f.get(0),!f.getAttribute("data-title")&&c&&f.setAttribute("data-title",c),c=f.id?f.id:b.replace("#",""),f.id=c,f.id!==b&&f.setAttribute("data-crc",b.replace("#","")));f.className="panel";c=f.id;this.addDivAndScroll(f,e,g);return c},addDivAndScroll:function(b,f,c,e){var g=!1,d,h=b.style.overflow,h="hidden"!==h&&"visible"!==h;e=e||this.content;!a.feat.nativeTouchScroll&&
(h&&!a.os.desktop)&&b.setAttribute("js-scrolling","true");if(b.getAttribute("js-scrolling")&&("yes"===b.getAttribute("js-scrolling").toLowerCase()||"true"===b.getAttribute("js-scrolling").toLowerCase()))h=g=!0;d=b.getAttribute("data-title")||b.title;b.title="";b.setAttribute("data-title",d);if(a(b).hasClass("no-scroll")||b.getAttribute("scrolling")&&"no"===b.getAttribute("scrolling"))g=h=!1,b.removeAttribute("js-scrolling");g?(d=b,e.appendChild(b),!1!==this.selectBox&&this.selectBox.getOldSelects(d.id),
!1!==this.passwordBox&&this.passwordBox.getOldPasswords(d.id)):(e.appendChild(b),d=b,b.style["-webkit-overflow-scrolling"]="none");h&&(this.scrollingDivs[d.id]=a(b).scroller({scrollBars:!0,verticalScroll:!0,horizontalScroll:this.horizontalScroll,vScrollCSS:"afScrollbar",refresh:f,useJsScroll:g,lockBounce:this.lockPageBounce,autoEnable:!1}),a(b).addClass("y-scroll"),this.horizontalScroll&&a(b).addClass("x-scroll"),c&&a.bind(this.scrollingDivs[d.id],"refresh-release",function(a){a&&c()}),g&&a(b).children().eq(0).addClass("afScrollPanel"));
return d.id},scrollToTop:function(a,f){f=f||"300ms";a=a.replace("#","");this.scrollingDivs[a]&&this.scrollingDivs[a].scrollToTop(f)},scrollToBottom:function(a,f){a=a.replace("#","");this.scrollingDivs[a]&&this.scrollingDivs[a].scrollToBottom(f)},parsePanelFunctions:function(b,f,c){var e=b.getAttribute("data-footer"),d=b.getAttribute("data-header");e&&"none"===e.toLowerCase()?(this.toggleNavMenu(!1),e=!1):this.toggleNavMenu(!0);e&&this.customFooter!==e?(this.customFooter=e,this.updateNavbarElements(e)):
e!==this.customFooter&&(this.customFooter&&this.updateNavbarElements(this.defaultFooter),this.customFooter=!1);d&&"none"===d.toLowerCase()?(this.toggleHeaderMenu(!1),d=!1):this.toggleHeaderMenu(!0);d&&this.customHeader!==d?(this.customHeader=d,this.updateHeaderElements(d,c)):d!==this.customHeader&&(this.customHeader&&this.updateHeaderElements(this.defaultHeader,c),this.customHeader=!1);e=a(b).find("footer");0<e.length&&(this.customFooter=b.id,e.data("parent",b.id),this.updateNavbarElements(e));e=
a(b).find("header");0<e.length&&(this.customHeader=b.id,e.data("parent",b.id),this.updateHeaderElements(e,c));b.getAttribute("data-tab")&&(a.query("#navbar>footer>a:not(.button)").removeClass("pressed"),a.query("#navbar #"+b.getAttribute("data-tab")).addClass("pressed"));(c=b.getAttribute("data-left-menu")||b.getAttribute("data-nav"))&&this.customMenu!==c?(this.customMenu=c,this.updateSideMenuElements(c)):c!==this.customMenu&&(this.customMenu&&this.updateSideMenuElements(this.defaultMenu),this.customMenu=
!1);(c=b.getAttribute("data-right-menu")||b.getAttribute("data-aside"))&&this.customAside!==c?(this.customAside=c,this.updateAsideElements(c)):c!==this.customAside&&(this.customAside&&this.updateAsideElements(this.defaultAside),this.customAside=!1);f&&((c=f.getAttribute("data-unload"))&&this.dispatchPanelEvent(c,f),a(f).trigger("unloadpanel"));(c=b.getAttribute("data-load"))&&this.dispatchPanelEvent(c,b);a(b).trigger("loadpanel");this.isSideMenuOn()&&this.toggleSideMenu(!1)},parseScriptTags:function(b){b&&
a.fn&&"appframework"===a.fn.namespace&&a.parseJS(b)},loadContent:function(b,f,c,e,d){if(this.doingTransition)this.loadContentQueue.push([b,f,c,e,d]);else if(0!==b.length){var k=!0;d=d||document.createElement("a");if(-1===b.indexOf("#")){var l="url"+h(b),m=a.query("div.panel[data-crc='"+l+"']");0<a.query("#"+b).length?k=!1:0<m.length?(k=!1,"true"===d.getAttribute("data-refresh-ajax")||d.refresh&&!0===d.refresh||this.isAjaxApp?k=!0:b="#"+m.get(0).id):0<a.query("#"+l).length&&(k=!1,"true"===d.getAttribute("data-refresh-ajax")||
d.refresh&&!0===d.refresh||this.isAjaxApp?k=!0:b="#"+l)}-1===b.indexOf("#")&&k?this.loadAjax(b,f,c,e,d):this.loadDiv(b,f,c,e)}},loadDiv:function(b,f,c,e){var d=this,h=b.replace("#",""),k=h.indexOf("/"),m="";-1!==k&&(m=h.substr(k),h=h.substr(0,k));if(h=a.query("#"+h).get(0))if(h===this.activeDiv&&!c)this.isSideMenuOn()&&this.toggleSideMenu(!1);else{this.transitionType=e;var n=this.activeDiv;b=h;if("true"===h.getAttribute("data-modal")||"true"===h.getAttribute("modal"))return this.showModal(h.id);n!==
b&&(f?(this.clearHistory(),this.pushHistory("#"+this.firstDiv.id,h.id,e,m)):c||this.pushHistory(l,h.id,e,m),l="#"+h.id+m,this.doingTransition=!0,n.style.display="block",b.style.display="block",this.runTransition(e,n,b,c),this.parsePanelFunctions(h,n,c),this.loadContentData(h,f,c,e),a.feat.nativeTouchScroll?setTimeout(function(){d.scrollingDivs[n.id]&&d.scrollingDivs[n.id].disable()},numOnly(d.transitionTime)+50):"undefined"!==typeof d.scrollingDivs[n.id]&&d.scrollingDivs[n.id].disable())}else a(document).trigger("missingpanel",
null,{missingTarget:b})},loadContentData:function(b,f,c){var e;c?0<this.history.length&&(c=this.history[this.history.length-1],e=c.target.indexOf("/"),c=-1!==e?c.target.substr(0,e):c.target,(c=a.query(c).get(0))?this.setBackButtonText(c.getAttribute("data-title")):this.setBackButtonText("Back")):this.activeDiv.getAttribute("data-title")?this.setBackButtonText(this.activeDiv.getAttribute("data-title")):this.setBackButtonText("Back");b.getAttribute("data-title")&&this.setTitle(b.getAttribute("data-title"));
f&&(this.setBackButtonText(this.firstDiv.getAttribute("data-title")),b===this.firstDiv&&(this.history.length=0));a("#header #menubadge").css("float","right");0===this.history.length?(this.setBackButtonVisibility(!1),this.history=[],a("#header #menubadge").css("float","left")):this.setBackButtonVisibility(this.showBackButton&&this.showBackbutton);this.activeDiv=b;this.scrollingDivs[this.activeDiv.id]&&this.scrollingDivs[this.activeDiv.id].enable(this.resetScrollers)},loadAjax:function(b,f,c,e,d){if(!("afui_ajax"===
this.activeDiv.id&&b===this.ajaxUrl)){var k="url"+h(b),l=this;-1===b.indexOf("http")&&(b=intel.xdk.webRoot+b);var m=new XMLHttpRequest;d&&"object"!==typeof d&&(d=document.createElement("a"),d.setAttribute("data-persist-ajax",!0));d=d||document.createElement("a");m.onreadystatechange=function(){if(4===m.readyState&&200===m.status){this.doingTransition=!1;var h,n=!1;h=a.query("#"+k);if(0<h.length)l.updatePanel(k,m.responseText),h.get(0).setAttribute("data-title",d.title?d.title:b);else if(d.getAttribute("data-persist-ajax")||
l.isAjaxApp){var q="true"===d.getAttribute("data-pull-scroller")?!0:!1;h=q?function(){d.refresh=!0;l.loadContent(b,f,c,e,d);d.refresh=!1}:null;var r=a(m.responseText);r.hasClass("panel")?(k=r.attr("id"),r=r.get(0).innerHTML):r=r.html();0<a("#"+k).length?l.updatePanel("#"+k,r):0<a("div.panel[data-crc='"+k+"']").length?(l.updatePanel(a("div.panel[data-crc='"+k+"']").get(0).id,r),k=a("div.panel[data-crc='"+k+"']").get(0).id):k=l.addContentDiv(k,m.responseText,d.title?d.title:b,q,h)}else l.updatePanel("afui_ajax",
m.responseText),a.query("#afui_ajax").attr("data-title",d.title?d.title:b),l.loadContent("#afui_ajax",f,c,e),n=!0;h=document.createElement("div");a(h).html(m.responseText);l.parseScriptTags(h);if(n)l.showLoading&&l.hideMask();else return l.loadContent("#"+k,f,c,e),l.showLoading&&l.hideMask(),null}else 4===m.readyState&&a.ui.hideMask()};this.ajaxUrl=b;var n=this.useAjaxCacheBuster?b+(b.split("?")[1]?"&":"?")+"cache="+1E16*Math.random():b;m.open("GET",n,!0);m.setRequestHeader("X-Requested-With","XMLHttpRequest");
m.send();this.showLoading&&this.showMask()}},runTransition:function(a,f,c,e){this.availableTransitions[a]||(a="default");"none"===f.style.display&&(f.style.display="block");"none"===c.style.display&&(c.style.display="block");this.availableTransitions[a].call(this,f,c,e)},launch:function(){if(!1===this.hasLaunched||this.launchCompleted)this.hasLaunched=!0;else{if(this.isLaunching)return!0;this.isLaunching=!0;var b=this;this.viewportContainer=af.query("#afui");this.navbar=af.query("#navbar").get(0);
this.content=af.query("#content").get(0);this.header=af.query("#header").get(0);this.menu=af.query("#menu").get(0);this.viewportContainer.on("click","a",function(a){b.useInternalRouting&&k(a,a.currentTarget)});var f=null;a.bind(a.touchLayer,"enter-edit",function(a){f=a});a.os.android&&!a.os.androidICS&&(a.bind(a.touchLayer,"enter-edit-reshape",function(){var c=a(f),d=c.closest(b.activeDiv);if(d&&0<d.size()){var e=c.offset(),d=d.offset();e.bottom>d.bottom&&e.height<d.height&&b.scrollingDivs[b.activeDiv.id].scrollToItem(c,
"bottom")}}),a.bind(a.touchLayer,"exit-edit-reshape",function(){b.activeDiv&&(b.activeDiv.id&&b.scrollingDivs.hasOwnProperty(b.activeDiv.id))&&b.scrollingDivs[b.activeDiv.id].setPaddings(0,0)}));this.navbar||(this.navbar=a.create("div",{id:"navbar"}).get(0),this.viewportContainer.append(this.navbar));this.header||(this.header=a.create("div",{id:"header"}).get(0),this.viewportContainer.prepend(this.header));this.content||(this.content=a.create("div",{id:"content"}).get(0),a(this.content).insertAfter(this.header));
this.menu||(this.menu=a.create("div",{id:"menu",html:"<div id='menu_scroller'></div>"}).get(0),this.viewportContainer.append(this.menu),this.menu.style.overflow="hidden",this.scrollingDivs.menu_scroller=a.query("#menu_scroller").scroller({scrollBars:!0,verticalScroll:!0,vScrollCSS:"afScrollbar",useJsScroll:!a.feat.nativeTouchScroll,autoEnable:!0,lockBounce:this.lockPageBounce,hasParent:!0}),a.feat.nativeTouchScroll&&a.query("#menu_scroller").css("height","100%"),this.asideMenu=a.create("div",{id:"aside_menu",
html:"<div id='aside_menu_scroller'></div>"}).get(0),this.viewportContainer.append(this.asideMenu),this.asideMenu.style.overflow="hidden",this.scrollingDivs.aside_menu_scroller=a.query("#aside_menu_scroller").scroller({scrollBars:!0,verticalScroll:!0,vScrollCSS:"afScrollbar",useJsScroll:!a.feat.nativeTouchScroll,autoEnable:!0,lockBounce:this.lockPageBounce,hasParent:!0}),a.feat.nativeTouchScroll&&a.query("#aside_menu_scroller").css("height","100%"));a(this.header).html("<a class='backButton button'></a> <h1 id='pageTitle'></h1>"+
this.header.innerHTML);this.backButton=a.query("#header .backButton").css("visibility","hidden");a(document).on("click","#header .backButton",function(a){a.preventDefault();b.goBack()});this.titlebar=a.query("#header #pageTitle").get(0);this.addContentDiv("afui_ajax","");var c=a.create("div",{id:"afui_mask",className:"ui-loader",html:"<span class='ui-icon ui-icon-loading spin'></span><h1>Loading Content</h1>"}).css({"z-index":2E4,display:"none"});document.body.appendChild(c.get(0));c=a.create("div",
{id:"afui_modal"}).get(0);a(c).hide();c.appendChild(a.create("div",{id:"modalHeader",className:"header"}).get(0));c.appendChild(a.create("div",{id:"modalContainer"}).get(0));c.appendChild(a.create("div",{id:"modalFooter",className:"footer"}).get(0));this.modalTransContainer=a.create("div",{id:"modalTransContainer"}).appendTo(c).get(0);this.viewportContainer.append(c);this.scrollingDivs.modal_container=a.query("#modalContainer").scroller({scrollBars:!0,vertical:!0,vScrollCSS:"afScrollbar",lockBounce:this.lockPageBounce});
this.modalWindow=c;for(var e={},c=this.viewportContainer.get(0).querySelectorAll(".panel"),d=0;d<c.length;d++){var h=c[d],n=h,v=h.previousSibling;h.parentNode&&"content"!==h.parentNode.id?(n.getAttribute("selected")&&(this.firstDiv=h),this.addDivAndScroll(n),a.query("#content").append(h)):h.parsedContent||(h.parsedContent=1,n.getAttribute("selected")&&(this.firstDiv=h),this.addDivAndScroll(h),a(h).insertAfter(v));h.getAttribute("data-defer")&&(e[h.id]=h.getAttribute("data-defer"));this.firstDiv||
(this.firstDiv=h);h=null}var c=null,s=!1,u=Object.keys(e).length,c=function(c){a.ajax({url:intel.xdk.webRoot+e[c],success:function(d){0<d.length&&(b.updatePanel(c,d),b.parseScriptTags(a.query("#"+c).get(0)));t++;t>=u&&(s=!1,a(document).trigger("defer:loaded"))},error:function(){console.log("Error with deferred load "+intel.xdk.webRoot+e[c]);t++;t>=u&&(s=!1,a(document).trigger("defer:loaded"))}})};if(0<u){var s=!0,t=0,q;for(q in e)c(q)}if(this.firstDiv)if(this.activeDiv=this.firstDiv,this.scrollingDivs[this.activeDiv.id]&&
this.scrollingDivs[this.activeDiv.id].enable(),q=function(){a.query("#navbar").append(a.create("footer",{id:"defaultNav"}).append(a.query("#navbar").children()));b.defaultFooter="defaultNav";b.prevFooter=a.query("#defaultNav");b.updateNavbarElements(b.prevFooter);var c=a.query("nav").get(0);c&&(b.defaultMenu=a(c),b.updateSideMenuElements(b.defaultMenu),b.prevMenu=b.defaultMenu);if(c=a.query("aside").get(0))b.defaultAside=a(c),b.updateAsideElements(b.defaultAside),b.prevAsideMenu=b.defaultAside;b.defaultHeader=
"defaultHeader";a.query("#header").append(a.create("header",{id:"defaultHeader"}).append(a.query("#header").children()));b.prevHeader=a.query("#defaultHeader");a.query("#header").addClass("header");a.query("#navbar").addClass("footer");a.query("#navbar").on("click","footer>a:not(.button)",function(b){a.query("#navbar>footer>a").not(b.currentTarget).removeClass("pressed");a(b.currentTarget).addClass("pressed")});0<a.query("nav").length&&(c=b.splitview?" splitview":"",a.query("#afui #header").addClass("hasMenu"+
c),a.query("#afui #content").addClass("hasMenu"+c),a.query("#afui #navbar").addClass("hasMenu"+c),a.query("#afui #menu").addClass("hasMenu"+c),a.query("#afui #aside_menu").addClass(c));0<a.query("aside").length&&a.query("#afui #header, #afui #content, #afui #navbar").addClass("hasAside");a.query("#afui #menu").addClass("tabletMenu");a.ui.splitview&&window.innerWidth>parseInt(a.ui.handheldMinWidth,10)&&(a.ui.sideMenuWidth=a("#menu").css("width")+"px");var c=b.getPanelId(m),d=null!==c&&c==="#"+b.firstDiv.id;
0<c.length&&b.loadDefaultHash&&!d?b.loadContent(m,!0,!1,"none"):(l="#"+b.firstDiv.id,b.firstDiv.style.display="block",b.parsePanelFunctions(b.firstDiv),b.loadContentData(b.firstDiv),a.query("#header .backButton").css("visibility","hidden"),("true"===b.firstDiv.getAttribute("data-modal")||"true"===b.firstDiv.getAttribute("modal"))&&b.showModal(b.firstDiv.id));b.launchCompleted=!0;a.query("#afui #splashscreen").remove();a.os.fennec?a(document).trigger("afui:ready"):setTimeout(function(){a(document).trigger("afui:ready")})},
s)a(document).one("defer:loaded",q);else q();else setTimeout(function(){a(document).trigger("afui:ready")});a.bind(b,"content-loaded",function(){if(0<b.loadContentQueue.length){var a=b.loadContentQueue.splice(0,1)[0];b.loadContent(a[0],a[1],a[2],a[3],a[4])}});(window.navigator.standalone||this.isIntel)&&this.blockPageScroll();this.enableTabBar();this.topClickScroll()}},topClickScroll:function(){var a=this;document.getElementById("header").addEventListener("click",function(d){15>=d.clientY&&"h1"===
d.target.nodeName.toLowerCase()&&a.scrollingDivs[a.activeDiv.id].scrollToTop("100")})},blockPageScroll:function(){a.query("#afui #header").bind("touchmove",function(a){a.preventDefault()})},noTransition:function(a,d){d.style.display="block";a.style.display="block";this.clearAnimations(d);this.css3animate(a,{x:"0%",y:0});this.finishTransition(a);d.style.zIndex=2;a.style.zIndex=1},finishTransition:function(b,d){b.style.display="none";this.doingTransition=!1;b&&a(b).trigger("unloadpanelcomplete");d&&
a(d).trigger("loadpanelcomplete");d&&this.clearAnimations(d);b&&this.clearAnimations(b);a.trigger(this,"content-loaded")},clearAnimations:function(b){b.style[a.feat.cssPrefix+"Transform"]="none";b.style[a.feat.cssPrefix+"Transition"]="none"}};var k=function(b,d){var c=document.getElementById("afui");if(d!==c){if("a"!==d.tagName.toLowerCase()&&d.parentNode)return k(b,d.parentNode);if("undefined"!==d.tagName&&"a"===d.tagName.toLowerCase()){if(!1!==("function"===typeof a.ui.customClickHandler?a.ui.customClickHandler:
!1)&&a.ui.customClickHandler(d,b))return b.preventDefault();if(!(-1!==d.href.toLowerCase().indexOf("javascript:")||d.getAttribute("data-ignore")))if(-1===d.hash.indexOf("#")&&0<d.target.length)0!==d.href.toLowerCase().indexOf("javascript:")&&(a.ui.isIntel?(b.preventDefault(),intel.xdk.device.launchExternal(d.href)):a.os.desktop||(b.target.target="_blank"));else{var c=d.href,e=location.protocol+"//"+location.hostname+":"+location.port+location.pathname;0===c.indexOf(e)&&(c=c.substring(e.length));if("#"===
c||c.indexOf("#")===c.length-1||0===c.length&&0===d.hash.length)return b.preventDefault();e=/^((http|https|file):\/\/)/;-1!==d.href.indexOf(":")&&e.test(d.href)&&b.preventDefault();var e=d.getAttribute("data-transition"),g=d.getAttribute("data-resetHistory"),g=g&&"true"===g.toLowerCase()?!0:!1,c=0<d.hash.length?d.hash:c;a.ui.loadContent(c,g,0,e,d)}}}},h=function(a,d){void 0===d&&(d=0);var c=0,c=0;d^=-1;for(var e=0,g=a.length;e<g;e++)c=(d^a.charCodeAt(e))&255,c="0x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substr(9*
c,8),d=d>>>8^c;return(d^-1)>>>0};a.ui=new d;a.ui.init=!0;a(window).trigger("afui:preinit");a(window).trigger("afui:init")})(af);
(function(a){var n=function(){a.ui.isIntel=!0;setTimeout(function(){document.getElementById("afui").style.height="100%";document.body.style.height="100%";document.documentElement.style.minHeight=window.innerHeight},30);document.removeEventListener("intel.xdk.device.ready",n)};document.addEventListener("intel.xdk.device.ready",n);a.feat.nativeTouchScroll&&document.addEventListener("orientationchange",function(){if(a.ui.scrollingDivs[a.ui.activeDiv.id]){var m=a.ui.scrollingDivs[a.ui.activeDiv.id];m&&
(0===m.el.scrollTop&&(m.disable(),setTimeout(function(){m.enable()},300)),m.refresh&&m.updateP2rHackPosition())}})})(af);
(function(a){a.availableTransitions.fade=function(n,m,l){var d=this;l?(m.style.zIndex=1,n.style.zIndex=2,d.clearAnimations(m),d.css3animate(n,{x:"0%",time:a.transitionTime,opacity:0.1,complete:function(a){a?d.finishTransition(n,m):(d.css3animate(n,{x:"-100%",opacity:1,complete:function(){d.finishTransition(n)}}),m.style.zIndex=2,n.style.zIndex=1)}})):(n.style.zIndex=1,m.style.zIndex=2,m.style.opacity=0,d.css3animate(m,{x:"0%",opacity:0.1,complete:function(){d.css3animate(m,{x:"0%",time:a.transitionTime,
opacity:1,complete:function(a){a?d.finishTransition(n,m):(d.clearAnimations(m),d.css3animate(n,{x:"-100%",y:0,complete:function(){d.finishTransition(n)}}))}})}}))}})(af.ui);
(function(a){a.availableTransitions.flip=function(n,m,l){var d=this;l||(n.style.zIndex=1,m.style.zIndex=2);d.css3animate(m,{x:"100%",scale:0.8,rotateY:"180deg",complete:function(){d.css3animate(m,{x:"0%",scale:1,time:a.transitionTime,rotateY:"0deg",complete:function(){d.clearAnimations(m)}})}});d.css3animate(n,{x:"100%",time:a.transitionTime,scale:0.8,rotateY:"180deg",complete:function(){d.css3animate(n,{x:"-100%",opacity:1,scale:1,rotateY:"0deg",complete:function(){d.finishTransition(n)}});m.style.zIndex=
2;n.style.zIndex=1}})}})(af.ui);
(function(a){a.availableTransitions.pop=function(n,m,l){var d=this;l?(m.style.zIndex=1,n.style.zIndex=2,d.clearAnimations(m),d.css3animate(n,{x:"0%",time:a.transitionTime,opacity:0.1,scale:0.2,origin:"50% 50%",complete:function(a){a?d.finishTransition(n):(d.css3animate(n,{x:"-100%",opacity:1,complete:function(){d.finishTransition(n)}}),m.style.zIndex=2,n.style.zIndex=1)}})):(n.style.zIndex=1,m.style.zIndex=2,d.css3animate(m,{x:"0%",scale:0.2,origin:"50% 50%",opacity:0.1,time:"0ms",complete:function(){d.css3animate(m,
{x:"0%",time:a.transitionTime,scale:1,opacity:1,origin:"0% 0%",complete:function(a){a?d.finishTransition(n,m):(d.clearAnimations(m),d.css3animate(n,{x:"100%",y:0,complete:function(){d.finishTransition(n)}}))}})}}))}})(af.ui);
(function(a){function n(m,l,d){var k=this;d?k.css3animate(m,{x:"0%",y:"0%",complete:function(){k.css3animate(m,{x:"100%",time:a.transitionTime,complete:function(){k.finishTransition(m,l)}}).link(l,{x:"0%",time:a.transitionTime})}}).link(l,{x:"-100%",y:"0%"}):k.css3animate(m,{x:"0%",y:"0%",complete:function(){k.css3animate(m,{x:"-100%",time:a.transitionTime,complete:function(){k.finishTransition(m,l)}}).link(l,{x:"0%",time:a.transitionTime})}}).link(l,{x:"100%",y:"0%"})}a.availableTransitions.slide=
n;a.availableTransitions["default"]=n})(af.ui);(function(a){a.availableTransitions.down=function(n,m,l){var d=this;l?(n.style.zIndex=2,m.style.zIndex=1,d.css3animate(n,{y:"0%",x:"0%",complete:function(){d.css3animate(n,{y:"-100%",time:a.transitionTime,complete:function(){d.finishTransition(n,m)}})}})):(n.style.zIndex=1,m.style.zIndex=2,d.css3animate(m,{y:"-100%",x:"0%",time:"10ms",complete:function(){d.css3animate(m,{y:"0%",time:a.transitionTime,complete:function(){d.finishTransition(n,m)}})}}))}})(af.ui);
(function(a){a.availableTransitions.up=function(n,m,l){var d=this;l?(n.style.zIndex=2,m.style.zIndex=1,d.css3animate(n,{y:"0%",x:"0%",complete:function(){d.css3animate(n,{y:"100%",time:a.transitionTime,complete:function(){d.finishTransition(n,m)}})}})):(n.style.zIndex=1,m.style.zIndex=2,d.css3animate(m,{y:"100%",x:"0%",time:"10ms",complete:function(){d.css3animate(m,{y:"0%",time:a.transitionTime,complete:function(){d.finishTransition(n,m)}})}}))}})(af.ui);
(function(a){function n(){a.ui.isWin8=!0;a.os.ie&&a.ui.isSideMenuEnabled()&&a.ui.ready(function(){if(!a.ui.tilesLoaded){a.ui.tilesLoaded=!0;if(window.innerWidth>a.ui.handheldMinWidth)return!0;a.ui.slideSideMenu&&(a.ui.slideSideMenu=!1);a.query("#afui #navbar footer").append("<a id='metroMenu' onclick='$.ui.toggleSideMenu()'>\u2022\u2022\u2022</a>");var m=a.query("#afui #navbar").find("a").not(".button");if(0<m.length){m.data("ignore-pressed","true").data("resetHistory","true");var l=parseFloat(100/
m.length);m.css("width",l+"%")}var d=a.ui.updateNavbarElements;a.ui.updateNavbarElements=function(){d.apply(a.ui,arguments);1!==a.query("#afui #navbar #metroMenu").length&&a.query("#afui #navbar footer").append("<a id='metroMenu' onclick='$.ui.toggleSideMenu()'>\u2022\u2022\u2022</a>")};a.ui.isSideMenuOn=function(){var d=0>parseInt(a.getCssMatrix(a("#navbar")).f,10)?!0:!1;return this.isSideMenuEnabled()&&d};a.ui.toggleRightSideMenu=function(d,h,b){if(this.isAsideMenuEnabled()&&!this.togglingAsideMenu){var f=
this,c=a("#menu"),e=a.query("#aside_menu"),g=a.query("#content,  #header, #navbar"),l=a.query(".afui_panel_mask");b=b||this.transitionTime;var m="block"===a("#aside_menu").css("display"),n="-"+f.sideMenuWidth;0===l.length&&window.innerWidth<a.ui.handheldMinWidth&&(g.append("<div class='afui_panel_mask'></div>"),l=a.query(".afui_panel_mask"),a(".afui_panel_mask").bind("click",function(){a.ui.toggleSideMenu(!1,null,null,!0)}));var s=this.getSideMenuPosition();m&&0<s&&(m=!1);if(2===d||!m&&(void 0!==
d&&!1!==d||void 0===d))this.togglingSideMenu=!0,e.show(),f.css3animate(g,{x:n,time:b,complete:function(b){f.togglingSideMenu=!1;g.vendorCss("Transition","");h&&h(b);0!==l.length&&window.innerWidth<a.ui.handheldMinWidth&&l.show()}});else if(void 0===d||void 0!==d&&!1===d)this.togglingSideMenu=!0,f.css3animate(g,{x:"0px",time:b,complete:function(b){g.vendorCss("Transition","");g.vendorCss("Transform","");f.togglingSideMenu=!1;h&&h(b);a.ui.splitview||c.hide();e.hide();0!==l.length&&window.innerWidth<
a.ui.handheldMinWidth&&l.hide()}})}};a.ui.toggleLeftSideMenu=function(d,h){if(this.isSideMenuEnabled()&&!this.togglingSideMenu){this.togglingSideMenu=!0;var b=this,f=a.query("#menu"),c=a.query("#navbar"),e=this.isSideMenuOn();if(2===d||!e&&(void 0!==d&&!1!==d||void 0===d))f.show(),b.css3animate(c,{y:"-150px",time:a.ui.transitionTime,complete:function(){b.togglingSideMenu=!1;h&&h(!0)}}),b.css3animate(f,{y:"0px",time:a.ui.transitionTime});else if(void 0===d||void 0!==d&&!1===d)b.css3animate(c,{y:"0",
time:a.ui.transitionTime,complete:function(){b.togglingSideMenu=!1;h&&h(!0);f.hide()}}),b.css3animate(f,{y:"150px",time:a.ui.transitionTime})}}}})}if(!a)throw"This plugin requires AFUi";a.ui?a.ui.ready(function(){n()}):a(document).ready(function(){n()})})(af);
