// DOMContentLoaded is fired once the document has been loaded and parsed,
// but without waiting for other external resources to load (css/images/etc)
// That makes the app more responsive and perceived as faster.
// https://developer.mozilla.org/Web/Reference/Events/DOMContentLoaded
window.addEventListener('DOMContentLoaded', function() {

  // We'll ask the browser to use strict code to help us catch errors earlier.
  // https://developer.mozilla.org/Web/JavaScript/Reference/Functions_and_function_scope/Strict_mode
  'use strict';

  var translate = navigator.mozL10n.get;

  // We want to wait until the localisations library has loaded all the strings.
  // So we'll tell it to let us know once it's ready.
  navigator.mozL10n.once(start);


  function start() {
    //var message = document.getElementById('message');
    // We're using textContent because inserting content from external sources into your page using innerHTML can be dangerous.
    // https://developer.mozilla.org/Web/API/Element.innerHTML#Security_considerations
    //message.textContent = translate('message');
  } // /start

});


// AngularJs App information And Routing
var app = angular
    .module('homeTrainingApp', [
		'ngAnimate', 'ngCookies', 'ngResource', 'ngRoute', 'ngSanitize','ngTouch'
		,'LocalStorageModule'])
	.config(
			function($compileProvider) {
							$compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|app|file|tel):/);
							$compileProvider.imgSrcSanitizationWhitelist(/^\s*(https?|ftp|mailto|app|file|tel):/);
			})
	.config(function ($routeProvider) {

			// Routing
			$routeProvider
			    .when('/main', {
						templateUrl: 'partials/home.html'
						, controller: 'HomeCtrl'
				}) // /
	            .when('/list', {
						templateUrl: 'partials/list.html'
						, controller: 'ListCtrl'
				}) // /list
				.when('/run', {
						templateUrl: 'partials/run.html'
						, controller: 'RunCtrl'
				}) // /run
				.when('/roadmap', {
						templateUrl: 'partials/roadmap.html'
						, controller: 'RoadMapCtrl'

				}) // /roadmap
				.when('/settings', {
						templateUrl: 'partials/settings.html'
						, controller: 'SettingsCtrl'
				}) // /settings
				.when('/credits', {
						templateUrl: 'partials/credits.html'

				})
				.otherwise({ redirectTo: '/main'});
	}) // /config
    .controller('AppCtrl', function($scope, $rootScope, $window) {
			//window.screen.lockOrientation('portrait');
			//window.screen.mozLockOrientation('portrait');
			$rootScope.windowHeight = $window.innerHeight;
	})
    .config(function (localStorageServiceProvider) {
            localStorageServiceProvider
			     .setPrefix('hometraining')
			     .setNotify(true, true);
	}); // /localStorageServiceProvider
