'use strict';

// HomeCtrl
app.controller('HomeCtrl', function($scope, $rootScope, $location, Program, Share) {

		// Title
		$scope.title = "Home Training";
		$scope.predicate = "order";
		$scope.reverse = false;
		$scope.loading = true;


		// Programs
		// -- Var
		$scope.programs = [];
		$scope.current = { };
		$scope.currentIndex = 0;
		$scope.maxIndex = 0;
		// -- Loading
		Program.all().then(function(data) {
				// Store
				$scope.programs = data;
				$scope.currentIndex = 0;
				$scope.maxIndex = data.length;
				// Set current
				$scope.setCurrent();
		});

		// Set the current selected program based on currentIndex
		$scope.setCurrent = function() {
				$scope.current = $scope.programs[$scope.currentIndex];
				//console.log($scope.current);
				if($scope.loading) { $scope.loading = false;}
		}; // /setCurrent

		// Next
		$scope.goNext = function() {
				if($scope.currentIndex < $scope.maxIndex - 1) {
                      $scope.currentIndex++;
					  $scope.setCurrent();
				}
		} // /Next

		// Previous
		$scope.goPrevious = function() {
				if($scope.currentIndex > 0) {
                      $scope.currentIndex--;
					  $scope.setCurrent();
				}
		} // /Previous

		// Go to generation
		$scope.generate = function(path) {
			 var p = $scope.current;
			 Share.setProgram(p);
			 $location.path(path);
		};

		// Handle of drawer
		$scope.sd = false;
		$scope.ctrDrawer = function() { $scope.sd = !$scope.sd; }
		$rootScope.$on("$routeChangeStart", 
						function(event, current, previous, rejection) { $scope.sd = false;  }
					  );
}); // /HomeCtrl
