/**
 * Hack to correct the ngTouch trouble
 * Issue : https://github.com/angular/angular.js/issues/6251
 * Corrections :
 * - http://jsfiddle.net/coma/2hWWa/
 * - http://stackoverflow.com/questions/21708730/why-are-multiple-click-events-fired-when-using-ngtouch
 */
app.directive('appclick', function() {

		return function(scope, element, attrs) {
				element.bind('touchstart click', function(event) {
						event.preventDefault();
						event.stopPropagation();

						scope.$apply(attrs['appclick']);

				}); // / bind
		}; // function
}); // /app-click

app.directive('resize', function($window) {
		return {
				restrict: 'A'
		        , link : function(scope, elem, attrs) {
						var winHeight = $window.innerHeight;
						//console.log(winHeight);
						var headerHeight = attrs.resize ? attrs.resize : 0;
						//console.log(headerHeight);
						elem.css('height', winHeight - headerHeight + 'px');

				}
		}; // /return
});

