'use strict';

app.factory('Exercice', function($q, $timeout, $http) {

		var Exercice = {
            all: function() {
					var def = $q.defer();
					$timeout(function() {
							// Get the json
							$http.get('data/exercices.json').success(function(data) {
                                  def.resolve(data);
							});
					}, 30); // timeout
					return def.promise;
			}, // /all
            load: function(program) {
                   //console.log(program.exercices);
				   var def = $q.defer();
				   $timeout(function() {
							// Get the json
							$http.get(program.exercices).success(function(data) {
                                  def.resolve(data);
							}
				   )}, 30);
				   return def.promise;
			}
		}; // /Exercice

		return Exercice;
}); // /Exercice
