'use strict';

app.factory('Settings', function(localStorageService) {

		// var
		var lss = localStorageService;

		// Length
		if(lss.length() == 0) {
				//console.log('Create');
		        var json = { 
						soundActivated:true
                        , vibrationActivated:true 
						, vibrationDuration:1000 
						, lockScreen:true 
						, lockOrientation: true 
				};
				lss.set('config', json);
		}
		// Get
		var config = lss.get('config');
		//console.log(config);

		var Settings = {
				// Get All
			all: function() { return config; },
			    // Save
			save: function(config) { lss.set('config', config); },
				// Return 1 if sound is activated
			soundActivated : function() { return config.soundActivated; },
				// Return 1 if vibration is activated
            vibrationActivated : function() { return config.vibrationActivated; },
                // Duration of vibration
		    vibrationDuration : function() { return config.vibrationDuration; },
				// Lock Screen
		    lockScreen : function() { return config.lockScreen; },
		        // Lock orientation
		    lockOrientation : function() { return config.lockOrientation; }
		}; // /Settings

        return Settings;

});
