var db;
var newItem = [{
	loged : 0,
	datos : ""
}];
window.onload = function() {
	//console.log('Aplicacion iniciada - database.js');
	window.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
	window.IDBTransaction = window.IDBTransaction || window.webkitIDBTransaction || window.msIDBTransaction;
	window.IDBKeyRange = window.IDBKeyRange || window.webkitIDBKeyRange || window.msIDBKeyRange;
	var request = window.indexedDB.open("sesion", 4);
	request.onerror = function(event) {
		//console.log('Error cargando database.');
	};
	request.onsuccess = function(event) {
		//console.log('Database inicializada');
		db = request.result;
		//console.log(db);
		getData();
	};
	request.onupgradeneeded = function(event) {
		var db = event.target.result;
		db.onerror = function(event) {
			//console.log('Error cargando database.');
		};
		var objectStore = db.createObjectStore("sesion", {
			keyPath : "loged"
		});
		objectStore.createIndex("datos", "datos", {
			unique : false
		});
		//console.log('Objeto creado');
	};
};
function addData(informacion) {
	var newItem = [{
		loged : 1,
		datos : informacion
	}];
	//console.log(newItem);
	var transaction = db.transaction(["sesion"], "readwrite");
	transaction.oncomplete = function(event) {
		//console.log('Transaction abierta. Agregar datos...' + informacion);
	};
	transaction.onerror = function(event) {
		//console.log('Transaction no abierta por error. No se permiten duplicados.');
	};
	var objectStore = transaction.objectStore("sesion");
	var request = objectStore.add(newItem[0]);
	request.onsuccess = function(event) {
		//console.log('datos agregados!');
	};
}

function deleteItem() {
	var request = db.transaction(["sesion"], "readwrite").objectStore("sesion").delete(1);
	request.onsuccess = function(event) {
		//console.log('Informacion borrada');
	};
}

function getData() {
	db.transaction("sesion").objectStore("sesion").get(1).onsuccess = function(event) {
		//console.log("Obteniendo informacion desde la base de datos " + event.target.result.datos);
		mostrarDatosAlumno(event.target.result.datos);
		getAlarm();
	};
}
