var objetoJSON;

function valida() {
	if (document.detect.p_codigo_c.value.length < 7) {
		if (document.detect.p_codigo_c.value.length == 5) {
			return true;
		} else {
			alert("Codigo Incorrecto");
			return false;
		}
	} else {
		return true;
	}
}

function calcularCiclo() {
	var today = new Date();
	var dd = today.getDate();
	var mm = today.getMonth() + 1;
	var yyyy = today.getFullYear();
	/*  año+10  ciclo A,
	 *  año+20  ciclo B,
	 *  año+80  verano   */
	var ciclo = yyyy;
	if ((mm == 6 && dd >= 20) || mm == 7) {
		ciclo += "80";
	} else if (mm >= 1 && mm <= 6) {
		ciclo += "10";
	} else if (mm >= 8 && mm <= 12) {
		ciclo = +"20";
	}
	return ciclo;
}

function peticionSiiau() {
	/*
	 * mostrar pagina loading
	 */
	document.querySelector('#loading').className = 'current';
	document.querySelector('[data-position="current"]').className = 'left';

	var http = new XMLHttpRequest({
		mozSystem : true
	});
	var ciclo = calcularCiclo();
	//console.log("Ciclo escolar segun sistema" + ciclo);
	var postdata = "p_codigo_c=" + document.getElementById('p_codigo_c').value + "&p_clave_c=" + document.getElementById('p_clave_c').value + "&pciclo=" + ciclo + "&formato=json";
	//console.log("Datos: " + postdata);
	//http.open("POST", "http://siiau.esy.es/Registro.php", true);
	http.open("POST", "http://siiau.netii.net/alumnos.php", true);
	http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	http.onreadystatechange = function() {
		if (http.status === 200 && http.readyState === 4) {
			var respuesta = http.response;
			if (respuesta == "1Error" || respuesta == "") {
				alert("Error al obtener informacion, verifica tus datos");
				document.querySelector('#loading').className = 'skin-dark right';
				document.querySelector('[data-position="current"]').className = 'current';
			} else {
				//console.log(respuesta);
				mostrarDatosAlumno(respuesta);
			}
		}
	};
	http.onerror = function() {
		alert("Error de conexion");
		//console.log('http.status = ' + http.status);
		//console.log('http.readyState = ' + http.readyState);
		/*
		 * Regresar al menu anterior
		 */
		document.querySelector('#loading').className = 'skin-dark right';
		document.querySelector('[data-position="current"]').className = 'current';
	};
	http.send(postdata);
}

function mostrarDatosAlumno(respuesta) {
	try {
		objetoJSON = JSON.parse(respuesta);
		alert("Bienvenido: " + objetoJSON.alumno.nombre);
		addData(respuesta);
		document.getElementById("jnombre").innerHTML = objetoJSON.alumno.nombre;
		document.getElementById("jcodigo").innerHTML = objetoJSON.alumno.codigo;
		document.getElementById("jcarrera").innerHTML = objetoJSON.alumno.carrera;
		document.getElementById("jcentro").innerHTML = objetoJSON.alumno.centro;
		mostrarHorario(document.getElementById('dia').value);
		document.querySelector('#loading').className = 'skin-dark left';
		document.querySelector('#horario').className = 'skin-dark current';
		document.querySelector('[data-position="current"]').className = 'left';
		
	} catch (e) {
		console.error("Parsing error:", e);
		alert("Error del Servidor");
		document.querySelector('#loading').className = 'skin-dark right';
		document.querySelector('[data-position="current"]').className = 'current';
		/*/temp
		respuesta = horario_prueba;
		objetoJSON = respuesta;
		alert("Bienvenido: " + objetoJSON.alumno.nombre);
		addData(respuesta);
		document.getElementById("jnombre").innerHTML = objetoJSON.alumno.nombre;
		document.getElementById("jcodigo").innerHTML = objetoJSON.alumno.codigo;
		document.getElementById("jcarrera").innerHTML = objetoJSON.alumno.carrera;
		document.getElementById("jcentro").innerHTML = objetoJSON.alumno.centro;
		mostrarHorario(document.getElementById('dia').value);
		if (getAlarm() > 0) {
			document.getElementById("notificacionesSwitch").checked = true;
		} else {
			document.getElementById("notificacionesSwitch").checked = false;
		}
		document.querySelector('#loading').className = 'skin-dark left';
		document.querySelector('#horario').className = 'skin-dark current';
		document.querySelector('[data-position="current"]').className = 'left';
		*/
	}
}

function mostrarHorario(dia) {
	if (dia == "T") {
		var tabla = '<table><tr><th>Materia</th><th>Edificio</th><th>Aula</th><th>Horario</th><th>L</th><th>M</th><th>I</th><th>J</th><th>V</th><th>S</th><th>Profesor</th></tr>';
	} else {
		var tabla = '<table><tr><th>Materia</th><th>Edificio</th><th>Aula</th><th>Horario</th></tr>';
	}
	if (objetoJSON.error != undefined) {
		alert(objetoJSON.error);
	} else if (objetoJSON.materias != undefined) {
		for (var i = 0; i < objetoJSON.materias.length; i++) {
			if (objetoJSON.materias[i].lunes == dia || objetoJSON.materias[i].martes == dia || objetoJSON.materias[i].miercoles == dia || objetoJSON.materias[i].jueves == dia || objetoJSON.materias[i].viernes == dia || objetoJSON.materias[i].sabado == dia) {
				if (objetoJSON.materias[i].materia != undefined) {
					tabla += '<tr><td>' + objetoJSON.materias[i].materia + '</td><td>' + objetoJSON.materias[i].edificio + '</td><td>' + objetoJSON.materias[i].aula + '</td><td>' + objetoJSON.materias[i].horario + '</td></tr>';
				} else {
					tabla += '<tr><td>' + objetoJSON.materias[i - 1].materia + '</td><td>' + objetoJSON.materias[i].edificio + '</td><td>' + objetoJSON.materias[i].aula + '</td><td>' + objetoJSON.materias[i].horario + '</td></tr>';
				}
			} else if (dia == "T") {
				if (objetoJSON.materias[i].materia != undefined) {
					tabla += '<tr><td>' + objetoJSON.materias[i].materia + '</td><td>' + objetoJSON.materias[i].edificio + '</td><td>' + objetoJSON.materias[i].aula + '</td><td>' + objetoJSON.materias[i].horario + '</td><td>' + imprimeDia(objetoJSON.materias[i].lunes) + '</td><td>' + imprimeDia(objetoJSON.materias[i].martes) + '</td><td>' + imprimeDia(objetoJSON.materias[i].miercoles) + '</td><td>' + imprimeDia(objetoJSON.materias[i].jueves) + '</td><td>' + imprimeDia(objetoJSON.materias[i].viernes) + '</td><td>' + imprimeDia(objetoJSON.materias[i].sabado) + '</td><td>' + objetoJSON.materias[i].profesor + '</td></tr>';
				} else {
					tabla += '<tr><td></td><td>' + objetoJSON.materias[i].edificio + '</td><td>' + objetoJSON.materias[i].aula + '</td><td>' + objetoJSON.materias[i].horario + '</td><td>' + imprimeDia(objetoJSON.materias[i].lunes) + '</td><td>' + imprimeDia(objetoJSON.materias[i].martes) + '</td><td>' + imprimeDia(objetoJSON.materias[i].miercoles) + '</td><td>' + imprimeDia(objetoJSON.materias[i].jueves) + '</td><td>' + imprimeDia(objetoJSON.materias[i].viernes) + '</td><td>' + imprimeDia(objetoJSON.materias[i].sabado) + '</td><td></td></tr>';
				}
			}
		};
		tabla += '</table>';
		document.getElementById('tablas').innerHTML = tabla;		
	} else {
		alert("Hubo un error al leer los datos");
	}
}

function imprimeDia(dia) {
	switch(dia) {
		case "L":
		case "M":
		case "I":
		case "J":
		case "V":
		case "S":
			return dia;
		default:
			return " ";
	}
}

function horarioDia(dia) {
	//console.log("Dia recibido: " + dia);
	switch(dia) {
		case "L":
		case "M":
		case "I":
		case "J":
		case "V":
		case "S":
		case "T":
			mostrarHorario(dia);
			break;
		default:
			alert("Error del dia seleccionado!");
			break;
	}
}