// We'll ask the browser to use strict code to help us catch errors earlier.
// https://developer.mozilla.org/Web/JavaScript/Reference/Functions_and_function_scope/Strict_mode
'use strict';

// DOMContentLoaded is fired once the document has been loaded and parsed,
// but without waiting for other external resources to load (css/images/etc)
// That makes the app more responsive and perceived as faster.
// https://developer.mozilla.org/Web/Reference/Events/DOMContentLoaded
// window.addEventListener('DOMContentLoaded', function() {



// Do not use mozL10n.get!! https://developer.mozilla.org/en-US/Apps/Build/Localization/Localization_code_best_practices
// var translate = navigator.mozL10n.get;
// We want to wait until the localisations library has loaded all the strings.
// So we'll tell it to let us know once it's ready.
// navigator.mozL10n.once(start);
// });

// Changer mozL10n.get (éviter de l'utiliser)
// https://developer.mozilla.org/en-US/Apps/Build/Localization/Localization_code_best_practices



// Return the version of Firefox OS or null if not Firefox OS. The simulator use the gecko version of the browser!
// https://gist.github.com/Mte90/11087561
function getVersion() {
    if (navigator.userAgent.match(/(mobile|tablet)/i)) {
        var ffVersionArray = (navigator.userAgent.match(/Firefox\/([\d]+\.[\w]?\.?[\w]+)/));
        if (ffVersionArray.length === 2) {
            //Check with the gecko version the Firefox OS version
            //Table https://developer.mozilla.org/en-US/docs/Gecko_user_agent_string_reference
            var hashVersion = {
                '18.0': '1.0.1',
                '18.1': '1.1',
                '26.0': '1.2',
                '28.0': '1.3',
                '30.0': '1.4',
                '32.0': '2.0',
                '34.0': '2.1',
                '37.0': '2.2',
                '44.0': '2.5',
                // Firefox 2.6 n'est pas encore sorti, donc on sait jamais d'où duplicata...
                '45.0': '2.6',
                '46.0': '2.6'
            }
            var rver = ffVersionArray[1];
            var sStr = ffVersionArray[1].substring(0, 4);
            if (hashVersion[sStr]) {
                rver = hashVersion[sStr];
            }
            return rver;
        }
    }
    return (null);
}

// Fonction pour permettre un délai dans l'envoi du SMS
function delaySMS() {
    var createSMS = new MozActivity({
        name: "new",
        data: {
            type: "websms/sms",
            number: contact.number,
            body: body
        }
    });

    // Appeler l'application "Messages" se fait à l'intérieur du programme, contrairement à "Courriel".
    createSMS.onsuccess = function() {
        // Effacer le contenu du message si le SMS a bien été envoyé.
        document.getElementById('textmsg').value = "";

        // Vider les variables (au cas où)
        contact = undefined;
        body = undefined;
    };
    createSMS.onerror = function() {
        console.log(this);
        alert('Error');
    };
}

// Fonction pour permettre un délai dans l'envoi de l'email
function delayemail() {
    var createEmail = new MozActivity({
        name: "new",
        data: {
            type: "mail",
            url: "mailto:" + [contact.email] + "?body=" + body
        }
    });

    // Fermer horiZon permet d'éviter un écran noir après avoir quitté Email.
    // Semblerait ne pas avoir lieu sur FF OS 2.6 (et en 2.1) donc fermeture inutile ?
    // window.close();

    // Appeler l'application "Courriel" se fait à l'extérieur du programme, contrairement à "Messages".  
    // Pas d'intérêt de faire un .onerror car c'est un cas normal où l'email n'est juste pas envoyé et non pas une "erreur".    
}


// Définir les variables pour récupérer l'action des boutons
var sendSMSButton = document.getElementById('sendSMS'),
    sendEmailButton = document.getElementById('sendEmail'),
    cleartextButton = document.getElementById('cleartextmsg'),
    exitButton = document.getElementById('exit'),
    body,
    contact;


// Bouton pour envoyer un sms
sendSMSButton.onclick = function() {
    console.log('START');

    body = document.getElementById('textmsg').value;

    // Remplace les apostrophes et guillements par un caractère proche ` et des caractères spéciaux par un espace. Bug corrigé avec FF OS v2.2.
    if (getVersion() in {
            '2.1': 0,
            '2.0': 0,
            '1.4': 0,
            '1.3': 0,
            '1.2': 0,
            '1.1': 0,
            '1.0.1': 0
        }) {
        body = body.replace(/['"]/g, '`').replace(/[<>&]/g, '');
    }

    // Si horiZon a pu être testé (avec succès) sur le simulateur de la version de FF OS, alors enchainement Contact puis SMS
    if (getVersion() in {
            '2.1': 0,
            '2.0': 0,
            '1.4': 0,
            '1.3': 0
        }) {


        // Récupérer le téléphone du contact
        var pick = new MozActivity({
            name: "pick",
            data: {
                type: "webcontacts/contact"
            }
        });

        // Après sélection du contact, écriture du SMS
        pick.onsuccess = function() {
            // Structure de contact : Object { name: Array[1], number: "XX XX XX XX XX" }
            contact = this.result;

            // Pour empêcher que l'enchainement des programmes ne bugge, une pause.
			setTimeout('delaySMS()', 500);
        };

        pick.onerror = function() {
            console.log(this);
            alert(navigator.mozL10n.get('alert-nocontact', {
                var1: "value"
            }));
        };
    }

    // Si horiZon n'a pu être testé (ou sans succès) sur le simulateur de la version de FF OS, alors directement vers SMS
    else {
        contact = {
            number: ''
        };
        delaySMS();
    }
};

// Bouton pour envoyer un email
sendEmailButton.onclick = function() {
    console.log('START');

    body = document.getElementById('textmsg').value;

    // Pour remettre la signature de fin d'email. Bug corrigé avec FF OS v2.6
    if (getVersion() in {
            '2.5': 0,
            '2.2': 0,
            '2.1': 0,
            '2.0': 0,
            '1.4': 0,
            '1.3': 0,
            '1.2': 0,
            '1.1': 0,
            '1.0.1': 0
        }) {
        body += "\n--\n" + navigator.mozL10n.get('signature-email', {
            var1: "value"
        });
    }

    // Mailto n'accepte pas des sauts de ligne ou les caractères spéciaux
    body = encodeURIComponent(body);

    // Si horiZon a pu être testé (avec succès) sur le simulateur de la version de FF OS, alors enchainement Contact puis SMS
    if (getVersion() in {
            '2.1': 0,
            '2.0': 0,
            '1.4': 0,
            '1.3': 0
        }) {

        // Récupérer l'email du contact.
        var pick = new MozActivity({
            name: "pick",
            data: {
                type: "webcontacts/email"
            }
        });

        // Après sélection du contact, écriture de l'email
        pick.onsuccess = function() {
            // Structure de contact : Object { name: Array[1], email: "nom.prenom@provider.com" }
            contact = this.result;

            // Pour mettre une pause pour les emails (nécessaire au moins pour FF OS v1.3)
            setTimeout('delayemail()', 500);
        };

        pick.onerror = function() {
            console.log(this);
            alert(navigator.mozL10n.get('alert-nocontact', {
                var1: "value"
            }));
        };

    }

    // Si horiZon n'a pu être testé (ou sans succès) sur le simulateur de la version de FF OS, alors directement vers Email
    else {
        contact = {
            email: ''
        };
        delayemail();
    }
};


// Bouton pour effacer le texte de "textmsg"
cleartextButton.onclick = function() {
    if (confirm(navigator.mozL10n.get('confirm-clear', {
            var1: "value"
        })) == true) {
        document.getElementById('textmsg').value = "";
    }
};

// Bouton pour quitter l'application
exitButton.onclick = function() {
    if (confirm(navigator.mozL10n.get('confirm-quit', {
            var1: "value"
        })) == true) {
        window.close();
    }
};