var key = "10576f6c00ef2b1cf478de8-7e68f71c-ca2e-11e2-8c82-009c5fda0a25";

$(document).delegate('div[data-role="page"]', 'pageshow', function () {
	localytics(key);	
});			


$(document).on('pagebeforecreate', '[id="page1"]', function() {     
	var interval = setInterval(function() {
		$.mobile.loading('show');
		clearInterval(interval);
	}, 1);    
});

$(document).on('pageshow', '[id="page1"]', function() {  
	var interval = setInterval(function() {
		$.mobile.loading('hide');
		clearInterval(interval);
	}, 300);
});

$(document).on('pageinit', 'div#page1', function() {
		
	console.log("arranca");	
		
	var urlJSON = 'http://www.revistadominical.com.ve/CMSPages/Servicios/HoroscopoJSON.aspx?tipo=consolidado';				
	var fechaJSON;
    
	if (localStorage.getItem('fecha')) {
		fechaJSON = localStorage.getItem('fecha');

		if (fechaJSON != getFecha()) {
			cargarData(urlJSON);
		}
		else {
			cargarDataSignos();
		}
	}
    else
    {
        cargarData(urlJSON);
    }
});

function cargarData(urlJSON) {
	
    $.ajaxSetup({
	  contentType: 'application/x-www-form-urlencoded; charset=ISO-8859-1',
	  beforeSend: function(jqXHR) {
		jqXHR.overrideMimeType('application/x-www-form-urlencoded; charset=ISO-8859-1');
	  }
	});

	
	$.ajax({
		url: urlJSON,
		crossDomain: true,
		type: "GET",
		crossDomain: true,
		dataType: "jsonp",
		async: true
	}).done(function() {
		console.log("Cargar desde URL");
		cargarJSON(urlJSON);
	})
	.fail(function() {
		console.log("Cargar desde el Storage");
		cargarDataSignos();
	})
	.always(function() {
		console.log("always");
	});
}

function localytics(key) {            
	var nombrePagina = $.mobile.activePage.data('title');
    var options = { appVersion: "Firefox v1.00", sessionTimeoutSeconds: 30};

	var localyticsSession = LocalyticsSession(key, options);
	localyticsSession.tagEvent("Content Viewed", {"Page Name":nombrePagina});
	localyticsSession.open();
	localyticsSession.upload();
}

function cargarDataSignos() {
	var nombreStorage = 'horoscopoJSON';
	var dataStorage;
	var toJSON;

	if (localStorage.getItem(nombreStorage)) {
		dataStorage = localStorage.getItem(nombreStorage);

		if (dataStorage != undefined) {
            console.log("Cargando desde Storage")
			toJSON = JSON.parse(dataStorage);
			cargarListaSignos(toJSON);
			cargarDetallesSignos(toJSON);
		}
	}
    else
    {
        console.log("Cargando en VIVO")   
        cargarListaSignos(toJSON);
	    cargarDetallesSignos(toJSON);        
    }	
}

function cargarJSON(urlJSON) {
	console.log("Try to load JSON");
	$.ajax({
		url: urlJSON,
		type: "GET",
		crossDomain: true,
		dataType: "jsonp",
		async: true,
		success: function (data) {
			console.log("Success");
			storageData(data);
			cargarListaSignos(data);
			cargarDetallesSignos(data);
		},
		error: function () {
			console.log("Something went wrong");
		}
	});
}

function cargarListaSignos(data) {
	
	console.log("Carga Lista de Signos");
	
	var nombreSigno;
	var periodoSigno;
	var nombreSignoSimple;
	var item;

	if (data['horoscopos'] != undefined) {
		$("#listaSignos").empty();                
		for (i = 0; i < data['horoscopos'].length; i++) {
			var horoscopo = data['horoscopos'][i];

			$.each(horoscopo['horoscopo'], function (index, value2) {
				nombreSigno = value2['nombreSigno'];
				periodoSigno = value2['periodoSigno'];
				imagen = value2['imagen'];
				nombreSignoSimple = getNombreSignoSimple(nombreSigno);

				item = $('<li><a href=\"#' + nombreSignoSimple + '\" class=\"ui-link-inherit itemListaNombreSigno\" data-transition=\"none\" data-inline=\"true\"><img src=\"' + getLogoSigno(nombreSignoSimple) + '\" alt=\"' + nombreSigno + '\" max-width=\"25px\" style=\"max-width:25px; max-height:34px;\" width=\"25\" height=\"34\" class=\"ui-li-icon ui-corner-none\"/>' + nombreSigno + '<br/><span class=\"itemListaPeriodoSigno\">' + periodoSigno + '</span></a></li>');

				item.appendTo('#listaSignos');
				$('#listaSignos').listview('refresh');
			});
		}
	}
}

function cargarDetallesSignos(data) {
	var tituloDiario;
	var tituloSemanal;
	var obj;
	var clone;
	var imagen;
	var contentPeriodoSigno;
	var contenedorImagen;

	if (data['horoscopos'] != undefined) {
		for (i = 0; i < data['horoscopos'].length; i++) {
			var horoscopo = data['horoscopos'][i];

			tituloDiario = horoscopo['tituloDiario'];
			tituloSemanal = horoscopo['tituloSemanal'];
			storageFecha(horoscopo['fecha']);

			for (j = 0; j < horoscopo['horoscopo'].length; j++) {
				obj = horoscopo['horoscopo'][j];

				$('#' + getNombreSignoSimple(obj.nombreSigno)).remove();

				clone = $("#detalle").clone();
				clone.attr("id", getNombreSignoSimple(obj.nombreSigno));
				clone.attr("data-title", "Detalle " + obj.nombreSigno);

				contenedorImagen = clone.find("#contenedorImagenSigno")
				contenedorImagen.attr("style", "background-image: url('" + getHeaderSignoBackground(obj.nombreSigno) + "');");

				imagen = clone.find("#content_imagen")
				imagen.attr("src", getHeaderSigno(obj.nombreSigno));
				imagen.attr("alt", obj.nombreSigno);

				contentPeriodoSigno = clone.find("#content_periodoSigno");
				contentPeriodoSigno.html(obj.periodoSigno);

				clone.find("#content_tituloDiario").html(tituloDiario);
				clone.find("#content_diario").html(obj.diario);
				clone.find("#content_tituloSemanal").html(tituloSemanal);

				clone.find("#content_claveSemana")
				.html('<span id="etiqueta">Clave de la Semana: </span>' + obj.claveSemana);
				clone.find("#content_diaImportante")
				.html('<span id="etiqueta">D&iacute;a Importante: </span>' + obj.diaImportante);
				clone.find("#content_numeroAstral")
				.html('<span id="etiqueta">N&uacute;mero Astral: </span>' + obj.numeroAstral);
				clone.find("#content_cuidate")
				.html('<span id="etiqueta">Cuidate: </span>' + obj.cuidate);
				clone.find("#content_activaSuerte")
				.html('<span id="etiqueta">Activa tu Suerte: </span>' + obj.activaSuerte);
				clone.find("#content_trabajo")
				.html('<span id="etiqueta">Trabajo: </span>' + obj.trabajo);
				clone.find("#content_amor")
				.html('<span id="etiqueta">Amor: </span>' + obj.amor);
				clone.find("#content_familia")
				.html('<span id="etiqueta">Familia: </span>' + obj.familia);
				clone.find("#content_salud")
				.html('<span id="etiqueta">Salud: </span>' + obj.salud);
				clone.find("#content_tenPresente")
				.html('<span id="etiqueta">Ten Presente: </span>' + obj.tenPresente);
                clone.find("#content_datoAstrologico")
				.html('<span id="etiqueta">Dato Astrol&oacute;gico: </span>' + obj.datoAstrologico);
                clone.find("#content_colorMagnetico")
				.html('<span id="etiqueta">Color Magn&eacute;tico: </span>' + obj.colorMagnetico);

				generarBotonTweet(clone, obj.nombreSigno, tituloDiario, obj.diario);

				clone.find('span[id="etiqueta"]', "#content_semanal")
				.attr("class", " tituloItemHoroscopo");        

				clone.appendTo("#cuerpo");
			}
		}
	}
}

function getHeaderSigno(nombreSigno) {
	return "img/headers/" + getNombreSignoSimple(nombreSigno) + ".jpg";
}

function getHeaderSignoBackground(nombreSigno) {
	return "img/backgrounds/" + getNombreSignoSimple(nombreSigno) + "_bk.jpg";
}

function getLogoSigno(nombreSigno) {
	return "img/logos/" + getNombreSignoSimple(nombreSigno) + ".png";
}                    

function getNombreSignoSimple(nombreSigno) {
	var nombreClase = nombreSigno.toLowerCase()
	.replace("\u00e1", "a")
	.replace("\u00e9", "e")
	.replace("\u00ed", "i")
	.replace("\u00f3", "o")
	.replace("\u00fa", "u");
	return nombreClase;
}

function storageData(data) {
	var nombreStorage = 'horoscopoJSON';
	if (data) {        
		if (localStorage.getItem(nombreStorage)) {
			localStorage.removeItem(nombreStorage);
		}		        		
		localStorage.setItem(nombreStorage, JSON.stringify(data));
	}				                                
}

function storageFecha(data) {
	var nombreStorage = 'fecha';
	localStorage.setItem(nombreStorage, data);								                                
}

function storageImage(imagen, nombreStorage) {
if (localStorage.getItem(nombreStorage)) {
imagen.attr("src", localStorage.getItem(nombreStorage));
}				
else {
imagen.load(function() {
var imgCanvas = document.createElement("canvas");
var imgContext = imgCanvas.getContext("2d");

imgCanvas.width = imagen.attr("width");
imgCanvas.height = imagen.attr("height");
imgContext.drawImage(this, 0, 0, imagen.attr("width"), imagen.attr("height"));

// Save image as a data URL
//imagen = imgCanvas.toDataURL("image/png");

localStorage.removeItem(nombreStorage);
localStorage.setItem(nombreStorage, imgCanvas.toDataURL("image/png"));                
});
}							                                
}

//function generarBotonTweet(clone, nombreSigno, claveSemana) {
function generarBotonTweet(clone, nombreSigno, tituloDiario, diario) {
	//var text = "#Hor\u00f3scopo #" + nombreSigno + " Clave de la Semana: " + claveSemana;
	var text = "#Hor\u00f3scopo #" + nombreSigno + " " + tituloDiario + ": ";
	text = text + diario.substring(0, 95 - text.length) + "...";                            

	var url = "http://dominical.cc/12BWR8x";//"http://revistadominical.com.ve/horoscopo.aspx";
	var via = "redominical";
	clone.find("#twitter-share-button").html("<a href=\"#\" class=\"twitter-share-button\" title=\"Compartir\" ><img src=\"img/logos/twitter.png\" alt=\"Twitter\" width=\"26px\" /></a>");
	//clone.find("a.twitter-share-button").attr("onclick", "openUrl(\"https://twitter.com/intent/tweet?text=" + encodeURIComponent(text) + "&url=" + encodeURIComponent(url) + "&via=" + via + "\"); return false;");
	clone.find("a.twitter-share-button").attr("onclick", "window.open(\"https://twitter.com/intent/tweet?text=" + encodeURIComponent(text) + "&url=" + encodeURIComponent(url) + "&via=" + via + "\"); return false;");
}

function openUrl(url) {
	/*window.plugins.childBrowser.onLocationChange = function(loc) {
	if (loc.indexOf("complete") >= 0) {
	sleep(10000);
	window.plugins.childBrowser.close();
	}
	}*/  
	window.plugins.childBrowser.showWebPage(url, { showLocationBar: true });
}

function sleep(milliseconds) {
	var start = new Date().getTime();
	for (var i = 0; i < 1e7; i++) {
		if ((new Date().getTime() - start) > milliseconds) {
			break;
		}
	}
}

function getFecha() {
	var today = new Date();
	var dd = today.getDate();
	var mm = today.getMonth() + 1; //porque Enero es 0 (cero)
	var yyyy = today.getFullYear();

	if (dd < 10) {
		dd = '0' + dd;
	}

	if (mm < 10) {
		mm = '0' + mm;
	}

	today = dd + '/' + mm + '/' + yyyy;
	return today;
}