var theViewModel =
{
    language: ko.observable(window.localStorage["language"] || CheckLanguage()),
    city: city,
    isPhone: ko.observable(true),
    isTablet: ko.observable(false),
    isWebPage: ko.observable(false),
    
    deviceType: ko.observable("phone"),

    screenWidth: ko.observable(),
    screenHight: ko.observable(),
    styleFile: ko.observable(),

    GoToNextSlide: function ()
    {
        contentSwiper.swipeNext();
    },

    GoToNextSlideVertical: function ()
    {
        swiperNested0.swipeNext();
    },

    GoToPrevSlide: function ()
    {
        contentSwiper.swipePrev();
    },

    GoToPrevSlideVertical: function ()
    {
        swiperNested0.swipePrev();
    }
};

var theOrientation = '';
var styleSheetNr = '';

var swiperNested0;
var contentSwiper;

function setContentSize()
{
    $('.swiper-content').css({
        height: $(window).height() - $('.swiper-nav').height()
    });
}

function setStylSheet()
{
    var w = $(window).width();
    var h = $(window).height();

    var currentOrientation = theOrientation;
    var currentstyleSheetNr = styleSheetNr;

    theViewModel.isPhone(true);

    if (w < h)
    {
        theOrientation = 'portrait';
    } else
    {
        theOrientation = 'landscape';
    }

    if (theOrientation === 'portrait')
    {
        if ((w <= 320))
        {
            styleSheetNr = '1';
        }

        if (w > 320 && w <= 480)
        {
            styleSheetNr = '2';
        }

        if (w > 480 && w <= 600)
        {
            styleSheetNr = '3';
        }

        if (w > 600 && w <= 800)
        {
            styleSheetNr = '4';
        }

        if (w > 800)
        {
            styleSheetNr = '5';
        }

        if (w > 600)
        {
            theViewModel.isPhone(false);
            theViewModel.isTablet(true);
            theViewModel.deviceType("phone");
        }
    }

    if (theOrientation === 'landscape')
    {
        if ((w <= 480))
        {
            styleSheetNr = '1';
        }

        if (w > 480 && w <= 600)
        {
            styleSheetNr = '2';
        }

        if (w > 600 && w <= 800)
        {
            styleSheetNr = '3';
        }

        if (w > 800 && w <= 1024)
        {
            styleSheetNr = '4';
        }

        if (w > 1024)
        {
            styleSheetNr = '5';
        }

        if (w > 800)
        {
            theViewModel.isPhone(false);
            theViewModel.isTablet(true);
            theViewModel.deviceType("tablet");
        }
    }

    if (currentOrientation != theOrientation || currentstyleSheetNr != styleSheetNr)
    {

        var file = 'css/app-' + styleSheetNr + '-' + theOrientation + '.css';

        theViewModel.styleFile(file);

        $('#StyleSheedSelector').attr('href', file);
    }
};

$(window).resize(function ()
{
    setStylSheet();

    setContentSize();

    setScreenDimension();
});

function setScreenDimension()
{

    theViewModel.screenWidth($(window).width());
    theViewModel.screenHight($(window).height());
}

$(function ()
{
    contentSwiper = $('.swiper-content').swiper({

        onSlideChangeEnd: function ()
        {

        },

        onTouchStart: function ()
        {

        },

    });

    swiperNested0 = new Swiper('.swiper-nested-0', {
        mode: 'vertical',
        pagination: '.pagination-nested-1',
        paginationClickable: true,
        slidesPerView: 1
    });
});

// Localized Text
ko.bindingHandlers.LocalizedText = {
    init: function (element, valueAccessor)
    {
        $(element).text(LocalizedText(valueAccessor()));
    }
};

function LocalizedText(textToTranslate)
{
    try
    {
        return localizedStrings[textToTranslate][theViewModel.language()];
    }
    catch (e)
    {
        return "n/a";
    }
}

// City booking link url
ko.bindingHandlers.CityBookingLinkUrl = {
    init: function (element, valueAccessor)
    {
        $(element).attr("href", CityBookingLinkUrl(valueAccessor()));
    }
};

function CityBookingLinkUrl(id)
{
    var suplierLink = "http://www.the-hotels.info/checkOut.html?providor=" + id + "&deviceType=" + theViewModel.deviceType() + "&language=" + theViewModel.language();
    //var suplierLink = "checkOut.html?providor=" + id + "&deviceType=" + theViewModel.deviceType() + "&language=" + theViewModel.language();

    return suplierLink;
}

// language check
function CheckLanguage()
{
    var language = window.navigator.language;

    // todo: browser bestimmte oder Sytem sprache auslesen

    if (typeof window.navigator.language == "undefined")
        language = window.navigator.systemLanguage;

    return language.substring(0, 2);
}

$(document).ready(function ()
{
    setStylSheet();
    setContentSize();
    setScreenDimension();

    $(document).attr("title", "Hotels " + self.city.City.name + " " + theViewModel.language());

    ko.applyBindings(theViewModel);
});

/* Custom Javascript for this PhoneGap APP */
document.addEventListener("deviceready", onDeviceReady, false);

function onDeviceReady()
{
    //Phonegap is ready
    console.log("Phonegap is ready");
}

//$(document).on("mobileinit", function ()
//{
//    console.log("Initialize jQuery Mobile Phonegap Enhancement Configurations"); // Make your jQuery Mobile framework configuration changes here!
//    $.mobile.allowCrossDomainPages = true;
//    $.support.cors = true;
//    $.mobile.buttonMarkup.hoverDelay = 0;
//    $.mobile.pushStateEnabled = false;
//    $.mobile.defaultPageTransition = "none";
//});


(function (i, s, o, g, r, a, m)
{
    i['GoogleAnalyticsObject'] = r; i[r] = i[r] || function ()
    {
        (i[r].q = i[r].q || []).push(arguments);
    }, i[r].l = 1 * new Date(); a = s.createElement(o),
    m = s.getElementsByTagName(o)[0]; a.async = 1; a.src = g; m.parentNode.insertBefore(a, m);
})(window, document, 'script', '//www.google-analytics.com/analytics.js', 'ga');

ga('create', 'UA-43104796-1', 'the-hotels.info');
ga('send', 'pageview');
