var theViewModel =
{
    language:  ko.observable("en"),
    location: locationFromData,
    isPhone: ko.observable(true),
    isTablet: ko.observable(false),
    isWebPage: ko.observable(false),

    deviceType: ko.observable("phone"),

    screenWidth: ko.observable(),
    screenHight: ko.observable(),
    styleFile: ko.observable(),

    NavigateToSupplier: function (supplier)
    {

        // https://developers.google.com/analytics/devguides/collection/analyticsjs/advanced#hitCallback
        
        ga('send', 'pageview',
            {
                'page': '/selectedSupplier', 'title': supplier
            });

        var supplierLink = LocationBookingLinkUrl(supplier);

        window.open(supplierLink,'_blank');
    },


    SwichToGerman: function () {
        this.language("de");
    },

    SwichToEnglish: function ()
    {
        this.language("en");
    },

    GoToNextSlide: function ()
    {
        contentSwiper.swipeNext();
    },

    GoToNextSlideVertical: function ()
    {
        swiperNested0.swipeNext();
    },

    GoToPrevSlide: function ()
    {
        contentSwiper.swipePrev();
    },

    GoToPrevSlideVertical: function ()
    {
        swiperNested0.swipePrev();
    }
};

var theOrientation = '';
var styleSheetNr = '';

var swiperNested0;
var contentSwiper;

var device = GetURLParameterWithHash('device');

function setContentSize()
{
    $('.swiper-content').css({
        height: $(window).height() - $('.swiper-nav').height()
    });
}

function setStylSheet()
{
    var w = $(window).innerWidth();
    var h = $(window).innerHeight();

    var currentOrientation = theOrientation;
    var currentstyleSheetNr = styleSheetNr;

    theViewModel.isPhone(true);

    if (w < h)
    {
        theOrientation = 'portrait';
    } else
    {
        theOrientation = 'landscape';
    }

    if (theOrientation === 'portrait')
    {
        if ((w <= 320))
        {
            styleSheetNr = '1';
        }

        if (w > 320 && w <= 480)
        {
            styleSheetNr = '2';
        }

        if (w > 480 && w <= 600)
        {
            styleSheetNr = '3';
        }

        if (w > 600 && w <= 800)
        {
            styleSheetNr = '4';
        }

        if (w > 800)
        {
            styleSheetNr = '5';
        }

        if (w > 600)
        {
            theViewModel.isPhone(false);
            theViewModel.isTablet(true);
            theViewModel.deviceType("phone");
        }
    }

    if (theOrientation === 'landscape')
    {
        if ((w <= 480))
        {
            styleSheetNr = '1';
        }

        if (w > 480 && w <= 600)
        {
            styleSheetNr = '2';
        }

        if (w > 600 && w <= 800)
        {
            styleSheetNr = '3';
        }

        if (w > 800 && w <= 1024)
        {
            styleSheetNr = '4';
        }

        if (w > 1024)
        {
            styleSheetNr = '5';
        }

        if (w > 800)
        {
            theViewModel.isPhone(false);
            theViewModel.isTablet(true);
            theViewModel.deviceType("tablet");
        }
    }

    if (currentOrientation != theOrientation || currentstyleSheetNr != styleSheetNr)
    {

        var file = 'css/app-' + styleSheetNr + '-' + theOrientation + '.css';

        theViewModel.styleFile(file);

        $('#StyleSheedSelector').attr('href', file);
    }
};

$(window).resize(function ()
{
    setStylSheet();

    setContentSize();

    setScreenDimension();
});

function setScreenDimension()
{

    theViewModel.screenWidth($(window).innerWidth());
    theViewModel.screenHight($(window).innerHeight());

}

$(function ()
{
    contentSwiper = $('.swiper-content').swiper({

        onSlideChangeEnd: function ()
        { },

        onTouchStart: function ()
        { },
        mousewheelControl: true,
        keyboardControl: true
    });
});

// Localized Text
ko.bindingHandlers.LocalizedText = {
    update: function (element, valueAccessor)
    {
        $(element).text(LocalizedText(valueAccessor()));
    }
};

function LocalizedText(textToTranslate)
{
    try
    {
        return localizedStrings[textToTranslate][theViewModel.language()];
    }
    catch (e)
    {
        return "n/a";
    }
}

// Location booking link url
ko.bindingHandlers.LocationBookingLinkUrl = {
    init: function (element, valueAccessor)
    {
        $(element).attr("href", LocationBookingLinkUrl(valueAccessor()));
    }
};

function LocationBookingLinkUrl(id)
{
    //var suplierLink = "http://www.the-hotels.info/" + theViewModel.locationFromData.Location.name + "/checkOut.html?providor=" + id + "&deviceType=" + theViewModel.deviceType() + "&language=" + theViewModel.language();
    //var suplierLink = "checkOut.html?providor=" + id + "&deviceType=" + theViewModel.deviceType() + "&language=" + theViewModel.language();
    var suplierLink = LocationBookingLinkUrl(id);
    
    return suplierLink;
    
}

// language check
function CheckLanguage()
{
    // todo: testen

    var language = null;
    
    // with hash #
    language = GetURLParameterWithHash('language');
    
    // with ?
    if (language == "" || language.length != 2)
    {
        language = GetURLParameter('language');
    }
    
    try
    {
        if (language == null || language == "" || language.length != 2)
        {

            if (typeof window.navigator.language != "undefined" && (window.navigator.language.substring(0, 2) == "en" || window.navigator.language.substring(0, 2) == "de"))
                language = window.navigator.language.substring(0, 2);

            // android webview
            if (typeof navigator.userAgent != "undefined" && (navigator.userAgent == "en" || navigator.userAgent == "de"))
                language = navigator.userAgent;

        }
        if (language == null || language == "" || language != "de")
        {
            language = "en";
        }
    }
    catch (e)
    {
        language = "en";
    }

    return language;
}

$(document).ready(function ()
{
    ko.applyBindings(theViewModel);
    
    setStylSheet();
    setContentSize();
    setScreenDimension();

    theViewModel.language(CheckLanguage());
    
    // todo: geht in android web app nicht
    try
    {
        $(document).attr("title", "Hotels " + theViewModel.locationFromData.Location.name + " " + theViewModel.language());

    } catch (e)
    {

    }

    var selectedPage = GetURLParameter('selectedPage');

    if (selectedPage == "1")
    {
        contentSwiper.swipeTo(1);
    }
    if (selectedPage == "2")
    {
        contentSwiper.swipeTo(2);
    }
});

function onDeviceReady()
{
}

(function (i, s, o, g, r, a, m)
{
    i['GoogleAnalyticsObject'] = r; i[r] = i[r] || function ()
    {
        (i[r].q = i[r].q || []).push(arguments);
    }, i[r].l = 1 * new Date(); a = s.createElement(o),
    m = s.getElementsByTagName(o)[0]; a.async = 1; a.src = g; m.parentNode.insertBefore(a, m);
})(window, document, 'script', 'http://www.google-analytics.com/analytics.js', 'ga');

ga('create', 'UA-43104796-1', 'the-hotels.info');
ga('send', 'pageview');

function GetURLParameter(sParam)
{
    var parameterName = "";

    var sPageUrl = window.location.search.substring(1);
    
    var sUrlVariables = sPageUrl.split('&');
    
    for (var i = 0; i < sUrlVariables.length; i++)
    {
        var sParameterName = sUrlVariables[i].split('=');
        if (sParameterName[0] == sParam)
        {
            parameterName = sParameterName[1];
        }
    }
    return parameterName;
}

function GetURLParameterWithHash(sParam)
{
    var parameterName = "";

    if (document.location.href.indexOf('#') > 0)
    {
        var sPageUrl = document.location.href.split("#")[1];
        var sUrlVariables = sPageUrl.split('&');
        for (var i = 0; i < sUrlVariables.length; i++)
        {
            var sParameterName = sUrlVariables[i].split('=');
            if (sParameterName[0] == sParam)
            {
                parameterName = sParameterName[1];
            }
        }
    }
    return parameterName;
}

function LocationBookingLinkUrl(providor) {
    var suplierLink = "";

    if (providor == 'booking') {
        if (theViewModel.deviceType() == "phone") {
            // suplierLink = "http://m.booking.com/city/" + locationFromData.Location.SupplierIdBookingDotCom + ".html?aid=304310&label=" + theViewModel.deviceType();
            suplierLink = "http://www.booking.com/city/" + locationFromData.Location.SupplierIdBookingDotCom + ".html?aid=304310&label=" + theViewModel.deviceType();
        } else {
            suplierLink = "http://www.booking.com/city/" + locationFromData.Location.SupplierIdBookingDotCom + ".html?aid=304310&label=" + theViewModel.deviceType();
        }
    }

    if (providor == 'ean') {
        suplierLink = "http://www.travelnow.com/templates/397351/hotels/list?lang=" + theViewModel.language() + "&targetId=" + locationFromData.Location.SupplierIdEan;
    }

    if (providor == 'easytobook') {

        if (theViewModel.deviceType() == "phone") {
            // http://www.easytobook.com/?lang=en&amu=280828148&location_name=Bangkok+Thailand
            // http://www.easytobook.com/en/netherlands/north-holland/amsterdam-hotels/?amu=280828148
            suplierLink = "http://www.easytobook.com/" + theViewModel.language() + "/" + locationFromData.Location.SupplierIdEasyToBook + "-hotels/?amu=280828148";
        } else {
            suplierLink = "http://www.easytobook.com/" + theViewModel.language() + "/" + locationFromData.Location.SupplierIdEasyToBook + "-hotels/?amu=280828148";
        }
    }

    if (providor == 'hrs') {

        if (theViewModel.deviceType() == "phone") {
            suplierLink = "http://www.hrs.com/web3ci/?client=" + theViewModel.language() + "__greens&customerId=2pl-com&location=" + locationFromData.Location.SupplierIdHrs;
        } else {
            suplierLink = "http://www.hrs.com/web3ci/?client=" + theViewModel.language() + "__greenm&customerId=2pl-com&location=" + locationFromData.Location.SupplierIdHrs;
        }
    }
    return suplierLink;
}
