window.addEventListener('load', function() {
    var compass = document.getElementById('compass'),
        size = (document.body.offsetWidth/100)*90;

    compass.style.width = compass.style.height = size + 'px';
    compass.style.visibility = 'visible';

    var directions = document.getElementsByClassName('direction');
    for (var i = 0, max = directions.length; i < max; i++) {
        directions[i].style.transform = 'rotateZ(' + (i * 45) + 'deg)';
    }

    var degrees = document.getElementsByClassName('degree');
    for (var i = 0, max = degrees.length; i < max; i++) {
        degrees[i].style.transform = 'rotateZ(' + (i * 30) + 'deg)';
    }
});

var face = document.getElementById('face'),
    deg = document.getElementById('degrees');

if (window.DeviceOrientationEvent) {
    window.addEventListener('deviceorientation', orientation, false);
} else {
    deg.innerHTML = '<p>Sorry, device not supported!</p>';
}

function orientation(event) {
    // compass direction facing in degrees
    var degree = Math.round(event.alpha);

    face.style.transform = 'rotate(-' + degree + 'deg)';
    deg.innerHTML = degree + ' &deg;';
}