/*! jquery.pep.js // Brian Gonzalez - @brianmgonzalez // v0.6.0 // 2014-04-10 */
(function(a,b,c){"use strict";var d="pep";var e={initiate:function(){},start:function(){},drag:function(){},stop:function(){},rest:function(){},moveTo:false,callIfNotStarted:["stop","rest"],startThreshold:[0,0],grid:[1,1],debug:false,activeClass:"pep-active",multiplier:1,velocityMultiplier:2.5,shouldPreventDefault:true,allowDragEventPropagation:true,stopEvents:"",hardwareAccelerate:true,useCSSTranslation:true,disableSelect:true,cssEaseString:"cubic-bezier(0.190, 1.000, 0.220, 1.000)",cssEaseDuration:1e3,shouldEase:true,droppable:false,droppableActiveClass:"pep-dpa",overlapFunction:false,constrainTo:false,removeMargins:true,place:true,deferPlacement:false,axis:null,forceNonCSS3Movement:false,elementsWithInteraction:"input",revert:false,revertAfter:"stop",revertIf:function(){return true},ignoreRightClick:true};function f(b,c){this.name=d;this.el=b;this.$el=a(b);this.options=a.extend({},e,c);this.$document=a(this.$el[0].ownerDocument);this.$body=this.$document.find("body");this.moveTrigger="MSPointerMove touchmove mousemove";this.startTrigger="MSPointerDown touchstart mousedown";this.stopTrigger="MSPointerUp touchend mouseup";this.startTriggerArray=this.startTrigger.split(" ");this.moveTriggerArray=this.moveTrigger.split(" ");this.stopTriggerArray=this.stopTrigger.split(" ");this.stopEvents=[this.stopTrigger,this.options.stopEvents].join(" ");if(this.options.constrainTo==="window")this.$container=this.$document;else if(this.options.constrainTo&&this.options.constrainTo!=="parent")this.$container=a(this.options.constrainTo);else this.$container=this.$el.parent();if(this.isPointerEventCompatible())this.applyMSDefaults();this.CSSEaseHash=this.getCSSEaseHash();this.scale=1;this.started=false;this.disabled=false;this.activeDropRegions=[];this.resetVelocityQueue();this.init()}f.prototype.init=function(){if(this.options.debug)this.buildDebugDiv();if(this.options.disableSelect)this.disableSelect();if(this.options.place&&!this.options.deferPlacement){this.positionParent();this.placeObject()}this.ev={};this.pos={};this.subscribe()};f.prototype.subscribe=function(){var a=this;this.onStartEvent=function(b){a.handleStart(b)};this.$el.on(this.startTrigger,this.onStartEvent);this.onStartEventOnElementsWithInteraction=function(a){a.stopPropagation()};this.$el.on(this.startTrigger,this.options.elementsWithInteraction,this.onStartEventOnElementsWithInteraction);this.onStopEvents=function(b){a.handleStop(b)};this.$document.on(this.stopEvents,this.onStopEvents);this.onMoveEvents=function(b){a.moveEvent=b};this.$document.on(this.moveTrigger,this.onMoveEvents)};f.prototype.unsubscribe=function(){this.$el.off(this.startTrigger,this.onStartEvent);this.$el.off(this.startTrigger,this.options.elementsWithInteraction,this.onStartEventOnElementsWithInteraction);this.$document.off(this.stopEvents,this.onStopEvents);this.$document.off(this.moveTrigger,this.onMoveEvents)};f.prototype.handleStart=function(b){var c=this;if(this.isValidMoveEvent(b)&&!this.disabled){if(!(this.options.ignoreRightClick&&b.which===3)){if(this.isPointerEventCompatible()&&b.preventManipulation)b.preventManipulation();b=this.normalizeEvent(b);if(this.options.place&&this.options.deferPlacement){this.positionParent();this.placeObject()}this.log({type:"event",event:b.type});if(this.options.hardwareAccelerate&&!this.hardwareAccelerated){this.hardwareAccelerate();this.hardwareAccelerated=true}var d=this.options.initiate.call(this,b,this);if(d===false)return;clearTimeout(this.restTimeout);this.$el.addClass(this.options.activeClass);this.removeCSSEasing();this.startX=this.ev.x=b.pep.x;this.startY=this.ev.y=b.pep.y;this.initialPosition=this.initialPosition||this.$el.position();this.startEvent=this.moveEvent=b;this.active=true;if(this.options.shouldPreventDefault)b.preventDefault();if(!this.options.allowDragEventPropagation)b.stopPropagation();(function e(){if(!c.active)return;c.handleMove();c.requestAnimationFrame(e)})(a,c)}}};f.prototype.handleMove=function(){if(typeof this.moveEvent==="undefined")return;var c=this.normalizeEvent(this.moveEvent);var d=b.parseInt(c.pep.x/this.options.grid[0])*this.options.grid[0];var e=b.parseInt(c.pep.y/this.options.grid[1])*this.options.grid[1];this.addToLIFO({time:c.timeStamp,x:d,y:e});var f,g;if(a.inArray(c.type,this.startTriggerArray)>-1){f=0;g=0}else{f=d-this.ev.x;g=e-this.ev.y}this.dx=f;this.dy=g;this.ev.x=d;this.ev.y=e;if(f===0&&g===0){this.log({type:"event",event:"** stopped **"});return}var h=Math.abs(this.startX-d);var i=Math.abs(this.startY-e);if(!this.started&&(h>this.options.startThreshold[0]||i>this.options.startThreshold[1])){this.started=true;this.$el.addClass("pep-start");this.options.start.call(this,this.startEvent,this)}if(this.options.droppable){this.calculateActiveDropRegions()}var j=this.options.drag.call(this,c,this);if(j===false){this.resetVelocityQueue();return}this.log({type:"event",event:c.type});this.log({type:"event-coords",x:this.ev.x,y:this.ev.y});this.log({type:"velocity"});this.doMoveTo(f,g)};f.prototype.doMoveTo=function(a,b){var c=this.handleConstraint(a,b);var d,e;if(typeof this.options.moveTo==="function"){d=a>=0?"+="+Math.abs(a/this.scale)*this.options.multiplier:"-="+Math.abs(a/this.scale)*this.options.multiplier;e=b>=0?"+="+Math.abs(b/this.scale)*this.options.multiplier:"-="+Math.abs(b/this.scale)*this.options.multiplier;if(this.options.constrainTo){d=c.x!==false?c.x:d;e=c.y!==false?c.y:e}if(this.options.axis==="x")e=c.y;if(this.options.axis==="y")d=c.x;this.options.moveTo.call(this,d,e)}else if(!this.shouldUseCSSTranslation()){d=a>=0?"+="+Math.abs(a/this.scale)*this.options.multiplier:"-="+Math.abs(a/this.scale)*this.options.multiplier;e=b>=0?"+="+Math.abs(b/this.scale)*this.options.multiplier:"-="+Math.abs(b/this.scale)*this.options.multiplier;if(this.options.constrainTo){d=c.x!==false?c.x:d;e=c.y!==false?c.y:e}if(this.options.axis==="x")e=c.y;if(this.options.axis==="y")d=c.x;this.moveTo(d,e)}else{a=a/this.scale*this.options.multiplier;b=b/this.scale*this.options.multiplier;if(this.options.constrainTo){a=c.x===false?a:0;b=c.y===false?b:0}if(this.options.axis==="x")b=0;if(this.options.axis==="y")a=0;this.moveToUsingTransforms(a,b)}};f.prototype.handleStop=function(b){if(!this.active)return;this.log({type:"event",event:b.type});this.active=false;this.$el.removeClass("pep-start").addClass("pep-ease");if(this.options.droppable){this.calculateActiveDropRegions()}if(this.started||!this.started&&a.inArray("stop",this.options.callIfNotStarted)>-1){this.options.stop.call(this,b,this)}if(this.options.shouldEase){this.ease(b,this.started)}else{this.removeActiveClass()}if(this.options.revert&&(this.options.revertAfter==="stop"||!this.options.shouldEase)&&(this.options.revertIf&&this.options.revertIf.call(this))){this.revert()}this.started=false;this.resetVelocityQueue()};f.prototype.ease=function(b,c){var d=this.$el.position();var e=this.velocity();var f=this.dt;var g=e.x/this.scale*this.options.multiplier;var h=e.y/this.scale*this.options.multiplier;var i=this.handleConstraint(g,h,true);if(this.cssAnimationsSupported())this.$el.css(this.getCSSEaseHash());var j=e.x>0?"+="+g:"-="+Math.abs(g);var k=e.y>0?"+="+h:"-="+Math.abs(h);if(this.options.constrainTo){j=i.x!==false?i.x:j;k=i.y!==false?i.y:k}if(this.options.axis==="x")k="+=0";if(this.options.axis==="y")j="+=0";var l=!this.cssAnimationsSupported()||this.options.forceNonCSS3Movement;if(typeof this.options.moveTo==="function"){this.options.moveTo.call(this,j,k)}else{this.moveTo(j,k,l)}var m=this;this.restTimeout=setTimeout(function(){if(m.options.droppable){m.calculateActiveDropRegions()}if(c||!c&&a.inArray("rest",m.options.callIfNotStarted)>-1){m.options.rest.call(m,b,m)}if(m.options.revert&&(m.options.revertAfter==="ease"&&m.options.shouldEase)&&(m.options.revertIf&&m.options.revertIf.call(m))){m.revert()}m.removeActiveClass()},this.options.cssEaseDuration)};f.prototype.normalizeEvent=function(a){a.pep={};if(this.isPointerEventCompatible()||!this.isTouch(a)){if(a.pageX){a.pep.x=a.pageX;a.pep.y=a.pageY}else{a.pep.x=a.originalEvent.pageX;a.pep.y=a.originalEvent.pageY}a.pep.type=a.type}else{a.pep.x=a.originalEvent.touches[0].pageX;a.pep.y=a.originalEvent.touches[0].pageY;a.pep.type=a.type}return a};f.prototype.resetVelocityQueue=function(){this.velocityQueue=new Array(5)};f.prototype.moveTo=function(a,b,c){this.log({type:"delta",x:a,y:b});if(c){this.$el.animate({top:b,left:a},0,"easeOutQuad",{queue:false})}else{this.$el.stop(true,false).css({top:b,left:a})}};f.prototype.moveToUsingTransforms=function(a,b){var c=this.matrixToArray(this.matrixString());if(!this.cssX)this.cssX=this.xTranslation(c);if(!this.cssY)this.cssY=this.yTranslation(c);this.cssX=this.cssX+a;this.cssY=this.cssY+b;this.log({type:"delta",x:a,y:b});c[4]=this.cssX;c[5]=this.cssY;this.translation=this.arrayToMatrix(c);this.transform(this.translation)};f.prototype.transform=function(a){this.$el.css({"-webkit-transform":a,"-moz-transform":a,"-ms-transform":a,"-o-transform":a,transform:a})};f.prototype.xTranslation=function(a){a=a||this.matrixToArray(this.matrixString());return parseInt(a[4],10)};f.prototype.yTranslation=function(a){a=a||this.matrixToArray(this.matrixString());return parseInt(a[5],10)};f.prototype.matrixString=function(){var a=function(a){return!(!a||a==="none"||a.indexOf("matrix")<0)};var b="matrix(1, 0, 0, 1, 0, 0)";if(a(this.$el.css("-webkit-transform")))b=this.$el.css("-webkit-transform");if(a(this.$el.css("-moz-transform")))b=this.$el.css("-moz-transform");if(a(this.$el.css("-ms-transform")))b=this.$el.css("-ms-transform");if(a(this.$el.css("-o-transform")))b=this.$el.css("-o-transform");if(a(this.$el.css("transform")))b=this.$el.css("transform");return b};f.prototype.matrixToArray=function(a){return a.split("(")[1].split(")")[0].split(",")};f.prototype.arrayToMatrix=function(a){return"matrix("+a.join(",")+")"};f.prototype.addToLIFO=function(a){var b=this.velocityQueue;b=b.slice(1,b.length);b.push(a);this.velocityQueue=b};f.prototype.velocity=function(){var a=0;var b=0;for(var c=0;c<this.velocityQueue.length-1;c++){if(this.velocityQueue[c]){a+=this.velocityQueue[c+1].x-this.velocityQueue[c].x;b+=this.velocityQueue[c+1].y-this.velocityQueue[c].y;this.dt=this.velocityQueue[c+1].time-this.velocityQueue[c].time}}return{x:a*this.options.velocityMultiplier,y:b*this.options.velocityMultiplier}};f.prototype.revert=function(){if(this.shouldUseCSSTranslation()){this.moveToUsingTransforms(-this.xTranslation(),-this.yTranslation())}this.moveTo(this.initialPosition.left,this.initialPosition.top)};f.prototype.requestAnimationFrame=function(a){return b.requestAnimationFrame&&b.requestAnimationFrame(a)||b.webkitRequestAnimationFrame&&b.webkitRequestAnimationFrame(a)||b.mozRequestAnimationFrame&&b.mozRequestAnimationFrame(a)||b.oRequestAnimationFrame&&b.mozRequestAnimationFrame(a)||b.msRequestAnimationFrame&&b.msRequestAnimationFrame(a)||b.setTimeout(a,1e3/60)};f.prototype.positionParent=function(){if(!this.options.constrainTo||this.parentPositioned)return;this.parentPositioned=true;if(this.options.constrainTo==="parent"){this.$container.css({position:"relative"})}else if(this.options.constrainTo==="window"&&this.$container.get(0).nodeName!=="#document"&&this.$container.css("position")!=="static"){this.$container.css({position:"static"})}};f.prototype.placeObject=function(){if(this.objectPlaced)return;this.objectPlaced=true;this.offset=this.options.constrainTo==="parent"||this.hasNonBodyRelative()?this.$el.position():this.$el.offset();if(parseInt(this.$el.css("left"),10))this.offset.left=this.$el.css("left");if(parseInt(this.$el.css("top"),10))this.offset.top=this.$el.css("top");if(this.options.removeMargins)this.$el.css({margin:0});this.$el.css({position:"absolute",top:this.offset.top,left:this.offset.left})};f.prototype.hasNonBodyRelative=function(){return this.$el.parents().filter(function(){var b=a(this);return b.is("body")||b.css("position")==="relative"}).length>1};f.prototype.setScale=function(a){this.scale=a};f.prototype.setMultiplier=function(a){this.options.multiplier=a};f.prototype.removeCSSEasing=function(){if(this.cssAnimationsSupported())this.$el.css(this.getCSSEaseHash(true))};f.prototype.disableSelect=function(){this.$el.css({"-webkit-touch-callout":"none","-webkit-user-select":"none","-khtml-user-select":"none","-moz-user-select":"none","-ms-user-select":"none","user-select":"none"})};f.prototype.removeActiveClass=function(){this.$el.removeClass([this.options.activeClass,"pep-ease"].join(" "))};f.prototype.handleConstraint=function(b,d,e){var f=this.$el.position();this.pos.x=f.left;this.pos.y=f.top;var g={x:false,y:false};var h,i,j,k;this.log({type:"pos-coords",x:this.pos.x,y:this.pos.y});if(a.isArray(this.options.constrainTo)){if(this.options.constrainTo[3]!==c&&this.options.constrainTo[1]!==c){i=this.options.constrainTo[1]===false?Infinity:this.options.constrainTo[1];j=this.options.constrainTo[3]===false?-Infinity:this.options.constrainTo[3]}if(this.options.constrainTo[0]!==false&&this.options.constrainTo[2]!==false){h=this.options.constrainTo[2]===false?Infinity:this.options.constrainTo[2];k=this.options.constrainTo[0]===false?-Infinity:this.options.constrainTo[0]}if(this.pos.x+b<j)g.x=j;if(this.pos.y+d<k)g.y=k}else if(typeof this.options.constrainTo==="string"){j=0;k=0;i=this.$container.width()-this.$el.outerWidth();h=this.$container.height()-this.$el.outerHeight();if(this.pos.x+b<0)g.x=0;if(this.pos.y+d<0)g.y=0}if(this.pos.x+b>i)g.x=i;if(this.pos.y+d>h)g.y=h;if(this.shouldUseCSSTranslation()&&e){if(g.x===j&&this.xTranslation())g.x=j-this.xTranslation();if(g.x===i&&this.xTranslation())g.x=i-this.xTranslation();if(g.y===k&&this.yTranslation())g.y=k-this.yTranslation();if(g.y===h&&this.yTranslation())g.y=h-this.yTranslation()}return g};f.prototype.getCSSEaseHash=function(a){if(typeof a==="undefined")a=false;var b;if(a){b=""}else if(this.CSSEaseHash){return this.CSSEaseHash}else{b=["all",this.options.cssEaseDuration+"ms",this.options.cssEaseString].join(" ")}return{"-webkit-transition":b,"-moz-transition":b,"-ms-transition":b,"-o-transition":b,transition:b}};f.prototype.calculateActiveDropRegions=function(){var b=this;this.activeDropRegions.length=0;a.each(a(this.options.droppable),function(c,d){var e=a(d);if(b.isOverlapping(e,b.$el)){e.addClass(b.options.droppableActiveClass);b.activeDropRegions.push(e)}else{e.removeClass(b.options.droppableActiveClass)}})};f.prototype.isOverlapping=function(a,b){if(this.options.overlapFunction){return this.options.overlapFunction(a,b)}var c=a[0].getBoundingClientRect();var d=b[0].getBoundingClientRect();return!(c.right<d.left||c.left>d.right||c.bottom<d.top||c.top>d.bottom)};f.prototype.isTouch=function(a){return a.type.search("touch")>-1};f.prototype.isPointerEventCompatible=function(){return"MSPointerEvent"in b};f.prototype.applyMSDefaults=function(a){this.$el.css({"-ms-touch-action":"none","touch-action":"none","-ms-scroll-chaining":"none","-ms-scroll-limit":"0 0 0 0"})};f.prototype.isValidMoveEvent=function(a){return!this.isTouch(a)||this.isTouch(a)&&a.originalEvent&&a.originalEvent.touches&&a.originalEvent.touches.length===1};f.prototype.shouldUseCSSTranslation=function(){if(this.options.forceNonCSS3Movement)return false;if(typeof this.useCSSTranslation!=="undefined")return this.useCSSTranslation;var a=false;if(!this.options.useCSSTranslation||typeof Modernizr!=="undefined"&&!Modernizr.csstransforms){a=false}else{a=true}this.useCSSTranslation=a;return a};f.prototype.cssAnimationsSupported=function(){if(typeof this.cssAnimationsSupport!=="undefined"){return this.cssAnimationsSupport}if(typeof Modernizr!=="undefined"&&Modernizr.cssanimations){this.cssAnimationsSupport=true;return true}var a=false,b=document.createElement("div"),d="animation",e="",f="Webkit Moz O ms Khtml".split(" "),g="";if(b.style.animationName){a=true}if(a===false){for(var h=0;h<f.length;h++){if(b.style[f[h]+"AnimationName"]!==c){g=f[h];d=g+"Animation";e="-"+g.toLowerCase()+"-";a=true;break}}}this.cssAnimationsSupport=a;return a};f.prototype.hardwareAccelerate=function(){this.$el.css({"-webkit-perspective":1e3,perspective:1e3,"-webkit-backface-visibility":"hidden","backface-visibility":"hidden"})};f.prototype.getMovementValues=function(){return{ev:this.ev,pos:this.pos,velocity:this.velocity()}};f.prototype.buildDebugDiv=function(){var b;if(a("#pep-debug").length===0){b=a("<div></div>");b.attr("id","pep-debug").append("<div style='font-weight:bold; background: red; color: white;'>DEBUG MODE</div>").append("<div id='pep-debug-event'>no event</div>").append("<div id='pep-debug-ev-coords'>event coords: <span class='pep-x'>-</span>, <span class='pep-y'>-</span></div>").append("<div id='pep-debug-pos-coords'>position coords: <span class='pep-x'>-</span>, <span class='pep-y'>-</span></div>").append("<div id='pep-debug-velocity'>velocity: <span class='pep-x'>-</span>, <span class='pep-y'>-</span></div>").append("<div id='pep-debug-delta'>&Delta; movement: <span class='pep-x'>-</span>, <span class='pep-y'>-</span></div>").css({position:"fixed",bottom:5,right:5,zIndex:99999,textAlign:"right",fontFamily:"Arial, sans",fontSize:10,border:"1px solid #DDD",padding:"3px",background:"white",color:"#333"})}var c=this;setTimeout(function(){c.debugElements={$event:a("#pep-debug-event"),$velocityX:a("#pep-debug-velocity .pep-x"),$velocityY:a("#pep-debug-velocity .pep-y"),$dX:a("#pep-debug-delta .pep-x"),$dY:a("#pep-debug-delta .pep-y"),$evCoordsX:a("#pep-debug-ev-coords .pep-x"),$evCoordsY:a("#pep-debug-ev-coords .pep-y"),$posCoordsX:a("#pep-debug-pos-coords .pep-x"),$posCoordsY:a("#pep-debug-pos-coords .pep-y")}},0);a("body").append(b)};f.prototype.log=function(a){if(!this.options.debug)return;switch(a.type){case"event":this.debugElements.$event.text(a.event);break;case"pos-coords":this.debugElements.$posCoordsX.text(a.x);this.debugElements.$posCoordsY.text(a.y);break;case"event-coords":this.debugElements.$evCoordsX.text(a.x);this.debugElements.$evCoordsY.text(a.y);break;case"delta":this.debugElements.$dX.text(a.x);this.debugElements.$dY.text(a.y);break;case"velocity":var b=this.velocity();this.debugElements.$velocityX.text(Math.round(b.x));this.debugElements.$velocityY.text(Math.round(b.y));break}};f.prototype.toggle=function(a){if(typeof a==="undefined"){this.disabled=!this.disabled}else{this.disabled=!a}};a.extend(a.easing,{easeOutQuad:function(a,b,c,d,e){return-d*(b/=e)*(b-2)+c},easeOutCirc:function(a,b,c,d,e){return d*Math.sqrt(1-(b=b/e-1)*b)+c},easeOutExpo:function(a,b,c,d,e){return b===e?c+d:d*(-Math.pow(2,-10*b/e)+1)+c}});a.fn[d]=function(b){return this.each(function(){if(!a.data(this,"plugin_"+d)){var c=new f(this,b);a.data(this,"plugin_"+d,c);a.pep.peps.push(c)}})};a.pep={};a.pep.peps=[];a.pep.toggleAll=function(b){a.each(this.peps,function(a,c){c.toggle(b)})};a.pep.unbind=function(a){var b=a.data("plugin_"+d);if(typeof b==="undefined")return;b.toggle(false);b.unsubscribe();a.removeData("plugin_"+d)}})(jQuery,window);