// Generated by CoffeeScript 1.9.2
(function() {
  define(['NewModel'], function(NewModel) {
    var NewsCollection;
    return NewsCollection = Hubii.CollectionPager.extend({
      model: NewModel,
      url: function() {
        return serverAPI + '/articles';
      },
      params: {
        limit: 20,
        offset: 0,
        page: 1
      },
      initialize: function() {
        _.bindAll(this, 'nextPage');
        this.on('changed_param:page', (function(_this) {
          return function() {
            return _this.fetchMore();
          };
        })(this));
        return hA.events.on('fetch_news', (function(_this) {
          return function() {
            return _this.fetchNewsNear();
          };
        })(this));
      },
      resetAllParams: function() {
        this.params.offset = 0;
        this.params.page = 1;
        this.noMorePages = false;
        delete this.params.bounds;
        delete this.params.country;
        delete this.params.topics;
        return delete this.params.languages;
      },
      parse: function(response) {
        if ((this.params.page != null) && this.params.page > 1) {
          hA.removeInfiniteScrollLoading();
        }
        if (!response || response.errors || response.length === 0) {
          this.noMorePages = true;
          if (this.params.page > 1) {
            hA.events.trigger('no_more_results');
          } else {
            if (this.params.bounds != null) {
              this.fetchNewsNear(true, false);
            }
          }
        }
        this.fetchedLength = response.length;
        return response;
      },
      fetchNewsNear: function(show_loading, withBounds) {
        var bounds, country, ref, ref1;
        if (show_loading == null) {
          show_loading = true;
        }
        if (withBounds == null) {
          withBounds = true;
        }
        if (show_loading) {
          hA.events.trigger('show_loading');
        }
        this.resetAllParams();
        bounds = hA.getBBox();
        country = hA.getCountryCode();
        this.params.offset = (this.params.page - 1) * this.params.limit;
        if ((bounds != null) && withBounds) {
          this.params.bounds = bounds;
        } else if (country != null) {
          this.params.country = country;
        }
        if ((ref = hA.filter_categories) != null ? ref.length : void 0) {
          this.params.topics = hA.filter_categories.toString();
        }
        if ((ref1 = hA.filter_languages) != null ? ref1.length : void 0) {
          this.params.languages = hA.filter_languages.toString();
        }
        console.log('query: fetchingNewsNear ' + JSON.stringify(this.params));
        return this.fetch({
          reset: true,
          data: this.paramsToUrl(),
          error: (function(_this) {
            return function() {
              _this.ajaxRequest = null;
              console.log('error! fetchingNewsNear');
              return _this.fetchNewsNear(true, false);
            };
          })(this),
          sucess: function() {
            return console.log('sucess! fetchedNewsNear');
          }
        });
      }
    });
  });

}).call(this);
