// Generated by CoffeeScript 1.9.2
(function() {
  define(['NewModel'], function(NewModel) {
    var PublicationNewsCollection;
    return PublicationNewsCollection = Hubii.CollectionPager.extend({
      model: NewModel,
      params: {
        limit: 20,
        page: 1,
        offset: 0
      },
      url: function() {
        return serverAPI + "/publications/" + this.params.publicationId + "/articles";
      },
      initialize: function() {
        _.bindAll(this, 'nextPage');
        this.on('changed_param:publicationId', (function(_this) {
          return function() {
            return _this.fetchNewsPublication();
          };
        })(this));
        return this.on('changed_param:page', (function(_this) {
          return function() {
            return _this.fetchMore();
          };
        })(this));
      },
      resetAllParams: function() {
        this.params.offset = 0;
        this.params.page = 1;
        this.noMorePages = false;
        delete this.params.languages;
        return delete this.params.topics;
      },
      fetchNewsPublication: function(show_loading) {
        var ref, ref1;
        if (show_loading == null) {
          show_loading = true;
        }
        if (show_loading) {
          hA.events.trigger('show_loading');
        }
        this.resetAllParams();
        if ((ref = hA.filter_categories) != null ? ref.length : void 0) {
          this.params.topics = hA.filter_categories.toString();
        }
        if ((ref1 = hA.filter_languages) != null ? ref1.length : void 0) {
          this.params.languages = hA.filter_languages.toString();
        }
        console.log('query: fetchNewsPublication ' + JSON.stringify(this.params));
        return this.fetch({
          add: true,
          reset: true,
          data: this.params,
          error: function() {
            return console.log('error! fetchNewsPublication');
          },
          sucess: function() {
            return console.log('sucess! fetchNewsPublication');
          }
        });
      }
    });
  });

}).call(this);
