// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var PublicationsCollection;
    return PublicationsCollection = Hubii.CollectionPager.extend({
      url: serverAPI + '/publications',
      params: {
        bounds: '39.335493,-0.537152,43.246329,4.730792',
        page: 1,
        limit: 50,
        info: 1,
        offset: 0
      },
      initialize: function() {
        _.bindAll(this, 'nextPage');
        this.on('changed_param:page', (function(_this) {
          return function() {
            return _this.fetchMore();
          };
        })(this));
        hA.events.on('fetch_publication', (function(_this) {
          return function(id) {
            return _this.fetchPublication(id);
          };
        })(this));
        hA.events.on('fetch_publications', (function(_this) {
          return function() {
            return _this.fetchPublications();
          };
        })(this));
        hA.events.on('selected_new_location', (function(_this) {
          return function() {
            return _this.fetchPublications();
          };
        })(this));
        return hA.events.on('get_publications_info', (function(_this) {
          return function() {
            return _this.fetchPublicationsInfo();
          };
        })(this));
      },
      parse: function(response) {
        if ((this.params.page != null) && this.params.page > 1) {
          hA.removeInfiniteScrollLoading();
        }
        if (!response || response.errors || response.length === 0) {
          this.noMorePages = true;
          if (this.params.page > 1) {
            hA.events.trigger('no_more_results');
          } else {
            if (this.params.bounds != null) {
              this.fetchPublications(false);
            }
          }
        }
        this.fetchedLength = response.length;
        return response;
      },
      resetAllParams: function() {
        this.params.offset = 0;
        this.params.info = 1;
        this.params.page = 1;
        this.noMorePages = false;
        delete this.params.bounds;
        return delete this.params.country;
      },
      fetchPublicationsInfo: function() {
        var ref;
        if ((((ref = hA.user_subscriptions) != null ? ref.Publications : void 0) != null) && hA.user_subscriptions.Publications.length) {
          return $.ajax({
            url: serverURL + '/getpublicationsinfo/',
            crossDomain: true,
            beforeSend: function(xhr) {
              xhr.withCredentials = true;
              if (hA.user_cookie != null) {
                return xhr.setRequestHeader("Cookie", hA.user_cookie);
              }
            },
            success: function(publications_info) {
              return hA.events.trigger('got_publications_info', publications_info);
            },
            error: function() {
              return hA.events.trigger('got_publications_info', {});
            }
          });
        } else {
          return hA.events.trigger('got_publications_info', {});
        }
      },
      fetchPublication: function(id) {
        var cachedPublication;
        cachedPublication = lscache.get("publication" + id);
        if (cachedPublication) {
          return hA.events.trigger('put_publication', cachedPublication);
        } else {
          return $.ajax({
            url: "http://api.hubii.com/publications/" + id,
            success: function(info) {
              if (info.id != null) {
                lscache.set("publication" + info.id, info, 2000);
                return hA.events.trigger('put_publication', info);
              }
            }
          });
        }
      },
      fetchPublications: function(withBounds) {
        var bounds, country;
        if (withBounds == null) {
          withBounds = true;
        }
        this.resetAllParams();
        bounds = hA.getBBox();
        country = hA.getCountryCode();
        if ((bounds != null) && withBounds) {
          this.params.bounds = bounds;
        } else if (country != null) {
          this.params.country = country;
        }
        console.log('query: fetchPublications ' + JSON.stringify(this.params));
        return this.fetch({
          data: this.paramsToUrl(),
          reset: true,
          error: (function(_this) {
            return function() {
              console.log('error! fetchPublications');
              _this.ajaxRequest = null;
              return _this.fetchPublications(false);
            };
          })(this),
          success: (function(_this) {
            return function() {
              _this.setNew();
              hA.events.trigger('fetch_news');
              return console.log('sucess! fetchPublications');
            };
          })(this)
        });
      }
    });
  });

}).call(this);
