// Generated by CoffeeScript 1.9.2
(function() {
  define(['NewModel'], function(NewModel) {
    var SearchCollection;
    return SearchCollection = Hubii.CollectionPager.extend({
      model: NewModel,
      url: function() {
        return serverAPI + '/search/' + this.params.keyword;
      },
      params: {
        limit: 20,
        page: 1
      },
      initialize: function() {
        _.bindAll(this, 'nextPage');
        this.on('changed_param:page', (function(_this) {
          return function() {
            return _this.fetchMore();
          };
        })(this));
        hA.events.on('fetch_trend', (function(_this) {
          return function(trend, bounds, country) {
            if (country == null) {
              country = null;
            }
            return _this.fetchTrend(trend, bounds, country);
          };
        })(this));
        return this.on('changed_param:keyword', (function(_this) {
          return function() {
            return _this.fetchNewsForKeyword();
          };
        })(this));
      },
      resetAllParams: function() {
        this.params.page = 1;
        this.noMorePages = false;
        delete this.params.bounds;
        delete this.params.ISO3166;
        delete this.params.topics;
        return delete this.params.languages;
      },
      fetchTrend: function(trend, bounds, country) {
        var ref, ref1;
        this.resetAllParams();
        if (bounds != null) {
          this.params.bounds = bounds;
        } else if (country != null) {
          this.params.ISO3166 = country;
        }
        this.params.keyword = trend;
        if ((ref = hA.filter_categories) != null ? ref.length : void 0) {
          this.params.topics = hA.filter_categories.toString();
        }
        if ((ref1 = hA.filter_languages) != null ? ref1.length : void 0) {
          this.params.languages = hA.filter_languages.toString();
        }
        if (hA.hasUserLocation()) {
          this.params.userlatlng = hA.userlocation.lat + ',' + hA.userlocation.lng;
          if (hA.userlocation.country_code != null) {
            this.params.usercountry = hA.userlocation.country_code;
          }
        }
        console.log('query: fetchTrend ' + JSON.stringify(this.params));
        return this.fetch({
          add: true,
          reset: true,
          data: this.params,
          error: function() {
            return console.log('error! fetchNewsForKeyword');
          },
          success: function() {
            return console.log('sucess! fetchNewsForKeyword');
          }
        });
      },
      fetchNewsForKeyword: function() {
        var bounds, country, ref, ref1;
        this.resetAllParams();
        bounds = hA.getBBox();
        country = hA.getCountryCode();
        if (bounds != null) {
          this.params.bounds = bounds;
        } else if (country != null) {
          this.params.ISO3166 = country;
        }
        if ((ref = hA.filter_categories) != null ? ref.length : void 0) {
          this.params.topics = hA.filter_categories.toString();
        }
        if ((ref1 = hA.filter_languages) != null ? ref1.length : void 0) {
          this.params.languages = hA.filter_languages.toString();
        }
        if (hA.hasUserLocation()) {
          this.params.userlatlng = hA.userlocation.lat + ',' + hA.userlocation.lng;
          if (hA.userlocation.country_code != null) {
            this.params.usercountry = hA.userlocation.country_code;
          }
        }
        console.log('query: fetchNewsForKeyword ' + JSON.stringify(this.params));
        return this.fetch({
          add: true,
          reset: true,
          data: this.params,
          error: function() {
            return console.log('error! fetchNewsForKeyword');
          },
          success: function() {
            return console.log('sucess! fetchNewsForKeyword');
          }
        });
      }
    });
  });

}).call(this);
