// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var TrendModel, TrendsCollection;
    TrendModel = Hubii.Model.extend({
      defaults: {
        Keyword: String,
        Images: Array
      }
    });
    return TrendsCollection = Hubii.Collection.extend({
      model: TrendModel,
      url: serverAPI + '/trends',
      params: {
        bounds: String
      },
      initialize: function() {
        hA.events.on('fetch_trends', (function(_this) {
          return function() {
            return _this.fetchTrends();
          };
        })(this));
        return hA.events.on('selected_new_location', (function(_this) {
          return function() {
            return _this.fetchTrends();
          };
        })(this));
      },
      resetAllParams: function() {
        this.params.page = 1;
        this.noMorePages = false;
        delete this.params.bounds;
        return delete this.params.country;
      },
      parse: function(trends) {
        if ((trends != null) && trends.length) {
          this.fetchedLength = trends.length;
          return trends;
        } else {
          if (this.params.bounds != null) {
            return this.fetchTrends(false);
          } else if (this.params.country != null) {
            return this.fetchTrends(false, false);
          } else {
            trends = 0;
            return [];
          }
        }
      },
      fetchTrends: function(withBounds, withCountry) {
        var bounds, country;
        if (withBounds == null) {
          withBounds = true;
        }
        if (withCountry == null) {
          withCountry = true;
        }
        this.resetAllParams();
        bounds = hA.getBBox();
        country = hA.getCountryCode();
        if ((bounds != null) && withBounds) {
          this.params.bounds = bounds;
        } else if ((country != null) && withCountry) {
          this.params.country = country;
        }
        console.log('query: fetchTrends ' + JSON.stringify(this.params));
        return this.fetch({
          data: this.paramsToUrl(),
          reset: true,
          error: (function(_this) {
            return function() {
              console.log('error! fetchTrends');
              _this.ajaxRequest = null;
              return _this.fetchTrends(false);
            };
          })(this),
          success: function() {
            return console.log('sucess! fetchTrends');
          }
        });
      }
    });
  });

}).call(this);
