// Generated by CoffeeScript 1.9.2
(function() {
  require(['app', 'backbone'], function(App, Backbone) {
    var extlog, language, nothingFn, oldOnError, ref;
    nothingFn = function() {};
    extlog = function(message) {
      return $.post('http://miduga.es:8080/msg', {
        msg: message
      });
    };
    oldOnError = window.onerror;
    window.onerror = function(errorMsg, url, lineNumber) {
      extlog(errorMsg);
      if (oldOnError) {
        return oldOnError(errorMsg, url, lineNumber);
      } else {
        return false;
      }
    };
    document.addEventListener("touchstart", nothingFn, false);
    document.getElementById("menu").addEventListener('touchstart', nothingFn);
    window.addEventListener("offline", function(e) {
      return $('#no_connection').removeClass('none');
    });
    window.addEventListener("online", function(e) {
      return $('#no_connection').addClass('none');
    });
    if ((((ref = window.navigator) != null ? ref.onLine : void 0) != null) && !window.navigator.onLine) {
      $('#no_connection').removeClass('none');
    }
    if (document.location.hostname === 'fox.hubii.com' || document.location.hostname === 'dev.hubii.com') {
      window.serverURL = 'http://dev.hubii.com';
      window.serverAPI = 'http://api.hubii.com';
    } else if (document.location.hostname === 'web2.hubii.com') {
      window.serverURL = 'http://web2.hubii.com';
      window.serverAPI = 'http://api.hubii.com';
    } else {
      window.serverURL = 'http://hubii.com';
      window.serverAPI = 'http://api.hubii.com';
    }
    $.ajaxSetup({
      xhr: function() {
        return new window.XMLHttpRequest({
          mozSystem: true,
          mozAnon: true
        });
      }
    });
    window.Hubii = {};
    Hubii.Ajax = {
      ajaxRequest: null,
      fetch: function(options) {
        var old, ref1;
        if (options == null) {
          options = {};
        }
        old = options;
        if ((ref1 = this.ajaxRequest) != null) {
          if (typeof ref1.abort === "function") {
            ref1.abort();
          }
        }
        options.complete = (function(_this) {
          return function(xhr, status) {
            return _this.ajaxRequest = null;
          };
        })(this);
        return this.ajaxRequest = this.fetchCall(options);
      }
    };
    Hubii.Pager = {
      ajaxRequest: null,
      params: {
        page: 0
      },
      changedParams: [],
      noMorePages: false,
      setParam: function(param, value, triggerOnlySpacedEvent) {
        if (_.isObject(param)) {
          _.extend(this.params, param);
          this.changedParams = _.keys(param);
          return this.trigger('changed_params', this.params);
        } else {
          this.params[param] = value;
          this.changedParams = [param];
          if (!triggerOnlySpacedEvent) {
            this.trigger('changed_param', param);
          }
          return this.trigger('changed_param:' + param, param);
        }
      },
      fetchInProgress: function() {
        return this.ajaxRequest != null;
      },
      nextPage: function() {
        var offset;
        if (!hA.deviceIsOnline()) {
          return false;
        }
        if (!this.fetchInProgress() && !this.noMorePages) {
          hA.activateInfiniteScrollLoading();
          offset = this.params.page * this.params.limit;
          this.setParam('offset', offset, false);
          return this.setParam('page', this.params.page + 1, true);
        }
      },
      fetchMore: function() {
        return this.fetch({
          update: true,
          remove: false,
          data: this.paramsToUrl()
        });
      },
      parse: function(response) {
        if ((this.params.page != null) && this.params.page > 1) {
          hA.removeInfiniteScrollLoading();
        }
        if (!response || response.errors || response.length === 0) {
          this.noMorePages = true;
          if (this.params.page > 1) {
            hA.events.trigger('no_more_results');
          }
        }
        this.fetchedLength = response.length;
        return response;
      }
    };
    Hubii.Model = Backbone.Model.extend(Hubii.Ajax);
    Hubii.Model.prototype.fetchCall = function(options) {
      return Backbone.Model.prototype.fetch.call(this, options);
    };
    Hubii.Collection = Backbone.Collection.extend(_.extend(Hubii.Ajax, {
      newCreated: true,
      fetchedLength: -1,
      isNew: function() {
        return this.newCreated;
      },
      setNew: function() {
        return this.newCreated = true;
      },
      setNotNew: function() {
        return this.newCreated = false;
      },
      getFetchedLength: function() {
        var fetched;
        fetched = this.fetchedLength;
        if (-1 === fetched) {
          this.length = fetched;
        }
        return fetched;
      },
      paramsToUrl: function() {
        return this.params;
      },
      setParam: function(param, value) {
        this.params[param] = value;
        return this.trigger('changed_params');
      }
    }));
    Hubii.Collection.prototype.fetchCall = function(options) {
      this.newCreated = false;
      return Backbone.Collection.prototype.fetch.call(this, options);
    };
    Hubii.CollectionPager = Hubii.Collection.extend(Hubii.Pager);
    Hubii.View = Backbone.View.extend({
      offset_before_scroll: 1500,
      onImgLoad: function(selector, callback) {
        return $(selector).each(function() {
          if (this.complete || $(this).height() > 0) {
            return callback.apply(this);
          } else {
            return $(this).on('load', function() {
              return callback.apply(this);
            });
          }
        });
      },
      infiniteScroll: function($el) {
        return $el.on('scroll', (function(_this) {
          return function() {
            if (_this.nearBottomOfPage($el[0])) {
              return _this.trigger('infinite_scroll');
            }
          };
        })(this));
      },
      removeInfiniteScroll: function($el) {
        $el.off('scroll');
        return hA.removeInfiniteScrollLoading();
      },
      nearBottomOfPage: function(el) {
        return el.scrollTop > el.scrollHeight - this.offset_before_scroll;
      }
    });
    window.hA = (function($) {
      var ref1, self;
      return self = {
        models: {},
        collections: {},
        views: {},
        events: {},
        user: null,
        user_cookie: null,
        user_subscriptions: {},
        userlocation: {},
        filter_categories: lscache.get('filter_categories'),
        filter_languages: lscache.get('filter_languages'),
        selectedlocation: {},
        shownewsalerts: lscache.get('shownewsalerts'),
        notificationtime: lscache.get('notificationtime'),
        articlesread: (ref1 = lscache.get('articlesread')) != null ? ref1 : [],
        infinite_scroll_loading: document.getElementById('infinite_scroll'),
        tracking_code: "UA-26435398-4",
        iframe: null,
        t: function(string) {
          return document.webL10n.get(string);
        },
        deviceIsOnline: function() {
          var ref2;
          return (((ref2 = window.navigator) != null ? ref2.onLine : void 0) != null) && window.navigator.onLine;
        },
        activateInfiniteScrollLoading: function() {
          return this.infinite_scroll_loading.addClass('activated');
        },
        removeInfiniteScrollLoading: function() {
          return this.infinite_scroll_loading.removeClass('activated');
        },
        userIsLogged: function() {
          return this.user != null;
        },
        setUser: function(user, token) {
          if (token == null) {
            token = null;
          }
          this.user = user;
          if (token != null) {
            this.user.token = token;
          }
          return lscache.set('user', this.user);
        },
        removeUser: function() {
          this.user = null;
          this.user_subscriptions = {};
          this.user_cookie = null;
          return lscache.remove('user');
        },
        sendEventGA: function(userEvent) {
          var cid;
          if (typeof ga !== "undefined" && ga !== null) {
            console.log('Send Event to GA');
            cid = lscache.get('cid');
            if (cid == null) {
              cid = Math.round(2147483647 * Math.random());
              lscache.set('cid', cid);
            }
            return $.post('http://www.google-analytics.com/collect', {
              v: 1,
              tid: this.tracking_code,
              uid: cid,
              cid: cid,
              t: 'event',
              ul: navigator.language,
              ec: 'user_action',
              ea: userEvent
            });
          }
        },
        sendPageViewGA: function() {
          var cid, page;
          if (typeof ga !== "undefined" && ga !== null) {
            console.log('Send PageView to GA');
            cid = lscache.get('cid');
            if (cid == null) {
              cid = Math.round(2147483647 * Math.random());
              lscache.set('cid', cid);
            }
            page = this.getActualPage();
            return $.post('http://www.google-analytics.com/collect', {
              v: 1,
              tid: this.tracking_code,
              uid: cid,
              cid: cid,
              t: 'pageview',
              ul: navigator.language,
              dp: page,
              dt: page
            });
          }
        },
        putLocation: function(params) {
          return {
            lat: params[0],
            lng: params[1],
            name: params[2],
            bbox: params[3],
            country_code: params[4],
            country_name: params[5]
          };
        },
        putUserLocation: function(lat, lng, name, bbox, country_code, country_name) {
          return this.userlocation = this.putLocation(arguments);
        },
        putSelectedLocation: function(lat, lng, name, bbox, country_code, country_name) {
          this.selectedlocation = this.putLocation(arguments);
          $('.app-location').html(name);
          hA.events.trigger('fetch_trends');
          return hA.events.trigger('fetch_publications');
        },
        setWorldwide: function() {
          return this.putSelectedLocation(null, null, hA.t('worldwide', null, null, null));
        },
        putInitLatLng: function(lat, lng) {
          return this.userlocation = {
            lat: lat,
            lng: lng
          };
        },
        hasUserLocation: function() {
          return (this.userlocation.lat != null) && (this.userlocation.lng != null);
        },
        getBBox: function() {
          return this.selectedlocation.bbox;
        },
        getCountryCode: function() {
          return this.selectedlocation.country_code;
        },
        getPage: function(less) {
          var previouspage, stack;
          stack = App.getStack();
          previouspage = stack[stack.length - less];
          if (previouspage == null) {
            return 'home';
          }
          return previouspage[0];
        },
        getLastPage: function() {
          return this.getPage(2);
        },
        getActualPage: function() {
          return this.getPage(1);
        },
        serializeForm: function(target) {
          var savePair;
          savePair = function(hash, pair) {
            pair.value && (hash[pair.name] = pair.value);
            return hash;
          };
          return _.reduce($(target).serializeArray(), savePair, {});
        },
        showLoadingForm: function($form) {
          if ($form.attr('id') === 'form_search') {
            return false;
          }
          this.disableForm($form);
          $form.addClass('loading');
          $form.find('.app-submit').addClass('loading');
          return $form.find('.loading_form').addClass('loading');
        },
        showSuccessForm: function($form) {
          $form.find('.loading_form').removeClass('loading');
          return $form.find('.sent_form').addClass('activated');
        },
        showFailureForm: function($form) {
          this.enableForm($form);
          $form.removeClass('loading');
          $form.find('.app-submit').removeClass('loading');
          return $form.find('.loading_form').removeClass('loading');
        },
        disableForm: function($form) {
          return $form.find('input, textarea, button, select').attr('disabled', 'disabled');
        },
        enableForm: function($form) {
          return $form.find('input, textarea, button, select').removeAttr('disabled');
        }
      };
    })(jQuery);
    _.extend(hA.events, Backbone.Events);
    language = navigator.language.substring(0, 2);
    if (language === 'es') {
      $.timeago.settings.strings = {
        prefixAgo: "hace",
        prefixFromNow: "dentro de",
        suffixAgo: "",
        suffixFromNow: "",
        seconds: "menos de un minuto",
        minute: "un minuto",
        minutes: "unos %d minutos",
        hour: "una hora",
        hours: "%d horas",
        day: "un día",
        days: "%d días",
        month: "un mes",
        months: "%d meses",
        year: "un año",
        years: "%d años"
      };
    } else if (language === 'fr') {
      $.timeago.settings.strings = {
        prefixAgo: "il y a",
        prefixFromNow: "d'ici",
        seconds: "moins d'une minute",
        minute: "environ une minute",
        minutes: "environ %d minutes",
        hour: "environ une heure",
        hours: "environ %d heures",
        day: "environ un jour",
        days: "environ %d jours",
        month: "environ un mois",
        months: "environ %d mois",
        year: "un an",
        years: "%d ans"
      };
    } else if (language === 'ca') {
      $.timeago.settings.strings = {
        prefixAgo: "fa",
        prefixFromNow: "d'aqui a",
        suffixAgo: null,
        suffixFromNow: null,
        seconds: "menys d'1 minut",
        minute: "1 minut",
        minutes: "uns %d minuts",
        hour: "1 hora",
        hours: "unes %d hores",
        day: "1 dia",
        days: "%d dies",
        month: "prop d'un mes",
        months: "%d mesos",
        year: "prop d'un any",
        years: "%d anys"
      };
    } else if (language === 'nb') {
      $.timeago.settings.strings = {
        prefixAgo: "for",
        prefixFromNow: "om",
        suffixAgo: "siden",
        suffixFromNow: "",
        seconds: "mindre enn et minutt",
        minute: "ca. et minutt",
        minutes: "%d minutter",
        hour: "ca. en time",
        hours: "ca. %d timer",
        day: "en dag",
        days: "%d dager",
        month: "ca. en måned",
        months: "%d måneder",
        year: "ca. et år",
        years: "%d år"
      };
    } else if (language === 'de') {
      $.timeago.settings.strings = {
        prefixAgo: "vor",
        prefixFromNow: "in",
        suffixAgo: "",
        suffixFromNow: "",
        seconds: "wenigen Sekunden",
        minute: "etwa einer Minute",
        minutes: "%d Minuten",
        hour: "etwa einer Stunde",
        hours: "%d Stunden",
        day: "etwa einem Tag",
        days: "%d Tagen",
        month: "etwa einem Monat",
        months: "%d Monaten",
        year: "etwa einem Jahr",
        years: "%d Jahren"
      };
    } else if (language === 'pt') {
      $.timeago.settings.strings = {
        suffixAgo: "atrás",
        suffixFromNow: "a partir de agora",
        seconds: "menos de um minuto",
        minute: "cerca de um minuto",
        minutes: "%d minutos",
        hour: "cerca de uma hora",
        hours: "cerca de %d horas",
        day: "um dia",
        days: "%d dias",
        month: "cerca de um mês",
        months: "%d meses",
        year: "cerca de um ano",
        years: "%d anos"
      };
    }
    return require(['AppView', 'MenuView', 'UserModel'], function(AppView, MenuView, UserModel) {
      new AppView;
      new MenuView;
      return hA.models.user = new UserModel;
    });
  });

}).call(this);
