// Generated by CoffeeScript 1.9.2
(function() {
  define(['LatestNewsView', 'NewsCollection', 'PublicationsView', 'PublicationsCollection', 'ArticleView', 'TrendsCollection', 'TrendsView', 'SettingsView', 'SearchCollection', 'SearchNewsView', 'LocationsView', 'PublicationNewsView', 'ChangeLocationView', 'NewModel', 'PublicationNewsCollection'], function(LatestNewsView, NewsCollection, PublicationsView, PublicationsCollection, ArticleView, TrendsCollection, TrendsView, SettingsView, SearchCollection, SearchNewsView) {
    var AppView;
    return AppView = Hubii.View.extend({
      initialize: function() {
        var news_collection, publications_collection, search_collection, trends_collection;
        new SettingsView;
        publications_collection = new PublicationsCollection();
        new PublicationsView({
          collection: publications_collection
        });
        news_collection = new NewsCollection();
        new LatestNewsView({
          collection: news_collection,
          publicationsCollection: publications_collection
        });
        new ArticleView;
        trends_collection = new TrendsCollection;
        new TrendsView({
          collection: trends_collection
        });
        search_collection = new SearchCollection;
        hA.views.searchnews = new SearchNewsView({
          collection: search_collection
        });
        this.initForms();
        this.initEvents();
        this.initNotificationsOnFirefox();
        this.initFacebookLogin();
        this.showIntroIfNeeded();
        hA.events.on('got_subscriptions', (function(_this) {
          return function(fireLogin) {
            if (fireLogin == null) {
              fireLogin = false;
            }
            return _this.loadUserNeededViews(fireLogin);
          };
        })(this));
        hA.events.on('trigger_notification', (function(_this) {
          return function() {
            return _this.triggerNotification();
          };
        })(this));
        return App.load('latestnews');
      },
      loadUserNeededViews: function(fireLogin) {
        return require(['ReadLatersView', 'SavedSearchesView', 'SubscriptionsView'], function(ReadLatersView, SavedSearchesView, SubscriptionsView) {
          new ReadLatersView;
          new SavedSearchesView;
          new SubscriptionsView;
          if (fireLogin) {
            return hA.events.trigger('login_finished');
          }
        });
      },
      showIntroIfNeeded: function() {
        var slider_showed;
        console.log("Check if Show Intro is Needed");
        slider_showed = lscache.get('slider_showed');
        if (!slider_showed) {
          return require(['IntroView'], function(IntroView) {
            return new IntroView;
          });
        } else {
          return document.getElementById('intro_app').remove();
        }
      },
      testEmail: function(email) {
        var filter;
        filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return filter.test(email);
      },
      initFacebookLogin: function() {
        var loginDone;
        loginDone = function(e) {
          var cookie, ref, ref1, ref2;
          if (((ref = e.data) != null ? ref.id : void 0) != null) {
            cookie = "PHPSESSID=" + e.data.id;
            hA.user_cookie = cookie;
            if ((((ref1 = e.data) != null ? ref1.user : void 0) != null) && (((ref2 = e.data) != null ? ref2.subscriptions : void 0) != null)) {
              hA.events.trigger('logged_with_facebook', e.data.user, e.data.subscriptions);
              $('#login_facebook_completed').removeClass('none');
              return $('#pre_login').addClass('none');
            } else {
              return window.open('http://hubii.com/auth/by/facebook');
            }
          }
        };
        window.addEventListener("message", loginDone, false);
        return $(document).on('click', '#log_in_with_facebook', function(e) {
          e.preventDefault();
          return window.open('http://hubii.com/auth/by/facebook');
        });
      },
      initForms: function() {
        App.populator('login', (function(_this) {
          return function(page) {
            var $form, $page;
            hA.events.trigger('hide_filters');
            $page = $(page);
            $form = $page.find('#form-log-in');
            hA.events.on('login_error', function() {
              return $page.find('#form-log-in-message').addClass('error').html(hA.t('wrong_email_password'));
            });
            $form.find('input[type="email"]').attr('placeholder', hA.t('email'));
            $form.find('input[type="password"]').attr('placeholder', hA.t('password'));
            $form.find('#submit-log-in').val(hA.t('log_in'));
            return $form.on('submit', function(e) {
              var data, valid;
              e.preventDefault();
              valid = true;
              $form.find('.no-valid').removeClass('no-valid');
              data = hA.serializeForm($form);
              if ((data.Email == null) || !_this.testEmail(data.Email)) {
                valid = false;
                $('#email-login-form').addClass('no-valid');
              }
              if (data.Password == null) {
                valid = false;
                $('#password-login-form').addClass('no-valid');
              }
              if (valid) {
                hA.models.user.set(data, {
                  silent: true
                });
                return hA.events.trigger('loginUser');
              }
            });
          };
        })(this), function(page) {
          $(page).off('submit', '#form-log-in');
          return hA.events.off('login_error');
        });
        App.populator('register', (function(_this) {
          return function(page) {
            var $form, $page;
            hA.events.trigger('hide_filters');
            $page = $(page);
            $form = $page.find('#form-sign-up');
            hA.events.on('user_registered', function() {
              $page.find('.pre_registration').hide();
              return $page.find('#registration_completed').removeClass('none');
            });
            $form.find('input[type="email"]').attr('placeholder', hA.t('email'));
            $form.find('input[type="password"]').attr('placeholder', hA.t('password'));
            $form.find('#submit-sign-up').val(hA.t('sign_up'));
            return $form.on('submit', function(e) {
              var data, valid;
              e.preventDefault();
              valid = true;
              $form.find('.no-valid').removeClass('no-valid');
              data = hA.serializeForm($form);
              if (data.Name == null) {
                valid = false;
                $('#name-register-form').addClass('no-valid');
              }
              if ((data.Email == null) || !_this.testEmail(data.Email)) {
                valid = false;
                $('#email-register-form').addClass('no-valid');
              }
              if (data.Password == null) {
                valid = false;
                $('#password-register-form').addClass('no-valid');
              }
              if (valid) {
                hA.models.user.set(data, {
                  silent: true
                });
                return hA.events.trigger('registerNewUser');
              }
            });
          };
        })(this), function(page) {
          var $page;
          $page = $(page);
          $page.off('submit', '#form-sign-up');
          return hA.events.off('user_registered');
        });
        App.populator('forgot-password', (function(_this) {
          return function(page) {
            var $form, $page;
            hA.events.trigger('hide_filters');
            $page = $(page);
            $page.on('click', '.back-button', function() {
              return App.back();
            });
            $form = $page.find('#form-password-recovery');
            $form.find('#submit-password-recovery').val(hA.t('submit'));
            $form.find('.first').attr('placeholder', hA.t('email'));
            return $form.on('submit', function(e) {
              var data, valid;
              e.preventDefault();
              valid = true;
              $form.find('.no-valid').removeClass('no-valid');
              data = hA.serializeForm($form);
              if ((data.email == null) || !_this.testEmail(data.email)) {
                valid = false;
                $('#email-password-recovery').addClass('no-valid');
              }
              if (valid) {
                return hA.events.trigger('start_forgot_password', data.email);
              }
            });
          };
        })(this), function(page) {
          var $page;
          $page = $(page);
          $page.off('click', '.back-button');
          return $page.off('submit', '#form-password-recovery');
        });
        App.populator('activation-link', (function(_this) {
          return function(page) {
            var $form, $page;
            hA.events.trigger('hide_filters');
            $page = $(page);
            $page.on('click', '.back-button', function() {
              return App.back();
            });
            $form = $page.find('#form-activation-link');
            $form.find('#submit-activation-link').val(hA.t('submit'));
            $form.find('.first').attr('placeholder', hA.t('email'));
            return $form.on('submit', function(e) {
              var data, valid;
              e.preventDefault();
              valid = true;
              $form.find('.no-valid').removeClass('no-valid');
              data = hA.serializeForm($form);
              if ((data.email == null) || !_this.testEmail(data.email)) {
                valid = false;
                $('#activation-email').addClass('no-valid');
              }
              if (valid) {
                return hA.events.trigger('start_resend_activation', data.email);
              }
            });
          };
        })(this), function(page) {
          var $page;
          $page = $(page);
          $page.off('submit', '#form-activation-link');
          return $page.off('click', '.back-button');
        });
        return App.populator('send-feedback', (function(_this) {
          return function(page) {
            var $form, $page;
            hA.events.trigger('hide_filters');
            $page = $(page);
            $page.on('click', '.back-button', function() {
              return App.back();
            });
            $form = $page.find('#form-send-feedback');
            $form.find('.app-textarea').attr('placeholder', hA.t('feedback_placeholder'));
            $page.find('#input-email-feedback').attr('placeholder', hA.t('your_email_address_optional'));
            $page.find('#submit-send-feedback').val(hA.t('send_feedback'));
            return $form.on('submit', function(e) {
              var data, valid;
              e.preventDefault();
              valid = true;
              $form.find('.no-valid').removeClass('no-valid');
              data = hA.serializeForm($form);
              if (data.comment == null) {
                valid = false;
                $('#comment-feedback').addClass('no-valid');
              }
              if ((data.email != null) && !_this.testEmail(data.email)) {
                valid = false;
                $('#input-email-feedback').addClass('no-valid');
              }
              if (valid) {
                return hA.events.trigger('sendFeedback', data);
              }
            });
          };
        })(this), function(page) {
          var $page;
          $page = $(page);
          $page.off('click', '.back-button');
          return $page.off('submit', '#form-send-feedback');
        });
      },
      initEvents: function() {
        hA.events.on('got_user_location', function(lat, lng, name, bbox, country) {
          if ((country != null) && country) {
            country = country.toLowerCase();
          }
          console.log('[EVENT] Got User Location', lat, lng, name, bbox, country);
          hA.putUserLocation(lat, lng, name, bbox, country);
          hA.putSelectedLocation(null, null, name, bbox, country);
          return $('.app-location').html(hA.userlocation.name);
        });
        return hA.events.on('error_getting_user_position', function() {
          hA.putUserLocation(null, null, hA.t('worldwide'), null, null);
          hA.setWorldwide();
          return $('.app-location').html(hA.t('worldwide'));
        });
      },
      initNotificationsOnFirefox: function() {
        if (navigator.mozAlarms == null) {
          return false;
        }
        this.handlerOfAlarmOnFirefoxOS();
        this.setAlarmOnFirefoxOS();
        return hA.events.on('set_alarm', (function(_this) {
          return function() {
            return _this.setAlarmOnFirefoxOS();
          };
        })(this));
      },
      launchSelf: function() {
        var request;
        request = window.navigator.mozApps.getSelf();
        return request.onsuccess = function() {
          if (request.result) {
            request.result.launch();
            return App.load('trends');
          }
        };
      },
      setAlarmOnFirefoxOS: function() {
        var ref, requestAlarms;
        requestAlarms = (ref = navigator.mozAlarms) != null ? ref.getAll() : void 0;
        if (requestAlarms != null) {
          requestAlarms.onerror = function() {
            return console.log('[ERROR] Getting the alarms');
          };
        }
        if (requestAlarms != null) {
          requestAlarms.onsuccess = function() {
            var nextAlarm;
            if (requestAlarms.result.length) {
              requestAlarms.result.forEach(function(alarm) {
                return navigator.mozAlarms.remove(alarm.id);
              });
            }
            console.log('[ALARM] Setting alarm on Firefox OS');
            nextAlarm = new Date();
            if (hA.notificationtime === null) {
              hA.notificationtime = 12;
            }
            if (nextAlarm.getHours() >= hA.notificationtime) {
              nextAlarm.setDate(nextAlarm.getDate() + 1);
            }
            console.log("[ALARM] Notification Time: " + hA.notificationtime);
            nextAlarm.setHours(hA.notificationtime);
            nextAlarm.setMinutes(0);
            return navigator.mozAlarms.add(nextAlarm, "ignoreTimezone");
          };
        }
        return true;
      },
      createNotification: function(title, msg) {
        var n, options;
        options = {
          body: msg,
          icon: window.location.origin + '/img/ff_app_icon_128x.png'
        };
        n = typeof Notification === "function" ? new Notification(title, options) : void 0;
        return n.onclick = function() {
          var ref;
          return (ref = navigator.mozApps) != null ? ref.getSelf().onsuccess = function(evt) {
            var self;
            self = evt.target.result;
            self.launch();
            return typeof App !== "undefined" && App !== null ? App.load('trends') : void 0;
          } : void 0;
        };
      },
      triggerNotification: function() {
        var country, url;
        country = hA.getCountryCode();
        url = "http://api.hubii.com/trends?limit=5";
        if (country) {
          url += "&country=" + country;
        }
        return $.get(url, (function(_this) {
          return function(data) {
            var trends_labels;
            if (data) {
              trends_labels = _.map(data, function(n) {
                var str;
                str = n.Label;
                return str.substring(0, 1).toLocaleUpperCase() + str.substring(1);
              });
              trends_labels = trends_labels.join(' , ');
              return _this.createNotification(hA.t('trends_title_notification'), trends_labels);
            }
          };
        })(this));
      },
      handlerOfAlarmOnFirefoxOS: function() {
        return typeof navigator.mozSetMessageHandler === "function" ? navigator.mozSetMessageHandler("alarm", (function(_this) {
          return function(mozAlarm) {
            var context, request;
            context = _this;
            request = navigator.mozAlarms.getAll();
            request.onsuccess = function() {
              this.result.forEach(function(alarm) {
                return navigator.mozAlarms.remove(alarm.id);
              });
              return context.setAlarmOnFirefoxOS();
            };
            if (hA.shownewsalerts || hA.shownewsalerts === null) {
              return _this.triggerNotification();
            }
          };
        })(this)) : void 0;
      }
    });
  });

}).call(this);
