// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var ArticleView;
    return ArticleView = Hubii.View.extend({
      title: null,
      url: null,
      el: null,
      currentAjaxCall: null,
      bg: $(document.getElementById('bg_overlay')),
      tmplArticle: function(j) {
        return "<article id='single_article'> <h1 id='single_article_title'>" + j.title + "</h1> " + j.content + " <a href='#' class='hubii-button open-url-on-hubii-app blue' rel='" + j.url + "'>Read original</a> </article>";
      },
      tmplError: function(j) {
        return "<article id='no-news'> <img src='img/no_general.png' width='160' height='120' /> <p id='no-phrase'></p> <a href='#' class='hubii-button open-url-on-hubii-app blue' rel='" + j.url + "'>Read original</a> </article>";
      },
      tmplLoading: function() {
        return '<div id="loading"><img src="img/loading_static.png" width="34" height="34" /></div>';
      },
      initialize: function() {
        hA.events.on('added_readlater', (function(_this) {
          return function(articleId) {
            if (_this.articleId === articleId && (_this.el != null)) {
              return _this.el.find('.added-readlater-button').removeClass('none').end().find('.add-readlater-button').addClass('none');
            }
          };
        })(this));
        hA.events.on('removed_readlater', (function(_this) {
          return function(articleId) {
            if (_this.articleId === articleId && (_this.el != null)) {
              return _this.el.find('.added-readlater-button').addClass('none').end().find('.add-readlater-button').removeClass('none');
            }
          };
        })(this));
        hA.events.on('open_article', (function(_this) {
          return function(articleId, collection) {
            _this.articleId = articleId;
            if (collection != null) {
              _this.collection = collection;
            }
            _this.model = _this.collection.findWhere({
              ArticleId: _this.articleId
            });
            if (hA.getActualPage() !== 'article') {
              App.load('article');
            } else {
              _this.showLoading();
            }
            _this.putPrevAndNextArticles();
            _this.putManageReadLater();
            return _this.getArticleURL();
          };
        })(this));
        return App.populator('article', (function(_this) {
          return function(page) {
            return _this.populate(page);
          };
        })(this), (function(_this) {
          return function() {
            return _this.destructor();
          };
        })(this));
      },
      populate: function(page) {
        this.el = $(page);
        this.action_menu = this.el.find('#action-menu ');
        this.showLoading();
        this.el.on('click', '#close-article', function() {
          return App.back();
        });
        this.el.on('click', '.action-button', (function(_this) {
          return function() {
            return _this.openMenu();
          };
        })(this));
        this.el.on('click', '.right-button', (function(_this) {
          return function(e) {
            return _this.goToArticle(e);
          };
        })(this));
        this.el.on('click', '.left-button', (function(_this) {
          return function(e) {
            return _this.goToArticle(e);
          };
        })(this));
        this.el.on('click', '.open-url-on-hubii-app', (function(_this) {
          return function() {
            return _this.openURL(_this.model.get('URL'), true);
          };
        })(this));
        this.el.on('click', '.share-article-facebook', (function(_this) {
          return function() {
            var url;
            _this.closeMenu();
            url = "https://m.facebook.com/sharer.php?u=" + _this.url;
            return _this.openURL(url, true);
          };
        })(this));
        this.el.on('click', '.share-article-twitter', (function(_this) {
          return function() {
            var url;
            _this.closeMenu();
            url = "https://twitter.com/intent/tweet?url=" + _this.url + "&text=" + _this.title;
            return _this.openURL(url, true);
          };
        })(this));
        this.el.on('click', '.share-article-email', (function(_this) {
          return function() {
            var createEmail, title;
            _this.closeMenu();
            title = _this.title.replace(/&nbsp;/g, "%20");
            return createEmail = new MozActivity({
              name: "new",
              data: {
                type: "mail",
                url: "mailto:?subject=Hubii: " + title + "&body=" + title + ":%0D%0A" + _this.url + "%0D%0A%0D%0AShared from Hubii. http://hubii.com"
              }
            });
          };
        })(this));
        this.el.on('click', '.add-readlater-button', (function(_this) {
          return function(e) {
            return hA.events.trigger('add_readlater', e.currentTarget.getAttribute('rel'));
          };
        })(this));
        this.el.on('click', '.added-readlater-button', (function(_this) {
          return function(e) {
            return hA.events.trigger('remove_readlater', e.currentTarget.getAttribute('rel'));
          };
        })(this));
        this.el.on('appHide', (function(_this) {
          return function() {
            if (_this.bg.hasClass('activated')) {
              return _this.closeMenu();
            }
          };
        })(this));
        return this.el.on('appShow', function() {
          hA.events.trigger('hide_filters');
          return hA.sendPageViewGA();
        });
      },
      destructor: function() {
        this.el.off('click', '#close-article');
        this.el.off('click', '.action-button');
        this.el.off('click', '.right-button');
        this.el.off('click', '.left-button');
        this.el.off('click', '.open-url-on-hubii-app');
        this.el.off('click', '.share-article-facebook, .share-article-twitter');
        this.el.off('click', '.added-readlater-button');
        this.el.off('click', '.add-readlater-button');
        this.el.off('appHide');
        this.el.off('appShow');
        this.cancelAjaxQueryIfNeeded();
        this.el = null;
        return this.action_menu = null;
      },
      getArticleURL: function() {
        return this.model.fetch({
          data: {
            id: this.articleId
          },
          success: (function(_this) {
            return function(model) {
              _this.model = model;
              return _this.loadArticleFromReadibility();
            };
          })(this),
          error: (function(_this) {
            return function() {
              return _this.renderNoArticle();
            };
          })(this)
        });
      },
      putManageReadLater: function() {
        var $addedreadlater, $addreadlater, ArticleId, ref;
        if (hA.userIsLogged()) {
          ArticleId = this.model.get('ArticleId');
          $addreadlater = this.el.find('.add-readlater-button').attr('rel', ArticleId);
          $addedreadlater = this.el.find('.added-readlater-button').attr('rel', ArticleId);
          if ((((ref = hA.user_subscriptions) != null ? ref.Articles : void 0) != null) && _.contains(hA.user_subscriptions.Articles, ArticleId)) {
            $addedreadlater.removeClass('none');
            return $addreadlater.addClass('none');
          } else {
            $addreadlater.removeClass('none');
            return $addedreadlater.addClass('none');
          }
        }
      },
      putPrevAndNextArticles: function() {
        var indexOfCurrent, modelNext, modelPrev;
        indexOfCurrent = this.collection.indexOf(this.model);
        if (this.collection.length === 1) {
          return false;
        } else {
          if (indexOfCurrent + 1 < this.collection.length) {
            modelNext = this.collection.at(indexOfCurrent + 1);
            this.el.find('.right-button').attr('rel', modelNext.get('ArticleId')).removeClass('disabled');
          }
          if (indexOfCurrent > 0) {
            modelPrev = this.collection.at(indexOfCurrent - 1);
            return this.el.find('.left-button').attr('rel', modelPrev.get('ArticleId')).removeClass('disabled');
          }
        }
      },
      putShareLinks: function() {
        this.url = "http://hubii.com/article/" + (this.model.get('ArticleId'));
        return this.title = this.model.get('Header');
      },
      goToArticle: function(e) {
        var articleId;
        e.preventDefault();
        articleId = e.target.getAttribute('rel');
        hA.events.trigger('open_article', articleId);
        return hA.events.trigger('mark_article_as_read', articleId);
      },
      openURL: function(url, mozbrowser) {
        if (mozbrowser == null) {
          mozbrowser = false;
        }
        return App.load('iframe-page', {
          url: url,
          mozbrowser: mozbrowser
        }, 'slide-up');
      },
      renderNoArticle: function(url) {
        var $article;
        if (url == null) {
          url = false;
        }
        $article = this.el.find(document.getElementById('article'));
        return this.hideLoading((function(_this) {
          return function() {
            return $article.html(_this.tmplError({
              url: url
            })).find('#no-phrase').text(hA.t('error_opening_article')).end().find('.open-url-on-hubii-app').text(hA.t('read_original'));
          };
        })(this));
      },
      renderReadabilityArticle: function(html) {
        var $article, article;
        $article = $(document.getElementById('article'));
        article = {
          url: this.model.get('URL'),
          content: html,
          title: this.model.get('Header')
        };
        return this.hideLoading((function(_this) {
          return function() {
            $article.html(_this.tmplArticle(article)).find('.open-url-on-hubii-app').text(hA.t('read_original'));
            return _this.putImageIfNeeded();
          };
        })(this));
      },
      loadArticleFromReadibility: function() {
        var id, url, urlReadability;
        this.putShareLinks();
        id = this.model.get('ArticleId');
        url = this.model.get('URL');
        this.cancelAjaxQueryIfNeeded();
        urlReadability = "https://www.readability.com/api/content/v1/parser?url=" + url + "&token=b3da9c9675b8ce431b60b18150af83715e81c0bc&callback=?";
        return this.loadArticleFromReadibilityServer(urlReadability);
      },
      loadArticleFromReadibilityServer: function(url) {
        var options;
        options = {
          url: url,
          success: (function(_this) {
            return function(html) {
              return _this.renderReadabilityArticle(html.content);
            };
          })(this),
          error: (function(_this) {
            return function() {
              return _this.renderNoArticle(url);
            };
          })(this),
          complete: (function(_this) {
            return function() {
              return _this.cancelAjaxQueryIfNeeded();
            };
          })(this)
        };
        if (document.location.hostname === 'fox.hubii.com' || document.location.hostname === 'dev.hubii.com') {
          options.dataType = 'jsonp';
          options.jsonp = 'callback';
        }
        return this.currentAjaxCall = $.ajax(options);
      },
      hideLoading: function(callback) {
        $(document.getElementById('loading')).remove();
        return typeof callback === "function" ? callback() : void 0;
      },
      cancelAjaxQueryIfNeeded: function() {
        if (this.currentAjaxCall && (this.currentAjaxCall.abort != null)) {
          this.currentAjaxCall.abort();
          return this.currentAjaxCall = null;
        }
      },
      putImageIfNeeded: function() {
        var $article, $articleImgs, image, img_src;
        image = this.model.get('Image');
        $article = this.el.find(document.getElementById('article'));
        $articleImgs = $article.find('img');
        if ((image != null) && image) {
          img_src = image.url;
          if (!$articleImgs.length) {
            $article.prepend("<img id='single_image' src='" + img_src + "' />");
          }
        }
        return this.onImgLoad($articleImgs, function() {
          var $this;
          $this = $(this);
          if ($this.height() >= 100 && $this.width() >= 200) {
            return true;
          } else {
            return $this.remove();
          }
        });
      },
      openMenu: function() {
        this.bg.addClass('activated').one('click', (function(_this) {
          return function() {
            return _this.closeMenu();
          };
        })(this));
        return this.action_menu.addClass('activated').find('.cancel-button').one('click', (function(_this) {
          return function() {
            return _this.closeMenu();
          };
        })(this));
      },
      closeMenu: function() {
        this.action_menu.removeClass('activated').find('.cancel-button').off('click');
        return this.bg.removeClass('activated').off('click');
      },
      showLoading: function() {
        var $loading;
        this.el.find('.right-button').addClass('disabled');
        this.el.find('.left-button').addClass('disabled');
        $loading = $(document.getElementById('loading'));
        if (!$loading.length || $loading.css('opacity' === 0)) {
          $('#single_article').remove();
          $('#single_image').remove();
          $loading.remove();
          return this.el.find('.app-content').append(this.tmplLoading());
        }
      }
    });
  });

}).call(this);
