// Generated by CoffeeScript 1.9.2
(function() {
  define(['LocationsView'], function(LocationsView) {
    var ChangeLocationView;
    return ChangeLocationView = LocationsView.extend({
      initialize: function() {
        return App.populator('change-location', (function(_this) {
          return function(page) {
            return _this.populate(page);
          };
        })(this), (function(_this) {
          return function() {
            return _this.destructor();
          };
        })(this));
      },
      populate: function(page) {
        this.el = $(page);
        this.input = this.el.find('.app-input');
        this.localization();
        this.renderFavLocations();
        this.el.on('click', '.back-button', (function(_this) {
          return function(e) {
            e.preventDefault();
            _this.input.blur();
            return App.back();
          };
        })(this));
        this.el.on('click', '.clean-search-button', (function(_this) {
          return function(e) {
            e.preventDefault();
            _this.input.focus().val('');
            _this.el.find('.clean-search-button').css({
              opacity: 0
            });
            _this.el.find('.location_nominatim').remove();
            return _this.input.focus();
          };
        })(this));
        this.el.on('focus', '.app-input', (function(_this) {
          return function(e) {
            return _this.el.find('.locations').show();
          };
        })(this));
        this.el.on('click', '#nearme', (function(_this) {
          return function(e) {
            _this.input.blur();
            hA.selectedlocation = hA.userlocation;
            return App.back(function() {
              return hA.events.trigger('selected_new_location');
            });
          };
        })(this));
        this.el.on('click', '#worldwide', (function(_this) {
          return function(e) {
            _this.input.blur();
            hA.setWorldwide();
            return App.back(function() {
              return hA.events.trigger('selected_new_location');
            });
          };
        })(this));
        this.el.on('submit', '#form_search', (function(_this) {
          return function(e) {
            e.preventDefault();
            return App.back(function() {
              return _this.selectLocation(_this.el.find('.location').first());
            });
          };
        })(this));
        this.el.on('click', '.location', (function(_this) {
          return function(e) {
            return App.back(function() {
              return _this.selectLocation($(e.currentTarget));
            });
          };
        })(this));
        this.el.on('appShow', (function(_this) {
          return function() {
            hA.events.trigger('hide_filters');
            _this.el.find('.app-input').focus();
            return hA.sendPageViewGA();
          };
        })(this));
        this.input.on('keypress', (function(_this) {
          return function(e) {
            if (e.which === 13) {
              e.stopPropagation();
              e.preventDefault();
              return _this.el.find('#form_search').submit();
            }
          };
        })(this));
        return this.input.on('input', (function(_this) {
          return function(e) {
            return _this.getAutocompleteLocations(_this.input.val());
          };
        })(this));
      },
      localization: function() {
        return this.input.attr('placeholder', hA.t('search_location'));
      },
      selectLocation: function($location) {
        if ($location.data('type') === 'country') {
          hA.putSelectedLocation($location.data('lat'), $location.data('lng'), $location.html(), null, $location.data('country_code'), $location.data('country_name'));
        } else {
          hA.putSelectedLocation($location.data('lat'), $location.data('lng'), $location.html(), $location.data('bbox'), $location.data('country_code'), $location.data('country_name'));
        }
        return this.favLocation();
      },
      destructor: function() {
        hA.events.off('showing_menu');
        this.el.off('click', '.back-button');
        this.el.off('click', '.clean-search-button');
        this.el.off('click', '#nearme');
        this.el.off('click', '#worldwide');
        this.el.off('click', '.location');
        this.el.off('focus', '.app-input');
        this.el.off('appShow');
        this.el.off('submit', '#form_search');
        this.input.removeAttr('disabled').off('keypress');
        this.cancelAjaxQueryIfNeeded();
        this.el = null;
        return this.input = null;
      }
    });
  });

}).call(this);
