// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var IntroView;
    return IntroView = Hubii.View.extend({
      el: document.getElementById('intro_app'),
      bg: document.getElementById('bg_overlay'),
      elements: {
        $slides: $('.slide'),
        $nav: $(document.getElementById('intro_navigation')),
        $button_skip: $(document.getElementById('skip-intro')),
        $button_next: $(document.getElementById('next-slider'))
      },
      initialize: function() {
        this.$el.removeClass('none');
        this.bg.addClass('activated');
        this.elements.$button_next.on('click', (function(_this) {
          return function(e) {
            return _this.nextSlide(e);
          };
        })(this));
        return this.elements.$button_skip.on('click', (function(_this) {
          return function(e) {
            return _this.skipIntro(e);
          };
        })(this));
      },
      skipIntro: function(e) {
        if (e != null) {
          e.preventDefault();
        }
        this.bg.removeClass('activated');
        lscache.set('slider_showed', true);
        return this.$el.remove();
      },
      previousSlide: function(e) {
        var $prev;
        e.stopPropagation();
        $prev = this.elements.$slides.filter('.current').prev('.slide');
        if ($prev.length) {
          return this.goToSlide($prev);
        }
      },
      nextSlide: function(e) {
        var $next;
        e.stopPropagation();
        $next = this.elements.$slides.filter('.current').next('.slide');
        if ($next.length) {
          return this.goToSlide($next);
        } else {
          return this.skipIntro();
        }
      },
      goToSlide: function($slide) {
        var slide_id;
        slide_id = $slide.attr('id');
        this.elements.$slides.removeClass('current');
        this.elements.$nav.find('li').removeClass('current');
        $slide.addClass('current');
        this.elements.$nav.find('li[rel="' + slide_id + '"]').addClass('current');
        switch (slide_id) {
          case 'slide4':
            this.elements.$button_skip.hide();
            return this.elements.$button_next.html(hA.t('get_started'));
          default:
            this.elements.$button_skip.hide();
            return this.elements.$button_next.html(hA.t('next'));
        }
      }
    });
  });

}).call(this);
