// Generated by CoffeeScript 1.9.2
(function() {
  define(['NewsView', 'ChangeLocationView'], function(NewsView, ChangeLocationView) {
    var LatestNewsView;
    return LatestNewsView = NewsView.extend({
      firstLoad: true,
      populate: function(page) {
        this.showing = true;
        this.el = $(page);
        this.content = this.el.find('.wrap');
        this.showLoading();
        this.el.find('.app-location').html(hA.selectedlocation.name);
        if (!this.collection.isNew()) {
          this.render();
        }
        this.el.on('click', '.new', (function(_this) {
          return function(e) {
            e.preventDefault();
            return _this.openArticle(e);
          };
        })(this));
        this.el.on('click', '.refresh-button', function(e) {
          e.preventDefault();
          return hA.events.trigger('fetch_news');
        });
        this.el.on('appHide', (function(_this) {
          return function() {
            _this.showing = false;
            return _this.removeInfiniteScroll(_this.el.find('.app-content'));
          };
        })(this));
        return this.el.on('appShow', (function(_this) {
          return function() {
            hA.events.trigger('show_filters');
            hA.sendPageViewGA();
            _this.infiniteScroll(_this.el.find('.app-content'));
            _this.showing = true;
            return _this.checkNewsRead();
          };
        })(this));
      },
      destructor: function() {
        this.el.off('click', '.new');
        this.el.off('click', '.refresh-button');
        this.el.off('appHide');
        this.el.off('appShow');
        this.el = null;
        return this.content = null;
      },
      initialize: function(options) {
        hA.views.changelocation = new ChangeLocationView;
        this.publicationsCollection = options.publicationsCollection;
        App.populator('latestnews', (function(_this) {
          return function(page, options) {
            if (options == null) {
              options = false;
            }
            return _this.populate(page);
          };
        })(this), (function(_this) {
          return function() {
            return _this.destructor();
          };
        })(this));
        this.collection.on('reset', (function(_this) {
          return function() {
            if (_this.showing) {
              return _this.render();
            }
          };
        })(this));
        this.collection.on('add', (function(_this) {
          return function(model) {
            if (_this.showing) {
              return _this.addNews(model);
            }
          };
        })(this));
        this.initMasterEvents();
        return this.publicationsCollection.on('reset', (function(_this) {
          return function() {
            if (_this.publicationsCollection.length) {
              return _this.firstLoad = false;
            } else {
              if (_this.firstLoad) {
                if ((hA.selectedlocation.bbox != null) && (hA.selectedlocation.country_code != null)) {
                  hA.selectedlocation.bbox = null;
                  _this.el.find('.app-location').html(hA.selectedlocation.country_name);
                  return hA.events.trigger('selected_new_location');
                } else {
                  hA.setWorldwide();
                  _this.el.find('.app-location').html('Worldwide');
                  return _this.firstLoad = false;
                }
              } else {
                _this.collection.setNotNew();
                _this.showNoNewsMessage();
                return _this.firstLoad = false;
              }
            }
          };
        })(this));
      }
    });
  });

}).call(this);
