// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var LocationsView;
    return LocationsView = Hubii.View.extend({
      el: null,
      input: null,
      currentAjaxCall: null,
      showCleanButtonIfNeeded: function(puttedText) {
        if (this.search) {
          this.el = this.search;
        }
        if (puttedText.length >= 1) {
          return this.el.find('.clean-search-button').css({
            opacity: 1
          });
        } else {
          return this.el.find('.clean-search-button').css({
            opacity: 0
          });
        }
      },
      cancelAjaxQueryIfNeeded: function() {
        if (this.currentAjaxCall) {
          this.currentAjaxCall.abort();
          return this.currentAjaxCall = null;
        }
      },
      getAutocompleteLocations: function(puttedText) {
        var cachedLocations;
        if (this.search) {
          this.el = this.search;
        }
        this.showCleanButtonIfNeeded(puttedText);
        if (puttedText.length === 0) {
          this.el.find('.location_nominatim').remove();
        }
        if (puttedText.length > 3) {
          this.cancelAjaxQueryIfNeeded();
          cachedLocations = lscache.get("aclocation" + puttedText);
          if (cachedLocations) {
            return this.renderAutocompleteLocations(cachedLocations);
          } else {
            return this.currentAjaxCall = $.ajax({
              url: 'http://nominatim.openstreetmap.org/search?',
              type: 'get',
              cache: true,
              data: {
                q: puttedText,
                format: 'json',
                limit: 2,
                addressdetails: 1
              },
              success: (function(_this) {
                return function(locations) {
                  if (locations.length) {
                    lscache.set("aclocation" + puttedText, locations, 10000);
                    return _this.renderAutocompleteLocations(locations);
                  }
                };
              })(this),
              complete: (function(_this) {
                return function() {
                  return _this.currentAjaxCall = null;
                };
              })(this)
            });
          }
        }
      },
      favLocation: function() {
        var exists, fav_locations;
        fav_locations = lscache.get('fav_locations');
        if (fav_locations != null) {
          exists = _.findWhere(fav_locations, {
            name: hA.selectedlocation.name
          });
          if (exists != null) {
            return false;
          }
          if (fav_locations.length > 2) {
            fav_locations.shift();
          }
        } else {
          fav_locations = [];
        }
        fav_locations.push(hA.selectedlocation);
        return lscache.set('fav_locations', fav_locations);
      },
      renderFavLocations: function() {
        var $applist, fav_locations, html, i, len, location, place_type;
        fav_locations = lscache.get('fav_locations');
        html = '';
        if (this.search) {
          this.el = this.search;
        }
        if ((fav_locations != null) && fav_locations) {
          $applist = this.el.find('.locations');
          for (i = 0, len = fav_locations.length; i < len; i++) {
            location = fav_locations[i];
            if (location.bbox == null) {
              place_type = 'country';
            } else {
              place_type = 'city';
            }
            html += "<li class='hubii-button location location_fav' data-type='" + place_type + "' data-country_code= '" + location.country_code + "' data-country_name='" + location.country + "' data-bbox='" + location.bbox + "' data-lat='" + location.lat + "' data-lng='" + location.lon + "'>" + location.name;
          }
          return $applist.prepend(html);
        }
      },
      renderAutocompleteLocations: function(locations) {
        var $applist, bbox, city, htmlToPrepend, i, len, location, place, place_type, ref, ref1, ref2, ref3, ref4;
        if (this.search) {
          this.el = this.search;
        }
        if (locations.length) {
          $applist = this.el.find('.locations');
          $applist.find('.location_nominatim').remove();
          htmlToPrepend = '';
          for (i = 0, len = locations.length; i < len; i++) {
            location = locations[i];
            place = location.address;
            if (place.tower != null) {
              place_type = 'tower';
            } else if (place.city != null) {
              place_type = 'city';
            } else if (place.county != null) {
              place_type = 'county';
            } else if (place.state != null) {
              place_type = 'state';
            } else if (place.country != null) {
              place_type = 'country';
            } else if (place.administrative != null) {
              place_type = 'administrative';
            }
            city = (ref = (ref1 = (ref2 = (ref3 = (ref4 = place.tower) != null ? ref4 : place.city) != null ? ref3 : place.county) != null ? ref2 : place.state) != null ? ref1 : place.country) != null ? ref : place.administrative;
            bbox = location.boundingbox[2] + ',' + location.boundingbox[0] + ',' + location.boundingbox[3] + ',' + location.boundingbox[1];
            htmlToPrepend += "<li class='hubii-button location location_nominatim' data-type='" + place_type + "' data-country_code= '" + place.country_code + "' data-country_name='" + place.country + "' data-bbox='" + bbox + "' data-lat='" + location.lat + "' data-lng='" + location.lon + "'>" + city + ", " + (place.country_code.toUpperCase());
          }
          return $applist.prepend(htmlToPrepend);
        }
      }
    });
  });

}).call(this);
