// Generated by CoffeeScript 1.9.2
(function() {
  define(['LocationsView', 'SearchNewsView', 'SearchCollection'], function(LocationsView, SearchNewsView, SearchCollection) {
    var MenuView;
    return MenuView = LocationsView.extend({
      $body: $(document.body),
      el: document.getElementById('menu'),
      bg: $(document.getElementById('bg_overlay')),
      inputSearchTrends: $(document.getElementById('search-trends')),
      inputSearchLocations: $(document.getElementById('search-location')),
      searchForTranslation: hA.t('search_for'),
      search: $(document.getElementById('search')),
      populated: false,
      input: null,
      menuShowed: false,
      events: {
        'click #menu-signup-button': 'openLogIn',
        'click #menu-settings-button': 'openSettings',
        'click #menu-trends-button': 'openTrends',
        'click #menu-latest-button': 'openLatestNews',
        'click #menu-publishers-button': 'openPublishers',
        'click #menu-searches-button': 'openSearches',
        'click #menu-readlaters-button': 'openReadLaters',
        'click #menu-subscriptions-button': 'openSubscriptions',
        'click #menu-categories-button': 'openCategories',
        'click #menu-languages-button': 'openLanguages',
        'focus #search-trends': 'openSearchPage',
        'click .close-button': 'closeSearchPage'
      },
      initialize: function() {
        this.initTapEvents();
        this.initSystemEvents();
        this.inputSearchTrends.attr('placeholder', hA.t('search_news'));
        this.inputSearchLocations.attr('placeholder', hA.t('search_location'));
        return App.populator('iframe-page', (function(_this) {
          return function(page, options) {
            return _this.populateIframe(page, options);
          };
        })(this), (function(_this) {
          return function(page) {
            return _this.destructorIframe(page);
          };
        })(this));
      },
      initSystemEvents: function() {
        hA.events.on('perform_search', (function(_this) {
          return function() {
            return _this.performSearchOrFocusInput();
          };
        })(this));
        hA.events.on('show_menu', (function(_this) {
          return function() {
            return _this.showMenu();
          };
        })(this));
        hA.events.on('selected_new_location', (function(_this) {
          return function() {
            return _this.changeLocationNameOnSearch();
          };
        })(this));
        hA.events.on('fire_search', (function(_this) {
          return function(keyword, isTrend) {
            if (isTrend == null) {
              isTrend = false;
            }
            return _this.loadSearchNews(keyword, isTrend);
          };
        })(this));
        hA.events.on('mark_current_menu', (function(_this) {
          return function(buttonOfMenu) {
            return _this.markButtonAsCurrent(buttonOfMenu);
          };
        })(this));
        hA.events.on('form_loading', function() {
          return hA.showLoadingForm($('.app-content form'));
        });
        hA.events.on('form_sent', function() {
          return hA.showSuccessForm($('.app-content form'));
        });
        hA.events.on('login_finished', (function(_this) {
          return function() {
            var loadLatestNews;
            $('.user-notlogged').hide();
            hA.showSuccessForm($('form'));
            loadLatestNews = function() {
              App.load('latestnews');
              return _this.markButtonAsCurrent(document.getElementById('menu-latest-button'));
            };
            return setTimeout(loadLatestNews, 1000);
          };
        })(this));
        hA.events.on('logout_finished', function() {
          return $('.user-notlogged').show();
        });
        return hA.events.on('form_error', function() {
          return hA.showFailureForm($('form'));
        });
      },
      initTapEvents: function() {
        this.$body.on('click', '.menu-button', function(e) {
          e.preventDefault();
          return hA.events.trigger('show_menu');
        });
        this.$body.on('click', '.location-button', function() {
          return App.load('change-location');
        });
        this.$body.on('click', '.go-to-login', (function(_this) {
          return function() {
            _this.hideMenu();
            $(document.getElementById('menu')).find('.current').removeClass('current');
            return App.load('login');
          };
        })(this));
        this.$body.on('click', '#go-to-filters', (function(_this) {
          return function() {
            return App.load('filters');
          };
        })(this));
        this.$body.on('click', '.go-to-register', function() {
          return App.load('register');
        });
        this.$body.on('click', '.go-to-forgot-password', function() {
          return App.load('forgot-password');
        });
        return this.$body.on('click', '.go-to-activation', function() {
          return App.load('activation-link');
        });
      },
      disableInputs: function() {
        this.inputSearchTrends.attr('disabled', '');
        return this.inputSearchLocations.attr('disabled', '');
      },
      enableInputs: function() {
        this.inputSearchTrends.removeAttr('disabled');
        return this.inputSearchLocations.removeAttr('disabled');
      },
      populateIframe: function(page, options) {
        var $page, attributes, iframe;
        $page = $(page);
        iframe = document.createElement('iframe');
        attributes = {
          style: "height:100%",
          id: 'iframe_article'
        };
        if (options.mozbrowser) {
          attributes.mozbrowser = '';
        }
        $(iframe).attr(attributes);
        $page.find('.app-content').html(iframe);
        $(iframe).attr('src', "" + options.url);
        $page.on('click', '.close-button', (function(_this) {
          return function() {
            return App.back();
          };
        })(this));
        return $page.on('appShow', (function(_this) {
          return function() {
            hA.events.trigger('hide_filters');
            return hA.sendPageViewGA();
          };
        })(this));
      },
      destructorIframe: function(page) {
        var $page;
        $page = $(page);
        $page.off('click', '.close-button');
        return $page.off('appShow');
      },
      changeLocationNameOnSearch: function() {
        return this.inputSearchLocations.val(hA.selectedlocation.name);
      },
      markButtonAsCurrent: function(e) {
        var $currentElement;
        if (e.currentTarget != null) {
          $currentElement = $(e.currentTarget);
        } else {
          $currentElement = $(e);
        }
        if ($currentElement.hasClass('current')) {
          if (typeof e.stopPropagation === "function") {
            e.stopPropagation();
          }
          if (typeof e.preventDefault === "function") {
            e.preventDefault();
          }
          return false;
        } else {
          this.$el.find('.current').removeClass('current');
          $currentElement.addClass('current');
          App.destroyStack();
          return true;
        }
      },
      openLogIn: function() {
        this.hideMenu();
        return App.load('login', {}, 'instant');
      },
      openSearchPage: function() {
        this.$el.scrollTop(0);
        this.$el.addClass('search_activated');
        if ((this.populated != null) && !this.populated) {
          return this.populate();
        }
      },
      closeSearchPage: function() {
        this.$el.removeClass('search_activated');
        this.inputSearchLocations.blur();
        return this.inputSearchTrends.blur();
      },
      openSettings: function(e) {
        this.hideMenu();
        this.markButtonAsCurrent(e);
        return App.load('settings', {}, 'instant');
      },
      openTrends: function(e) {
        this.hideMenu();
        if (this.markButtonAsCurrent(e)) {
          return App.load('trends', {}, 'instant');
        }
      },
      openLatestNews: function(e) {
        this.hideMenu();
        if (this.markButtonAsCurrent(e)) {
          return App.load('latestnews', {}, 'instant');
        }
      },
      openPublishers: function(e) {
        this.hideMenu();
        if (this.markButtonAsCurrent(e)) {
          return App.load('publications', {}, 'instant');
        }
      },
      openSearches: function(e) {
        this.hideMenu();
        if (hA.userIsLogged()) {
          if (this.markButtonAsCurrent(e)) {
            return App.load('savedsearches', {}, 'instant');
          }
        } else {
          return this.openLoginIfNeeded();
        }
      },
      openReadLaters: function(e) {
        this.hideMenu();
        if (hA.userIsLogged()) {
          if (this.markButtonAsCurrent(e)) {
            return App.load('readlaters', {}, 'instant');
          }
        } else {
          return this.openLoginIfNeeded();
        }
      },
      openCategories: function(e) {
        this.hideMenu();
        this.$el.find('.current').removeClass('current');
        return App.load('filters', {}, 'instant');
      },
      openSubscriptions: function(e) {
        this.hideMenu();
        if (hA.userIsLogged()) {
          if (this.markButtonAsCurrent(e)) {
            return App.load('subscriptions', {}, 'instant');
          }
        } else {
          return this.openLoginIfNeeded();
        }
      },
      openLoginIfNeeded: function() {
        $(document.getElementById('menu')).find('.current').removeClass('current');
        if (hA.getActualPage() === 'login') {
          return false;
        } else {
          return App.load('login');
        }
      },
      showMenu: function() {
        hA.events.trigger('showing_menu');
        this.menuShowed = true;
        this.bg.addClass('activated');
        this.$el.addClass('activated');
        return this.bg.one('click', (function(_this) {
          return function() {
            return _this.hideMenu();
          };
        })(this));
      },
      hideMenu: function() {
        this.menuShowed = false;
        this.$el.removeClass('activated search_activated');
        this.inputSearchTrends.val('').blur();
        this.inputSearchLocations.blur();
        return this.bg.removeClass('activated').off('click', (function(_this) {
          return function() {
            return _this.hideMenu();
          };
        })(this));
      },
      getAutocompleteTrends: function(puttedText) {
        var cachedTrends;
        this.showCleanButtonIfNeeded(puttedText);
        if (puttedText.length > 0) {
          this.el.find('.trends')[0].innerHTML = "<li data-keyword=\"" + puttedText + "\" class=\"trend selected\"><i>" + this.searchForTranslation + " </i>" + puttedText + "</li>";
        } else {
          this.cancelAjaxQueryIfNeeded();
          this.el.find('.trends')[0].innerHTML = '';
        }
        if (puttedText.length > 3) {
          this.cancelAjaxQueryIfNeeded();
          cachedTrends = lscache.get("actrends" + puttedText);
          if (cachedTrends) {
            return this.listAutocompleteTrends(cachedTrends);
          } else {
            return this.currentAjaxCall = $.ajax({
              url: serverAPI + '/words',
              type: 'get',
              data: {
                q: puttedText,
                limit: 2
              },
              success: (function(_this) {
                return function(trends) {
                  if (trends.length != null) {
                    lscache.set("actrends" + puttedText, trends, 60);
                  }
                  return _this.listAutocompleteTrends(trends);
                };
              })(this),
              complete: (function(_this) {
                return function() {
                  return _this.currentAjaxCall = null;
                };
              })(this)
            });
          }
        }
      },
      listAutocompleteTrends: function(trends) {
        var i, len, results, trend;
        if (trends != null ? trends.length : void 0) {
          results = [];
          for (i = 0, len = trends.length; i < len; i++) {
            trend = trends[i];
            results.push(this.el.find('.trends').append(("<li class='trend' data-keyword=\"" + trend + "\">") + trend));
          }
          return results;
        }
      },
      loadSearchNews: function(keyword, isTrend) {
        var ref;
        if (isTrend == null) {
          isTrend = false;
        }
        if ((ref = this.input) != null) {
          ref.blur();
        }
        if (!keyword) {
          $(document.getElementById('menu')).find('.current').removeClass('current');
          $(document.getElementById('menu-latest-button')).addClass('current');
          App.load('latestnews', {}, 'instant');
        } else if (hA.views.searchnews == null) {
          hA.collections.search = new SearchCollection;
          hA.views.searchnews = new SearchNewsView({
            collection: hA.collections.search
          });
          this.markButtonAsCurrent(document.getElementById('search'));
          if (isTrend) {
            App.load('search-news', {
              keyword: keyword,
              isTrend: true
            });
          } else {
            App.load('search-news', {
              keyword: keyword
            }, 'instant');
          }
        } else {
          this.markButtonAsCurrent(document.getElementById('search'));
          if (isTrend) {
            App.load('search-news', {
              keyword: keyword,
              isTrend: true
            });
          } else {
            App.load('search-news', {
              keyword: keyword
            }, 'instant');
          }
        }
        return this.hideMenu();
      },
      populate: function() {
        this.populated = true;
        this.inputSearchLocations.val(hA.selectedlocation.name);
        this.input = this.inputSearchTrends;
        hA.events.on('showing_menu', (function(_this) {
          return function() {
            var ref;
            return (ref = _this.input) != null ? ref.blur() : void 0;
          };
        })(this));
        this.search.on('click', '.clean-search-button', (function(_this) {
          return function(e) {
            e.preventDefault();
            _this.input.focus();
            _this.input.val('');
            _this.search.find('.clean-search-button').css({
              opacity: 0
            });
            _this.search.find('.location').remove();
            _this.search.find('.trend').remove();
            return _this.input.focus();
          };
        })(this));
        this.search.on('click', '#nearme', (function(_this) {
          return function(e) {
            _this.input.val('Near me').blur();
            hA.selectedlocation = hA.userlocation;
            hA.events.trigger('selected_new_location', hA.getBBox());
            return _this.performSearchOrFocusInput();
          };
        })(this));
        this.search.on('click', '#worldwide', (function(_this) {
          return function(e) {
            _this.input.val('Worldwide').blur();
            hA.setWorldwide();
            hA.events.trigger('selected_new_location', hA.getBBox());
            return _this.performSearchOrFocusInput();
          };
        })(this));
        this.search.on('click', '.location', (function(_this) {
          return function(e) {
            var $location, puttedTrend;
            _this.input.blur();
            $location = $(e.currentTarget);
            _this.input.val($location.html());
            hA.putSelectedLocation($location.data('lat'), $location.data('lng'), $location.html(), $location.data('bbox'));
            hA.events.trigger('selected_new_location', hA.getBBox());
            puttedTrend = _this.inputSearchTrends.val();
            return _this.performSearchOrFocusInput();
          };
        })(this));
        this.search.on('click', '.trend', (function(_this) {
          return function(e) {
            return _this.loadSearchNews($(e.currentTarget).data('keyword'));
          };
        })(this));
        this.inputSearchLocations.on('input', (function(_this) {
          return function(e) {
            return _this.getAutocompleteLocations(_this.input.val());
          };
        })(this));
        this.inputSearchLocations.on('focus', (function(_this) {
          return function(e) {
            _this.input = $(e.currentTarget);
            _this.search.find('.clean-search-button').addClass('with_margin');
            _this.showCleanButtonIfNeeded(_this.input.val());
            _this.search.find('.locations').css({
              display: 'block'
            });
            return _this.search.find('.trends').css({
              display: 'none'
            });
          };
        })(this));
        this.inputSearchTrends.on('input', (function(_this) {
          return function(e) {
            return _this.getAutocompleteTrends(_this.input.val());
          };
        })(this));
        return this.inputSearchTrends.on('focus', (function(_this) {
          return function(e) {
            var puttedText;
            _this.input = $(e.currentTarget);
            puttedText = _this.input.val();
            _this.getAutocompleteLocations(puttedText);
            _this.search.find('.clean-search-button').removeClass('with_margin');
            _this.showCleanButtonIfNeeded(_this.input.val());
            _this.renderFavLocations();
            _this.search.find('.locations').css({
              display: 'none'
            });
            return _this.search.find('.trends').css({
              display: 'block'
            });
          };
        })(this));
      },
      performSearchOrFocusInput: function() {
        if (this.inputSearchTrends.val().length) {
          return this.loadSearchNews(this.inputSearchTrends.val());
        } else {
          return this.inputSearchTrends.focus();
        }
      }
    });
  });

}).call(this);
