// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var NewsView;
    return NewsView = Hubii.View.extend({
      needClean: false,
      showing: false,
      appendCached: [],
      listPublishers: [],
      el: null,
      content: null,
      tmplInstructionsFiltering: function(title, paragraph, link) {
        return "<article id='filter_instructions' class='popup_info_box'> <a id='close-instructions' href='#'><i class='sprite close-instructions'></i></a> <h2>" + title + "</h2> <p><span>" + paragraph + "</span> <a id='go-to-filters' href='#'>" + link + "</a></p> </article>";
      },
      tmplNoNewsWithFilters: function(nophrase, linkname) {
        return "<div id='no-news'><img src='img/active_filters.png' /><p id='no-phrase'>" + nophrase + "</p><a href='#'>" + linkname + "</a></div>";
      },
      tmplNew: function(j) {
        var html, style;
        style = '';
        if (j.Image) {
          style += 'with_image ';
          style += "size_image_" + j.Image.width + " ";
        }
        if (j.isRead) {
          style += 'read';
        }
        html = "<article data-article='" + j.ArticleId + "' class='new " + style + "'>";
        if (j.Image) {
          html += "<img class='new_img' src='" + j.Image.url + "' width='" + j.Image.width + "' height='" + j.Image.height + "' />";
        }
        html += "<span data-publisher='" + j.PublicationId + "' class='publisher'>" + j.PublicationName + "</span>";
        html += "<time datetime='" + j.Published + "' class='timeago'>" + j.Published + "</time>";
        html += "<span class='category category_" + j.CategoryClass + "'></span>";
        return html += "<h2 class='new_title'>" + j.Header + "</h2></article>";
      },
      tmplNoNews: function(nophrase) {
        return "<div id='no-news'><i class='sprite no-news-here'></i><p id='no-phrase'>" + nophrase + "</p></div>";
      },
      tmplLoading: function() {
        return '<div id="loading"><img src="img/loading_static.png" width="34" height="34" /></div>';
      },
      initMasterEvents: function() {
        this.no_results_text = hA.t('no_news_in_this_location');
        this.on('infinite_scroll', (function(_this) {
          return function() {
            return _this.collection.nextPage();
          };
        })(this));
        hA.events.on('show_loading', (function(_this) {
          return function() {
            if (_this.showing) {
              return _this.showLoading();
            }
          };
        })(this));
        hA.events.on('hide_loading', (function(_this) {
          return function() {
            if (_this.showing) {
              return _this.hideLoading();
            }
          };
        })(this));
        hA.events.on('put_publication', (function(_this) {
          return function(publication) {
            return _this.addPublicationForNews(publication);
          };
        })(this));
        return $(body).on('click', '#close-instructions', function() {
          $('#filter_instructions').remove();
          return lscache.set('instructions_showed', true);
        });
      },
      addPublicationForNews: function(publication) {
        return $('.new').find(".publisher[data-publisher='" + publication.id + "']").html(publication.Name);
      },
      showInstructionsIfNeeded: function() {
        var instructionsDOM, instructionsShowed, link, paragraph, timesShowed, title;
        instructionsShowed = lscache.get('instructions_showed') || false;
        timesShowed = lscache.get('times_instructions_showed') || 0;
        instructionsDOM = document.getElementById('filter_instructions');
        if (timesShowed < 5 && !instructionsShowed && instructionsDOM === null) {
          title = hA.t('title_instructions_block_filter');
          paragraph = hA.t('paragraph_instructions_block_filter');
          link = hA.t('link_instructions_block_filter');
          this.content.prepend(this.tmplInstructionsFiltering(title, paragraph, link));
          timesShowed = parseInt(timesShowed) + 1;
          return lscache.set('times_instructions_showed', timesShowed);
        }
      },
      showNoNewsMessage: function() {
        var ref, ref1;
        if (((ref = hA.filter_categories) != null ? ref.length : void 0) || ((ref1 = hA.filter_languages) != null ? ref1.length : void 0)) {
          this.content.html(this.tmplNoNewsWithFilters(hA.t('no_news_with_filters'), hA.t('link_no_news_filters')));
          return this.content.find('a').on('click', function(e) {
            e.preventDefault();
            return App.load('filters');
          });
        } else {
          return this.content.html(this.tmplNoNews(this.no_results_text));
        }
      },
      render: function() {
        var $loading;
        if (this.el == null) {
          return false;
        }
        $loading = this.el.find('#loading');
        if ($loading.length) {
          $loading.remove();
        }
        this.content.empty();
        if (this.collection.length) {
          return this.collection.each(this.addNews, this);
        } else {
          return this.showNoNewsMessage();
        }
      },
      addNews: function(model) {
        var $toAppend, cachedPublication, i, imageFromModel, len, p, publication, publicationId, ref, ref1, title;
        publicationId = model.get('PublicationId');
        if ((ref = this.publicationsCollection) != null ? ref.length : void 0) {
          publication = this.publicationsCollection.findWhere({
            id: publicationId
          });
          if (publication != null) {
            model.set('PublicationName', publication.get('Name'));
          }
        }
        if (publication == null) {
          cachedPublication = lscache.get("publication" + publicationId);
          if (cachedPublication) {
            model.set('PublicationName', cachedPublication.Name);
          } else {
            this.listPublishers.push(publicationId);
          }
        }
        imageFromModel = model.get('Image');
        if ((imageFromModel != null ? imageFromModel.width : void 0) >= 300) {
          imageFromModel.width = 320;
          if (imageFromModel.height === 310) {
            imageFromModel.height = 190;
            model.set('Image', imageFromModel);
          } else if (imageFromModel.height === 195) {
            imageFromModel.height = 119;
            model.set('Image', imageFromModel);
          }
        } else if ((imageFromModel != null ? imageFromModel.width : void 0) < 300) {
          imageFromModel.width = 137;
          imageFromModel.height = 127;
          model.set('Image', imageFromModel);
          title = model.get('Header');
        } else {
          model.set('Image', 0);
        }
        if (this.checkArticleIsRead(model.get('ArticleId'))) {
          model.set({
            isRead: true
          });
        }
        this.appendCached.push(this.tmplNew(model.toJSON()));
        if (this.appendCached.length === this.collection.getFetchedLength()) {
          $toAppend = $(this.appendCached.join(''));
          $toAppend.find('.timeago').timeago();
          this.showInstructionsIfNeeded();
          this.content.append($toAppend);
          ref1 = this.listPublishers;
          for (i = 0, len = ref1.length; i < len; i++) {
            p = ref1[i];
            hA.events.trigger('fetch_publication', p);
          }
          this.appendCached = [];
          return this.listPublishers = [];
        }
      },
      openArticle: function(e) {
        var articleId;
        e.preventDefault();
        articleId = e.currentTarget.dataset.article;
        hA.events.trigger('open_article', articleId, this.collection);
        return this.markArticleAsRead(e.currentTarget, articleId);
      },
      showLoading: function() {
        if (!this.el.find('#loading').length) {
          return this.content.html(this.tmplLoading());
        }
      },
      hideLoading: function() {
        var $loading;
        $loading = this.el.find('#loading');
        if ($loading.length) {
          return $loading.remove();
        }
      },
      markArticleAsRead: function($article, articleId) {
        var article;
        $article.addClass('read');
        article = this.collection.findWhere({
          ArticleId: articleId
        });
        article.set({
          isRead: true
        });
        return hA.events.trigger('mark_article_as_read', articleId);
      },
      checkArticleIsRead: function(articleId) {
        return _.contains(hA.articlesread, articleId);
      },
      checkNewsRead: function() {
        var article, i, len, news, results;
        news = document.querySelectorAll('.new');
        if (news != null ? news.length : void 0) {
          results = [];
          for (i = 0, len = news.length; i < len; i++) {
            article = news[i];
            if (this.checkArticleIsRead(article.dataset.article)) {
              results.push(article.addClass('read'));
            } else {
              results.push(void 0);
            }
          }
          return results;
        }
      }
    });
  });

}).call(this);
