// Generated by CoffeeScript 1.9.2
(function() {
  define(['NewsView'], function(NewsView) {
    var PublicationNewsView;
    return PublicationNewsView = NewsView.extend({
      publicationsCollection: null,
      publicationId: null,
      publication: null,
      tmplNoNews: function(nophrase) {
        return "<div id='no-news'> <img src='img/no_general.png' width='160' height='120' /> <p id='no-phrase'>" + nophrase + "</p> </div>";
      },
      initialize: function(options) {
        this.no_results_text = hA.t('no_news_for_this_publication');
        this.publicationsCollection = options.publicationsCollection;
        hA.events.on('suscribed_to_publication', (function(_this) {
          return function(publicationId) {
            if (_this.publicationId === publicationId && (_this.el != null)) {
              return _this.el.find('.remove-subscription-button').removeClass('none').end().find('.add-subscription-button').addClass('none');
            }
          };
        })(this));
        hA.events.on('unsuscribed_to_publication', (function(_this) {
          return function(publicationId) {
            if (_this.publicationId === publicationId && (_this.el != null)) {
              return _this.el.find('.remove-subscription-button').addClass('none').end().find('.add-subscription-button').removeClass('none');
            }
          };
        })(this));
        this.collection.on('reset', (function(_this) {
          return function() {
            return _this.render();
          };
        })(this));
        this.collection.on('add', (function(_this) {
          return function(model) {
            return _this.addNews(model);
          };
        })(this));
        this.initMasterEvents();
        hA.events.on('open_publication', (function(_this) {
          return function(publication) {
            if (typeof publication === 'string' || publication instanceof String) {
              _this.publicationId = publication;
            } else {
              _this.publication = publication;
              _this.publicationId = publication.id;
            }
            App.load('newsfrompublication');
            return _this.collection.setParam('publicationId', _this.publicationId);
          };
        })(this));
        return App.populator('newsfrompublication', (function(_this) {
          return function(page) {
            return _this.populate(page);
          };
        })(this), (function(_this) {
          return function(page) {
            return _this.destructor(page);
          };
        })(this));
      },
      populate: function(page) {
        this.appendCached = [];
        this.showing = true;
        this.el = $(page);
        this.content = this.el.find('.wrap');
        this.showPublicationOnTopBar();
        this.putManageSubscription();
        this.showLoading();
        this.infiniteScroll(this.el.find('.app-content'));
        this.el.on('click', '.back-button', function() {
          return App.back();
        });
        this.el.on('click', '.new', (function(_this) {
          return function(e) {
            return _this.openArticle(e);
          };
        })(this));
        this.el.on('click', '.refresh-button', (function(_this) {
          return function(e) {
            return _this.collection.setParam('publicationId', _this.publicationId);
          };
        })(this));
        this.el.on('appHide', (function(_this) {
          return function() {
            return _this.showing = false;
          };
        })(this));
        return this.el.on('appShow', (function(_this) {
          return function() {
            hA.events.trigger('show_filters');
            hA.sendPageViewGA();
            _this.showing = true;
            return _this.checkNewsRead();
          };
        })(this));
      },
      destructor: function(page) {
        this.showing = null;
        this.el.off('click', '.back-button');
        this.el.off('click', '.new');
        this.el.off('appHide');
        this.el.off('appShow');
        return this.el = null;
      },
      putManageSubscription: function() {
        var $addsubscription, $removesubscription, ref;
        if (hA.userIsLogged()) {
          $addsubscription = this.el.find('.add-subscription-button').on('click', (function(_this) {
            return function() {
              return hA.events.trigger('add_subscription', _this.publicationId);
            };
          })(this));
          $removesubscription = this.el.find('.remove-subscription-button').on('click', (function(_this) {
            return function() {
              return hA.events.trigger('remove_subscription', _this.publicationId);
            };
          })(this));
          if ((((ref = hA.user_subscriptions) != null ? ref.Publications : void 0) != null) && _.contains(hA.user_subscriptions.Publications, this.publicationId)) {
            return $removesubscription.removeClass('none');
          } else {
            return $addsubscription.removeClass('none');
          }
        }
      },
      showPublicationOnTopBar: function() {
        var htmlForTitle, logo, name, publication;
        publication = this.publicationsCollection.findWhere({
          id: this.publicationId
        });
        if ((publication == null) || !publication && (this.publication != null)) {
          logo = this.publication.LogoURL;
          name = this.publication.Name;
        } else {
          logo = publication.get('LogoURL');
          name = publication.get('Name');
        }
        if (logo) {
          htmlForTitle = '<img src="' + logo + '" />';
        } else {
          htmlForTitle = name;
        }
        return this.el.find('.app-title').html(htmlForTitle);
      }
    });
  });

}).call(this);
