// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var PublicationsView;
    return PublicationsView = Hubii.View.extend({
      showing: false,
      appendCached: [],
      el: null,
      tmplPublication: function(j) {
        var html;
        html = "<li class='publication go-right' data-publication='" + j.id + "' class='hubii-button go-right'>";
        if (j.LogoURL) {
          html += "<img class='publication_img' src='" + j.LogoURL + "' />";
        } else {
          html += "<h3 class='publication_title'>" + j.Name + "</h3>";
        }
        return html += "</li>";
      },
      tmplNoPublications: function() {
        return '<div id="no-news"> <i class="sprite no-news-here"></i> <p id="no-phrase">Sorry, no publications in this location</p> </div>';
      },
      tmplLoading: function() {
        return '<div id="loading"> <img src="img/loading_static2x.png" width="34" height="34" /> </div>';
      },
      initialize: function() {
        this.on('infinite_scroll', (function(_this) {
          return function() {
            return _this.collection.nextPage();
          };
        })(this));
        require(['PublicationNewsCollection', 'PublicationNewsView'], (function(_this) {
          return function(PublicationNewsCollection, PublicationNewsView) {
            var publicationnews_collection;
            publicationnews_collection = new PublicationNewsCollection;
            return new PublicationNewsView({
              collection: publicationnews_collection,
              publicationsCollection: _this.collection
            });
          };
        })(this));
        App.populator('publications', (function(_this) {
          return function(page) {
            return _this.populate(page);
          };
        })(this), (function(_this) {
          return function(page) {
            return _this.destructor(page);
          };
        })(this));
        this.collection.on('reset', (function(_this) {
          return function() {
            if (_this.showing) {
              return _this.render();
            }
          };
        })(this));
        return this.collection.on('add', (function(_this) {
          return function(model) {
            if (_this.showing) {
              return _this.addPublications(model);
            }
          };
        })(this));
      },
      populate: function(page) {
        hA.events.trigger('hide_filters');
        this.showing = true;
        this.el = $(page);
        this.el.find('.app-location').html(hA.selectedlocation.name);
        this.render();
        this.el.on('click', '.publication', (function(_this) {
          return function(e) {
            return _this.openPublication(e);
          };
        })(this));
        this.el.on('appHide', (function(_this) {
          return function() {
            _this.showing = false;
            return _this.removeInfiniteScroll(_this.el.find('.app-content'));
          };
        })(this));
        return this.el.on('appShow', (function(_this) {
          return function() {
            hA.sendPageViewGA();
            _this.infiniteScroll(_this.el.find('.app-content'));
            return _this.showing = true;
          };
        })(this));
      },
      destructor: function(page) {
        this.el.off('click', '.publication');
        this.el.off('appShow');
        this.el.off('appHide');
        this.el = null;
        return this.showing = false;
      },
      render: function() {
        if (this.el == null) {
          return false;
        }
        this.el.find('#loading').remove();
        this.el.find('#message').empty();
        this.el.find('.app-list').empty();
        if (this.collection.length) {
          return this.collection.each(this.addPublications, this);
        } else {
          return this.showNoPublicationsMessage();
        }
      },
      showNoPublicationsMessage: function() {
        return this.el.find('#message').html(this.tmplNoPublications()).find('#no-phrase').text(hA.t('no_publications_in_this_location'));
      },
      addPublications: function(model) {
        var $toAppend;
        this.appendCached.push(this.tmplPublication(model.toJSON()));
        if ((this.appendCached.length === this.collection.getFetchedLength()) || (!this.collection.isNew() && this.appendCached.length === this.collection.length)) {
          $toAppend = $(this.appendCached.join(''));
          this.el.find('.app-list').append($toAppend);
          this.appendCached = [];
          return this.collection.setNotNew();
        }
      },
      showLoading: function() {
        if (!this.el.find('#loading').length) {
          return this.el.find('#publications').append(this.tmplLoading());
        }
      },
      openPublication: function(e) {
        var publicationId;
        e.preventDefault();
        publicationId = e.currentTarget.dataset.publication;
        return hA.events.trigger('open_publication', publicationId);
      }
    });
  });

}).call(this);
