// Generated by CoffeeScript 1.9.2
(function() {
  define(['NewsView', 'ReadLatersCollection'], function(NewsView, ReadLatersCollection) {
    var ReadLatersView;
    return ReadLatersView = NewsView.extend({
      appendCached: [],
      firstLoad: true,
      tmplNoReadLaters: function() {
        return "<div id='no-news'> <i class='sprite no-news-here'></i> <p id='no-phrase'>You don't have any read later articles</p> </div>";
      },
      initialize: function() {
        hA.collections.readlaters = new ReadLatersCollection;
        this.collection = hA.collections.readlaters;
        App.populator('readlaters', (function(_this) {
          return function(page) {
            return _this.populate(page);
          };
        })(this), (function(_this) {
          return function() {
            return _this.destructor();
          };
        })(this));
        hA.events.on('added_readlater', (function(_this) {
          return function() {
            return _this.collection.setNew();
          };
        })(this));
        hA.events.on('removed_readlater', (function(_this) {
          return function(id) {
            _this.collection.setNew();
            return _this.collection.findWhere({
              "ArticleId": id
            }).set({
              toRemove: true
            });
          };
        })(this));
        this.collection.on('reset', (function(_this) {
          return function() {
            if (_this.showing) {
              _this.render();
            }
            return lscache.set('readlaters', _this.collection.toJSON());
          };
        })(this));
        this.collection.on('add', (function(_this) {
          return function(model) {
            if (_this.showing) {
              return _this.addNews(model);
            }
          };
        })(this));
        return this.collection.on('error', (function(_this) {
          return function() {
            var readlaters;
            readlaters = lscache.get('readlaters');
            if (readlaters && readlaters.length) {
              _this.collection.set(readlaters, {
                add: false,
                remove: false
              });
            }
            if (_this.showing) {
              return render();
            }
          };
        })(this));
      },
      populate: function(page) {
        this.showing = true;
        this.el = $(page);
        this.content = this.el.find('.wrap');
        this.showLoading();
        this.appendCached = [];
        if (!this.collection.isNew()) {
          this.render();
        } else {
          hA.events.trigger('fetch_readlaters');
        }
        this.el.on('click', '.new', (function(_this) {
          return function(e) {
            return _this.openArticle(e);
          };
        })(this));
        this.el.on('appHide', (function(_this) {
          return function() {
            return _this.showing = false;
          };
        })(this));
        return this.el.on('appShow', (function(_this) {
          return function() {
            var articlesToRemove;
            hA.events.trigger('hide_filters');
            hA.sendPageViewGA();
            _this.showing = true;
            articlesToRemove = _this.collection.where({
              toRemove: true
            });
            if (articlesToRemove.length) {
              return _.each(articlesToRemove, function(article) {
                var articleId;
                articleId = article.get('ArticleId');
                return _this.el.find(".new[data-article='" + articleId + "']").remove();
              });
            }
          };
        })(this));
      },
      destructor: function() {
        this.el.off('click', '.new');
        this.el.off('appShow');
        this.el.off('appHide');
        this.el = null;
        this.content = null;
        return this.collection.off('reset');
      },
      showNoNewsMessage: function() {
        return this.content.html(this.tmplNoReadLaters()).find('#no-phrase').text(hA.t('no_readlaters'));
      }
    });
  });

}).call(this);
