// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var SavedSearchesView;
    return SavedSearchesView = Hubii.View.extend({
      el: null,
      search_to_remove: null,
      tmplSavedSearch: function(j) {
        var html, i, image, len, ref;
        html = "<a href='#' rel='" + j.SearchId + "' class='saved_search'> <div class='titles'> <h2>" + j.Keyword + "</h2> <h3>" + j.Place + "</h3> </div> <div class='search_background'>";
        ref = j.Images;
        for (i = 0, len = ref.length; i < len; i++) {
          image = ref[i];
          html += "<img class='saved_search_img' src='" + image + "' />";
        }
        return html += "</div></a>";
      },
      tmplLoading: function() {
        return '<div id="loading"> <img src="img/loading_static.png" width="34" height="34" /> </div>';
      },
      tmplNoSavedSearches: function() {
        return '<div id="no-news"> <i class="sprite no-my-trends"></i> <p id="no-phrase">You are not subscribed to any publishers</p> </div>';
      },
      initialize: function() {
        hA.events.on('remove_search', (function(_this) {
          return function(id) {
            return _this.search_to_remove = id;
          };
        })(this));
        hA.events.on('add_search', (function(_this) {
          return function() {
            return _this.search_to_remove = null;
          };
        })(this));
        return App.populator('savedsearches', (function(_this) {
          return function(page) {
            return _this.populate(page);
          };
        })(this), (function(_this) {
          return function(page) {
            return _this.destructor(page);
          };
        })(this));
      },
      populate: function(page) {
        this.showing = true;
        this.el = $(page);
        this.content = this.el.find('.app-content');
        this.showLoading();
        this.render();
        this.el.on('click', '.saved_search', (function(_this) {
          return function(e) {
            var bbox, bounds, search, searchId;
            searchId = $(e.currentTarget).attr('rel');
            search = _.findWhere(hA.user_subscriptions.Searches, {
              SearchId: searchId
            });
            if (search.Bounds != null) {
              bbox = search.Bounds;
              bounds = bbox.SW_Lat + "," + bbox.NE_Lat + "," + bbox.SW_Long + "," + bbox.NE_Long;
              App.load('search-news', {
                keyword: search.Keyword,
                isTrend: true,
                place: search.Place,
                bounds: bounds,
                searchId: searchId
              });
              return hA.events.trigger('fetch_trend', search.Keyword, bounds);
            } else if (search.CountryCode != null) {
              App.load('search-news', {
                keyword: search.Keyword,
                isTrend: true,
                place: search.Place,
                bounds: null,
                country: search.CountryCode,
                searchId: searchId
              });
              return hA.events.trigger('fetch_trend', search.Keyword, null, search.CountryCode);
            }
          };
        })(this));
        this.el.on('appHide', (function(_this) {
          return function() {
            return _this.showing = false;
          };
        })(this));
        return this.el.on('appShow', (function(_this) {
          return function() {
            hA.events.trigger('hide_filters');
            hA.sendPageViewGA();
            _this.showing = true;
            if (_this.search_to_remove != null) {
              _this.el.find(".saved_search[rel='" + _this.search_to_remove + "']").remove();
              return _this.search_to_remove = null;
            }
          };
        })(this));
      },
      destructor: function(page) {
        this.el.off('click', '.saved_search');
        this.el.off('appHide');
        this.el.off('appShow');
        this.el = null;
        return this.content = null;
      },
      showLoading: function() {
        if (!this.content.find('#loading').length) {
          return this.content.append(this.tmplLoading());
        }
      },
      getThumbnails: function(k, isLast) {
        if (isLast == null) {
          isLast = false;
        }
        return $.ajax({
          url: "http://api.hubii.com/images?q=" + k + "&limit=4",
          success: (function(_this) {
            return function(searches_images) {
              var i, len, results, search, searches;
              searches = _.where(hA.user_subscriptions.Searches, {
                Keyword: k
              });
              results = [];
              for (i = 0, len = searches.length; i < len; i++) {
                search = searches[i];
                if (searches_images.length) {
                  search.Images = searches_images;
                } else {
                  search.Images = [];
                }
                results.push(_this.content.append(_this.tmplSavedSearch(search)));
              }
              return results;
            };
          })(this)
        });
      },
      render: function() {
        var i, k, keywords, len, ref, ref1, results;
        if ((ref = hA.user_subscriptions) != null ? (ref1 = ref.Searches) != null ? ref1.length : void 0 : void 0) {
          keywords = _.uniq(_.pluck(hA.user_subscriptions.Searches, 'Keyword'));
          this.content.find('#loading').remove();
          results = [];
          for (i = 0, len = keywords.length; i < len; i++) {
            k = keywords[i];
            results.push(this.getThumbnails(k));
          }
          return results;
        } else {
          this.content.html(this.tmplNoSavedSearches()).find('#no-phrase').text(hA.t('no_saved_searches'));
          return this.content.find('#loading').remove();
        }
      }
    });
  });

}).call(this);
