// Generated by CoffeeScript 1.9.2
(function() {
  define(['NewsView'], function(NewsView) {
    var SearchNewsView;
    return SearchNewsView = NewsView.extend({
      title: null,
      url: null,
      bg: $(document.getElementById('bg_overlay')),
      keyword: null,
      search_menu: null,
      tmplNoNews: function(nophrase) {
        return "<div id='no-news'> <img src='img/no_results.png' width='160' height='120' /> <p>" + nophrase + "</p> </div>";
      },
      initialize: function() {
        App.populator('search-news', (function(_this) {
          return function(page, params) {
            return _this.populate(page, params);
          };
        })(this), (function(_this) {
          return function() {
            return _this.destructor();
          };
        })(this));
        this.collection.on('reset', (function(_this) {
          return function() {
            return _this.render();
          };
        })(this));
        this.collection.on('add', (function(_this) {
          return function(model) {
            return _this.addNews(model);
          };
        })(this));
        this.initMasterEvents();
        hA.events.on('search_saved', (function(_this) {
          return function(searchId) {
            if (_this.el != null) {
              return _this.showRemoveTrendButton(searchId);
            }
          };
        })(this));
        return hA.events.on('search_removed', (function(_this) {
          return function() {
            if (_this.el != null) {
              return _this.showAddTrendButton();
            }
          };
        })(this));
      },
      populate: function(page, params) {
        this.appendCached = [];
        this.el = $(page);
        this.search_menu = this.el.find('#search-menu');
        this.keyword = params.keyword;
        this.isTrend = (params.isTrend != null) && params.isTrend === true;
        this.content = this.el.find('.wrap');
        this.showLoading();
        this.collection.setParam('keyword', this.keyword);
        this.el.find('.app-title').html(this.keyword);
        if (params.place != null) {
          this.el.find('.app-location').html(params.place);
        } else {
          this.el.find('.app-location').html(hA.selectedlocation.name);
        }
        this.infiniteScroll(this.el.find('.app-content'));
        this.el.on('click', 'article', (function(_this) {
          return function(e) {
            return _this.openArticle(e);
          };
        })(this));
        if (this.isTrend) {
          this.el.find('.back-button').removeClass('none');
          this.el.on('click', '.back-button', (function(_this) {
            return function(e) {
              e.stopPropagation();
              return App.back();
            };
          })(this));
        } else {
          this.el.find('.menu-button').removeClass('none');
          this.el.on('click', '.menu-button', function(e) {
            e.stopPropagation();
            return hA.events.trigger('show_menu');
          });
        }
        this.el.on('click', '.refresh-button', (function(_this) {
          return function(e) {
            _this.showLoading();
            if (_this.isTrend && ((params.bounds != null) || (params.country != null)) && (params.keyword != null)) {
              return hA.events.trigger('fetch_trend', params.keyword, params.bounds, params.country);
            } else {
              return _this.collection.setParam('keyword', _this.keyword);
            }
          };
        })(this));
        this.el.on('click', '.action-button', (function(_this) {
          return function(e) {
            return _this.openMenu(e);
          };
        })(this));
        this.el.on('click', '.share-search-facebook', (function(_this) {
          return function() {
            var url;
            _this.closeMenu();
            url = "https://m.facebook.com/sharer.php?u=" + _this.url;
            return _this.openURL(url);
          };
        })(this));
        this.el.on('click', '.share-search-twitter', (function(_this) {
          return function() {
            var url;
            _this.closeMenu();
            url = encodeURI("https://www.twitter.com/share?url=" + _this.url + "&text=" + _this.title);
            return _this.openURL(url);
          };
        })(this));
        this.el.on('click', '.share-search-email', (function(_this) {
          return function(e) {
            var createEmail, title;
            _this.closeMenu();
            title = _this.title.replace(/&nbsp;/g, "%20");
            return createEmail = new MozActivity({
              name: "new",
              data: {
                type: "mail",
                url: "mailto:?subject=Hubii: " + title + "&body=" + title + ":%0D%0A" + _this.url + "%0D%0A%0D%0AShared from Hubii. http://hubii.com"
              }
            });
          };
        })(this));
        this.on('infinite_scroll', (function(_this) {
          return function() {
            return _this.collection.nextPage();
          };
        })(this));
        this.el.on('appShow', (function(_this) {
          return function() {
            hA.events.trigger('show_filters');
            hA.sendPageViewGA();
            return _this.checkNewsRead();
          };
        })(this));
        this.el.on('click', '.add-trend-button', (function(_this) {
          return function(e) {
            return hA.events.trigger('add_search', _this.keyword, hA.selectedlocation.bbox, hA.selectedlocation.name, hA.selectedlocation.country_code);
          };
        })(this));
        this.el.on('click', '.remove-trend-button', (function(_this) {
          return function(e) {
            return hA.events.trigger('remove_search', $(e.currentTarget).attr('rel'));
          };
        })(this));
        this.putManageTrend(params);
        return this.putShareLinks();
      },
      putManageTrend: function(params) {
        var bbox, i, len, ref, ref1, s, savedsearches, subscribed;
        if (params == null) {
          params = false;
        }
        subscribed = false;
        if (hA.userIsLogged()) {
          if ((ref = hA.user_subscriptions) != null ? (ref1 = ref.Searches) != null ? ref1.length : void 0 : void 0) {
            console.log(params.searchId);
            if (params.searchId != null) {
              subscribed = true;
              this.showRemoveTrendButton(params.searchId);
              return true;
            }
            savedsearches = _.filter(hA.user_subscriptions.Searches, (function(_this) {
              return function(search_info) {
                return search_info.Keyword === _this.keyword;
              };
            })(this));
            if (savedsearches != null ? savedsearches.length : void 0) {
              for (i = 0, len = savedsearches.length; i < len; i++) {
                s = savedsearches[i];
                console.log(s);
                if (s.Bounds != null) {
                  bbox = s.Bounds;
                  bbox = bbox.SW_Lat + "," + bbox.NE_Lat + "," + bbox.SW_Long + "," + bbox.NE_Long;
                  if ((params.bounds != null) && (params.keyword != null)) {
                    if (params.bounds === bbox) {
                      subscribed = true;
                      this.showRemoveTrendButton(s.SearchId);
                    }
                  } else if (hA.selectedlocation.bbox === bbox) {
                    subscribed = true;
                    this.showRemoveTrendButton(s.SearchId);
                  }
                } else if ((s.CountryCode != null) && s.CountryCode === hA.selectedlocation.country_code) {
                  subscribed = true;
                  this.showRemoveTrendButton(s.SearchId);
                }
              }
            }
          }
          if (!subscribed) {
            return this.showAddTrendButton();
          }
        }
      },
      showRemoveTrendButton: function(searchId) {
        this.el.find('.remove-trend-button').removeClass('none').attr('rel', searchId);
        return this.el.find('.add-trend-button').addClass('none');
      },
      showAddTrendButton: function() {
        if ((hA.selectedlocation.bbox != null) || (hA.selectedlocation.country_code != null) || this.isTrend) {
          this.el.find('.remove-trend-button').addClass('none');
          return this.el.find('.add-trend-button').removeClass('none');
        }
      },
      putShareLinks: function() {
        if ((hA.selectedlocation.lat != null) && (hA.selectedlocation.lng != null)) {
          this.url = "http://hubii.com/search/" + this.keyword + "/lat/" + hA.selectedlocation.lat + "/lng/" + hA.selectedlocation.lng;
          this.title = "News about " + this.keyword + " in " + hA.selectedlocation.name;
        } else if (hA.selectedlocation.country_code != null) {
          this.url = "http://hubii.com/search/" + this.keyword + "/country/" + hA.selectedlocation.country_code;
          this.title = "News about " + this.keyword + " in " + hA.selectedlocation.name;
        } else {
          this.url = "http://hubii.com/search/" + this.keyword;
          this.title = "News about " + this.keyword + " in the world";
        }
        this.url = encodeURI(this.url.replace(/'/g, '&#39;'));
        return this.title = this.title.replace(/&/g, '&amp;').replace(/'/g, '&apos;').replace(/\s+/g, "&nbsp;");
      },
      openURL: function(url, mozbrowser) {
        if (mozbrowser == null) {
          mozbrowser = true;
        }
        return App.load('iframe-page', {
          url: url,
          mozbrowser: mozbrowser
        }, 'slide-up');
      },
      destructor: function() {
        this.off('infinite_scroll');
        this.el.off('click', 'article');
        this.el.off('click', '.back-button');
        this.el.off('click', '.menu-button');
        this.el.off('click', '.action-button');
        this.el.off('click', '.refresh-button');
        this.el = null;
        this.search_menu = null;
        this.keyword = null;
        return this.content = null;
      },
      openMenu: function() {
        this.bg.addClass('activated').one('click', (function(_this) {
          return function() {
            return _this.closeMenu();
          };
        })(this));
        return this.search_menu.addClass('activated').find('.cancel-button').one('click', (function(_this) {
          return function() {
            return _this.closeMenu();
          };
        })(this));
      },
      closeMenu: function() {
        this.search_menu.removeClass('activated').find('.cancel-button').off('click');
        return this.bg.removeClass('activated').off('click');
      }
    });
  });

}).call(this);
