// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var SettingsView;
    return SettingsView = Hubii.View.extend({
      initialize: function() {
        var $openfilters;
        $openfilters = $('#open-filters');
        hA.events.on('show_filters', function() {
          return $openfilters.addClass('show');
        });
        hA.events.on('hide_filters', function() {
          return $openfilters.removeClass('show');
        });
        $openfilters.on('click', function(e) {
          e.preventDefault();
          return App.load('filters');
        });
        App.populator('settings', (function(_this) {
          return function(page) {
            return _this.populateSettings(page);
          };
        })(this), (function(_this) {
          return function(page) {
            return _this.destroySettings(page);
          };
        })(this));
        App.populator('filters', (function(_this) {
          return function(page) {
            return _this.populateFilters(page);
          };
        })(this), (function(_this) {
          return function(page) {
            return _this.destroyFilters(page);
          };
        })(this));
        return App.populator('notification-time', (function(_this) {
          return function(page) {
            return _this.populateNotificationOptions(page);
          };
        })(this), (function(_this) {
          return function(page) {
            return _this.destroyNotificationOptions(page);
          };
        })(this));
      },
      setShowNewsAlerts: function(activated) {
        var ref, result;
        hA.shownewsalerts = activated;
        lscache.set('shownewsalerts', activated);
        if (activated) {
          return hA.events.trigger('set_alarm');
        } else {
          result = (ref = navigator.mozAlarms) != null ? ref.getAll() : void 0;
          return result != null ? result.onsuccess = function() {
            return result.forEach(function(alarm) {
              return navigator.mozAlarms.remove(alarm.id);
            });
          } : void 0;
        }
      },
      populateSettings: function(page) {
        var $page, $toggleNotificationSwitch, avatar;
        hA.events.trigger('hide_filters');
        $page = $(page);
        $page.on('appShow', (function(_this) {
          return function() {
            return hA.sendPageViewGA();
          };
        })(this));
        if (hA.userIsLogged()) {
          $page.find('.user-notlogged').remove();
          $page.find('.user-logged').show();
          $page.on('click', '#log-out-button', (function(_this) {
            return function() {
              return hA.events.trigger('logoutUser');
            };
          })(this));
          if ((hA.user.Avatar != null) && hA.user.Avatar.length) {
            avatar = hA.user.Avatar;
          } else {
            avatar = "http://c14294765.r65.cf2.rackcdn.com/Avatar_Hubiito_S.png";
          }
          $page.find('#user_img').attr('src', avatar);
          $page.find('#user_name').html(hA.user.Name);
        } else {
          $page.find('.user-logged').remove();
          $page.find('.user-notlogged').show();
        }
        $toggleNotificationSwitch = $page.find('#show_news_alerts');
        if (hA.shownewsalerts || hA.shownewsalerts === null) {
          $toggleNotificationSwitch.addClass('checked');
          $page.find('#notification-time').removeClass('none');
        } else {
          $toggleNotificationSwitch.removeClass('checked');
        }
        $page.on('click', '.go-to-terms', function(e) {
          return App.load('iframe-page', {
            url: 'http://hubii.com/terms.html'
          }, 'slide-up');
        });
        $page.on('click', '.go-to-notificationtime', function() {
          return App.load('notification-time');
        });
        $page.on('click', '.go-to-feedback', function(e) {
          return App.load('send-feedback');
        });
        return $page.on('click', '#show_news_alerts', (function(_this) {
          return function(e) {
            var $notificationtime;
            e.preventDefault();
            $notificationtime = $page.find('#notification-time');
            if ($toggleNotificationSwitch.hasClass('checked')) {
              $toggleNotificationSwitch.removeClass('checked');
              $notificationtime.addClass('none');
              return _this.setShowNewsAlerts(false);
            } else {
              $toggleNotificationSwitch.addClass('checked');
              $notificationtime.removeClass('none');
              return _this.setShowNewsAlerts(true);
            }
          };
        })(this));
      },
      destroySettings: function(page) {
        var $page;
        $page = $(page);
        hA.events.off('login_error');
        $page.off('appShow');
        $page.off('click', '.go-to-terms');
        $page.off('click', '.go-to-feedback');
        $page.off('click', '#show_news_alerts');
        if (hA.userIsLogged()) {
          return $page.off('click', '#log-out-button');
        }
      },
      populateFilters: function(page) {
        var $page;
        hA.events.trigger('hide_filters');
        $page = $(page);
        this.$tabcategories = $page.find('#tab-categories');
        this.$tablanguages = $page.find('#tab-languages');
        this.$tabpages = $page.find('.tab-page');
        $page.on('appShow', (function(_this) {
          return function() {
            return hA.sendPageViewGA();
          };
        })(this));
        this.$tabcategories.on('click', (function(_this) {
          return function(e) {
            e.preventDefault();
            _this.$tabcategories.addClass('active');
            _this.$tablanguages.removeClass('active');
            _this.$tabpages.addClass('none');
            _this.$tabpages.filter("[rel='tab-categories']").removeClass('none');
            return $page.find('.app-content').scrollTop(0);
          };
        })(this));
        this.$tablanguages.on('click', (function(_this) {
          return function(e) {
            e.preventDefault();
            _this.$tablanguages.addClass('active');
            _this.$tabcategories.removeClass('active');
            _this.$tabpages.addClass('none');
            _this.$tabpages.filter("[rel='tab-languages']").removeClass('none');
            return $page.find('.app-content').scrollTop(0);
          };
        })(this));
        $page.on('click', '.back-button', function(e) {
          e.preventDefault();
          lscache.set('instructions_showed', true);
          return App.back(function() {
            hA.events.trigger('show_filters');
            return $('.refresh-button').trigger('click');
          });
        });
        this.initCategoriesFilters($page);
        return this.initLanguagesFilters($page);
      },
      destroyFilters: function(page) {
        var $page;
        $page = $(page);
        $page.off('click', '.filter-language');
        $page.off('click', '.filter-category');
        $page.off('click', '.back-button');
        $page.off('appShow');
        this.$tabcategories.off('click');
        this.$tablanguages.off('click');
        return this.$tabpages = this.$tabcategories = this.$tablanguages = null;
      },
      initCategoriesFilters: function($page) {
        var ref;
        if ((ref = hA.filter_categories) != null ? ref.length : void 0) {
          _.each(hA.filter_categories, (function(_this) {
            return function(category) {
              return $page.find(".filter-category[rel='" + category + "']").addClass('selected');
            };
          })(this));
        }
        return $page.on('click', '.filter-category', (function(_this) {
          return function(e) {
            var id, ref1;
            id = e.currentTarget.getAttribute('rel');
            if (e.currentTarget.hasClass('selected')) {
              e.currentTarget.removeClass('selected');
              hA.filter_categories = _.without(hA.filter_categories, id);
            } else {
              e.currentTarget.addClass('selected');
              if ((ref1 = hA.filter_categories) != null ? ref1.length : void 0) {
                hA.filter_categories.push(id);
              } else {
                hA.filter_categories = [id];
              }
            }
            return lscache.set('filter_categories', hA.filter_categories);
          };
        })(this));
      },
      initLanguagesFilters: function($page) {
        var ref;
        if ((ref = hA.filter_languages) != null ? ref.length : void 0) {
          _.each(hA.filter_languages, (function(_this) {
            return function(language) {
              return $page.find(".filter-language[rel='" + language + "']").addClass('selected');
            };
          })(this));
        }
        return $page.on('click', '.filter-language', (function(_this) {
          return function(e) {
            var $element, id, ref1;
            $element = $(e.currentTarget);
            id = $element.attr('rel');
            if ($element.hasClass('selected')) {
              hA.filter_languages = _.without(hA.filter_languages, id);
            } else {
              if ((ref1 = hA.filter_languages) != null ? ref1.length : void 0) {
                hA.filter_languages.push(id);
              } else {
                hA.filter_languages = [id];
              }
            }
            lscache.set('filter_languages', hA.filter_languages);
            return $element.toggleClass('selected');
          };
        })(this));
      },
      populateNotificationOptions: function(page) {
        var $page;
        hA.events.trigger('hide_filters');
        $page = $(page);
        $page.on('appShow', (function(_this) {
          return function() {
            return hA.sendPageViewGA();
          };
        })(this));
        $page.on('click', '.back-button', function() {
          return App.back();
        });
        if (hA.notificationtime === 12 || hA.notificationtime === null) {
          $page.find('#notificationtime_noon').addClass('selected');
        } else if (hA.notificationtime === 7) {
          $page.find('#notificationtime_morning').addClass('selected');
        } else if (hA.notificationtime === 20) {
          $page.find('#notificationtime_evening').addClass('selected');
        }
        return $page.on('click', '.option', (function(_this) {
          return function(e) {
            var $element, hour;
            $element = $(e.currentTarget);
            if ($element.hasClass('selected')) {
              return false;
            } else {
              hour = $element.data('hour');
              $page.find('.option').removeClass('selected');
              $element.addClass('selected');
              hA.notificationtime = hour;
              return lscache.set('notificationtime', hA.notificationtime);
            }
          };
        })(this));
      },
      destroyNotificationOptions: function(page) {
        var $page;
        $page = $(page);
        $page.off('click', '.back-button');
        $page.off('click', '.option');
        return $page.off('appShow');
      }
    });
  });

}).call(this);
