// Generated by CoffeeScript 1.9.2
(function() {
  define(function() {
    var SubscriptionsView;
    return SubscriptionsView = Hubii.View.extend({
      showing: false,
      needRefresh: false,
      appendCached: [],
      publications: [],
      el: null,
      tmplPublication: function(j) {
        var html;
        html = "<li class='publication go-right' data-publication='" + j.id + "' class='hubii-button go-right'>";
        if (j.LogoURL) {
          html += "<img class='publication_img' src='" + j.LogoURL + "' />";
        } else {
          html += "<h3 class='publication_title'>" + j.Name + "</h3>";
        }
        return html += "</li>";
      },
      tmplNoPublications: function() {
        return '<div id="no-news"> <i class="sprite no-subscriptions"></i> <p id="no-phrase">You are not subscribed to any publishers</p> </div>';
      },
      tmplLoading: function() {
        return '<div id="loading"> <img src="img/loading_static.png" width="34" height="34" /> </div>';
      },
      initialize: function() {
        hA.events.on('got_publications_info', (function(_this) {
          return function(publications) {
            if (_this.showing) {
              return _this.render(publications);
            }
          };
        })(this));
        App.populator('subscriptions', (function(_this) {
          return function(page) {
            return _this.populateSubscriptions(page);
          };
        })(this), (function(_this) {
          return function() {
            return _this.destroySubscriptions();
          };
        })(this));
        return hA.events.on('remove_subscription', (function(_this) {
          return function(id) {
            _this.publications = _.reject(_this.publications, function(publication) {
              return publication.id === id;
            });
            return _this.needRefresh = true;
          };
        })(this));
      },
      populateSubscriptions: function(page) {
        this.appendCached = [];
        this.showing = true;
        this.el = $(page);
        this.showLoading();
        hA.events.trigger('get_publications_info');
        this.el.on('click', '.publication', (function(_this) {
          return function(e) {
            return _this.openPublication(e);
          };
        })(this));
        this.el.on('appShow', (function(_this) {
          return function() {
            hA.events.trigger('hide_filters');
            hA.sendPageViewGA();
            _this.showing = true;
            if (_this.needRefresh) {
              _this.appendCached = [];
              _this.needRefresh = false;
              _this.showLoading();
              return hA.events.trigger('get_publications_info');
            }
          };
        })(this));
        return this.el.on('appHide', (function(_this) {
          return function() {
            return _this.showing = false;
          };
        })(this));
      },
      destroySubscriptions: function() {
        this.showing = false;
        this.el.off('click', '.publication');
        return this.el = null;
      },
      render: function(publications) {
        if ((this.el != null) && this.showing) {
          this.el.find('#loading').remove();
          this.el.find('#message').empty();
          this.el.find('.app-list').empty();
          if (publications.length) {
            this.publications = publications;
            return _.each(publications, this.addPublications, this);
          } else {
            return this.showNoPublicationsMessage();
          }
        }
      },
      showNoPublicationsMessage: function() {
        return this.el.find('#message').html(this.tmplNoPublications()).find('#no-phrase').text(hA.t('no_subscriptions'));
      },
      addPublications: function(publication) {
        var $toAppend;
        this.appendCached.push(this.tmplPublication(publication));
        if (this.appendCached.length === this.publications.length) {
          $toAppend = $(this.appendCached.join(''));
          this.el.find('.app-list').append($toAppend);
          return this.appendCached = [];
        }
      },
      showLoading: function() {
        if (this.showing && (this.el != null) && !this.el.find('#loading').length) {
          return this.el.find('.app-list').empty().end().find('#publications').append(this.tmplLoading());
        }
      },
      openPublication: function(e) {
        var publication, publicationId;
        e.preventDefault();
        publicationId = $(e.currentTarget).data('publication');
        publication = _.findWhere(this.publications, {
          id: publicationId
        });
        if (publication) {
          return hA.events.trigger('open_publication', publication);
        }
      }
    });
  });

}).call(this);
